require "narray"
require "dcl/advanced"

include AdvancedDCL

n = 9
y = NArray.sfloat(n).indgen

Dev.open("X")
Frame.new

x1 = 0.1
x2 = 0.9
xc = 0.5

Plot.lineindex=1
y = 0.1 * (9 - y)

(0..(n-1)).each{|i|
  Plot.vdraw([x1, x2], [y[i], y[i]])
}

Plot.vdraw([xc, xc], [0.05, 0.95]) 

#--------------------- super/sub script ------------------------
Text.lcntl=false
Text.vdraw(xc, y[0], "SGTXV|SUP\"RST_SUB\"")

Text.charindex=2
Text.lcntl=true
Text.vdraw(xc, y[1], 'SGTXV|SUP"RST_SUB"')

Text.shift=0.5
Text.small=0.5
Text.vdraw(xc, y[2], 'SGTXV|SUP"RST_SUB"')

#--------------------- font selection ---------------------------

Text.charindex=1
Text.charsize=0.05
Text.vdraw(xc, y[3], "ABCDEFG abcdefg")

Text.ifont=2
Text.vdraw(xc, y[4], "ABCDEFG abcdefg")

Text.charindex=3
Text.vdraw(xc, y[5], "ABCDEFG abcdefg")

#--------------------- greek letters ---------------------------

greek1 = Text.spchar([152,153,154,155,156,157,158,159,160,161])
greek2 = Text.spchar([130,131,135,138,141,143,145,148,150,151])

Text.vdraw(xc, y[6], greek1)
Text.vdraw(xc, y[7], greek2)

#------------------------ symbols ------------------------------

symbol =  Text.spchar([189,190,191,192,193,210,211,212,217,218])

Text.vdraw(xc, y[8], symbol)

Dev.close
