require 'narray'
require "dcl/advanced"

include AdvancedDCL
include Math

n = 37
x = NArray.sfloat(n)
y = NArray.sfloat(n)

dt = 2 * PI / (n-1)
r = 0.2
(0..(n-1)).each{|i|
  x[i] = r * sin(dt * i) + 0.5
  y[i] = r * cos(dt * i) + 0.5
}

xc = 0.5
yc = 0.5

Dev.open("X")

#---------------- page 1 ---------------------

Frame.new
Text.charindex=3
Plot.lineindex=2

Fig.window=[0.0, 1.0, 0.0, 1.0]
Fig.viewport=[0.0, 1.0, 0.0, 1.0]
Fig.transnum=1

Plot.draw(x, y)
Text.draw(xc, yc, "SGTXU")
Fig.pvpr(1)

#----------------- page 2 --------------------

Frame.new


Fig.window=[0.0, 1.0, 0.0, 1.0]
Fig.viewport=[0.1, 0.4, 0.6, 0.9]
Fig.transnum=[1]

Plot.draw(x, y)
Text.draw(xc, yc, "SGTXU")
Fig.pvpr(1)

Fig.window=[0.0, 1.0, 0.3, 0.7]
Fig.viewport=[0.6, 0.9, 0.6, 0.9]
Fig.transnum=1

Plot.draw(x, y)
Text.draw(xc, yc, "SGTXU")
Fig.pvpr(1)

Fig.window=[0.0, 1.0, -0.5, 0.5]
Fig.viewport=[0.1, 0.4, 0.1, 0.4]
Fig.transnum=1

Plot.draw(x, y)
Text.draw(xc, yc, "SGTXU")
Fig.pvpr(1)

Fig.lclip=true

Fig.window=[0.0, 1.0, -0.5, 0.5]
Fig.viewport=[0.6, 0.9, 0.1, 0.4]
Fig.transnum=1

Plot.draw(x, y)
Text.draw(xc, yc, "SGTXU")
Fig.pvpr(1)

Dev.close
