require "narray"
require "dcl/advanced"

include AdvancedDCL

n = 9
y = NArray.sfloat(n)

Dev.open("X")
Frame.new

Fig.window=[0.0, 1.0, 0.0, 1.0]
Fig.viewport=[0.0, 1.0, 0.0, 1.0]
Fig.transnum=1

x1 = 0.1
x2 = 0.9
xc = 0.5

Plot.lineindex=1
(0..(n-1)).each{|i|
  y[i] = 0.1 * (9-i)
  Plot.vdraw([x1, x2], [y[i], y[i]])
}

Plot.vdraw([xc, xc], [0.05, 0.95])

Text.vdraw(xc, y[0], "SGTXV TEST")

Text.charindex=2
Text.vdraw(xc, y[1], "INDEX2")

Text.charindex=3
Text.vdraw(xc, y[2], "INDEX3")

Text.charindex=4
Text.charsize=0.03
Text.vdraw(xc, y[3], "SMALL")

Text.charsize=0.07
Text.vdraw(xc, y[4], "LARGE")

Text.charsize=0.05
Text.charindex=5
Text.charcent=-1
Text.vdraw(xc, y[5], "LEFT")

Text.charcent=0
Text.vdraw(xc, y[6], "CENTER")

Text.charcent=1
Text.vdraw(xc, y[7], "RIGHT")

Text.charcent=0
Text.charindex=4
Text.charrot=20
Text.vdraw(xc, y[8], "ROTATION")

Dev.close
