require "narray"
require "dcl/advanced"

include AdvancedDCL
include NMath


nx = 37
xmin = 0
xmax = 360
ymin = 0
ymax = 180
drad = PI/180

alon = NArray.sfloat(nx)
alat = NArray.sfloat(nx)
r = NArray.sfloat(nx)
a = NArray.sfloat(nx)

#-- data ---
alon.indgen!(xmin, (xmax-xmin)/(nx-1).to_f)
alat.indgen!(ymin, (ymax-ymin)/(nx-1).to_f)
r.fill!(1.0)

#-- graph ---
Dev.open("X")

Frame.new
Fig.ldeg = true

#---------------- 3-D ------------------
Fig.origin = [1.0, 0.0, 0.0, 0.0]
Fig.transnum3d = 3 

Fig.eyepoint = [5.0, 1.0, 2.0]
Fig.objpoint = [0.0, 0.0, 0.0]

Common.marktype = 10
Common.markindex = 1
Common.marksize = 0.01

for i in 0..nx-1
  a.fill!(alat[i])
  ThreeD.plot(r, a, alon)
  ThreeD.mark(r, a, alon)
end

Dev.close


