require "narray"
require "dcl/advanced"

include AdvancedDCL
include NMath


nx = 73
ny = 37
xmin = 0
xmax = 360
ymin = -90
ymax = 90

p1 = NArray.sfloat(nx*ny)
p2 = NArray.sfloat(nx*ny)

#-- data ---
i = 0
File.foreach("t810630.dat") do |line|
  line.split(" ").each do |data|
    p1[i] = data.to_f
    i += 1
  end
end
i = 0
File.foreach("t811231.dat") do |line|
  line.split(" ").each do |data|
    p2[i] = data.to_f
    i += 1
  end
end
p1.reshape!(nx, ny)
p2.reshape!(nx, ny)

190.step(245, 5) do |r|
  amin=r
  amax=r+5
#       IDX=(R-180)*1.4*1000+999
  idx=((r-170)*1.25).to_i*1000+999
  Tone.stlv(amin, amax, idx)
end

#-- graph ---

Dev.open("X")

Tone.lsoftf = false
Map.lgridmj = false
Map.dgridmn = 30.0
Map.itypemn = 1
Map.itypeout = 1
Frame.new

Fig.l2to3 = true

Fig.objpoint=[0.5, 0.5, 0.0]
Fig.plane=[1, 2, -0.3]

Fig.simtrans=[0.12, 0.0, 0.0]
Fig.mapangle=[180.0, 90.0, 0.0]
Fig.viewport=[0.1, 0.9, 0.1, 0.9]
Fig.window=[xmin, xmax, ymin, ymax]
Fig.mapwindow=[-180.0, 180.0, -90.0, 90.0]
Fig.transnum = Fig.sname2trn('MER')

Fig.lclip = true
Fig.pwwr(1)
Map.settrf

Tone.draw(p1)
Map.open('coast_world')
Map.draw
Fig.pvpr(1)

Fig.lclip = false

Text.charsize = 0.025
Text.charrot = 0
Text.charcent = 0
Text.charindex = 3

Text.vdraw(0.5, 0.95, 'Temp. : 10 hPa : Jun 30, 1981')

Fig.plane=[1, 2, 0.4]

Fig.lclip = true
Fig.pwwr(1)
Map.settrf

Tone.draw(p2)
Map.open('coast_world')
Map.draw
Fig.pvpr(1)

Fig.lclip = false
Text.vdraw(0.5, 0.95, 'Temp. : 10 hPa : Dec 31, 1981')

Dev.close

