require "dcl/advanced"
include AdvancedDCL
include NMath


nx = 21
ny = 21
xmin = -10
xmax = 10
ymin = -10
ymax = 10
dx1 = 1
dx2 = 5
dy1 = 1
dy2 = 5
kmax = 56
pmin = 0
pmax = 1
p = NArray.sfloat(nx, ny)
pi = NArray.sfloat(2, kmax+1)

#-- data ---
for j in 0..ny-1
  for i in 0..nx-1
    x = xmin + (xmax-xmin)*i/(nx-1).to_f
    y = ymin + (ymax-ymin)*j/(ny-1).to_f
    p[i,j] = exp(-x**2/64 -y**2/25)
  end
end

#-- graph ---
Dev.open("X")

Frame.new

Fig.window=[xmin, xmax, ymin, ymax]
Fig.viewport=[0.2, 0.8, 0.2, 0.8]
Fig.transnum=1

dp = (pmax-pmin)/kmax.to_f
for k in 1..kmax
  tlev1 = (k-1)*dp
  tlev2 = tlev1 + dp
  ipat  = (29+k)*1000 + 999
  Tone.stlv(tlev1, tlev2, ipat)
end

Tone.draw(p)
Axis.draw

#-- g[o[ ----

Fig.window=[0.0, 1.0, pmin, pmax]
Fig.viewport=[0.85, 0.9, 0.2, 0.8]
Fig.transnum=1

for k in 0..kmax
  pi[0,k] = pmin + k*dp
  pi[1,k] = pmin + k*dp
end

Tone.draw(pi)

Fig.pvpr(3)
Axis::Lin.labelyr=true

Axis::Lin.zfact(0.8)
Axis::Lin.cyfmt='(F4.1)'

Axis::Lin.yaxdv('R', 0.1, 0.2)

Dev.close
