require "numru/gphys/gphys"

# ToDo :: data missing handling ; use scaled_put/scaled_get

module NumRu
   class GPhys

      module NetCDF_Convention_Uguide
      end

      module NetCDF_IO

	 @@convention = NetCDF_Convention_Uguide

	 module_function

	 def open(file, varname)
	    if file.is_a?(String)
	       file = NetCDF.open(file)
	    elsif ! file.is_a?(NetCDF)
	       raise ArgumentError, "1st arg must be a NetCDF or a file name"
	    end
	    ncvar = file.var(varname)
	    data = VArrayNetCDF.new(ncvar)
	    axposnames = ncvar.dim_names    # NC User's Guide
	    rank = ncvar.rank
	    bare_index = [ false ] * rank # --> true if coord var is not found
	    cell = [ false ] * rank       # NC User's Guide gives no rule
            cell_center = [ true ] * rank # NC User's Guide gives no rule

            axes = Array.new
	    var_names = file.var_names
            for i in 0...rank
	       if var_names.include?(axposnames[i])
		  axpos = VArrayNetCDF.new( file.var(axposnames[i]) )
	       else
		  bare_index[i]=true
		  na = NArray.float(file.dim(dimnames[i]).length).indgen!
		  axpos = VArray.new( na )
	       end
	       axis = Axis.new(cell[i],bare_index[i])
	       if !cell[i]
		  axis.set_pos( axpos )
	       else
		  if cell_center[i]
		     p "Sorry: method to find bounds has not been defined"
		     axis.set_cell_guess_bounds(axpos).set_pos_to_center
		  else
		     raise "Sorry: method to find center has not been defined"
		  end
	       end

	       #p "yet-to-be-defined: method to define aux coord vars"

	       axis.set_default_algorithms

	       axes[i] = axis
	    end

	    grid = Grid.new( *axes )

	    GPhys.new(grid,data)
	 end

	 def write(file, gphys, name=nil)
	    (0...(gphys.rank)).collect{|i| gphys.grid.axis(i).flatten}.\
	    flatten.each{|va|
	       VArrayNetCDF.write(file, va)
	    }
	    VArrayNetCDF.write(file, gphys.data, name, gphys.grid.axnames)
	 end

      end
   end
end

######################################################
if $0 == __FILE__
   include NumRu

   file = NetCDF.open("../../testdata/T.jan.nc")
   temp = GPhys::NetCDF_IO.open(file,"T")
   p temp.name, temp.shape_current
   temp2 = temp[true,true,2]
   p temp2.name, temp2.shape_current

   temp_xmean = temp.mean(0)
   p temp.val

   temp_edy = ( temp - temp_xmean )
   p '###',temp_edy.name,temp_edy.val[0,true,true]
   p '@@@',temp
   p '///',temp.copy
   p '+++',temp2

   puts "\n** test write (tmp.nc) **"
   file2 = NetCDF.create('tmp.nc')
   GPhys::NetCDF_IO.write(file2,temp_edy)
   file2.close
end
