!= 
!= Setting of date
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: dccaldatecreate.f90,v 1.2 2009-10-18 02:34:48 morikawa Exp $
! Tag Name::  $Name: gtool5-20100705 $
! Copyright:: Copyright (C) GFD Dennou Club, 2009-. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! Υե˵ܤ³ dc_calendar ⥸塼뤫󶡤ޤ. 
!
! Procedures described in this file are provided from "dc_calendar" module. 
!

subroutine DCCalDateCreate1( year, month, day, hour, min, sec, date, zone, err )
  !
  ! Ԥޤ. 
  ! 
  ! YYYY-MM-DDThh:mm:ss.sTZD Τ褦ʸ 
  ! (YYYY ǯ, MM Ϸ, DD , hh ϻ, mm ʬ, ss.s ,
  ! TZD ϥॾ) ǻꤹˤ
  ! Ʊ̾Υ֥롼ѤƲ. 
  !
  ! άǽ *date* ά줿ˤ, dc_calendar 
  ! ݻ "dc_calendar_types#DC_CAL_DATE" ѿ
  ! ꤵޤ. θμ³ *date* άˤ
  ! Ѥޤ. 
  ! *date* άʤˤϤѿꤵޤ. 
  ! Ѥ, ³ˤ "dc_calendar_types#DC_CAL_DATE" ѿ
  ! ͿƤ. 
  !
  ! Set date. 
  !
  ! If a string like as "YYYY-MM-DDThh:mm:ss.sTZD"
  ! (YYYY is year, MM is month, DD is day, hh is hour, mm is minute, 
  ! ss.s is second, TZD is time zone) is used, 
  ! use a following homonymous subroutine. 
  !
  ! If an optional argument *date* is omitted, 
  ! the date setting is stored to a "dc_calendar_types#DC_CAL_DATE" 
  ! variable that is saved in the "dc_calendar". 
  ! When *date* is omitted in subsequent procedures, the internal date
  ! is used. 
  ! If *date* is not omitted, the settings is stored to the *date*. 
  ! In order to use the date setting, use the "dc_calendar_types#DC_CAL_DATE" 
  ! varieble to subsequent procedures. 
  !


  use dc_calendar_types, only: DC_CAL_DATE
  use dc_calendar_internal, only: default_date
  use dc_regex, only: match
  use dc_message, only: MessageNotify
  use dc_string, only: LChar
  use dc_trace, only: BeginSub, EndSub
  use dc_error, only: StoreError, DC_NOERR, DC_EALREADYINIT, DC_EBADDATE
  use dc_types, only: STRING, DP
  implicit none
  integer, intent(in):: year  ! ǯ. Year.
  integer, intent(in):: month ! . Month.
  integer, intent(in):: day   ! . Day.
  integer, intent(in):: hour  ! . Hour.
  integer, intent(in):: min   ! ʬ. Minute.
  real(DP), intent(in):: sec  ! . Second.
  type(DC_CAL_DATE), intent(out), optional, target:: date
                              ! ᤿֥. 
                              ! άˤ, ǥեȤȤ
                              ! ꤵ. 
                              ! 
                              ! An object that stores information of 
                              ! date and time. 
                              ! If this is omitted, these information is 
                              ! set as default date and time. 
  character(*), intent(in), optional:: zone
                              ! UTC λ. Time-zone. 
  logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 


  ! ѿ
  ! Work variables
  !
  type(DC_CAL_DATE), pointer:: datep =>null()
  integer:: start, length
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter:: version = &
    & '$Name: gtool5-20100705 $' // &
    & '$Id: dccaldatecreate.f90,v 1.2 2009-10-18 02:34:48 morikawa Exp $'
  character(*), parameter:: subname = 'DCCalDateCreate1'
continue
  call BeginSub( subname, version )
  stat = DC_NOERR
  cause_c = ''

  ! ֥ȤΥݥ󥿳
  ! Associate pointer of an object
  !
  if ( present( date ) ) then
    datep => date
  else
    datep => default_date
  end if

!!$  ! Υå
!!$  ! Check initialization
!!$  !
!!$  if ( datep % initialized ) then
!!$    stat = DC_EALREADYINIT
!!$    cause_c = 'DC_CAL_DATE'
!!$    goto 999
!!$  end if

  ! Υå
  ! Validate date and time
  !
  if ( year < 1 ) then
    stat = DC_EBADDATE
    call MessageNotify('W', subname, 'year=<%d> must be natural number', &
      & i = (/ year /) )
    goto 999
  end if

  if ( month < 1 ) then
    stat = DC_EBADDATE
    call MessageNotify('W', subname, 'month=<%d> must be natural number', &
      & i = (/ month /) )
    goto 999
  end if

  if ( day < 1 ) then
    stat = DC_EBADDATE
    call MessageNotify('W', subname, 'day=<%d> must be natural number', &
      & i = (/ day /) )
    goto 999
  end if

  if ( hour < 0 ) then
    stat = DC_EBADDATE
    call MessageNotify('W', subname, 'hour=<%d> must not be negative', &
      & i = (/ hour /) )
    goto 999
  end if

  if ( min < 0 ) then
    stat = DC_EBADDATE
    call MessageNotify('W', subname, 'min=<%d> must not be negative', &
      & i = (/ min /) )
    goto 999
  end if

  if ( sec < 0.0_DP ) then
    stat = DC_EBADDATE
    call MessageNotify('W', subname, 'sec=<%f> must not be negative', &
      & d = (/ sec /) )
    goto 999
  end if

  call match( '^[#+-]#d+:#d+$', zone, & ! (in)
    &         start, length )           ! (out)
  if ( length > 0 ) then
    datep % zone = zone
  else
    datep % zone = ''
  end if

  ! Ǥؤͤ
  ! Configure elements
  !
  datep % year  = year
  datep % month = month
  datep % day   = day
  datep % hour  = hour
  datep % min   = min
  datep % sec   = sec

  ! λ, 㳰
  ! Termination and Exception handling
  !
  datep % initialized = .true.
999 continue
  nullify( datep )
  call StoreError( stat, subname, err, cause_c )
  call EndSub( subname )
end subroutine DCCalDateCreate1

subroutine DCCalDateCreate2( date_str, date, err )
  !
  ! Ԥޤ. 
  ! 
  ! *date_str*  YYYY-MM-DDThh:mm:ss.sTZD ηʸ 
  ! (YYYY ǯ, MM Ϸ, DD , hh ϻ, mm ʬ, ss.s ,
  ! TZD ϥॾ) ꤷƤ. 
  ! ǯʬäƸѿǻꤹˤ
  ! 嵭Ʊ̾Υ֥롼ѤƲ. 
  ! ʸ 
  ! gtool4 netCDF 5.5 פ˽򤷤Ƥޤ. 
  ! 
  ! "s since 2009-06-17T11:23:45+09:00" Τ褦ʸͿˤ, 
  ! "s since " ʬ򥵥֥롼ǼưŪڤä, 
  ! "2009-06-17T11:23:45+09:00" ʬꤷޤ. 
  !
  ! άǽ *date* ά줿ˤ, dc_calendar 
  ! ݻ "dc_calendar_types#DC_CAL_DATE" ѿ
  ! ꤵޤ. θμ³ *date* άˤ
  ! Ѥޤ. 
  ! *date* άʤˤϤѿꤵޤ. 
  ! Ѥ, ³ˤ "dc_calendar_types#DC_CAL_DATE" ѿ
  ! ͿƤ. 
  !
  ! Set date. 
  !
  ! Specify a string like as "YYYY-MM-DDThh:mm:ss.sTZD"
  ! (YYYY is year, MM is month, DD is day, hh is hour, mm is minute, 
  ! ss.s is second, TZD is time zone). 
  ! If individual variables (year, month, day, hour, minute, second, zone) 
  ! are used, use a foregoing homonymous subroutine. 
  ! Format of date is conformed to gtool4 netCDF Convention "5.5 Expression of date and time" 
  !
  ! If a string like as "s since 2009-06-17T11:23:45+09:00" is specified, 
  ! A part "s since " is truncated automatically, and 
  ! a part "2009-06-17T11:23:45+09:00" is set. 
  !
  ! If an optional argument *date* is omitted, 
  ! the date setting is stored to a "dc_calendar_types#DC_CAL_DATE" 
  ! variable that is saved in the "dc_calendar". 
  ! When *date* is omitted in subsequent procedures, the internal date
  ! is used. 
  ! If *date* is not omitted, the settings is stored to the *date*. 
  ! In order to use the date setting, use the "dc_calendar_types#DC_CAL_DATE" 
  ! varieble to subsequent procedures. 
  !
  use dc_calendar_generic, only: DCCalDateParseStr, DCCalDateCreate
  use dc_calendar_types, only: DC_CAL_DATE
  use dc_calendar_internal, only: default_date
  use dc_message, only: MessageNotify
  use dc_types, only: DP, TOKEN
  use dc_trace, only: BeginSub, EndSub
  use dc_error, only: StoreError, DC_NOERR, DC_EALREADYINIT, DC_EBADDATE
  use dc_types, only: STRING
  implicit none
  character(*), intent(in):: date_str
                              ! ɽʸ. 
                              ! ɽˤĤƤ gtool4 netCDF 
                              ! 5.5 򻲾ȤΤ. 
                              ! 
                              ! Strings that express date and time. 
                              ! See gtool4 netCDF Convention 
                              ! 5.5 Expression of date and time for details. 
  type(DC_CAL_DATE), intent(out), optional, target:: date
                              ! ᤿֥. 
                              ! άˤ, ǥեȤȤ
                              ! ꤵ. 
                              ! 
                              ! An object that stores information of 
                              ! date and time. 
                              ! If this is omitted, these information is 
                              ! set as default date and time. 
  logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 


  ! ѿ
  ! Work variables
  !
  type(DC_CAL_DATE), pointer:: datep =>null()
  integer:: year  ! ǯ. Year.
  integer:: month ! . Month.
  integer:: day   ! . Day.
  integer:: hour  ! . Hour.
  integer:: min   ! ʬ. Minute.
  real(DP):: sec  ! . Second.
  character(TOKEN):: zone
                  ! UTC λ. Time-zone.
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter:: version = &
    & '$Name: gtool5-20100705 $' // &
    & '$Id: dccaldatecreate.f90,v 1.2 2009-10-18 02:34:48 morikawa Exp $'
  character(*), parameter:: subname = 'DCCalDateCreate2'
continue
  call BeginSub( subname, version )
  stat = DC_NOERR
  cause_c = ''

  ! ֥ȤΥݥ󥿳
  ! Associate pointer of an object
  !
  if ( present( date ) ) then
    datep => date
  else
    datep => default_date
  end if

!!$  ! Υå
!!$  ! Check initialization
!!$  !
!!$  if ( datep % initialized ) then
!!$    stat = DC_EALREADYINIT
!!$    cause_c = 'DC_CAL_DATE'
!!$    goto 999
!!$  end if

  ! ɽʸβ
  ! Parse strings that express date and time
  !
  call DCCalDateParseStr( date_str, &           ! (in)
    & year, month, day, hour, min, sec, zone, & ! (out)
    & err = err )                               ! (out) optional
  if ( present(err) ) then
    if ( err ) then
      stat = DC_EBADDATE
      goto 999
    end if
  end if

  ! ֥Ȥκ
  ! Create an object
  !
  call DCCalDateCreate( &
    & year, month, day, hour, min, sec, & ! (in)
    & datep, zone, err = err )            ! (out) optional
  if ( present(err) ) then
    if ( err ) then
      stat = DC_EBADDATE
      goto 999
    end if
  end if

  ! λ, 㳰
  ! Termination and Exception handling
  !
999 continue
  nullify( datep )
  call StoreError( stat, subname, err, cause_c )
  call EndSub( subname )
end subroutine DCCalDateCreate2
