#= Rules for GNU make
#
# Authors::   Yasuhiro MORIKAWA
# Version::   $Id: rules.make,v 1.3 2009-03-24 03:56:12 morikawa Exp $
# Tag Name::  $Name: gtool5-20090324 $
# Copyright:: Copyright (C) GFD Dennou Club, 2009-. All rights reserved.
# License::   See COPYRIGHT[link:COPYRIGHT]
#
#== Overview
#
# This file provides general rules for Makefiles.
# To use, "include" this file.
#
# [JAPANESE]
# Υեˤ Makefile ƤӽФ붦̥롼뤬
# ҤƤޤ. ΥեѤˤ,  Makefile 
# Υե include Ƥ.
#
############################################################

############################################################
#== Suffixes rules
#
# [JAPANESE] եå롼
#
%.o: %.F90
	@test $< -ot depend || eval "rm -fv depend; $(MAKE) depend"
	$(FC) -o $@ -c $(MODPATHFLAG)$(MODDIR)  $(FFLAGS) $(SYSFFLAGS) $(INCLUDES) $(CPPFLAGS) $<
	@if [ -f $(MODFILE) ]; then \
	    test -d $(MODDIR) || $(INSTALLDIR) $(MODDIR) ;\
	    $(CP) $(MODFILE) $(MODDIR) ;\
	    if [ ! `dirname $@` = "." ]; then \
		$(MV) $(MODFILE) `dirname $@` ;\
	    fi ;\
	fi

%.o: %.f90
	@test $< -ot depend || eval "rm -fv depend; $(MAKE) depend"
	$(FC) -o $@ -c $(MODPATHFLAG)$(MODDIR) $(FFLAGS) $(SYSFFLAGS) $(INCLUDES) $<
	@if [ -f $(MODFILE) ]; then \
	    test -d $(MODDIR) || $(INSTALLDIR) $(MODDIR) ;\
	    $(CP) $(MODFILE) $(MODDIR) ;\
	    if [ ! `dirname $@` = "." ]; then \
		$(MV) $(MODFILE) `dirname $@` ;\
	    fi ;\
	fi

%: %.o
	$(LINKF) -o $@ $(MODPATHFLAG)$(MODDIR) $+ $(LIBPATH) $(SYSLDFLAGS) $(SYSLDLIBS)

$(LIBPATH): $(OBJS)

archive:
	$(AR) $(ARFLAGS) $(LIBPATH) $(OBJS)
	$(RANLIB) $(LIBPATH)

rb2f90: $(RB2F90)

clean.src:
	-@$(RM) $(wildcard $(MODS) *.o work.pc*)
	-@$(RM) $(wildcard $(OBJS:%.o=$(MODDIR)/%$(MODSUFFIX)))
	@test -d $(MODDIR) && $(RMDIR) $(MODDIR) 2> /dev/null || true
	-@$(RM) $(wildcard $(LIBPATH))

clean.rb2f90:
	-@$(RM) $(wildcard $(RB2F90))

Makefile.win: Makefile depend
	$(RUBY) $(SCRIPTDIR)/gnumakefileparser-test.rb
	$(RUBY) $(SCRIPTDIR)/gen-Makefile.win.rb --input $(shell echo $+ | sed -e 's/ /,/') --output $@

depend: 
	@$(RUBY) $(RUBYVERCHECK) > /dev/null 2>&1 && \
	    $(F90DEPEND) -q $(wildcard *.f90 *.F90 ../*/*.f90 ../*/*.F90) > $@ || \
	    touch $@

$(OBJS): work.pcl

work.pcl: Makefile $(DIRDEPTH)/Config.mk
	sh $(DIRDEPTH)/chkpcl.sh $(SYSFFLAGS)

######################################################################
#== Mode setting for Emacs
#Local Variables:
#mode: makefile
#End:
#
