#!/usr/bin/env ruby
#
#== GNU Make  Makefile ѡ
#
#Authors::   Yasuhiro MORIKAWA
#Version::   $Id: gnumakefileparser.rb,v 1.1.1.1 2008-09-23 09:56:36 morikawa Exp $
#Tag Name::  $Name: gtool5-20090115 $
#Copyright:: Copyright (C) GFD Dennou Club, 2007-. All rights reserved.
#License::   See COPYRIGHT[link:../../COPYRIGHT]
#
#
#GNU Make  Makefile βϥץ
#
#
class GNUMakefileParser

  attr_reader :file
  attr_reader :body
  attr_accessor :list

  #
  # *file* ˤ Makefile ̾ޤȤ߹ѿ STDIN Ϳޤ.
  #Makefile ɤ߹ʤˤϥ顼֤ޤ.
  #ʸͿ,  Makefile Ϳ뤳ȤƱͤˤʤޤ.
  #ʣ Makefile 򳫤ˤ, ե̾ ',' Ƕڤä
  #Ϳޤ.
  #
  #Makefile ɤ߹ޤ줿ƤϲϤ, ġ򥪥֥ȤѴ
  # @list ˳Ǽޤ. GNUMake ƤǤ
  #櫓ǤʤΤդƤ.
  #
  #
  def initialize(file=nil)
    @file = file
    @body = ''
    if @file.class == String
      if !@file.empty?
        files = @file.split(/,/)
        files.each{ |fi|
          @body << File.open(fi, 'r') {|f| f.read}
          @body << "\n"
        }
      end
    elsif @file == STDIN
      @body = STDIN.read || ''
    else
      raise "  argument \"file\" must be String or STDIN"
    end
    @list = []
    @list += self.parse(@body)
  end

  #
  # *body* Ϳ줿ʸ Makefile ǤȤƲϤ,
  #GNUMakefileParser Υ֥Ȥɲäޤ.
  #
  def add(body)
    @list += self.parse(body)
  end

  def +(other)
    newmk = self.dup
    newmk.list = @list + other.list
    return newmk
  end

#  def +=(other)
#    @list += other.list
#  end

  #
  # *body* Ϳ줿ʸ Makefile ǤȤƲϤ,
  #ġ򥪥֥ȤѴȤ֤ޤ.
  #GNUMake ƤǤ
  #Ǥ櫓ǤʤΤդƤ.
  #
  def parse(body)
    list = []
    body.gsub!(/\s*\\\s*\n/, ' ')
    unit = ''
    kind = nil
    body.split("\n").each{|line|
      if line =~ /^\t/
        unit = unit + "\n" + line
      elsif line =~ /^\s*\#/
        next
      elsif line =~ /^\s*$/
        next
      else
        if kind == :mktarget
          list << MkTarget.new(unit)
          kind = false
        elsif kind == :mkvariable
          list << MkVariable.new(unit)
          kind = false
        end
        if line =~ /^\s*\w+\s*:?\??\=/
          kind = :mkvariable
          unit = line
        elsif line =~ /^[\w\s\-\.\,\$\(\)\%]+:/
          kind = :mktarget
          unit = line
        else
          list << MkOther.new(line)
        end
      end
    }
    if kind == :mktarget
      list << MkTarget.new(unit)
    elsif kind == :mkvariable
      list << MkVariable.new(unit)
    end
    return list
  end

  #
  #֥ȤƤ Makefile ѤΥƥȤѴ.
  #
  def to_s(target=true, variable=true, other=true)
    str = ''
    @list.each{|obj|
      if obj.class == GNUMakefileParser::MkTarget
        next if !target
      elsif obj.class == GNUMakefileParser::MkVariable
        next if !variable
      elsif obj.class == GNUMakefileParser::MkOther
        next if !other
      elsif !obj
        next
      end
      str << obj.to_s
    }
    return str
  end


  #
  #Τ褦˵Ҥ Makefile Υå.
  #
  #   test.o: test.f90
  #           f90 $< -o $@
  #
  class MkTarget
    attr_accessor :target
    attr_accessor :prerequisites
    attr_accessor :commands

    #
    # target_rules ˾嵭ν񼰤ʸͿ뤳Ȥ,
    #줾 @tareget, @prerequisites, @command ꤵ.
    #
    def initialize(target_rules)
      rule = target_rules.split("\n")[0]
      if rule =~ /^([\w\s\-\.\,\$\(\)\%]+):\s*(.*)\s*$/
        target = $1
        prerequisites = $2
        @target = target.sub(/^\s*/, '').sub(/\s*$/, '')
        @prerequisites = []
        prerequisites.split(/\s+/).each{|i|
          @prerequisites << i
        }
      else
        raise "Syntax Error"
      end
      @commands = []
      target_rules.split("\n")[1..-1].each{|c|
        commands << c.sub(/^\s+/, '').gsub(/\t+/, ' ')
      }
    end

    #
    #֥ȤƤ Makefile ѤΥƥȤѴ.
    #
    def to_s
      str = @target + ': ' + @prerequisites.join(' ')
      if @commands.size > 0
        str = str + "\n\t" + @commands.join("\n\t")
      end
      return str + "\n"
    end
  end

  #
  #Τ褦˵Ҥѿ.
  #
  #    objects = main.o command.o display.o \
  #              insert.o search.o
  #
  class MkVariable
    attr_accessor :var
    attr_accessor :value
    attr_accessor :simply_expanded
    attr_accessor :conditional

    #
    # var_rules ˾嵭ν񼰤ʸͿ뤳Ȥ,
    #줾 @var, @value, ꤵ.
    #
    def initialize(var_rules)
      if var_rules =~ /^\s*(\w+)\s*(:?)(\??)\=\s*(.*)\s*$/
        @var = $1
        @simply_expanded = $2
        @conditional = $3
        value = $4
        @value = value.gsub(/[\t ]+/, ' ')
      else
        raise "Syntax Error"
      end
    end

    #
    #֥ȤƤ Makefile ѤΥƥȤѴ.
    #
    def to_s
      return @var + ' ' + @simply_expanded + @conditional + '= ' + @value + "\n"
    end

  end

  #
  #åȤԽǤϤʤ
  #
  class MkOther
    attr_accessor :line

    #
    # line ʸͿ뤳Ȥ, @line ꤵ.
    #
    def initialize(line)
      @line = line
    end

    #
    #֥ȤƤ Makefile ѤΥƥȤѴ.
    #
    def to_s
      return @line + "\n"
    end
  end


end

