#!/bin/sh

set -e

${MAKE:-make} histtest

test ! -f xhist1.nc || rm -f xhist1.nc
test ! -f xhist2.nc || rm -f xhist2.nc
test ! -f xhist3.nc || rm -f xhist3.nc

./histtest $debug

ncdump xhist1.nc > xhist1.cdl

diff xhist1.cdl - <<EOF
netcdf xhist1 {
dimensions:
	time = UNLIMITED ; // (24 currently)
variables:
	float time(time) ;
		time:long_name = "time" ;
		time:units = "s @ 2001-12-16T10:00" ;
	float u(time) ;
		u:long_name = "any quantity" ;
		u:units = "non-dimensional" ;

// global attributes:
		:title = "gtool_history test 1" ;
		:source = "gtool4/Fortran library test kit" ;
		:institution = "GFD Dennou Club" ;
		:history = "unknown unknown> gtool_history: HistoryCreate\n",
    "" ;
data:

 time = 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 
    20, 21, 22, 23, 24 ;

 u = 0.09983342, 0.1986693, 0.2955202, 0.3894183, 0.4794255, 0.5646425, 
    0.6442177, 0.7173561, 0.7833269, 0.841471, 0.8912074, 0.9320391, 
    0.9635582, 0.9854497, 0.997495, 0.9995736, 0.9916648, 0.9738476, 
    0.9463001, 0.9092974, 0.8632094, 0.8084964, 0.7457052, 0.6754631 ;
}
EOF

ncdump xhist2.nc > xhist2.cdl

diff xhist2.cdl - <<EOF
netcdf xhist2 {
dimensions:
	x = 3 ;
	time = UNLIMITED ; // (3 currently)
variables:
	float x(x) ;
		x:long_name = "eastward length" ;
		x:units = "m" ;
	float time(time) ;
		time:long_name = "time" ;
		time:units = "s" ;
	float u(time, x) ;
		u:long_name = "foo quantity" ;
		u:units = "m/s" ;
	float v(time, x) ;
		v:long_name = "foo quantity" ;
		v:units = "m/s" ;

// global attributes:
		:title = "gtool_history test 2" ;
		:source = "gtool4/Fortran library test kit" ;
		:institution = "GFD DennouClub" ;
		:history = "unknown unknown> gtool_history: HistoryCreate\n",
    "" ;
data:

 x = 0, 1, 2 ;

 time = 0, 1, 2 ;

 u =
  0, 0.1, 0.2,
  2, 2.1, 2.2,
  3, 3.1, 3.2 ;

 v =
  1, 1.1, 1.2,
  _, _, _,
  4, 4.1, 4.2 ;
}
EOF

ncdump xhist3.nc > xhist3.cdl; diff xhist3.cdl - <<EOF
netcdf xhist3 {
dimensions:
	x = 3 ;
	time = UNLIMITED ; // (3 currently)
variables:
	float x(x) ;
		x:long_name = "eastward length" ;
		x:units = "m" ;
	float time(time) ;
		time:long_name = "time" ;
		time:units = "s" ;
	float u(time, x) ;
		u:long_name = "foo quantity" ;
		u:units = "m/s" ;
	float v(time, x) ;
		v:long_name = "foo quantity" ;
		v:units = "m/s" ;

// global attributes:
		:title = "gtool_history test 3" ;
		:source = "gtool4/Fortran library test kit" ;
		:institution = "GFD DennouClub" ;
		:history = "unknown unknown> gtool_history: HistoryCreate\n",
    "" ;
data:

 x = 0, 1, 2 ;

 time = 0, 1, 2 ;

 u =
  0, 0.1, 0.2,
  2, 2.1, 2.2,
  3, 3.1, 3.2 ;

 v =
  1, 1.1, 1.2,
  4, 4.1, 4.2,
  5, 5.1, 5.2 ;
}
EOF

rm -f xhist?.*

echo okay

exit 0
