program histtest
    use gtool
    use dc_trace, only: setdebug
    use gtool_history
implicit none
    integer:: i
    character(len = string):: arg
continue

    do, i = 1, gtArgCount()
	call gtArgGet(i, arg)
	if (arg == '-debug') then
	    call setdebug
        endif
    enddo

    call HistoryCreate(file='xhist1.nc', title='gtool_history test 1', &
        & source='gtool4/Fortran library test kit', &
	& institution='GFD Dennou Club', &
	& dims=(/'time'/), &
	& dimsizes=(/0/), &
	& longnames=(/'time'/), &
	& units=(/'s @ 2001-12-16T10:00'/), &
	& origin=0.0, interval=0.0, &
	& xtypes=(/'real'/))
    call HistoryAddVariable('u', dims=(/'time'/), longname='any quantity', &
	units='non-dimensional')
    do, i = 1, 24
        call HistoryPut('time', real(i))
        call HistoryPut('u', sin(real(i) / 10.0))
    enddo
    call HistoryClose

    call HistoryCreate(file='xhist2.nc', title='gtool_history test 2', &
	& source='gtool4/Fortran library test kit', &
	& institution='GFD DennouClub', &
	& axes=(/ &
	& GT_HISTORY_AXIS('x', 3, 'eastward length', 'm', 'float'), &
	& GT_HISTORY_AXIS('time', 0, 'time', 's', 'float') &
	& /), origin=0.0, interval=0.0) 
    call HistoryAddVariable('u', dims=(/'x   ', 'time'/), &
	& longname='foo quantity', units='m/s')
    call HistoryAddVariable('v', dims=(/'x   ', 'time'/), &
	& longname='foo quantity', units='m/s')
    call HistoryPut('x', (/0.0, 1.0, 2.0/))
    call HistoryPut('time', 0.0)
    call HistoryPut('u', (/0.0, 0.1, 0.2/))
    call HistoryPut('v', (/1.0, 1.1, 1.2/))
    call HistoryPut('time', 1.0)
    call HistoryPut('u', (/2.0, 2.1, 2.2/))
    call HistoryPut('time', 2.0)
    call HistoryPut('u', (/3.0, 3.1, 3.2/))
    call HistoryPut('v', (/4.0, 4.1, 4.2/))
    call HistoryClose

    call HistoryCreate(file='xhist3.nc', title='gtool_history test 3', &
	& source='gtool4/Fortran library test kit', &
	& institution='GFD DennouClub', &
	& axes=(/ &
	& GT_HISTORY_AXIS('x', 3, 'eastward length', 'm', 'float'), &
	& GT_HISTORY_AXIS('time', 0, 'time', 's', 'float') &
	& /), origin=0.0, interval=0.0) 
    call HistoryAddVariable('u', dims=(/'x   ', 'time'/), &
	& longname='foo quantity', units='m/s')
    call HistoryAddVariable('v', dims=(/'x   ', 'time'/), &
	& longname='foo quantity', units='m/s')
    call HistoryPut('x', (/0.0, 1.0, 2.0/))
    call HistorySetTime(0.0)
    call HistoryPut('u', (/0.0, 0.1, 0.2/))
    call HistoryPut('v', (/1.0, 1.1, 1.2/))
    call HistorySetTime(1.0)
    call HistoryPut('u', (/2.0, 2.1, 2.2/))
    call HistorySetTime(2.0)
    call HistoryPut('u', (/3.0, 3.1, 3.2/))
    call HistorySetTime(1.0)
    call HistoryPut('v', (/4.0, 4.1, 4.2/))
    call HistorySetTime(2.0)
    call HistoryPut('v', (/5.0, 5.1, 5.2/))
    call HistoryClose

end program
