! gtvarattrtrue.f90 - _^̓
! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

logical function GTVarAttrTrue(var, name, default) result(result)
    use gtdata_types, only: GT_VARIABLE
    use gt_map, only: var_class, vtb_class_netcdf, vtb_class_memory
    use an_generic, only: get_attr, an_variable
    use gt_mem, only: Attr_True, memvar_t => mem_variable
    use dc_error
    implicit none
    type(GT_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    logical, intent(in), optional:: default
    integer:: class, cid
    call var_class(var, class, cid)
    if (class == vtb_class_netcdf) then
        call Get_Attr(an_variable(cid), name, result, default)
    else if (class == vtb_class_memory) then
        result = Attr_True(memvar_t(cid), name, default)
    else
        call StoreError(GT_ENOTVAR, "GTVarAttrTrue(NO VARIABLE)")
        result = .FALSE.
    endif
end function
