! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

subroutine GTVarCopyAttr(to, attrname, from, err)
    use gtdata_types, only: GT_VARIABLE
    use dc_string
    use gtdata_generic, only: GET_ATTR, PUT_ATTR
    use gt_map, only: var_class, vtb_class_netcdf, vtb_class_memory
    use an_generic, only: copy_attr, an_variable
    use dc_trace, only: beginsub, endsub
    implicit none
    type(GT_VARIABLE), intent(inout):: to
    character(len = *), intent(in):: attrname
    type(GT_VARIABLE), intent(in):: from
    logical, intent(out), optional:: err
    type(VSTRING):: svalue
    integer:: from_class, from_cid, to_class, to_cid, stat
continue
    if (present(err)) err = .false.
    call beginsub('gtvarcopyattr', 'mapid to=%d from=%d name=%c', &
        & i=(/to%mapid, from%mapid/), c1=attrname)
    call var_class(from, from_class, from_cid)
    call var_class(to, to_class, to_cid)
    if (from_class == vtb_class_netcdf .and. to_class == vtb_class_netcdf) then
        call Copy_Attr(an_variable(to_cid), attrname, &
            & an_variable(from_cid), stat)
    else
        ! Ƃ肠œo͂Ă
        call Get_Attr(from, attrname, svalue, default="")
        call Put_Attr(to, attrname, svalue, err)
        stat = 0
    endif
    call endsub('gtvarcopyattr', 'stat = %d', i=(/stat/))
end subroutine
