#!/bin/sh

set -e

${MAKE:-make} diffusion

test ! -f diffusion_1.nc || rm -f diffusion_1.nc

./diffusion 2> xdifs.log

ncdump -h diffusion_1.nc > xdifs.cdl

diff xdifs.cdl - <<EOF
netcdf diffusion_1 {
dimensions:
	x = 30 ;
	t = UNLIMITED ; // (201 currently)
variables:
	float x(x) ;
		x:long_name = "X-coordinate" ;
		x:units = "m" ;
	float t(t) ;
		t:long_name = "time" ;
		t:units = "s" ;
	double temp(t, x) ;
		temp:long_name = "temperature" ;
		temp:units = "K" ;

// global attributes:
		:title = "Diffusion equation" ;
		:source = "Sample program of gtool_history/gtool4" ;
		:institution = "GFD_Dennou Club davis project" ;
		:history = "unknown unknown> gtool_history: HistoryCreate\n",
    "" ;
}
EOF

../gtprint/gtprint diffusion_1.nc@temp > xdifs.pri
diff xdifs.pri - <<EOF
0.13887954E-10
0.38776193E-09
0.85351575E-08
0.14810763E-06
0.20261093E-05
0.21850821E-04
0.18577711E-03
0.12451914E-02
0.65796012E-02
0.27408328E-01
0.90008803E-01
0.23302738
0.47560725
0.76526076
0.97071099
0.97071099
0.76526076
0.47560728
0.23302741
0.90008818E-01
0.27408332E-01
0.65796026E-02
0.12451917E-02
0.18577716E-03
0.21850827E-04
0.20261098E-05
0.14810767E-06
0.85351601E-08
0.38776204E-09
0.13887959E-10
0.13887954E-10
0.36565280E-08
0.63799405E-07
0.87911712E-06
0.95727019E-05
0.82445542E-04
0.56232989E-03
0.30428271E-02
0.13094962E-01
0.44973351E-01
0.12382462
0.27489290
0.49540171
0.72985327
0.88431913
0.88431919
0.72985327
0.49540174
0.27489293
0.12382463
0.44973355E-01
0.13094964E-01
0.30428278E-02
0.56233001E-03
0.82445556E-04
0.95727037E-05
0.87911735E-06
0.63799426E-07
0.36565293E-08
0.13887959E-10
0.13887954E-10
0.27414881E-07
0.38135045E-06
0.41919284E-05
0.36560079E-04
0.25359387E-03
0.14035876E-02
0.62267007E-02
0.22272902E-01
0.64725451E-01
0.15419188
0.30409265
0.50126463
0.69621927
0.81936622
0.81936628
0.69621933
0.50126463
0.30409268
0.15419188
0.64725459E-01
0.22272905E-01
0.62267017E-02
0.14035880E-02
0.25359393E-03
0.36560086E-04
0.41919297E-05
0.38135056E-06
0.27414888E-07
0.13887959E-10
0.13887954E-10
0.16472268E-06
0.18348687E-05
0.16200389E-04
0.11421199E-03
0.64590358E-03
0.29481344E-02
0.10946009E-01
0.33376772E-01
0.84494784E-01
0.17960452
0.32397020
0.50033224
0.66602415
0.76758295
0.76758295
0.66602415
0.50033224
0.32397020
0.17960453
0.84494792E-01
0.33376776E-01
0.10946011E-01
0.29481349E-02
0.64590370E-03
0.11421202E-03
0.16200393E-04
0.18348692E-05
0.16472272E-06
0.13887959E-10
0.13887954E-10
0.79775907E-06
0.71732734E-05
0.51373569E-04
0.29657444E-03
0.13904154E-02
0.53431531E-02
0.17015038E-01
0.45439761E-01
0.10299330
0.20031664
0.33742467
0.49584544
0.63905621
0.72487748
0.72487748
0.63905621
0.49584547
0.33742470
0.20031665
0.10299331
0.45439765E-01
0.17015040E-01
0.53431536E-02
0.13904156E-02
0.29657449E-03
0.51373579E-04
0.71732752E-05
0.79775924E-06
0.13887959E-10
0.13887954E-10
0.31432112E-05
0.23078594E-04
0.13589431E-03
0.65342762E-03
0.25925816E-02
0.85890545E-02
0.24059607E-01
0.57688430E-01
0.11971650
0.21704611
0.34638667
0.48944962
0.61492389
0.68878961
0.68878961
0.61492395
0.48944965
0.34638670
0.21704611
0.11971651
0.57688437E-01
0.24059610E-01
0.85890563E-02
0.25925818E-02
0.65342773E-03
0.13589434E-03
0.23078599E-04
0.31432119E-05
0.13887959E-10
0.13887954E-10
0.10204326E-04
0.62134779E-04
0.30607806E-03
0.12512191E-02
0.42986847E-02
0.12572905E-01
0.31695161E-01
0.69630317E-01
0.13456079
0.23050672
0.35215694
0.48205361
0.59322250
0.65772909
0.65772909
0.59322250
0.48205361
0.35215694
0.23050673
0.13456081
0.69630325E-01
0.31695165E-01
0.12572907E-01
0.42986851E-02
0.12512193E-02
0.30607812E-03
0.62134786E-04
0.10204328E-04
0.13887959E-10
0.13887954E-10
0.27750169E-04
0.14287618E-03
0.60093176E-03
0.21352465E-02
0.64965351E-02
0.17134504E-01
0.39605986E-01
0.80981851E-01
0.14760280
0.24131538
0.35562456
0.47417858
0.57360101
0.63060409
0.63060409
0.57360101
0.47417858
0.35562459
0.24131539
0.14760280
0.80981858E-01
0.39605990E-01
0.17134506E-01
0.64965361E-02
0.21352468E-02
0.60093182E-03
0.14287620E-03
0.27750173E-04
0.13887959E-10
0.13887954E-10
0.64491716E-04
0.28707806E-03
0.10534988E-02
0.33239892E-02
0.91358796E-02
0.22110496E-01
0.47555279E-01
0.91597408E-01
0.15899482
0.24997625
0.35740951
0.46613374
0.55576366
0.60663426
0.60663426
0.55576366
0.46613374
0.35740954
0.24997626
0.15899484
0.91597416E-01
0.47555283E-01
0.22110498E-01
0.91358805E-02
0.33239895E-02
0.10534989E-02
0.28707812E-03
0.64491731E-04
0.13887959E-10
0.13887954E-10
0.13097051E-03
0.51576045E-03
0.16859601E-02
0.48131477E-02
0.12147807E-01
0.27354201E-01
0.55375464E-01
0.10141831
0.16891190
0.25689426
0.35795236
0.45810458
0.53946537
0.58524317
0.58524317
0.53946537
0.45810458
0.35795239
0.25689426
0.16891190
0.10141832
0.55375468E-01
0.27354203E-01
0.12147808E-01
0.48131482E-02
0.16859603E-02
0.51576050E-03
0.13097054E-03
0.13887959E-10
0.13887954E-10
0.23770158E-03
0.84602524E-03
0.25088736E-02
0.65823891E-02
0.15457872E-01
0.32742854E-01
0.62953539E-01
0.11043835
0.17752743
0.26239261
0.35757142
0.45020279
0.52450275
0.56599361
0.56599361
0.52450275
0.45020279
0.35757145
0.26239261
0.17752743
0.11043835
0.62953547E-01
0.32742854E-01
0.15457873E-01
0.65823901E-02
0.25088738E-02
0.84602536E-03
0.23770162E-03
0.13887959E-10
0.13887954E-10
0.39354819E-03
0.12894529E-02
0.35225593E-02
0.86016161E-02
0.18994067E-01
0.38178112E-01
0.70217311E-01
0.11868194
0.18500228
0.26672950
0.35650024
0.44249442
0.51070654
0.54854667
0.54854667
0.51070654
0.44249445
0.35650024
0.26672950
0.18500228
0.11868195
0.70217311E-01
0.38178116E-01
0.18994067E-01
0.86016171E-02
0.35225598E-02
0.12894531E-02
0.39354822E-03
0.13887959E-10
0.13887954E-10
0.60478912E-03
0.18517462E-02
0.47192816E-02
0.10835898E-01
0.22690933E-01
0.43583702E-01
0.77124208E-01
0.12619026
0.19148088
0.27011180
0.35491219
0.43501705
0.49793515
0.53263491
0.53263491
0.49793515
0.43501705
0.35491219
0.27011180
0.19148088
0.12619027
0.77124208E-01
0.43583706E-01
0.22690935E-01
0.10835899E-01
0.47192820E-02
0.18517465E-02
0.60478918E-03
0.13887959E-10
0.13887954E-10
0.87482081E-03
0.25331995E-02
0.60855201E-02
0.13248903E-01
0.26491301E-01
0.48902076E-01
0.83652705E-01
0.13301268
0.19709048
0.27270606
0.35293773
0.42779002
0.48606932
0.51804364
0.51804364
0.48606935
0.42779002
0.35293773
0.27270606
0.19709048
0.13301270
0.83652705E-01
0.48902079E-01
0.26491303E-01
0.13248905E-01
0.60855211E-02
0.25331997E-02
0.87482086E-03
0.13887959E-10
0.13887954E-10
0.12043070E-02
0.33296023E-02
0.76039718E-02
0.15805129E-01
0.30346604E-01
0.54090984E-01
0.89795940E-01
0.13920152
0.20194212
0.27464712
0.35067570
0.42082107
0.47500807
0.50459844
0.50459844
0.47500807
0.42082107
0.35067570
0.27464712
0.20194213
0.13920154
0.89795940E-01
0.54090988E-01
0.30346606E-01
0.15805131E-01
0.76039727E-02
0.33296025E-02
0.12043071E-02
0.13887959E-10
0.13887954E-10
0.15915825E-02
0.42332881E-02
0.92551857E-02
0.18471232E-01
0.34216426E-01
0.59120405E-01
0.95557056E-01
0.14480889
0.20613216
0.27604470
0.34820181
0.41411057
0.46466520
0.49215570
0.49215570
0.46466520
0.41411057
0.34820181
0.27604470
0.20613216
0.14480890
0.95557056E-01
0.59120409E-01
0.34216426E-01
0.18471234E-01
0.92551867E-02
0.42332886E-02
0.15915827E-02
0.13887959E-10
0.13887954E-10
0.20331594E-02
0.52341591E-02
0.11018826E-01
0.21216739E-01
0.38067695E-01
0.63969895E-01
0.10094585
0.14988492
0.20974395
0.27698854
0.34557438
0.40765417
0.45496672
0.48059595
0.48059595
0.45496672
0.40765417
0.34557438
0.27698854
0.20974395
0.14988492
0.10094585
0.63969895E-01
0.38067698E-01
0.21216741E-01
0.11018827E-01
0.52341595E-02
0.20331594E-02
0.13887959E-10
0.13887954E-10
0.25242362E-02
0.63205911E-02
0.12874596E-01
0.24014344E-01
0.41873742E-01
0.68626404E-01
0.10597634
0.15447676
0.21284957
0.27755252
0.34283859
0.40144455
0.44584888
0.46981886
0.46981886
0.44584888
0.40144455
0.34283859
0.27755255
0.21284959
0.15447676
0.10597634
0.68626411E-01
0.41873746E-01
0.24014344E-01
0.12874597E-01
0.63205916E-02
0.25242364E-02
0.13887959E-10
0.13887954E-10
0.30591621E-02
0.74801832E-02
0.14802901E-01
0.26839957E-01
0.45613360E-01
0.73082559E-01
0.11066512
0.15862811
0.21551140
0.27779773
0.34002960
0.39547276
0.43725625
0.45973948
0.45973948
0.43725625
0.39547276
0.34002960
0.27779773
0.21551141
0.15862811
0.11066512
0.73082559E-01
0.45613363E-01
0.26839959E-01
0.14802902E-01
0.74801836E-02
0.30591623E-02
0.13887959E-10
0.13887954E-10
0.36318237E-02
0.87003466E-02
0.16785281E-01
0.29672591E-01
0.49269941E-01
0.77335231E-01
0.11503009
0.16237910
0.21778338
0.27777484
0.33717495
0.38972887
0.42914048
0.45028529
0.45028529
0.42914048
0.38972887
0.33717495
0.27777484
0.21778338
0.16237910
0.11503009
0.77335231E-01
0.49269944E-01
0.29672593E-01
0.16785281E-01
0.87003475E-02
0.36318239E-02
0.13887959E-10
0.13887954E-10
0.42359559E-02
0.99687474E-02
0.18804681E-01
0.32494165E-01
0.52830707E-01
0.81384465E-01
0.11908966
0.16576633
0.21971229
0.27752617
0.33429611
0.38420254
0.42145929
0.44139388
0.44139388
0.42145929
0.38420254
0.33429614
0.27752617
0.21971229
0.16576634
0.11908966
0.81384465E-01
0.52830711E-01
0.32494165E-01
0.18804681E-01
0.99687483E-02
0.42359559E-02
0.13887959E-10
0.13887954E-10
0.48653753E-02
0.11273618E-01
0.20845598E-01
0.35289254E-01
0.56286044E-01
0.85232645E-01
0.12286217
0.16882306
0.22133875
0.27708718
0.33140999
0.37888336
0.41417533
0.43301138
0.43301138
0.41417533
0.37888336
0.33140999
0.27708721
0.22133876
0.16882306
0.12286218
0.85232645E-01
0.56286048E-01
0.35289254E-01
0.20845599E-01
0.11273619E-01
0.48653758E-02
0.13887959E-10
0.13887954E-10
0.55141514E-02
0.12603969E-01
0.22894138E-01
0.38044848E-01
0.59628937E-01
0.88883817E-01
0.12636551
0.17157935
0.22269812
0.27648771
0.32852980
0.37376109
0.40725562
0.42509082
0.42509082
0.40725562
0.37376109
0.32852980
0.27648771
0.22269812
0.17157936
0.12636551
0.88883817E-01
0.59628941E-01
0.38044851E-01
0.22894138E-01
0.12603970E-01
0.55141514E-02
0.13887959E-10
0.13887954E-10
0.61767194E-02
0.13949716E-01
0.24937997E-01
0.40750086E-01
0.62854506E-01
0.92343189E-01
0.12961687
0.17406237
0.22382121
0.27575290
0.32566586
0.36882576
0.40067086
0.41759112
0.41759112
0.40067086
0.36882579
0.32566586
0.27575290
0.22382121
0.17406239
0.12961689
0.92343196E-01
0.62854506E-01
0.40750086E-01
0.24937997E-01
0.13949717E-01
0.61767199E-02
0.13887959E-10
0.13887954E-10
0.68479544E-02
0.15301743E-01
0.26966408E-01
0.43396011E-01
0.65959588E-01
0.95616780E-01
0.13263263
0.17629664
0.22473489
0.27490401
0.32282621
0.36406788
0.39439496
0.41047615
0.41047615
0.39439496
0.36406788
0.32282621
0.27490401
0.22473490
0.17629664
0.13263263
0.95616788E-01
0.65959595E-01
0.43396011E-01
0.26966410E-01
0.15301744E-01
0.68479548E-02
0.13887959E-10
0.13887954E-10
0.75232075E-02
0.16651917E-01
0.28970065E-01
0.45975346E-01
0.68942457E-01
0.98711096E-01
0.13542818
0.17830421
0.22546272
0.27395919
0.32001704
0.35947829
0.38840458
0.40371400
0.40371400
0.38840458
0.35947829
0.32001707
0.27395919
0.22546272
0.17830421
0.13542818
0.98711096E-01
0.68942457E-01
0.45975350E-01
0.28970065E-01
0.16651917E-01
0.75232079E-02
0.13887959E-10
0.13887954E-10
0.81983209E-02
0.17993076E-01
0.30941004E-01
0.48482295E-01
0.71802497E-01
0.10163292
0.13801801
0.18010499
0.22602533
0.27293375
0.31724316
0.35504833
0.38267869
0.39727640
0.39727640
0.38267869
0.35504836
0.31724319
0.27293375
0.22602533
0.18010500
0.13801801
0.10163292
0.71802504E-01
0.48482295E-01
0.30941006E-01
0.17993076E-01
0.81983218E-02
0.13887959E-10
0.13887954E-10
0.88696210E-02
0.19318985E-01
0.32872513E-01
0.50912328E-01
0.74540041E-01
0.10438916
0.14041565
0.18171692
0.22644082
0.27184087
0.31450814
0.35076982
0.37719846
0.39113805
0.39113805
0.37719846
0.35076982
0.31450814
0.27184087
0.22644082
0.18171692
0.14041565
0.10438916
0.74540049E-01
0.50912332E-01
0.32872513E-01
0.19318987E-01
0.88696219E-02
0.13887959E-10
0.13887954E-10
0.95339036E-02
0.20624286E-01
0.34758996E-01
0.53262040E-01
0.77156141E-01
0.10698675
0.14263369
0.18315613
0.22672515
0.27069172
0.31181461
0.34663501
0.37194681
0.38527647
0.38527647
0.37194681
0.34663504
0.31181461
0.27069175
0.22672515
0.18315615
0.14263369
0.10698675
0.77156149E-01
0.53262044E-01
0.34759000E-01
0.20624287E-01
0.95339036E-02
0.13887959E-10
0.13887954E-10
0.10188403E-01
0.21904426E-01
0.36595881E-01
0.55528980E-01
0.79652444E-01
0.10943252
0.14468384
0.18443722
0.22689232
0.26949593
0.30916443
0.34263664
0.36690831
0.37967134
0.37967134
0.36690831
0.34263664
0.30916443
0.26949593
0.22689234
0.18443722
0.14468384
0.10943253
0.79652444E-01
0.55528983E-01
0.36595881E-01
0.21904428E-01
0.10188404E-01
0.13887959E-10
0.13887954E-10
0.10830767E-01
0.23155596E-01
0.38379494E-01
0.57711527E-01
0.82031049E-01
0.11173318
0.14657696
0.18557329
0.22695477
0.26826173
0.30655891
0.33876783
0.36206892
0.37430450
0.37430450
0.36206892
0.33876783
0.30655891
0.26826173
0.22695477
0.18557329
0.14657696
0.11173318
0.82031049E-01
0.57711530E-01
0.38379494E-01
0.23155596E-01
0.10830767E-01
0.13887959E-10
0.13887954E-10
0.11459020E-01
0.24374655E-01
0.40106963E-01
0.59808765E-01
0.84294438E-01
0.11389524
0.14832310
0.18657625
0.22692344
0.26699612
0.30399880
0.33502209
0.35741585
0.36915943
0.36915943
0.35741585
0.33502209
0.30399880
0.26699612
0.22692344
0.18657625
0.14832312
0.11389524
0.84294438E-01
0.59808768E-01
0.40106967E-01
0.24374655E-01
0.11459020E-01
0.13887959E-10
0.13887954E-10
0.12071527E-01
0.25559066E-01
0.41776136E-01
0.61820384E-01
0.86445354E-01
0.11592502
0.14993164
0.18745679
0.22680800
0.26570517
0.30148447
0.33139336
0.35293746
0.36422127
0.36422127
0.35293746
0.33139336
0.30148447
0.26570517
0.22680801
0.18745680
0.14993164
0.11592502
0.86445354E-01
0.61820384E-01
0.41776136E-01
0.25559068E-01
0.12071527E-01
0.13887959E-10
0.13887954E-10
0.12666960E-01
0.26706833E-01
0.43385465E-01
0.63746579E-01
0.88486753E-01
0.11782860
0.15141118
0.18822464
0.22661708
0.26439410
0.29901597
0.32787597
0.34862301
0.35947642
0.35947642
0.34862301
0.32787597
0.29901597
0.26439410
0.22661708
0.18822464
0.15141119
0.11782860
0.88486753E-01
0.63746579E-01
0.43385465E-01
0.26706835E-01
0.12666961E-01
0.13887959E-10
0.13887954E-10
0.13244270E-01
0.27816432E-01
0.44933949E-01
0.65587975E-01
0.90421759E-01
0.11961183
0.15276977
0.18888861
0.22635829
0.26306736
0.29659310
0.32446447
0.34446272
0.35491258
0.35491258
0.34446275
0.32446447
0.29659310
0.26306736
0.22635831
0.18888861
0.15276977
0.11961183
0.90421759E-01
0.65587975E-01
0.44933949E-01
0.27816432E-01
0.13244270E-01
0.13887959E-10
0.13887954E-10
0.13802649E-01
0.28886752E-01
0.46421051E-01
0.67345560E-01
0.92253573E-01
0.12128032
0.15401483
0.18945664
0.22603846
0.26172876
0.29421544
0.32115382
0.34044760
0.35051841
0.35051841
0.34044760
0.32115382
0.29421544
0.26172876
0.22603846
0.18945664
0.15401483
0.12128032
0.92253581E-01
0.67345560E-01
0.46421051E-01
0.28886754E-01
0.13802649E-01
0.13887959E-10
0.13887954E-10
0.14341501E-01
0.29917059E-01
0.47846634E-01
0.69020621E-01
0.93985498E-01
0.12283944
0.15515324
0.18993601
0.22566357
0.26038164
0.29188240
0.31793928
0.33656934
0.34628364
0.34628364
0.33656934
0.31793928
0.29188240
0.26038164
0.22566359
0.18993601
0.15515324
0.12283944
0.93985505E-01
0.69020629E-01
0.47846638E-01
0.29917059E-01
0.14341502E-01
0.13887959E-10
0.13887954E-10
0.14860421E-01
0.30906923E-01
0.49210910E-01
0.70614696E-01
0.95620848E-01
0.12429431
0.15619144
0.19033331
0.22523908
0.25902876
0.28959325
0.31481630
0.33282027
0.34219879
0.34219879
0.33282027
0.31481630
0.28959325
0.25902876
0.22523908
0.19033331
0.15619144
0.12429432
0.95620848E-01
0.70614696E-01
0.49210913E-01
0.30906925E-01
0.14860422E-01
0.13887959E-10
0.13887954E-10
0.15359169E-01
0.31856198E-01
0.50514374E-01
0.72129488E-01
0.97162955E-01
0.12564987
0.15713535
0.19065453
0.22476976
0.25767255
0.28734717
0.31178066
0.32919326
0.33825511
0.33825511
0.32919326
0.31178066
0.28734717
0.25767258
0.22476976
0.19065453
0.15713535
0.12564987
0.97162955E-01
0.72129495E-01
0.50514378E-01
0.31856198E-01
0.15359169E-01
0.13887959E-10
0.13887954E-10
0.15837638E-01
0.32764960E-01
0.51757768E-01
0.73566906E-01
0.98615125E-01
0.12691076
0.15799052
0.19090517
0.22425993
0.25631511
0.28514329
0.30882838
0.32568178
0.33444461
0.33444461
0.32568178
0.30882838
0.28514329
0.25631511
0.22425994
0.19090517
0.15799052
0.12691076
0.98615132E-01
0.73566906E-01
0.51757768E-01
0.32764960E-01
0.15837640E-01
0.13887959E-10
0.13887954E-10
0.16295850E-01
0.33633497E-01
0.52942034E-01
0.74928939E-01
0.99980667E-01
0.12808149
0.15876210
0.19109024
0.22371346
0.25495815
0.28298062
0.30595565
0.32227969
0.33075982
0.33075982
0.32227969
0.30595565
0.28298062
0.25495815
0.22371346
0.19109024
0.15876210
0.12808149
0.99980667E-01
0.74928939E-01
0.52942038E-01
0.33633497E-01
0.16295850E-01
0.13887959E-10
0.13887954E-10
0.16733926E-01
0.34462258E-01
0.54068290E-01
0.76217696E-01
0.10126281
0.12916629
0.15945488
0.19121431
0.22313379
0.25360319
0.28085816
0.30315891
0.31898132
0.32719395
0.32719395
0.31898132
0.30315891
0.28085819
0.25360322
0.22313379
0.19121432
0.15945488
0.12916629
0.10126282
0.76217696E-01
0.54068290E-01
0.34462258E-01
0.16733926E-01
0.13887959E-10
0.13887954E-10
0.17152073E-01
0.35251830E-01
0.55137780E-01
0.77435337E-01
0.10246475
0.13016923
0.16007337
0.19128162
0.22252403
0.25225154
0.27877492
0.30043477
0.31578141
0.32374054
0.32374054
0.31578141
0.30043477
0.27877492
0.25225154
0.22252405
0.19128162
0.16007337
0.13016923
0.10246475
0.77435344E-01
0.55137780E-01
0.35251830E-01
0.17152073E-01
0.13887959E-10
0.13887954E-10
0.17550575E-01
0.36002923E-01
0.56151863E-01
0.78584082E-01
0.10358962
0.13109419
0.16062175
0.19129598
0.22188701
0.25090420
0.27672979
0.29778007
0.31267497
0.32039371
0.32039371
0.31267497
0.29778007
0.27672979
0.25090420
0.22188701
0.19129600
0.16062175
0.13109419
0.10358962
0.78584082E-01
0.56151863E-01
0.36002923E-01
0.17550575E-01
0.13887959E-10
0.13887954E-10
0.17929770E-01
0.36716338E-01
0.57111982E-01
0.79666160E-01
0.10464046
0.13194485
0.16110392
0.19126099
0.22122522
0.24956214
0.27472177
0.29519174
0.30965739
0.31714797
0.31714797
0.30965739
0.29519174
0.27472177
0.24956214
0.22122522
0.19126099
0.16110393
0.13194485
0.10464046
0.79666160E-01
0.57111982E-01
0.36716342E-01
0.17929772E-01
0.13887959E-10
0.13887954E-10
0.18290054E-01
0.37392955E-01
0.58019646E-01
0.80683820E-01
0.10562027
0.13272475
0.16152358
0.19117990
0.22054094
0.24822609
0.27274975
0.29266691
0.30672437
0.31399819
0.31399819
0.30672437
0.29266694
0.27274978
0.24822609
0.22054094
0.19117990
0.16152358
0.13272475
0.10562027
0.80683827E-01
0.58019649E-01
0.37392955E-01
0.18290054E-01
0.13887959E-10
0.13887954E-10
0.18631857E-01
0.38033709E-01
0.58876410E-01
0.81639312E-01
0.10653193
0.13343722
0.16188416
0.19105573
0.21983622
0.24689668
0.27081272
0.29020292
0.30387187
0.31093955
0.31093955
0.30387187
0.29020292
0.27081272
0.24689668
0.21983624
0.19105573
0.16188416
0.13343723
0.10653193
0.81639312E-01
0.58876410E-01
0.38033709E-01
0.18631857E-01
0.13887959E-10
0.13887954E-10
0.18955640E-01
0.38639586E-01
0.59683856E-01
0.82534857E-01
0.10737826
0.13408548
0.16218887
0.19089128
0.21911295
0.24557446
0.26890960
0.28779712
0.30109602
0.30796757
0.30796757
0.30109602
0.28779712
0.26890960
0.24557446
0.21911296
0.19089128
0.16218887
0.13408548
0.10737826
0.82534857E-01
0.59683856E-01
0.38639586E-01
0.18955640E-01
0.13887959E-10
0.13887954E-10
0.19261893E-01
0.39211601E-01
0.60443584E-01
0.83372660E-01
0.10816199
0.13467257
0.16244076
0.19068913
0.21837281
0.24425982
0.26703939
0.28544712
0.29839334
0.30507809
0.30507809
0.29839334
0.28544712
0.26703939
0.24425983
0.21837281
0.19068913
0.16244076
0.13467257
0.10816199
0.83372660E-01
0.60443588E-01
0.39211601E-01
0.19261893E-01
0.13887959E-10
0.13887954E-10
0.19551119E-01
0.39750800E-01
0.61157212E-01
0.84154896E-01
0.10888577
0.13520139
0.16264267
0.19045167
0.21761732
0.24295314
0.26520103
0.28315055
0.29576039
0.30226716
0.30226716
0.29576039
0.28315055
0.26520103
0.24295314
0.21761732
0.19045168
0.16264267
0.13520139
0.10888578
0.84154904E-01
0.61157212E-01
0.39750800E-01
0.19551119E-01
0.13887959E-10
0.13887954E-10
0.19823838E-01
0.40258229E-01
0.61826341E-01
0.84883705E-01
0.10955216
0.13567473
0.16279730
0.19018114
0.21684788
0.24165466
0.26339355
0.28090522
0.29319406
0.29953107
0.29953107
0.29319406
0.28090522
0.26339355
0.24165466
0.21684788
0.19018114
0.16279730
0.13567474
0.10955216
0.84883705E-01
0.61826345E-01
0.40258233E-01
0.19823838E-01
0.13887959E-10
0.13887954E-10
0.20080576E-01
0.40734958E-01
0.62452573E-01
0.85561171E-01
0.11016361
0.13609523
0.16290717
0.18987960
0.21606576
0.24036461
0.26161599
0.27870902
0.29069132
0.29686636
0.29686636
0.29069132
0.27870902
0.26161599
0.24036461
0.21606576
0.18987960
0.16290717
0.13609524
0.11016362
0.85561171E-01
0.62452573E-01
0.40734962E-01
0.20080576E-01
0.13887959E-10
0.13887954E-10
0.20321863E-01
0.41182049E-01
0.63037485E-01
0.86189337E-01
0.11072253
0.13646540
0.16297466
0.18954897
0.21527214
0.23908316
0.25986740
0.27655995
0.28824934
0.29426974
0.29426974
0.28824937
0.27655995
0.25986740
0.23908316
0.21527216
0.18954898
0.16297466
0.13646542
0.11072253
0.86189337E-01
0.63037485E-01
0.41182049E-01
0.20321863E-01
0.13887959E-10
0.13887954E-10
0.20548226E-01
0.41600548E-01
0.63582629E-01
0.86770192E-01
0.11123120
0.13678767
0.16300201
0.18919107
0.21446808
0.23781040
0.25814685
0.27445614
0.28586555
0.29173818
0.29173818
0.28586555
0.27445614
0.25814685
0.23781040
0.21446809
0.18919107
0.16300201
0.13678767
0.11123120
0.86770192E-01
0.63582629E-01
0.41600551E-01
0.20548228E-01
0.13887959E-10
0.13887954E-10
0.20760199E-01
0.41991509E-01
0.64089537E-01
0.87305672E-01
0.11169184
0.13706431
0.16299137
0.18880756
0.21365455
0.23654643
0.25645342
0.27239573
0.28353733
0.28926873
0.28926873
0.28353733
0.27239573
0.25645342
0.23654644
0.21365455
0.18880756
0.16299137
0.13706431
0.11169184
0.87305672E-01
0.64089537E-01
0.41991513E-01
0.20760199E-01
0.13887959E-10
0.13887954E-10
0.20958303E-01
0.42355962E-01
0.64559706E-01
0.87797672E-01
0.11210658
0.13729751
0.16294475
0.18840002
0.21283242
0.23529129
0.25478628
0.27037704
0.28126234
0.28685868
0.28685868
0.28126234
0.27037704
0.25478628
0.23529129
0.21283242
0.18840002
0.16294475
0.13729753
0.11210658
0.87797672E-01
0.64559706E-01
0.42355962E-01
0.20958303E-01
0.13887959E-10
0.13887954E-10
0.21143053E-01
0.42694919E-01
0.64994596E-01
0.88248000E-01
0.11247747
0.13748939
0.16286403
0.18796991
0.21200255
0.23404498
0.25314453
0.26839840
0.27903834
0.28450543
0.28450543
0.27903834
0.26839840
0.25314456
0.23404498
0.21200255
0.18796991
0.16286403
0.13748939
0.11247747
0.88248000E-01
0.64994596E-01
0.42694919E-01
0.21143053E-01
0.13887959E-10
0.13887954E-10
0.21314958E-01
0.43009374E-01
0.65395638E-01
0.88658437E-01
0.11280649
0.13764191
0.16275102
0.18751861
0.21116567
0.23280750
0.25152743
0.26645824
0.27686316
0.28220651
0.28220651
0.27686316
0.26645824
0.25152743
0.23280750
0.21116567
0.18751861
0.16275102
0.13764192
0.11280649
0.88658437E-01
0.65395638E-01
0.43009374E-01
0.21314960E-01
0.13887959E-10
0.13887954E-10
0.21474520E-01
0.43300297E-01
0.65764219E-01
0.89030683E-01
0.11309553
0.13775699
0.16260742
0.18704742
0.21032247
0.23157883
0.24993411
0.26455510
0.27473477
0.27995962
0.27995962
0.27473477
0.26455510
0.24993411
0.23157884
0.21032247
0.18704742
0.16260742
0.13775700
0.11309553
0.89030690E-01
0.65764219E-01
0.43300297E-01
0.21474520E-01
0.13887959E-10
0.13887954E-10
0.21622224E-01
0.43568637E-01
0.66101693E-01
0.89366406E-01
0.11334641
0.13783644
0.16243483
0.18655756
0.20947361
0.23035893
0.24836384
0.26268753
0.27265126
0.27776256
0.27776256
0.27265126
0.26268753
0.24836384
0.23035893
0.20947361
0.18655756
0.16243483
0.13783646
0.11334641
0.89366406E-01
0.66101693E-01
0.43568637E-01
0.21622224E-01
0.13887959E-10
0.13887954E-10
0.21758545E-01
0.43815318E-01
0.66409357E-01
0.89667186E-01
0.11356088
0.13788201
0.16223481
0.18605015
0.20861968
0.22914772
0.24681588
0.26085415
0.27061081
0.27561328
0.27561328
0.27061081
0.26085415
0.24681588
0.22914772
0.20861968
0.18605016
0.16223481
0.13788201
0.11356088
0.89667186E-01
0.66409357E-01
0.43815318E-01
0.21758545E-01
0.13887959E-10
0.13887954E-10
0.21883950E-01
0.44041239E-01
0.66688478E-01
0.89934565E-01
0.11374062
0.13789533
0.16200881
0.18552630
0.20776123
0.22794515
0.24528952
0.25905374
0.26861167
0.27350974
0.27350974
0.26861167
0.25905374
0.24528952
0.22794515
0.20776124
0.18552630
0.16200881
0.13789533
0.11374062
0.89934565E-01
0.66688478E-01
0.44041239E-01
0.21883952E-01
0.13887959E-10
0.13887954E-10
0.21998888E-01
0.44247262E-01
0.66940293E-01
0.90170033E-01
0.11388723
0.13787799
0.16175820
0.18498698
0.20689878
0.22675112
0.24378406
0.25728500
0.26665220
0.27145010
0.27145010
0.26665220
0.25728500
0.24378407
0.22675112
0.20689878
0.18498698
0.16175820
0.13787799
0.11388723
0.90170033E-01
0.66940293E-01
0.44247266E-01
0.21998888E-01
0.13887959E-10
0.13887954E-10
0.22103798E-01
0.44434242E-01
0.67165978E-01
0.90375006E-01
0.11400227
0.13783149
0.16148427
0.18443319
0.20603278
0.22556557
0.24229886
0.25554675
0.26473081
0.26943257
0.26943257
0.26473081
0.25554675
0.24229886
0.22556557
0.20603278
0.18443319
0.16148427
0.13783151
0.11400227
0.90375006E-01
0.67165978E-01
0.44434242E-01
0.22103798E-01
0.13887959E-10
0.13887954E-10
0.22199102E-01
0.44602986E-01
0.67366682E-01
0.90550870E-01
0.11408719
0.13775730
0.16118830
0.18386580
0.20516369
0.22438838
0.24083325
0.25383791
0.26284602
0.26745549
0.26745549
0.26284602
0.25383791
0.24083325
0.22438838
0.20516369
0.18386580
0.16118830
0.13775730
0.11408719
0.90550870E-01
0.67366682E-01
0.44602986E-01
0.22199102E-01
0.13887959E-10
0.13887954E-10
0.22285212E-01
0.44754285E-01
0.67543499E-01
0.90698943E-01
0.11414345
0.13765676
0.16087145
0.18328567
0.20429191
0.22321945
0.23938663
0.25215736
0.26099640
0.26551720
0.26551720
0.26099640
0.25215736
0.23938663
0.22321947
0.20429191
0.18328567
0.16087145
0.13765676
0.11414345
0.90698943E-01
0.67543499E-01
0.44754285E-01
0.22285214E-01
0.13887959E-10
0.13887954E-10
0.22362527E-01
0.44888906E-01
0.67697503E-01
0.90820491E-01
0.11417238
0.13753119
0.16053484
0.18269362
0.20341782
0.22205873
0.23795843
0.25050408
0.25918058
0.26361620
0.26361620
0.25918058
0.25050408
0.23795843
0.22205873
0.20341782
0.18269362
0.16053486
0.13753119
0.11417238
0.90820491E-01
0.67697503E-01
0.44888906E-01
0.22362527E-01
0.13887959E-10
0.13887954E-10
0.22431426E-01
0.45007575E-01
0.67829706E-01
0.90916745E-01
0.11417529
0.13738185
0.16017957
0.18209039
0.20254178
0.22090605
0.23654805
0.24887709
0.25739729
0.26175103
0.26175103
0.25739729
0.24887711
0.23654805
0.22090605
0.20254180
0.18209039
0.16017957
0.13738185
0.11417529
0.90916745E-01
0.67829706E-01
0.45007575E-01
0.22431426E-01
0.13887959E-10
0.13887954E-10
0.22492282E-01
0.45111008E-01
0.67941099E-01
0.90988860E-01
0.11415343
0.13720994
0.15980662
0.18147670
0.20166415
0.21976134
0.23515496
0.24727547
0.25564530
0.25992027
0.25992027
0.25564530
0.24727547
0.23515496
0.21976134
0.20166415
0.18147670
0.15980662
0.13720994
0.11415343
0.90988867E-01
0.67941099E-01
0.45111012E-01
0.22492282E-01
0.13887959E-10
0.13887954E-10
0.22545453E-01
0.45199886E-01
0.68032630E-01
0.91037981E-01
0.11410799
0.13701658
0.15941699
0.18085325
0.20078519
0.21862449
0.23377861
0.24569830
0.25392342
0.25812265
0.25812265
0.25392342
0.24569830
0.23377861
0.21862449
0.20078519
0.18085326
0.15941699
0.13701658
0.11410799
0.91037981E-01
0.68032630E-01
0.45199890E-01
0.22545453E-01
0.13887959E-10
0.13887954E-10
0.22591280E-01
0.45274865E-01
0.68105213E-01
0.91065168E-01
0.11404011
0.13680288
0.15901157
0.18022068
0.19990523
0.21749538
0.23241854
0.24414474
0.25223053
0.25635687
0.25635687
0.25223053
0.24414474
0.23241854
0.21749538
0.19990523
0.18022068
0.15901157
0.13680288
0.11404011
0.91065168E-01
0.68105213E-01
0.45274869E-01
0.22591280E-01
0.13887959E-10
0.13887954E-10
0.22630095E-01
0.45336578E-01
0.68159714E-01
0.91071472E-01
0.11395089
0.13656989
0.15859126
0.17957960
0.19902453
0.21637391
0.23107421
0.24261394
0.25056559
0.25462174
0.25462174
0.25056559
0.24261394
0.23107421
0.21637391
0.19902454
0.17957960
0.15859126
0.13656989
0.11395090
0.91071472E-01
0.68159714E-01
0.45336578E-01
0.22630095E-01
0.13887959E-10
0.13887954E-10
0.22662217E-01
0.45385629E-01
0.68196982E-01
0.91057874E-01
0.11384138
0.13631858
0.15815687
0.17893060
0.19814335
0.21525997
0.22974519
0.24110515
0.24892753
0.25291613
0.25291613
0.24892753
0.24110515
0.22974519
0.21525997
0.19814335
0.17893060
0.15815687
0.13631859
0.11384138
0.91057874E-01
0.68196982E-01
0.45385633E-01
0.22662217E-01
0.13887959E-10
0.13887954E-10
0.22687949E-01
0.45422606E-01
0.68217814E-01
0.91025338E-01
0.11371258
0.13604993
0.15770923
0.17827421
0.19726193
0.21415347
0.22843102
0.23961760
0.24731542
0.25123891
0.25123891
0.24731542
0.23961760
0.22843102
0.21415347
0.19726193
0.17827421
0.15770923
0.13604993
0.11371259
0.91025338E-01
0.68217814E-01
0.45422606E-01
0.22687951E-01
0.13887959E-10
0.13887954E-10
0.22707591E-01
0.45448069E-01
0.68222992E-01
0.90974763E-01
0.11356544
0.13576481
0.15724906
0.17761096
0.19638048
0.21305428
0.22713126
0.23815058
0.24572831
0.24958909
0.24958909
0.24572831
0.23815058
0.22713126
0.21305428
0.19638048
0.17761096
0.15724906
0.13576481
0.11356544
0.90974763E-01
0.68222992E-01
0.45448069E-01
0.22707591E-01
0.13887959E-10
0.13887954E-10
0.22721419E-01
0.45462552E-01
0.68213254E-01
0.90907022E-01
0.11340089
0.13546410
0.15677711
0.17694137
0.19549924
0.21196233
0.22584552
0.23670340
0.24416533
0.24796563
0.24796563
0.24416533
0.23670340
0.22584552
0.21196233
0.19549924
0.17694137
0.15677711
0.13546410
0.11340089
0.90907022E-01
0.68213254E-01
0.45462552E-01
0.22721419E-01
0.13887959E-10
0.13887954E-10
0.22729710E-01
0.45466576E-01
0.68189315E-01
0.90822965E-01
0.11321981
0.13514864
0.15629406
0.17626588
0.19461837
0.21087748
0.22457337
0.23527540
0.24262562
0.24636760
0.24636760
0.24262562
0.23527540
0.22457337
0.21087748
0.19461839
0.17626588
0.15629406
0.13514864
0.11321981
0.90822965E-01
0.68189315E-01
0.45466576E-01
0.22729710E-01
0.13887959E-10
0.13887954E-10
0.22732720E-01
0.45460634E-01
0.68151854E-01
0.90723388E-01
0.11302301
0.13481921
0.15580057
0.17558496
0.19373810
0.20979965
0.22331445
0.23386596
0.24110836
0.24479410
0.24479410
0.24110836
0.23386596
0.22331445
0.20979965
0.19373810
0.17558496
0.15580057
0.13481921
0.11302301
0.90723388E-01
0.68151854E-01
0.45460634E-01
0.22732720E-01
0.13887959E-10
0.13887954E-10
0.22730699E-01
0.45445204E-01
0.68101525E-01
0.90609051E-01
0.11281132
0.13447657
0.15529725
0.17489901
0.19285859
0.20872875
0.22206838
0.23247448
0.23961279
0.24324425
0.24324425
0.23961279
0.23247448
0.22206838
0.20872875
0.19285859
0.17489903
0.15529725
0.13447657
0.11281133
0.90609051E-01
0.68101525E-01
0.45445204E-01
0.22730699E-01
0.13887959E-10
0.13887954E-10
0.22723889E-01
0.45420736E-01
0.68038955E-01
0.90480693E-01
0.11258550
0.13412143
0.15478469
0.17420848
0.19197999
0.20766467
0.22083484
0.23110038
0.23813815
0.24171722
0.24171722
0.23813815
0.23110038
0.22083484
0.20766467
0.19197999
0.17420848
0.15478469
0.13412143
0.11258550
0.90480693E-01
0.68038955E-01
0.45420740E-01
0.22723889E-01
0.13887959E-10
0.13887954E-10
0.22712519E-01
0.45387674E-01
0.67964748E-01
0.90339012E-01
0.11234628
0.13375448
0.15426348
0.17351370
0.19110247
0.20660731
0.21961343
0.22974311
0.23668377
0.24021222
0.24021222
0.23668377
0.22974311
0.21961343
0.20660731
0.19110247
0.17351370
0.15426350
0.13375448
0.11234628
0.90339012E-01
0.67964748E-01
0.45387674E-01
0.22712519E-01
0.13887959E-10
0.13887954E-10
0.22696808E-01
0.45346428E-01
0.67879468E-01
0.90184689E-01
0.11209437
0.13337637
0.15373416
0.17281507
0.19022618
0.20555660
0.21840389
0.22840212
0.23524894
0.23872851
0.23872851
0.23524894
0.22840212
0.21840389
0.20555660
0.19022618
0.17281507
0.15373416
0.13337637
0.11209437
0.90184696E-01
0.67879468E-01
0.45346431E-01
0.22696808E-01
0.13887959E-10
0.13887954E-10
0.22676965E-01
0.45297407E-01
0.67783669E-01
0.90018362E-01
0.11183044
0.13298774
0.15319723
0.17211291
0.18935125
0.20451245
0.21720587
0.22707695
0.23383301
0.23726535
0.23726535
0.23383301
0.22707695
0.21720587
0.20451245
0.18935125
0.17211293
0.15319723
0.13298774
0.11183044
0.90018369E-01
0.67783669E-01
0.45297407E-01
0.22676967E-01
0.13887959E-10
0.13887954E-10
0.22653196E-01
0.45240987E-01
0.67677885E-01
0.89840651E-01
0.11155511
0.13258918
0.15265319
0.17140760
0.18847781
0.20347475
0.21601906
0.22576708
0.23243539
0.23582205
0.23582205
0.23243539
0.22576708
0.21601908
0.20347475
0.18847781
0.17140760
0.15265319
0.13258919
0.11155511
0.89840651E-01
0.67677885E-01
0.45240987E-01
0.22653196E-01
0.13887959E-10
0.13887954E-10
0.22625692E-01
0.45177538E-01
0.67562610E-01
0.89652136E-01
0.11126900
0.13218127
0.15210250
0.17069939
0.18760599
0.20244342
0.21484321
0.22447206
0.23105545
0.23439796
0.23439796
0.23105545
0.22447206
0.21484321
0.20244342
0.18760599
0.17069939
0.15210250
0.13218127
0.11126900
0.89652136E-01
0.67562610E-01
0.45177538E-01
0.22625692E-01
0.13887959E-10
0.13887954E-10
0.22594640E-01
0.45107409E-01
0.67438334E-01
0.89453384E-01
0.11097272
0.13176455
0.15154561
0.16998862
0.18673591
0.20141840
0.21367803
0.22319146
0.22969267
0.23299244
0.23299244
0.22969267
0.22319146
0.21367803
0.20141840
0.18673591
0.16998863
0.15154561
0.13176455
0.11097272
0.89453384E-01
0.67438334E-01
0.45107409E-01
0.22594640E-01
0.13887959E-10
0.13887954E-10
0.22560213E-01
0.45030944E-01
0.67305513E-01
0.89244932E-01
0.11066680
0.13133952
0.15098296
0.16927557
0.18586767
0.20039959
0.21252325
0.22192481
0.22834645
0.23160487
0.23160487
0.22834645
0.22192481
0.21252325
0.20039959
0.18586767
0.16927557
0.15098296
0.13133952
0.11066680
0.89244939E-01
0.67305513E-01
0.45030944E-01
0.22560215E-01
0.13887959E-10
0.13887954E-10
0.22522585E-01
0.44948455E-01
0.67164585E-01
0.89027300E-01
0.11035179
0.13090670
0.15041494
0.16856050
0.18500136
0.19938691
0.21137860
0.22067176
0.22701633
0.23023471
0.23023471
0.22701633
0.22067176
0.21137860
0.19938691
0.18500136
0.16856050
0.15041494
0.13090670
0.11035179
0.89027300E-01
0.67164585E-01
0.44948459E-01
0.22522585E-01
0.13887959E-10
0.13887954E-10
0.22481916E-01
0.44860259E-01
0.67015976E-01
0.88800974E-01
0.11002818
0.13046657
0.14984193
0.16784367
0.18413711
0.19838029
0.21024387
0.21943188
0.22570176
0.22888137
0.22888137
0.22570176
0.21943188
0.21024387
0.19838029
0.18413711
0.16784367
0.14984193
0.13046658
0.11002818
0.88800974E-01
0.67015976E-01
0.44860259E-01
0.22481916E-01
0.13887959E-10
0.13887954E-10
0.22438364E-01
0.44766646E-01
0.66860087E-01
0.88566422E-01
0.10969649
0.13001958
0.14926432
0.16712533
0.18327498
0.19737966
0.20911880
0.21820481
0.22440231
0.22754435
0.22754435
0.22440231
0.21820481
0.20911880
0.19737966
0.18327498
0.16712533
0.14926432
0.13001958
0.10969649
0.88566422E-01
0.66860087E-01
0.44766646E-01
0.22438364E-01
0.13887959E-10
0.13887954E-10
0.22392074E-01
0.44667896E-01
0.66697307E-01
0.88324100E-01
0.10935715
0.12956613
0.14868246
0.16640571
0.18241507
0.19638495
0.20800316
0.21699019
0.22311749
0.22622313
0.22622313
0.22311749
0.21699019
0.20800316
0.19638495
0.18241507
0.16640571
0.14868246
0.12956613
0.10935716
0.88324100E-01
0.66697307E-01
0.44667896E-01
0.22392074E-01
0.13887959E-10
0.13887954E-10
0.22343190E-01
0.44564281E-01
0.66528007E-01
0.88074431E-01
0.10901063
0.12910667
0.14809667
0.16568501
0.18155746
0.19539608
0.20689675
0.21578768
0.22184688
0.22491720
0.22491720
0.22184688
0.21578768
0.20689675
0.19539608
0.18155746
0.16568501
0.14809667
0.12910667
0.10901063
0.88074431E-01
0.66528007E-01
0.44564281E-01
0.22343190E-01
0.13887959E-10
0.13887954E-10
0.22291847E-01
0.44456057E-01
0.66352531E-01
0.87817833E-01
0.10865735
0.12864158
0.14750728
0.16496348
0.18070224
0.19441298
0.20579934
0.21459693
0.22059005
0.22362614
0.22362614
0.22059005
0.21459694
0.20579936
0.19441298
0.18070224
0.16496348
0.14750728
0.12864158
0.10865735
0.87817833E-01
0.66352531E-01
0.44456057E-01
0.22291848E-01
0.13887959E-10
0.13887954E-10
0.22238176E-01
0.44343475E-01
0.66171221E-01
0.87554686E-01
0.10829770
0.12817124
0.14691459
0.16424130
0.17984946
0.19343558
0.20471077
0.21341765
0.21934661
0.22234946
0.22234946
0.21934661
0.21341766
0.20471077
0.19343558
0.17984946
0.16424130
0.14691459
0.12817124
0.10829770
0.87554686E-01
0.66171221E-01
0.44343475E-01
0.22238176E-01
0.13887959E-10
0.13887954E-10
0.22182301E-01
0.44226766E-01
0.65984406E-01
0.87285377E-01
0.10793208
0.12769599
0.14631888
0.16351864
0.17899919
0.19246383
0.20363079
0.21224953
0.21811618
0.22108677
0.22108677
0.21811618
0.21224953
0.20363079
0.19246383
0.17899919
0.16351865
0.14631888
0.12769599
0.10793208
0.87285377E-01
0.65984406E-01
0.44226766E-01
0.22182301E-01
0.13887959E-10
0.13887954E-10
0.22124341E-01
0.44106156E-01
0.65792374E-01
0.87010257E-01
0.10756087
0.12721619
0.14572045
0.16279572
0.17815150
0.19149765
0.20255926
0.21109228
0.21689838
0.21983764
0.21983764
0.21689838
0.21109228
0.20255926
0.19149765
0.17815150
0.16279572
0.14572045
0.12721619
0.10756087
0.87010257E-01
0.65792374E-01
0.44106156E-01
0.22124341E-01
0.13887959E-10
0.13887954E-10
0.22064408E-01
0.43981858E-01
0.65595441E-01
0.86729668E-01
0.10718440
0.12673217
0.14511956
0.16207267
0.17730646
0.19053701
0.20149599
0.20994562
0.21569288
0.21860169
0.21860169
0.21569288
0.20994562
0.20149599
0.19053701
0.17730646
0.16207267
0.14511956
0.12673217
0.10718440
0.86729668E-01
0.65595441E-01
0.43981858E-01
0.22064408E-01
0.13887959E-10
0.13887954E-10
0.22002611E-01
0.43854080E-01
0.65393873E-01
0.86443938E-01
0.10680302
0.12624423
0.14451645
0.16134970
0.17646410
0.18958181
0.20044081
0.20880927
0.21449931
0.21737853
0.21737853
0.21449931
0.20880927
0.20044081
0.18958181
0.17646410
0.16134970
0.14451645
0.12624423
0.10680302
0.86443938E-01
0.65393873E-01
0.43854080E-01
0.22002613E-01
0.13887959E-10
0.13887954E-10
0.21939056E-01
0.43723021E-01
0.65187946E-01
0.86153381E-01
0.10641706
0.12575267
0.14391136
0.16062692
0.17562449
0.18863203
0.19939354
0.20768300
0.21331736
0.21616782
0.21616782
0.21331736
0.20768300
0.19939354
0.18863203
0.17562449
0.16062692
0.14391136
0.12575267
0.10641706
0.86153381E-01
0.65187946E-01
0.43723021E-01
0.21939056E-01
0.13887959E-10
0.13887954E-10
0.21873839E-01
0.43588866E-01
0.64977907E-01
0.85858293E-01
0.10602681
0.12525778
0.14330453
0.15990451
0.17478769
0.18768758
0.19835404
0.20656653
0.21214673
0.21496920
0.21496920
0.21214673
0.20656653
0.19835404
0.18768758
0.17478769
0.15990451
0.14330453
0.12525778
0.10602681
0.85858293E-01
0.64977914E-01
0.43588866E-01
0.21873841E-01
0.13887959E-10
0.13887954E-10
0.21807058E-01
0.43451790E-01
0.64764015E-01
0.85558951E-01
0.10563257
0.12475981
0.14269616
0.15918259
0.17395371
0.18674842
0.19732215
0.20545964
0.21098711
0.21378236
0.21378236
0.21098711
0.20545965
0.19732215
0.18674842
0.17395371
0.15918259
0.14269616
0.12475982
0.10563257
0.85558951E-01
0.64764015E-01
0.43451790E-01
0.21807058E-01
0.13887959E-10
0.13887954E-10
0.21738799E-01
0.43311972E-01
0.64546496E-01
0.85255638E-01
0.10523462
0.12425904
0.14208646
0.15846130
0.17312263
0.18581450
0.19629771
0.20436212
0.20983821
0.21260695
0.21260695
0.20983821
0.20436212
0.19629771
0.18581450
0.17312263
0.15846130
0.14208648
0.12425904
0.10523462
0.85255638E-01
0.64546496E-01
0.43311972E-01
0.21738801E-01
0.13887959E-10
0.13887954E-10
0.21669153E-01
0.43169569E-01
0.64325571E-01
0.84948607E-01
0.10483322
0.12375570
0.14147565
0.15774077
0.17229447
0.18488576
0.19528060
0.20327373
0.20869976
0.21144269
0.21144269
0.20869976
0.20327373
0.19528060
0.18488576
0.17229447
0.15774077
0.14147565
0.12375571
0.10483322
0.84948607E-01
0.64325571E-01
0.43169569E-01
0.21669153E-01
0.13887959E-10
0.13887954E-10
0.21598199E-01
0.43024745E-01
0.64101458E-01
0.84638104E-01
0.10442864
0.12325004
0.14086390
0.15702112
0.17146927
0.18396215
0.19427069
0.20219427
0.20757152
0.21028930
0.21028930
0.20757152
0.20219427
0.19427069
0.18396215
0.17146927
0.15702112
0.14086390
0.12325004
0.10442865
0.84638104E-01
0.64101458E-01
0.43024745E-01
0.21598199E-01
0.13887959E-10
0.13887954E-10
0.21526018E-01
0.42877641E-01
0.63874356E-01
0.84324367E-01
0.10402112
0.12274227
0.14025138
0.15630245
0.17064708
0.18304363
0.19326781
0.20112354
0.20645320
0.20914647
0.20914647
0.20645320
0.20112354
0.19326781
0.18304363
0.17064708
0.15630245
0.14025138
0.12274227
0.10402112
0.84324367E-01
0.63874356E-01
0.42877641E-01
0.21526018E-01
0.13887959E-10
0.13887954E-10
0.21452684E-01
0.42728402E-01
0.63644469E-01
0.84007621E-01
0.10361088
0.12223261
0.13963827
0.15558489
0.16982792
0.18213014
0.19227187
0.20006134
0.20534460
0.20801395
0.20801395
0.20534460
0.20006134
0.19227187
0.18213016
0.16982792
0.15558490
0.13963827
0.12223261
0.10361088
0.84007621E-01
0.63644469E-01
0.42728405E-01
0.21452686E-01
0.13887959E-10
0.13887954E-10
0.21378271E-01
0.42577170E-01
0.63411966E-01
0.83688088E-01
0.10319815
0.12172125
0.13902475
0.15486853
0.16901182
0.18122165
0.19128275
0.19900748
0.20424545
0.20689149
0.20689149
0.20424545
0.19900748
0.19128275
0.18122166
0.16901182
0.15486853
0.13902475
0.12172125
0.10319815
0.83688088E-01
0.63411966E-01
0.42577170E-01
0.21378271E-01
0.13887959E-10
0.13887954E-10
0.21302843E-01
0.42424064E-01
0.63177042E-01
0.83365962E-01
0.10278313
0.12120841
0.13841094
0.15415347
0.16819881
0.18031810
0.19030030
0.19796179
0.20315555
0.20577882
0.20577882
0.20315555
0.19796179
0.19030030
0.18031810
0.16819881
0.15415347
0.13841094
0.12120841
0.10278314
0.83365962E-01
0.63177042E-01
0.42424064E-01
0.21302845E-01
0.13887959E-10
0.13887954E-10
0.21226471E-01
0.42269219E-01
0.62939852E-01
0.83041444E-01
0.10236604
0.12069424
0.13779701
0.15343980
0.16738890
0.17941946
0.18932445
0.19692411
0.20207466
0.20467573
0.20467573
0.20207466
0.19692411
0.18932445
0.17941946
0.16738890
0.15343980
0.13779701
0.12069424
0.10236604
0.83041444E-01
0.62939852E-01
0.42269219E-01
0.21226471E-01
0.13887959E-10
0.13887954E-10
0.21149216E-01
0.42112745E-01
0.62700570E-01
0.82714714E-01
0.10194705
0.12017895
0.13718309
0.15272760
0.16658215
0.17852566
0.18835506
0.19589426
0.20100261
0.20358199
0.20358199
0.20100261
0.19589426
0.18835506
0.17852566
0.16658215
0.15272760
0.13718309
0.12017895
0.10194705
0.82714714E-01
0.62700570E-01
0.42112745E-01
0.21149216E-01
0.13887959E-10
0.13887954E-10
0.21071134E-01
0.41954760E-01
0.62459338E-01
0.82385965E-01
0.10152636
0.11966268
0.13656932
0.15201697
0.16577856
0.17763667
0.18739203
0.19487208
0.19993918
0.20249736
0.20249736
0.19993918
0.19487208
0.18739203
0.17763668
0.16577856
0.15201697
0.13656932
0.11966268
0.10152636
0.82385965E-01
0.62459338E-01
0.41954763E-01
0.21071136E-01
0.13887959E-10
0.13887954E-10
0.20992288E-01
0.41795373E-01
0.62216312E-01
0.82055360E-01
0.10110415
0.11914560
0.13595581
0.15130799
0.16497815
0.17675246
0.18643527
0.19385743
0.19888417
0.20142165
0.20142165
0.19888417
0.19385743
0.18643527
0.17675246
0.16497815
0.15130799
0.13595581
0.11914560
0.10110415
0.82055360E-01
0.62216312E-01
0.41795373E-01
0.20992288E-01
0.13887959E-10
0.13887954E-10
0.20912727E-01
0.41634679E-01
0.61971623E-01
0.81723057E-01
0.10068056
0.11862786
0.13534270
0.15060070
0.16418095
0.17587298
0.18548466
0.19285016
0.19783744
0.20035464
0.20035464
0.19783744
0.19285016
0.18548466
0.17587298
0.16418095
0.15060070
0.13534270
0.11862787
0.10068056
0.81723057E-01
0.61971627E-01
0.41634679E-01
0.20912727E-01
0.13887959E-10
0.13887954E-10
0.20832507E-01
0.41472785E-01
0.61725415E-01
0.81389211E-01
0.10025577
0.11810961
0.13473010
0.14989521
0.16338696
0.17499819
0.18454014
0.19185013
0.19679877
0.19929615
0.19929615
0.19679877
0.19185013
0.18454014
0.17499819
0.16338696
0.14989521
0.13473010
0.11810961
0.10025577
0.81389211E-01
0.61725415E-01
0.41472785E-01
0.20832507E-01
0.13887959E-10
0.13887954E-10
0.20751674E-01
0.41309778E-01
0.61477810E-01
0.81053972E-01
0.99829920E-01
0.11759099
0.13411811
0.14919156
0.16259620
0.17412806
0.18360160
0.19085719
0.19576801
0.19824600
0.19824600
0.19576801
0.19085719
0.18360160
0.17412806
0.16259620
0.14919156
0.13411811
0.11759099
0.99829927E-01
0.81053972E-01
0.61477810E-01
0.41309778E-01
0.20751674E-01
0.13887959E-10
0.13887954E-10
0.20670278E-01
0.41145753E-01
0.61228931E-01
0.80717482E-01
0.99403165E-01
0.11707211
0.13350683
0.14848983
0.16180870
0.17326254
0.18266895
0.18987121
0.19474500
0.19720401
0.19720401
0.19474500
0.18987121
0.18266895
0.17326254
0.16180870
0.14848983
0.13350683
0.11707212
0.99403165E-01
0.80717482E-01
0.61228931E-01
0.41145753E-01
0.20670278E-01
0.13887959E-10
0.13887954E-10
0.20588363E-01
0.40980790E-01
0.60978889E-01
0.80379874E-01
0.98975629E-01
0.11655312
0.13289638
0.14779006
0.16102445
0.17240159
0.18174210
0.18889208
0.19372958
0.19617000
0.19617000
0.19372958
0.18889210
0.18174210
0.17240159
0.16102445
0.14779006
0.13289638
0.11655313
0.98975629E-01
0.80379874E-01
0.60978889E-01
0.40980794E-01
0.20588363E-01
0.13887959E-10
0.13887954E-10
0.20505972E-01
0.40814977E-01
0.60727805E-01
0.80041274E-01
0.98547451E-01
0.11603413
0.13228683
0.14709233
0.16024348
0.17154519
0.18082099
0.18791969
0.19272161
0.19514380
0.19514380
0.19272161
0.18791969
0.18082099
0.17154519
0.16024348
0.14709233
0.13228683
0.11603413
0.98547451E-01
0.80041274E-01
0.60727805E-01
0.40814977E-01
0.20505972E-01
0.13887959E-10
0.13887954E-10
0.20423148E-01
0.40648386E-01
0.60475774E-01
0.79701811E-01
0.98118752E-01
0.11551525
0.13167828
0.14639668
0.15946579
0.17069329
0.17990552
0.18695389
0.19172093
0.19412526
0.19412526
0.19172093
0.18695389
0.17990552
0.17069329
0.15946579
0.14639668
0.13167828
0.11551525
0.98118752E-01
0.79701811E-01
0.60475774E-01
0.40648386E-01
0.20423148E-01
0.13887959E-10
0.13887954E-10
0.20339927E-01
0.40481091E-01
0.60222905E-01
0.79361588E-01
0.97689651E-01
0.11499657
0.13107081
0.14570315
0.15869139
0.16984586
0.17899562
0.18599460
0.19072741
0.19311425
0.19311425
0.19072741
0.18599460
0.17899562
0.16984586
0.15869139
0.14570315
0.13107081
0.11499657
0.97689651E-01
0.79361588E-01
0.60222905E-01
0.40481091E-01
0.20339927E-01
0.13887959E-10
0.13887954E-10
0.20256346E-01
0.40313162E-01
0.59969287E-01
0.79020724E-01
0.97260259E-01
0.11447823
0.13046449
0.14501181
0.15792030
0.16900288
0.17809121
0.18504168
0.18974093
0.19211058
0.19211058
0.18974093
0.18504168
0.17809121
0.16900288
0.15792030
0.14501181
0.13046449
0.11447823
0.97260267E-01
0.79020724E-01
0.59969287E-01
0.40313162E-01
0.20256346E-01
0.13887959E-10
0.13887954E-10
0.20172445E-01
0.40144671E-01
0.59715014E-01
0.78679323E-01
0.96830688E-01
0.11396030
0.12985942
0.14432268
0.15715250
0.16816430
0.17719224
0.18409504
0.18876134
0.19111414
0.19111414
0.18876134
0.18409504
0.17719224
0.16816430
0.15715250
0.14432268
0.12985942
0.11396030
0.96830688E-01
0.78679323E-01
0.59715014E-01
0.40144671E-01
0.20172445E-01
0.13887959E-10
0.13887954E-10
0.20088254E-01
0.39975680E-01
0.59460174E-01
0.78337483E-01
0.96401043E-01
0.11344288
0.12925564
0.14363582
0.15638803
0.16733009
0.17629862
0.18315458
0.18778852
0.19012478
0.19012478
0.18778852
0.18315458
0.17629862
0.16733009
0.15638803
0.14363582
0.12925564
0.11344288
0.96401043E-01
0.78337483E-01
0.59460178E-01
0.39975680E-01
0.20088254E-01
0.13887959E-10
0.13887954E-10
0.20003805E-01
0.39806247E-01
0.59204850E-01
0.77995300E-01
0.95971406E-01
0.11292605
0.12865324
0.14295125
0.15562686
0.16650021
0.17541029
0.18222022
0.18682235
0.18914239
0.18914239
0.18682235
0.18222022
0.17541029
0.16650021
0.15562686
0.14295125
0.12865324
0.11292605
0.95971406E-01
0.77995300E-01
0.59204854E-01
0.39806247E-01
0.20003805E-01
0.13887959E-10
0.13887954E-10
0.19919133E-01
0.39636433E-01
0.58949124E-01
0.77652872E-01
0.95541880E-01
0.11240990
0.12805228
0.14226903
0.15486902
0.16567466
0.17452718
0.18129183
0.18586273
0.18816681
0.18816681
0.18586273
0.18129183
0.17452718
0.16567466
0.15486902
0.14226903
0.12805228
0.11240990
0.95541880E-01
0.77652872E-01
0.58949124E-01
0.39636433E-01
0.19919133E-01
0.13887959E-10
0.13887954E-10
0.19834263E-01
0.39466295E-01
0.58693063E-01
0.77310272E-01
0.95112555E-01
0.11189452
0.12745281
0.14158918
0.15411450
0.16485336
0.17364924
0.18036936
0.18490954
0.18719794
0.18719794
0.18490954
0.18036936
0.17364924
0.16485336
0.15411450
0.14158918
0.12745281
0.11189452
0.95112555E-01
0.77310272E-01
0.58693063E-01
0.39466295E-01
0.19834263E-01
0.13887959E-10
0.13887954E-10
0.19749224E-01
0.39295882E-01
0.58436744E-01
0.76967597E-01
0.94683513E-01
0.11137996
0.12685490
0.14091173
0.15336330
0.16403633
0.17277639
0.17945269
0.18396267
0.18623567
0.18623567
0.18396267
0.17945269
0.17277639
0.16403633
0.15336330
0.14091173
0.12685490
0.11137997
0.94683513E-01
0.76967597E-01
0.58436744E-01
0.39295882E-01
0.19749224E-01
0.13887959E-10
0.13887954E-10
0.19664045E-01
0.39125245E-01
0.58180235E-01
0.76624915E-01
0.94254829E-01
0.11086631
0.12625858
0.14023671
0.15261543
0.16322352
0.17190857
0.17854175
0.18302202
0.18527988
0.18527988
0.18302202
0.17854175
0.17190859
0.16322352
0.15261543
0.14023671
0.12625858
0.11086632
0.94254829E-01
0.76624915E-01
0.58180235E-01
0.39125245E-01
0.19664045E-01
0.13887959E-10
0.13887954E-10
0.19578749E-01
0.38954433E-01
0.57923600E-01
0.76282308E-01
0.93826577E-01
0.11035363
0.12566394
0.13956416
0.15187088
0.16241488
0.17104575
0.17763646
0.18208750
0.18433045
0.18433045
0.18208750
0.17763646
0.17104575
0.16241488
0.15187088
0.13956416
0.12566394
0.11035363
0.93826577E-01
0.76282308E-01
0.57923600E-01
0.38954433E-01
0.19578749E-01
0.13887959E-10
0.13887954E-10
0.19493360E-01
0.38783491E-01
0.57666901E-01
0.75939834E-01
0.93398839E-01
0.10984199
0.12507099
0.13889410
0.15112965
0.16161041
0.17018786
0.17673673
0.18115899
0.18338728
0.18338728
0.18115899
0.17673673
0.17018786
0.16161041
0.15112966
0.13889410
0.12507100
0.10984199
0.93398839E-01
0.75939834E-01
0.57666901E-01
0.38783491E-01
0.19493360E-01
0.13887959E-10
0.13887954E-10
0.19407902E-01
0.38612466E-01
0.57410195E-01
0.75597577E-01
0.92971675E-01
0.10933144
0.12447981
0.13822654
0.15039176
0.16081007
0.16933484
0.17584249
0.18023643
0.18245028
0.18245028
0.18023643
0.17584249
0.16933484
0.16081007
0.15039176
0.13822654
0.12447981
0.10933144
0.92971675E-01
0.75597577E-01
0.57410195E-01
0.38612466E-01
0.19407902E-01
0.13887959E-10
0.13887954E-10
0.19322397E-01
0.38441394E-01
0.57153545E-01
0.75255588E-01
0.92545144E-01
0.10882205
0.12389041
0.13756151
0.14965717
0.16001384
0.16848664
0.17495367
0.17931971
0.18151936
0.18151936
0.17931971
0.17495367
0.16848664
0.16001384
0.14965717
0.13756151
0.12389042
0.10882205
0.92545152E-01
0.75255588E-01
0.57153545E-01
0.38441394E-01
0.19322397E-01
0.13887959E-10
0.13887954E-10
0.19236866E-01
0.38270313E-01
0.56896996E-01
0.74913941E-01
0.92119329E-01
0.10831386
0.12330286
0.13689904
0.14892593
0.15922168
0.16764322
0.17407021
0.17840874
0.18059440
0.18059440
0.17840874
0.17407021
0.16764322
0.15922168
0.14892593
0.13689905
0.12330286
0.10831386
0.92119329E-01
0.74913941E-01
0.56896996E-01
0.38270313E-01
0.19236866E-01
0.13887959E-10
0.13887954E-10
0.19151330E-01
0.38099270E-01
0.56640599E-01
0.74572682E-01
0.91694266E-01
0.10780694
0.12271718
0.13623916
0.14819799
0.15843357
0.16680451
0.17319201
0.17750345
0.17967534
0.17967534
0.17750345
0.17319201
0.16680451
0.15843357
0.14819799
0.13623916
0.12271719
0.10780694
0.91694266E-01
0.74572682E-01
0.56640603E-01
0.38099270E-01
0.19151330E-01
0.13887959E-10
0.13887954E-10
0.19065805E-01
0.37928291E-01
0.56384411E-01
0.74231863E-01
0.91270015E-01
0.10730132
0.12213341
0.13558185
0.14747337
0.15764949
0.16597047
0.17231902
0.17660376
0.17876206
0.17876206
0.17660376
0.17231902
0.16597047
0.15764949
0.14747337
0.13558185
0.12213341
0.10730132
0.91270015E-01
0.74231863E-01
0.56384411E-01
0.37928291E-01
0.19065805E-01
0.13887959E-10
0.13887954E-10
0.18980309E-01
0.37757412E-01
0.56128468E-01
0.73891550E-01
0.90846635E-01
0.10679705
0.12155159
0.13492717
0.14675204
0.15686940
0.16514106
0.17145120
0.17570959
0.17785449
0.17785449
0.17570959
0.17145120
0.16514106
0.15686940
0.14675204
0.13492717
0.12155159
0.10679705
0.90846635E-01
0.73891550E-01
0.56128468E-01
0.37757412E-01
0.18980309E-01
0.13887959E-10
0.13887954E-10
0.18894861E-01
0.37586670E-01
0.55872817E-01
0.73551789E-01
0.90424173E-01
0.10629418
0.12097173
0.13427509
0.14603403
0.15609328
0.16431624
0.17058845
0.17482087
0.17695257
0.17695257
0.17482087
0.17058845
0.16431624
0.15609328
0.14603403
0.13427509
0.12097173
0.10629418
0.90424173E-01
0.73551789E-01
0.55872817E-01
0.37586670E-01
0.18894861E-01
0.13887959E-10
0.13887954E-10
0.18809477E-01
0.37416089E-01
0.55617500E-01
0.73212616E-01
0.90002671E-01
0.10579275
0.12039389
0.13362566
0.14531931
0.15532112
0.16349594
0.16973072
0.17393751
0.17605619
0.17605619
0.17393751
0.16973072
0.16349594
0.15532112
0.14531931
0.13362567
0.12039389
0.10579275
0.90002671E-01
0.73212616E-01
0.55617500E-01
0.37416089E-01
0.18809477E-01
0.13887959E-10
0.13887954E-10
0.18724171E-01
0.37245702E-01
0.55362552E-01
0.72874092E-01
0.89582182E-01
0.10529280
0.11981807
0.13297889
0.14460789
0.15455288
0.16268015
0.16887796
0.17305946
0.17516528
0.17516528
0.17305946
0.16887796
0.16268015
0.15455288
0.14460790
0.13297889
0.11981807
0.10529280
0.89582182E-01
0.72874092E-01
0.55362552E-01
0.37245702E-01
0.18724171E-01
0.13887959E-10
0.13887954E-10
0.18638961E-01
0.37075534E-01
0.55108018E-01
0.72536245E-01
0.89162745E-01
0.10479436
0.11924431
0.13233475
0.14389975
0.15378854
0.16186881
0.16803010
0.17218664
0.17427978
0.17427978
0.17218664
0.16803010
0.16186881
0.15378854
0.14389975
0.13233475
0.11924431
0.10479436
0.89162745E-01
0.72536245E-01
0.55108018E-01
0.37075534E-01
0.18638961E-01
0.13887959E-10
0.13887954E-10
0.18553857E-01
0.36905613E-01
0.54853927E-01
0.72199121E-01
0.88744394E-01
0.10429747
0.11867264
0.13169330
0.14319490
0.15302806
0.16106188
0.16718709
0.17131898
0.17339961
0.17339961
0.17131898
0.16718709
0.16106188
0.15302806
0.14319491
0.13169332
0.11867265
0.10429747
0.88744394E-01
0.72199121E-01
0.54853927E-01
0.36905613E-01
0.18553857E-01
0.13887959E-10
0.13887954E-10
0.18468874E-01
0.36735967E-01
0.54600313E-01
0.71862757E-01
0.88327177E-01
0.10380216
0.11810307
0.13105454
0.14249332
0.15227143
0.16025931
0.16634890
0.17045644
0.17252471
0.17252471
0.17045644
0.16634890
0.16025931
0.15227143
0.14249332
0.13105454
0.11810307
0.10380217
0.88327177E-01
0.71862757E-01
0.54600313E-01
0.36735967E-01
0.18468874E-01
0.13887959E-10
0.13887954E-10
0.18384025E-01
0.36566611E-01
0.54347213E-01
0.71527191E-01
0.87911122E-01
0.10330846
0.11753564
0.13041846
0.14179501
0.15151864
0.15946108
0.16551545
0.16959892
0.17165500
0.17165500
0.16959892
0.16551545
0.15946108
0.15151864
0.14179501
0.13041846
0.11753564
0.10330846
0.87911122E-01
0.71527191E-01
0.54347213E-01
0.36566611E-01
0.18384025E-01
0.13887959E-10
0.13887954E-10
0.18299321E-01
0.36397576E-01
0.54094650E-01
0.71192451E-01
0.87496258E-01
0.10281640
0.11697034
0.12978508
0.14109996
0.15076965
0.15866715
0.16468669
0.16874640
0.17079042
0.17079042
0.16874640
0.16468669
0.15866715
0.15076965
0.14109996
0.12978508
0.11697034
0.10281640
0.87496258E-01
0.71192451E-01
0.54094650E-01
0.36397576E-01
0.18299321E-01
0.13887959E-10
0.13887954E-10
0.18214773E-01
0.36228880E-01
0.53842656E-01
0.70858575E-01
0.87082632E-01
0.10232601
0.11640720
0.12915438
0.14040816
0.15002444
0.15787748
0.16386259
0.16789880
0.16993091
0.16993091
0.16789880
0.16386259
0.15787748
0.15002444
0.14040816
0.12915438
0.11640721
0.10232601
0.87082632E-01
0.70858575E-01
0.53842656E-01
0.36228880E-01
0.18214773E-01
0.13887959E-10
0.13887954E-10
0.18130392E-01
0.36060542E-01
0.53591259E-01
0.70525594E-01
0.86670257E-01
0.10183731
0.11584625
0.12852640
0.13971959
0.14928299
0.15709201
0.16304307
0.16705607
0.16907641
0.16907641
0.16705607
0.16304307
0.15709201
0.14928299
0.13971959
0.12852640
0.11584625
0.10183731
0.86670257E-01
0.70525594E-01
0.53591259E-01
0.36060542E-01
0.18130392E-01
0.13887959E-10
0.13887954E-10
0.18046189E-01
0.35892580E-01
0.53340480E-01
0.70193537E-01
0.86259171E-01
0.10135032
0.11528750
0.12790114
0.13903427
0.14854528
0.15631074
0.16222812
0.16621816
0.16822685
0.16822685
0.16621816
0.16222812
0.15631074
0.14854528
0.13903427
0.12790114
0.11528750
0.10135032
0.86259171E-01
0.70193537E-01
0.53340480E-01
0.35892580E-01
0.18046189E-01
0.13887959E-10
0.13887954E-10
0.17962174E-01
0.35725016E-01
0.53090349E-01
0.69862425E-01
0.85849404E-01
0.10086507
0.11473095
0.12727858
0.13835217
0.14781128
0.15553361
0.16141768
0.16538501
0.16738220
0.16738220
0.16538501
0.16141768
0.15553363
0.14781128
0.13835217
0.12727858
0.11473095
0.10086507
0.85849404E-01
0.69862425E-01
0.53090349E-01
0.35725016E-01
0.17962174E-01
0.13887959E-10
0.13887954E-10
0.17878354E-01
0.35557862E-01
0.52840885E-01
0.69532290E-01
0.85440971E-01
0.10038158
0.11417663
0.12665874
0.13767327
0.14708096
0.15476061
0.16061169
0.16455656
0.16654238
0.16654238
0.16455656
0.16061169
0.15476061
0.14708096
0.13767327
0.12665875
0.11417663
0.10038158
0.85440971E-01
0.69532290E-01
0.52840885E-01
0.35557862E-01
0.17878354E-01
0.13887959E-10
0.13887954E-10
0.17794739E-01
0.35391141E-01
0.52592110E-01
0.69203153E-01
0.85033901E-01
0.99899873E-01
0.11362454
0.12604162
0.13699760
0.14635433
0.15399170
0.15981013
0.16373278
0.16570733
0.16570733
0.16373278
0.15981013
0.15399170
0.14635433
0.13699760
0.12604162
0.11362454
0.99899873E-01
0.85033901E-01
0.69203153E-01
0.52592110E-01
0.35391141E-01
0.17794739E-01
0.13887959E-10
0.13887954E-10
0.17711338E-01
0.35224862E-01
0.52344047E-01
0.68875037E-01
0.84628209E-01
0.99419951E-01
0.11307471
0.12542723
0.13632512
0.14563134
0.15322684
0.15901296
0.16291361
0.16487704
0.16487704
0.16291361
0.15901296
0.15322684
0.14563134
0.13632512
0.12542723
0.11307471
0.99419951E-01
0.84628209E-01
0.68875037E-01
0.52344047E-01
0.35224862E-01
0.17711338E-01
0.13887959E-10
0.13887954E-10
0.17628158E-01
0.35059042E-01
0.52096710E-01
0.68547964E-01
0.84223934E-01
0.98941848E-01
0.11252712
0.12481555
0.13565582
0.14491197
0.15246598
0.15822011
0.16209900
0.16405141
0.16405141
0.16209900
0.15822011
0.15246600
0.14491197
0.13565582
0.12481555
0.11252712
0.98941848E-01
0.84223934E-01
0.68547964E-01
0.52096713E-01
0.35059042E-01
0.17628158E-01
0.13887959E-10
0.13887954E-10
0.17545205E-01
0.34893695E-01
0.51850125E-01
0.68221956E-01
0.83821073E-01
0.98465569E-01
0.11198180
0.12420660
0.13498971
0.14419623
0.15170914
0.15743157
0.16128892
0.16323043
0.16323043
0.16128892
0.15743157
0.15170914
0.14419623
0.13498971
0.12420660
0.11198180
0.98465569E-01
0.83821073E-01
0.68221956E-01
0.51850125E-01
0.34893695E-01
0.17545205E-01
0.13887959E-10
0.13887954E-10
0.17462486E-01
0.34728833E-01
0.51604301E-01
0.67897029E-01
0.83419658E-01
0.97991131E-01
0.11143875
0.12360036
0.13432676
0.14348406
0.15095624
0.15664731
0.16048332
0.16241403
0.16241403
0.16048332
0.15664731
0.15095624
0.14348406
0.13432676
0.12360036
0.11143875
0.97991131E-01
0.83419658E-01
0.67897029E-01
0.51604301E-01
0.34728833E-01
0.17462486E-01
0.13887959E-10
0.13887954E-10
0.17380010E-01
0.34564469E-01
0.51359259E-01
0.67573205E-01
0.83019696E-01
0.97518548E-01
0.11089799
0.12299685
0.13366696
0.14277546
0.15020728
0.15586725
0.15968214
0.16160215
0.16160215
0.15968214
0.15586725
0.15020728
0.14277546
0.13366696
0.12299685
0.11089799
0.97518548E-01
0.83019696E-01
0.67573205E-01
0.51359259E-01
0.34564469E-01
0.17380010E-01
0.13887959E-10
0.13887954E-10
0.17297780E-01
0.34400612E-01
0.51115014E-01
0.67250490E-01
0.82621217E-01
0.97047836E-01
0.11035950
0.12239606
0.13301031
0.14207041
0.14946222
0.15509139
0.15888534
0.16079479
0.16079479
0.15888534
0.15509139
0.14946222
0.14207041
0.13301031
0.12239606
0.11035950
0.97047836E-01
0.82621217E-01
0.67250490E-01
0.51115014E-01
0.34400612E-01
0.17297780E-01
0.13887959E-10
0.13887954E-10
0.17215805E-01
0.34237277E-01
0.50871577E-01
0.66928908E-01
0.82224220E-01
0.96579000E-01
0.10982332
0.12179798
0.13235679
0.14136890
0.14872104
0.15431969
0.15809292
0.15999188
0.15999188
0.15809292
0.15431969
0.14872104
0.14136890
0.13235679
0.12179798
0.10982332
0.96579000E-01
0.82224220E-01
0.66928908E-01
0.50871577E-01
0.34237277E-01
0.17215805E-01
0.13887959E-10
0.13887954E-10
0.17134087E-01
0.34074470E-01
0.50628964E-01
0.66608481E-01
0.81828728E-01
0.96112050E-01
0.10928943
0.12120262
0.13170640
0.14067088
0.14798369
0.15355210
0.15730478
0.15919335
0.15919335
0.15730478
0.15355210
0.14798369
0.14067088
0.13170640
0.12120262
0.10928943
0.96112050E-01
0.81828728E-01
0.66608481E-01
0.50628964E-01
0.34074470E-01
0.17134087E-01
0.13887959E-10
0.13887954E-10
0.17052636E-01
0.33912204E-01
0.50387185E-01
0.66289209E-01
0.81434749E-01
0.95647000E-01
0.10875784
0.12060996
0.13105913
0.13997635
0.14725016
0.15278858
0.15652092
0.15839921
0.15839921
0.15652092
0.15278858
0.14725016
0.13997635
0.13105913
0.12060996
0.10875784
0.95647000E-01
0.81434749E-01
0.66289209E-01
0.50387185E-01
0.33912204E-01
0.17052636E-01
0.13887959E-10
0.13887954E-10
0.16971450E-01
0.33750486E-01
0.50146256E-01
0.65971106E-01
0.81042297E-01
0.95183857E-01
0.10822855
0.12002002
0.13041495
0.13928530
0.14652044
0.15202913
0.15574129
0.15760939
0.15760939
0.15574129
0.15202913
0.14652044
0.13928530
0.13041495
0.12002002
0.10822855
0.95183857E-01
0.81042297E-01
0.65971106E-01
0.50146256E-01
0.33750486E-01
0.16971450E-01
0.13887959E-10
0.13887954E-10
0.16890539E-01
0.33589322E-01
0.49906183E-01
0.65654196E-01
0.80651388E-01
0.94722621E-01
0.10770157
0.11943277
0.12977386
0.13859768
0.14579447
0.15127368
0.15496586
0.15682386
0.15682386
0.15496586
0.15127368
0.14579447
0.13859768
0.12977386
0.11943277
0.10770157
0.94722621E-01
0.80651388E-01
0.65654196E-01
0.49906183E-01
0.33589322E-01
0.16890539E-01
0.13887959E-10
0.13887954E-10
0.16809905E-01
0.33428725E-01
0.49666982E-01
0.65338477E-01
0.80262020E-01
0.94263315E-01
0.10717689
0.11884823
0.12913585
0.13791351
0.14507224
0.15052223
0.15419459
0.15604258
0.15604258
0.15419459
0.15052223
0.14507224
0.13791351
0.12913585
0.11884823
0.10717689
0.94263315E-01
0.80262020E-01
0.65338477E-01
0.49666982E-01
0.33428725E-01
0.16809905E-01
0.13887959E-10
0.13887954E-10
0.16729554E-01
0.33268698E-01
0.49428657E-01
0.65023966E-01
0.79874218E-01
0.93805932E-01
0.10665453
0.11826637
0.12850091
0.13723275
0.14435372
0.14977473
0.15342744
0.15526550
0.15526550
0.15342744
0.14977473
0.14435372
0.13723275
0.12850091
0.11826638
0.10665453
0.93805932E-01
0.79874218E-01
0.65023966E-01
0.49428657E-01
0.33268698E-01
0.16729554E-01
0.13887959E-10
0.13887954E-10
0.16649486E-01
0.33109251E-01
0.49191222E-01
0.64710669E-01
0.79487972E-01
0.93350478E-01
0.10613447
0.11768722
0.12786902
0.13655537
0.14363889
0.14903116
0.15266438
0.15449259
0.15449259
0.15266438
0.14903116
0.14363889
0.13655537
0.12786902
0.11768722
0.10613447
0.93350478E-01
0.79487972E-01
0.64710669E-01
0.49191222E-01
0.33109251E-01
0.16649486E-01
0.13887959E-10
0.13887954E-10
0.16569708E-01
0.32950390E-01
0.48954681E-01
0.64398594E-01
0.79103298E-01
0.92896968E-01
0.10561673
0.11711074
0.12724018
0.13588138
0.14292772
0.14829148
0.15190537
0.15372384
0.15372384
0.15190537
0.14829148
0.14292772
0.13588138
0.12724018
0.11711074
0.10561673
0.92896968E-01
0.79103298E-01
0.64398594E-01
0.48954681E-01
0.32950390E-01
0.16569708E-01
0.13887959E-10
0.13887954E-10
0.16490223E-01
0.32792117E-01
0.48719041E-01
0.64087756E-01
0.78720205E-01
0.92445388E-01
0.10510130
0.11653695
0.12661438
0.13521075
0.14222020
0.14755566
0.15115039
0.15295917
0.15295917
0.15115039
0.14755566
0.14222020
0.13521075
0.12661438
0.11653695
0.10510130
0.92445388E-01
0.78720212E-01
0.64087756E-01
0.48719041E-01
0.32792117E-01
0.16490223E-01
0.13887959E-10
0.13887954E-10
0.16411031E-01
0.32634441E-01
0.48484314E-01
0.63778155E-01
0.78338705E-01
0.91995761E-01
0.10458818
0.11596581
0.12599158
0.13454345
0.14151628
0.14682369
0.15039940
0.15219858
0.15219858
0.15039940
0.14682369
0.14151628
0.13454345
0.12599158
0.11596581
0.10458818
0.91995761E-01
0.78338705E-01
0.63778162E-01
0.48484314E-01
0.32634441E-01
0.16411031E-01
0.13887959E-10
0.13887954E-10
0.16332136E-01
0.32477368E-01
0.48250504E-01
0.63469805E-01
0.77958785E-01
0.91548078E-01
0.10407736
0.11539736
0.12537181
0.13387947
0.14081597
0.14609551
0.14965236
0.15144202
0.15144202
0.14965236
0.14609551
0.14081597
0.13387947
0.12537181
0.11539736
0.10407736
0.91548078E-01
0.77958785E-01
0.63469805E-01
0.48250504E-01
0.32477368E-01
0.16332136E-01
0.13887959E-10
0.13887954E-10
0.16253544E-01
0.32320902E-01
0.48017617E-01
0.63162707E-01
0.77580467E-01
0.91102347E-01
0.10356886
0.11483156
0.12475502
0.13321880
0.14011922
0.14537112
0.14890926
0.15068947
0.15068947
0.14890926
0.14537112
0.14011922
0.13321880
0.12475502
0.11483156
0.10356886
0.91102347E-01
0.77580467E-01
0.63162707E-01
0.48017617E-01
0.32320902E-01
0.16253544E-01
0.13887959E-10
0.13887954E-10
0.16175253E-01
0.32165047E-01
0.47785658E-01
0.62856868E-01
0.77203751E-01
0.90658560E-01
0.10306265
0.11426841
0.12414122
0.13256140
0.13942601
0.14465049
0.14817005
0.14994089
0.14994089
0.14817005
0.14465049
0.13942601
0.13256140
0.12414122
0.11426841
0.10306265
0.90658568E-01
0.77203751E-01
0.62856868E-01
0.47785658E-01
0.32165047E-01
0.16175253E-01
0.13887959E-10
0.13887954E-10
0.16097268E-01
0.32009806E-01
0.47554635E-01
0.62552288E-01
0.76828636E-01
0.90216734E-01
0.10255875
0.11370791
0.12353039
0.13190728
0.13873634
0.14393358
0.14743471
0.14919625
0.14919625
0.14743471
0.14393358
0.13873634
0.13190728
0.12353040
0.11370791
0.10255875
0.90216734E-01
0.76828636E-01
0.62552288E-01
0.47554635E-01
0.32009806E-01
0.16097268E-01
0.13887959E-10
0.13887954E-10
0.16019588E-01
0.31855185E-01
0.47324546E-01
0.62248979E-01
0.76455124E-01
0.89776859E-01
0.10205715
0.11315005
0.12292252
0.13125642
0.13805015
0.14322037
0.14670321
0.14845553
0.14845553
0.14670321
0.14322037
0.13805015
0.13125642
0.12292252
0.11315005
0.10205715
0.89776859E-01
0.76455124E-01
0.62248979E-01
0.47324546E-01
0.31855185E-01
0.16019588E-01
0.13887959E-10
0.13887954E-10
0.15942220E-01
0.31701185E-01
0.47095403E-01
0.61946940E-01
0.76083228E-01
0.89338936E-01
0.10155785
0.11259481
0.12231760
0.13060878
0.13736746
0.14251083
0.14597552
0.14771868
0.14771868
0.14597552
0.14251083
0.13736746
0.13060878
0.12231760
0.11259481
0.10155785
0.89338936E-01
0.76083228E-01
0.61946940E-01
0.47095403E-01
0.31701185E-01
0.15942220E-01
0.13887959E-10
0.13887954E-10
0.15865160E-01
0.31547807E-01
0.46867203E-01
0.61646178E-01
0.75712942E-01
0.88902965E-01
0.10106084
0.11204220
0.12171561
0.12996437
0.13668822
0.14180495
0.14525162
0.14698568
0.14698568
0.14525162
0.14180495
0.13668822
0.12996437
0.12171561
0.11204220
0.10106084
0.88902965E-01
0.75712942E-01
0.61646178E-01
0.46867207E-01
0.31547807E-01
0.15865160E-01
0.13887959E-10
0.13887954E-10
0.15788414E-01
0.31395063E-01
0.46639957E-01
0.61346695E-01
0.75344272E-01
0.88468947E-01
0.10056611
0.11149220
0.12111654
0.12932314
0.13601242
0.14110269
0.14453146
0.14625651
0.14625651
0.14453146
0.14110269
0.13601242
0.12932314
0.12111654
0.11149220
0.10056611
0.88468947E-01
0.75344272E-01
0.61346695E-01
0.46639957E-01
0.31395063E-01
0.15788414E-01
0.13887959E-10
0.13887954E-10
0.15711982E-01
0.31242944E-01
0.46413660E-01
0.61048493E-01
0.74977219E-01
0.88036880E-01
0.10007367
0.11094481
0.12052038
0.12868510
0.13534003
0.14040403
0.14381504
0.14553113
0.14553113
0.14381504
0.14040403
0.13534003
0.12868512
0.12052038
0.11094481
0.10007367
0.88036880E-01
0.74977219E-01
0.61048493E-01
0.46413660E-01
0.31242944E-01
0.15711982E-01
0.13887959E-10
0.13887954E-10
0.15635863E-01
0.31091461E-01
0.46188321E-01
0.60751576E-01
0.74611776E-01
0.87606765E-01
0.99583521E-01
0.11040003
0.11992712
0.12805024
0.13467105
0.13970895
0.14310233
0.14480951
0.14480951
0.14310233
0.13970895
0.13467105
0.12805024
0.11992712
0.11040003
0.99583521E-01
0.87606765E-01
0.74611776E-01
0.60751576E-01
0.46188321E-01
0.31091461E-01
0.15635863E-01
0.13887959E-10
0.13887954E-10
0.15560062E-01
0.30940611E-01
0.45963939E-01
0.60455941E-01
0.74247956E-01
0.87178595E-01
0.99095635E-01
0.10985783
0.11933675
0.12741852
0.13400544
0.13901743
0.14239329
0.14409164
0.14409164
0.14239329
0.13901743
0.13400544
0.12741852
0.11933675
0.10985783
0.99095635E-01
0.87178595E-01
0.74247956E-01
0.60455941E-01
0.45963939E-01
0.30940613E-01
0.15560062E-01
0.13887959E-10
0.13887954E-10
0.15484577E-01
0.30790400E-01
0.45740519E-01
0.60161594E-01
0.73885746E-01
0.86752377E-01
0.98610021E-01
0.10931821
0.11874925
0.12678993
0.13334318
0.13832943
0.14168790
0.14337748
0.14337748
0.14168790
0.13832943
0.13334318
0.12678994
0.11874925
0.10931821
0.98610021E-01
0.86752377E-01
0.73885746E-01
0.60161594E-01
0.45740519E-01
0.30790400E-01
0.15484577E-01
0.13887959E-10
0.13887954E-10
0.15409411E-01
0.30640826E-01
0.45518056E-01
0.59868537E-01
0.73525161E-01
0.86328097E-01
0.98126680E-01
0.10878117
0.11816461
0.12616447
0.13268426
0.13764495
0.14098613
0.14266701
0.14266701
0.14098613
0.13764495
0.13268426
0.12616447
0.11816461
0.10878117
0.98126680E-01
0.86328097E-01
0.73525161E-01
0.59868537E-01
0.45518056E-01
0.30640826E-01
0.15409411E-01
0.13887959E-10
0.13887954E-10
0.15334563E-01
0.30491890E-01
0.45296557E-01
0.59576768E-01
0.73166184E-01
0.85905768E-01
0.97645588E-01
0.10824669
0.11758281
0.12554210
0.13202865
0.13696395
0.14028798
0.14196020
0.14196020
0.14028798
0.13696395
0.13202865
0.12554210
0.11758281
0.10824669
0.97645588E-01
0.85905768E-01
0.73166184E-01
0.59576768E-01
0.45296557E-01
0.30491890E-01
0.15334563E-01
0.13887959E-10
0.13887954E-10
0.15260036E-01
0.30343598E-01
0.45076024E-01
0.59286289E-01
0.72808832E-01
0.85485369E-01
0.97166754E-01
0.10771476
0.11700385
0.12492282
0.13137636
0.13628641
0.13959339
0.14125703
0.14125703
0.13959339
0.13628641
0.13137636
0.12492282
0.11700385
0.10771476
0.97166754E-01
0.85485369E-01
0.72808832E-01
0.59286289E-01
0.45076024E-01
0.30343598E-01
0.15260036E-01
0.13887959E-10
0.13887954E-10
0.15185828E-01
0.30195946E-01
0.44856455E-01
0.58997102E-01
0.72453089E-01
0.85066907E-01
0.96690170E-01
0.10718539
0.11642772
0.12430660
0.13072732
0.13561231
0.13890237
0.14055747
0.14055747
0.13890237
0.13561231
0.13072732
0.12430660
0.11642772
0.10718539
0.96690170E-01
0.85066907E-01
0.72453089E-01
0.58997102E-01
0.44856455E-01
0.30195946E-01
0.15185828E-01
0.13887959E-10
0.13887954E-10
0.15111942E-01
0.30048937E-01
0.44637851E-01
0.58709200E-01
0.72098956E-01
0.84650375E-01
0.96215829E-01
0.10665855
0.11585439
0.12369344
0.13008155
0.13494164
0.13821487
0.13986149
0.13986149
0.13821487
0.13494164
0.13008155
0.12369344
0.11585439
0.10665855
0.96215829E-01
0.84650375E-01
0.72098956E-01
0.58709200E-01
0.44637851E-01
0.30048937E-01
0.15111942E-01
0.13887959E-10
0.13887954E-10
0.15038377E-01
0.29902570E-01
0.44420216E-01
0.58422592E-01
0.71746439E-01
0.84235780E-01
0.95743723E-01
0.10613424
0.11528386
0.12308332
0.12943901
0.13427436
0.13753088
0.13916910
0.13916910
0.13753088
0.13427436
0.12943903
0.12308332
0.11528386
0.10613424
0.95743723E-01
0.84235780E-01
0.71746439E-01
0.58422592E-01
0.44420216E-01
0.29902570E-01
0.15038377E-01
0.13887959E-10
0.13887954E-10
0.14965132E-01
0.29756846E-01
0.44203546E-01
0.58137268E-01
0.71395524E-01
0.83823100E-01
0.95273845E-01
0.10561244
0.11471611
0.12247622
0.12879971
0.13361047
0.13685039
0.13848023
0.13848023
0.13685039
0.13361047
0.12879971
0.12247622
0.11471611
0.10561244
0.95273845E-01
0.83823100E-01
0.71395524E-01
0.58137268E-01
0.44203546E-01
0.29756846E-01
0.14965132E-01
0.13887959E-10
0.13887954E-10
0.14892210E-01
0.29611766E-01
0.43987840E-01
0.57853237E-01
0.71046226E-01
0.83412342E-01
0.94806187E-01
0.10509315
0.11415114
0.12187213
0.12816361
0.13294993
0.13617335
0.13779488
0.13779488
0.13617335
0.13294993
0.12816361
0.12187213
0.11415114
0.10509316
0.94806187E-01
0.83412342E-01
0.71046226E-01
0.57853237E-01
0.43987840E-01
0.29611766E-01
0.14892210E-01
0.13887959E-10
0.13887954E-10
0.14819609E-01
0.29467331E-01
0.43773100E-01
0.57570487E-01
0.70698522E-01
0.83003499E-01
0.94340742E-01
0.10457637
0.11358893
0.12127102
0.12753068
0.13229273
0.13549976
0.13711302
0.13711302
0.13549976
0.13229273
0.12753068
0.12127102
0.11358893
0.10457637
0.94340742E-01
0.83003499E-01
0.70698522E-01
0.57570487E-01
0.43773100E-01
0.29467331E-01
0.14819609E-01
0.13887959E-10
0.13887954E-10
0.14747331E-01
0.29323541E-01
0.43559328E-01
0.57289027E-01
0.70352428E-01
0.82596570E-01
0.93877517E-01
0.10406207
0.11302947
0.12067289
0.12690094
0.13163884
0.13482958
0.13643464
0.13643464
0.13482958
0.13163884
0.12690094
0.12067289
0.11302947
0.10406207
0.93877517E-01
0.82596570E-01
0.70352428E-01
0.57289027E-01
0.43559328E-01
0.29323541E-01
0.14747331E-01
0.13887959E-10
0.13887954E-10
0.14675374E-01
0.29180393E-01
0.43346517E-01
0.57008848E-01
0.70007928E-01
0.82191542E-01
0.93416482E-01
0.10355026
0.11247274
0.12007772
0.12627433
0.13098826
0.13416280
0.13575971
0.13575971
0.13416280
0.13098826
0.12627433
0.12007772
0.11247274
0.10355026
0.93416482E-01
0.82191542E-01
0.70007928E-01
0.57008848E-01
0.43346517E-01
0.29180393E-01
0.14675374E-01
0.13887959E-10
0.13887954E-10
0.14603740E-01
0.29037887E-01
0.43134671E-01
0.56729950E-01
0.69665022E-01
0.81788421E-01
0.92957646E-01
0.10304091
0.11191873
0.11948550
0.12565087
0.13034095
0.13349941
0.13508822
0.13508822
0.13349941
0.13034095
0.12565087
0.11948550
0.11191873
0.10304091
0.92957646E-01
0.81788421E-01
0.69665022E-01
0.56729950E-01
0.43134671E-01
0.29037887E-01
0.14603740E-01
0.13887959E-10
0.13887954E-10
0.14532426E-01
0.28896026E-01
0.42923789E-01
0.56452334E-01
0.69323711E-01
0.81387192E-01
0.92501000E-01
0.10253402
0.11136743
0.11889621
0.12503050
0.12969691
0.13283937
0.13442013
0.13442013
0.13283937
0.12969691
0.12503050
0.11889621
0.11136743
0.10253402
0.92501000E-01
0.81387192E-01
0.69323711E-01
0.56452334E-01
0.42923789E-01
0.28896026E-01
0.14532426E-01
0.13887959E-10
0.13887954E-10
0.14461434E-01
0.28754806E-01
0.42713869E-01
0.56175996E-01
0.68983994E-01
0.80987856E-01
0.92046529E-01
0.10202958
0.11081883
0.11830983
0.12441325
0.12905610
0.13218267
0.13375542
0.13375542
0.13218267
0.12905610
0.12441325
0.11830983
0.11081883
0.10202958
0.92046529E-01
0.80987856E-01
0.68983994E-01
0.56175996E-01
0.42713869E-01
0.28754806E-01
0.14461434E-01
0.13887959E-10
0.13887954E-10
0.14390764E-01
0.28614229E-01
0.42504907E-01
0.55900935E-01
0.68645857E-01
0.80590405E-01
0.91594234E-01
0.10152759
0.11027292
0.11772636
0.12379908
0.12841851
0.13152929
0.13309407
0.13309407
0.13152929
0.12841851
0.12379908
0.11772636
0.11027292
0.10152759
0.91594234E-01
0.80590405E-01
0.68645857E-01
0.55900935E-01
0.42504907E-01
0.28614229E-01
0.14390764E-01
0.13887959E-10
0.13887954E-10
0.14320415E-01
0.28474292E-01
0.42296905E-01
0.55627145E-01
0.68309300E-01
0.80194831E-01
0.91144100E-01
0.10102803
0.10972968
0.11714576
0.12318797
0.12778412
0.13087919
0.13243608
0.13243608
0.13087919
0.12778412
0.12318797
0.11714576
0.10972968
0.10102803
0.91144100E-01
0.80194831E-01
0.68309300E-01
0.55627145E-01
0.42296905E-01
0.28474292E-01
0.14320415E-01
0.13887959E-10
0.13887954E-10
0.14250386E-01
0.28334996E-01
0.42089861E-01
0.55354625E-01
0.67974322E-01
0.79801135E-01
0.90696119E-01
0.10053088
0.10918910
0.11656804
0.12257990
0.12715292
0.13023238
0.13178141
0.13178141
0.13023238
0.12715292
0.12257990
0.11656804
0.10918910
0.10053088
0.90696119E-01
0.79801135E-01
0.67974322E-01
0.55354625E-01
0.42089861E-01
0.28334996E-01
0.14250386E-01
0.13887959E-10
0.13887954E-10
0.14180677E-01
0.28196339E-01
0.41883774E-01
0.55083372E-01
0.67640916E-01
0.79409301E-01
0.90250291E-01
0.10003614
0.10865116
0.11599319
0.12197487
0.12652488
0.12958883
0.13113004
0.13113004
0.12958883
0.12652488
0.12197487
0.11599319
0.10865116
0.10003614
0.90250291E-01
0.79409301E-01
0.67640916E-01
0.55083372E-01
0.41883774E-01
0.28196339E-01
0.14180677E-01
0.13887959E-10
0.13887954E-10
0.14111288E-01
0.28058318E-01
0.41678637E-01
0.54813385E-01
0.67309074E-01
0.79019330E-01
0.89806609E-01
0.99543810E-01
0.10811587
0.11542116
0.12137285
0.12589999
0.12894852
0.13048196
0.13048196
0.12894852
0.12589999
0.12137285
0.11542116
0.10811587
0.99543810E-01
0.89806609E-01
0.79019330E-01
0.67309074E-01
0.54813385E-01
0.41678637E-01
0.28058320E-01
0.14111288E-01
0.13887959E-10
0.13887954E-10
0.14042218E-01
0.27920937E-01
0.41474454E-01
0.54544661E-01
0.66978797E-01
0.78631215E-01
0.89365050E-01
0.99053867E-01
0.10758319
0.11485197
0.12077383
0.12527823
0.12831143
0.12983716
0.12983716
0.12831143
0.12527823
0.12077383
0.11485197
0.10758319
0.99053867E-01
0.89365050E-01
0.78631215E-01
0.66978797E-01
0.54544661E-01
0.41474458E-01
0.27920937E-01
0.14042218E-01
0.13887959E-10
0.13887954E-10
0.13973467E-01
0.27784191E-01
0.41271221E-01
0.54277197E-01
0.66650085E-01
0.78244954E-01
0.88925622E-01
0.98566301E-01
0.10705313
0.11428559
0.12017779
0.12465959
0.12767753
0.12919559
0.12919559
0.12767753
0.12465959
0.12017779
0.11428559
0.10705313
0.98566301E-01
0.88925622E-01
0.78244954E-01
0.66650085E-01
0.54277197E-01
0.41271225E-01
0.27784191E-01
0.13973467E-01
0.13887959E-10
0.13887954E-10
0.13905033E-01
0.27648078E-01
0.41068938E-01
0.54010984E-01
0.66322930E-01
0.77860534E-01
0.88488303E-01
0.98081104E-01
0.10652567
0.11372201
0.11958472
0.12404404
0.12704682
0.12855725
0.12855725
0.12704682
0.12404404
0.11958472
0.11372201
0.10652567
0.98081104E-01
0.88488303E-01
0.77860534E-01
0.66322930E-01
0.54010984E-01
0.41068938E-01
0.27648078E-01
0.13905033E-01
0.13887959E-10
EOF

rm -f xdifs.* diffusion_1.nc 

echo okay
