! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

module gtvarsearch
    use an_types, only: AN_VARIABLE_SEARCH
    type(AN_VARIABLE_SEARCH), save:: an
end module

subroutine GTVarSearchInit(urlBase)
    use an_generic, only: var_search
    use gtvarsearch
    use dc_trace, only: beginsub, endsub
    character(len = *), intent(in):: urlBase
    call beginsub('gtvarsearchinit', 'urlbase=<%c>', c1=trim(urlbase))
    call var_search(an, urlBase=urlBase)
    call endsub('gtvarsearchinit')
end subroutine

subroutine GTVarSearchNext(url, end)
    use an_generic, only: var_search
    use gtvarsearch
    use dc_trace, only: beginsub, endsub
    character(len = *), intent(out):: url
    logical, intent(out):: end
    call beginsub('gtvarsearchnext')
    call var_search(an, url=url, end=end)
    call endsub('gtvarsearchnext', 'url=%c end=%y', c1=trim(url), L=(/end/))
end subroutine
