! GTLineSave - }ϐƂĕۑ
! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.

subroutine GTLineSave(Line, name, name_result)
    use gtgraph_generic, only: Save, GTGraphSaveName
    use gtgraph_types, only: GT_LINE
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: Create, Close, Put_Attr, get_attr, add_member, &
        & Inquire
    use dc_string
    use dc_types, only: STRING
    use dc_trace, only: beginsub, endsub
    implicit none
    type(GT_LINE), intent(inout):: Line
    type(VSTRING), intent(in), optional:: name
    type(VSTRING), intent(out), optional:: name_result
    type(VSTRING):: title, member
    character(STRING):: url, cmember, vname
    type(GT_VARIABLE):: var
continue
    if (present(name)) then
        vname = name
    else
        call GTGraphSaveName(result = vname)
    endif
    call beginsub('gtlinesave', '%s', s=(/name/))
    call get_attr(Line%var, "long_name", title)
    title = "line graph of " // title
    call Create(var, trim(vname), xtype="int", overwrite=.TRUE., &
        long_name=vchar(title, len(title)))
    call Put_Attr(var, "gt_structure_class", "LINE")
    call Put_Attr(var, "gt_line_index", (/line%index/))
    call Put_Attr(var, "gt_line_type", (/line%type/))
    call Put_Attr(var, "gt_line_mark", (/line%mark/))

    ! }̃oɂȂĂ̂̏o
    call Inquire(Line%var, url=url)
    call add_member(var, url, link_name="data")
    if (associated(Line%v_axis)) then
        if (Line%v_axis%saved /= "") then
            call add_member(var, Line%v_axis%saved, link_name="vaxis")
        else
            call Save(Line%v_axis, resultname=member)
            cmember = member
            call add_member(var, cmember, link_name="vaxis")
        endif
    endif
    if (associated(Line%h_axis)) then
        if (Line%h_axis%saved /= "") then
            call add_member(var, Line%h_axis%saved, link_name="haxis")
        else
            call Save(Line%h_axis, resultname=member)
            cmember = member
            call add_member(var, cmember, link_name="haxis")
        endif
    endif
    
    call Close(var)
    print *, vchar(title, len(title)), " stored at ", trim(vname)
    if (present(name_result)) name_result = vname
    call endsub('gtlinesave')
end subroutine

