! Copyright (C) GFD Dennou Club, 2000.  All rights reserved

subroutine ANVarDelAttr(var, name, err)
    use an_types, only: AN_VARIABLE, an_variable_entry
    use an_file, only: ANFileDefineMode
    use an_vartable, only: vtable_lookup
    use netcdf_f77, only: NF_NOERR, NF_DEL_ATT, NF_ENOTINDEFINE
    use dc_error
    implicit none
    type(AN_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    logical, intent(out), optional:: err
    type(an_variable_entry):: ent
    integer:: stat
continue
    stat = vtable_lookup(var, ent)
    if (stat /= NF_NOERR) goto 999
    stat = nf_del_att(ent%fileid, ent%varid, name=name)
    if (stat == 0) goto 999
    if (stat /= NF_ENOTINDEFINE) goto 999
    stat = ANFileDefineMode(ent%fileid)
    if (stat /= NF_NOERR) goto 999
    stat = nf_del_att(ent%fileid, ent%varid, name=name)

999 continue
    call StoreError(stat, 'ANVarPutAttrChar', err)
end subroutine
