! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

subroutine GTVarGetAttrSC(var, name, value, default)
    use dc_string, only: VSTRING, assignment(=)
    use gtdata_types, only: GT_VARIABLE
    use gt_map, only: var_class, vtb_class_netcdf, vtb_class_memory
    use an_generic, only: get_attr, an_variable
    use gt_mem, only: mem_variable, get_attr
    implicit none
    type(GT_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    type(VSTRING), intent(out):: value
    character(len = *), intent(in), optional:: default
    logical:: err
    integer:: class, cid

    call var_class(var, class, cid)
    if (class == vtb_class_netcdf) then
        call get_attr(an_variable(cid), name, value, default)
    else if (class == vtb_class_memory) then
        call get_attr(mem_variable(cid), name, value, err)
        if (err) value = default
    endif
end subroutine

! character ^Ŏ󂯎ꍇ͒ʏ̕^ƓlA
! 󂯑ϐ̒ɍ킹Đ؂̂āE󔒖߂sB
! ݂Ȃꍇ default lgB

subroutine GTVarGetAttrCC(var, name, value, default)
    use dc_string, only: VSTRING, assignment(=)
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: get_attr
    implicit none
    type(GT_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    character(len = *), intent(out):: value
    character(len = *), intent(in), optional:: default
    type(VSTRING):: s
    s = ""
    call get_attr(var, name, s, default)
    value = s
    s = ""
end subroutine
