! Copyright (C) GFD Dennou Club, 2000-2001.  All rights reserved.

subroutine GTVarGetDouble(var, value, nvalue, err)
    use gtdata_types, only: GT_VARIABLE
    use gt_map, only: var_class, vtb_class_netcdf, &
        & map_to_internal_specs, gtvar_dump
    use an_generic, only: get, an_variable
    use dc_trace, only: beginsub, endsub
    use dc_error
    implicit none
    type(GT_VARIABLE), intent(inout):: var
    double precision, intent(out):: value(*)
    integer, intent(in):: nvalue
    logical, intent(out), optional:: err
    integer:: class, cid, stat
    integer, pointer:: specs(:, :)
    call var_class(var, class, cid)
    call beginsub('gtvargetdouble')
    call gtvar_dump(var)
    call map_to_internal_specs(var, specs)
    if (class == vtb_class_netcdf) then
        call get(an_variable(cid), start=specs(:, 1), count=specs(:, 2), &
            stride=specs(:, 3), imap=specs(:, 4), value=value, iostat=stat)
    else
	stat = GT_EFAKE
    endif
    call StoreError(stat, "GTVarGetDouble")
    call endsub('gtvargetdouble', 'stat=', i=(/stat/))
    deallocate(specs)
end subroutine
