! Copyright (C) GFD Dennou Club, 2001.  All rights reserved


subroutine anvarputreal(var, start, count, stride, imap, value, iostat)
    use an_types, only: an_variable
    use an_vartable, only: an_variable_entry, vtable_lookup
    use netcdf_f77, only: nf_noerr, nf_einval, nf_put_varm_real
    use an_file, only: anfiledatamode
    implicit none
    type(AN_VARIABLE), intent(in):: var
    integer, intent(in):: start(:)
    integer, intent(in):: count(:)
    integer, intent(in):: stride(:)
    integer, intent(in):: imap(:)
    real, intent(in):: value(*)
    integer, intent(out):: iostat
    integer:: ndims
    type(an_variable_entry), pointer:: ent
continue
    iostat = vtable_lookup(var, ent)
    if (iostat /= nf_noerr) return
    ndims = 0
    if (associated(ent%dimids)) ndims = size(ent%dimids)
    if (min(size(start), size(count), size(stride), size(imap)) < ndims) then
        iostat = nf_einval
        return
    endif
    iostat = anfiledatamode(ent%fileid)
    if (iostat /= nf_noerr) return
    iostat = nf_put_varm_real(ent%fileid, ent%varid, start, count, stride, &
        & imap, value)
    return
End subroutine
