    ! \obt@^ȂΌʂ͕ۏ؂Ȃ
subroutine ANVarInquireC(var, name, url, xtype)
    use an_types, only: an_variable, an_variable_entry
    use an_vartable, only: vtable_lookup
    use an_generic, only: ANXTypeName
    use an_file, only: inquire
    use dc_trace, only: beginsub, endsub, message
    use netcdf_f77, only: nf_noerr, nf_max_name, nf_inq_vartype
    type(an_variable), intent(in):: var
    ! '@' ̂Ƃ̕ϐ
    character(*), intent(out), optional:: name
    ! ϐAȂƂt@C܂ށAȂׂO
    character(*), intent(out), optional:: url
    ! ϐ̌^
    character(*), intent(out), optional:: xtype
    type(an_variable_entry), pointer:: ent
    character(len = nf_max_name):: buffer
    character(len = nf_max_name):: fbuffer
    integer:: stat, i_xtype

    stat = vtable_lookup(var, ent)
    if (stat /= nf_noerr .or. (.not. associated(ent))) return

    call beginsub('anvarinquire-c', 'var%%id=%d xtype=%y name=%y url=%y', &
        & i=(/var%id/), L=(/present(xtype), present(name), present(url)/))

    if (present(xtype)) then
        stat = nf_inq_vartype(ent%fileid, ent%varid, xtype=i_xtype)
        if (stat /= NF_NOERR) i_xtype = 0
        call ANXTypeName(i_xtype, xtype)
    endif

    if (present(name)) then
        call getname(ent, buffer)
        name = buffer
    endif

    if (present(url)) then
        call getname(ent, buffer)
        call message('ent%%fileid=%d', i=(/ent%fileid/))
        call inquire(ent%fileid, name=fbuffer)
        url = trim(fbuffer) // '?' // trim(buffer)
    endif

    call endsub('anvarinquire-c')
contains

    subroutine getname(ent, varname)
        use netcdf_f77, only: nf_inq_varname, nf_inq_dimname
        type(an_variable_entry), intent(in):: ent
        character(len = *), intent(out):: varname
        if (ent%dimid > 0) then
            stat = nf_inq_dimname(ent%fileid, ent%dimid, varname)
        else
            stat = nf_inq_varname(ent%fileid, ent%varid, varname)
        endif
        if (stat /= NF_NOERR) varname = ""
    end subroutine

end subroutine
