! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.
! gtbinary - ϐւ̓񍀉ZqKp

! 
!   gtbinary  Zq E [IvV=l ...] 
!
! o͂ output IvV܂ gtool.nc@default
! Zq͔Cӌw. ftHgŁuZv.

subroutine help
    use sysdep
    write(*, *) "usage: gtbinary lhs operator rhs [option=value ...]"
    call AbortProgram("gtbinary")
end subroutine

program gtbinary
    use gtool
    implicit none
    type(VSTRING):: lhs, rhs, operator, output
    type(VSTRING):: arg, optname, optvalue
    type(GT_VARIABLE):: lvar, rvar, ovar
    double precision, allocatable:: lhsbuf(:), rhsbuf(:), obuf(:)
    integer:: i, nargs, siz, stat
!--
    output = "gtool.nc@default"
    nargs = GtArgCount()
    if (nargs < 3) then
        call help
    endif
    call GtArgGet(1, lhs)
    call GtArgGet(2, operator)
    call GtArgGet(3, rhs)
    do, i = 4, nargs
	call GtArgGet(i, arg)
        if (.not. gtoptionform(arg, optname, optvalue)) cycle
	if (optname == "output") then
	    output = optvalue
	endif
    enddo
    call Open(lvar, lhs)
    call Open(rvar, rhs)
    call Limit(rvar, lvar)
    call Create(ovar, url=output, copyfrom=lvar, copyvalue=.false.)
    call Slice(lvar)
    call Slice(rvar, compatible=lvar)
    call Slice(ovar, compatible=lvar)
    call Inquire(lvar, size=siz)
    allocate(lhsbuf(siz), rhsbuf(siz), obuf(siz))
    do
	call Get(lvar, lhsbuf, siz)
	call Get(rvar, rhsbuf, siz)
	call BinOp(obuf, lhsbuf, operator, rhsbuf, siz)
	call Put(ovar, obuf, siz)
	call Slice_Next(lvar, stat);  if (stat /= 0) exit
	call Slice_Next(rvar, stat);  if (stat /= 0) exit
        call Slice_Next(ovar, stat);  if (stat /= 0) exit
    enddo
    call Close(lvar)
    call Close(rvar)
    call Close(ovar)
end program

subroutine binop(out, lhs, operator, rhs, n)
    integer, intent(in):: n
    double precision, intent(out):: out(n)
    character(*), intent(in):: operator
    double precision, intent(in):: lhs(n), rhs(n)
    out(1:n) = lhs(1:n) + rhs(1:n)
end subroutine
