! Copyright (C) GFD Dennou Club, 2000.  All rights reserved

subroutine GTVarSliceNext(var, dimord, err, stat)
    use gtdata_types, only: GT_VARIABLE
    use dc_error, only: GT_EFAKE, StoreError, DC_NOERR
    use an_generic, only: slice_next
    type(GT_VARIABLE), intent(in out):: var
    integer, intent(in), optional:: dimord
    logical, intent(out), optional:: err
    integer, intent(out), optional:: stat
    integer:: mystat
    if (associated(var%an)) then
        call slice_next(var%an, stat=mystat, dimord=dimord)
    else
        mystat = GT_EFAKE
    endif
    if (present(stat)) then
        stat = mystat
        if (present(err)) err = (mystat /= DC_NOERR)
    else
        call StoreError(mystat, "GTVarSliceNext", err)
    endif
end subroutine
