! gtool_figure.f90 - gtool4 graphic objects - figure
! Copyright (C) by TOYODA Eizi, 2000.  All rights reserved.
! vi: set sw=4 ts=8:

module gtool_figure 

    use gtool_axis
    use gtool_contours
    use gtool_device
    implicit none

    type GT_FIGURE
	type(GT_AXIS):: h_axis
	type(GT_AXIS):: v_axis
	type(GT_CONTOURS):: contours
	type(VARYING_STRING):: title
	integer:: h_axis_given, v_axis_given, contours_given
    end type

    interface Init
	module procedure GtoolFigureInit
    end interface

    interface Put
	module procedure GtoolFigurePutAxis
	module procedure GtoolFigurePutContours
    end interface

    interface Display
	module procedure GtoolFigureDisplay
    end interface

contains

    subroutine GtoolFigureInit(fig)
	type(GT_FIGURE), intent(out):: fig
    continue
	fig%h_axis_given = 0
	fig%v_axis_given = 0
	fig%contours_given = 0
	fig%title = ""
    end subroutine

    subroutine GtoolFigurePutAxis(fig, axis, vertical)
	type(GT_FIGURE), intent(inout):: fig
	type(GT_AXIS), intent(in):: axis
	logical, optional, intent(in):: vertical
	logical:: v
    continue
	v = axis%vertical
	if (present(vertical)) v = vertical
	if (v) then
	    fig%v_axis = axis
	else
	    fig%h_axis = axis
	endif
    end subroutine

    subroutine GtoolFigurePutContours(fig, contours)
	type(GT_FIGURE), intent(inout):: fig
	type(GT_CONTOURS), intent(in):: contours
    continue
	fig%contours = contours
	fig%title = LongName(contours)
    end subroutine

    subroutine GtoolFigureDisplay(dev, fig)
	type(GT_DEVICE), intent(inout):: dev
	type(GT_FIGURE), intent(in):: fig
	character(len = 40):: titl
    continue
	titl = fig%title
	call DclSetWindow(fig%h_axis%lower, fig%h_axis%upper, &
	    & fig%v_axis%lower, fig%v_axis%upper)
	call DclSetViewport(0.2, 0.8, 0.2, 0.6)
	call DclSetTransFunction()
!	call DclSetTitle(xtitle, ytitle, xunit, yunit)
	call DclDrawTextNormalized(x=0.2, y=0.7, text=trim(titl), &
	    & height=0.04, centering=-1)
	call Display(fig%contours)
    end subroutine

end module
