# getanchor.pl - extract anchor list
# Copyright (C) TOYODA Eizi, 2000.  All rights reserved.

sub register($$) {
	local($name, $where) = @_;
	$name =~ s/\s//g;
	$where =~ s/\s//g;
	print OUTPUT $name, "\t", $where, "\n";
}

open(OUTPUT, ">anchor.txt") || die "anchor.txt: $!";

opendir(DIR, ".");
@ARGV = grep(/\.html$/, readdir(DIR));
closedir(DIR);

while (<>) {
	next unless /name=/i;
	while (1) {
		last unless /\bname\s*=/i;
		if (/\bname\s*=\s*(\w+)/i) {
			$anchor = $1;
			&register($anchor, $ARGV);
		} elsif (/\bname\s*=\s*["']([^"']*)["']/i) {
			$anchor = $1;
			&register($anchor, $ARGV);
		} else {
			print "cannot recognize line: '$_'\n";
		}
		s/\bname\s*=/XXXX/i;
	}
}

close(OUTPUT);
