program dc_hash_test
  use dc_types, only: STRING
  use dc_test, only: AssertEqual
  use dc_string, only: StoA
  use dc_hash, only: HASH, Put, Put_Line, Get, Number, Delete
  use dc_trace, only: SetDebug
  implicit none
  type(HASH) :: hashv
  character(STRING) :: value
  logical :: found
continue

  call SetDebug

  call Put(hashv, 'hoge', 'hero')
  call Put(hashv, 'key', 'value')
  call Put(hashv, 'hoge  ', 'foo')
  call Put(hashv, 'local', 'demo')
  call Get(hashv, 'hoge', value)
  call AssertEqual('Put, Get test 1', 'foo', value)

  call Get(hashv, 'not+found', value, found)
  call AssertEqual('Put, Get test 2', '', value)
  call AssertEqual('Put, Get test 3', .false., found)

  call Get(hashv, 'local', value, found)
  call AssertEqual('Put, Get test 4', 'demo', value)
  call AssertEqual('Put, Get test 5', .true., found)

  call AssertEqual('Number test', 3, number(hashv))

  call Delete(hashv, 'hogehoge')
  call AssertEqual('Delete test 1', 3, number(hashv))
  
  call Delete(hashv, 'hoge')
  call AssertEqual('Delete test 2', 2, number(hashv))
  
  call Delete(hashv, 'key')
  call AssertEqual('Delete test 3', 1, number(hashv))
  
  call Delete(hashv, 'local')
  call AssertEqual('Delete test 4', 0, number(hashv))
  
  call Put(hashv, 'new', 'val1')
!  call Put_Line(hashv)

  call Delete(hashv)

end program dc_hash_test
