!== netcdf_f77_win.f90 - netCDF original interface module (for Windows IntelVisualFortran)
!
! Authors::   Naohito OTOBE, Eizi TOYODA, Yasuhiro MORIKAWA
! Version::   $Id: netcdf_f77_win.f90,v 1.1 2007/04/17 15:29:20 morikawa Exp $
! Tag Name::  $Name: gt4f90io-20070417 $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2005. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!


module netcdf_f77
  !
  ! ܥ⥸塼뷲 netCDF ꥸʥ netcdf.inc 
  ! Ѥ٤ΤǤnetcdf.inc ؤλȤϤƤޤ
  !
!
!DEC$OBJCOMMENT LIB:'netcdf.LIB'
!DEC$OBJCOMMENT LIB:'netcdfs.LIB'
!

  use dc_types, only: NF_KIND_INT1, NF_KIND_INT2

  implicit none

  !
  ! --- symbols ---
  !

  !
  ! external netCDF data type ID
  !

  integer, parameter:: NF_BYTE = 1
  integer, parameter:: NF_INT1 = NF_BYTE
  integer, parameter:: NF_CHAR = 2
  integer, parameter:: NF_SHORT = 3
  integer, parameter:: NF_INT2 = NF_SHORT
  integer, parameter:: NF_INT = 4
  integer, parameter:: NF_FLOAT = 5
  integer, parameter:: NF_REAL = NF_FLOAT
  integer, parameter:: NF_DOUBLE = 6

  !
  ! default fill values
  !

  integer, parameter:: NF_FILL_BYTE = -127
  integer, parameter:: NF_FILL_INT1 = NF_FILL_BYTE
  integer, parameter:: NF_FILL_CHAR = 0
  integer, parameter:: NF_FILL_SHORT = -32767
  integer, parameter:: NF_FILL_INT2 = NF_FILL_SHORT
  integer, parameter:: NF_FILL_INT = -2147483647
  real, parameter:: NF_FILL_FLOAT = 9.9692099683868690e+36
  real, parameter:: NF_FILL_REAL = NF_FILL_FLOAT
  double precision, parameter:: &
    & NF_FILL_DOUBLE = 9.9692099683868690e+36

  !
  ! mode flags for opening and creating a netcdf dataset:
  !

  integer, parameter:: NF_NOWRITE = 0
  integer, parameter:: NF_WRITE = 1
  integer, parameter:: NF_CLOBBER = 0
  integer, parameter:: NF_NOCLOBBER = 4
  integer, parameter:: NF_FILL = 0
  integer, parameter:: NF_NOFILL = 256
  integer, parameter:: NF_LOCK = 1024
  integer, parameter:: NF_SHARE = 2048
  integer, parameter:: NF_SIZEHINT_DEFAULT = 0
  integer, parameter:: NF_ALIGN_CHUNK = -1

  !
  ! size argument for defining an unlimited dimension:
  !

  integer, parameter:: NF_UNLIMITED = 0

  !
  ! global attribute id:
  !

  integer, parameter:: NF_GLOBAL = 0

  !
  ! implementation limits:
  !

  integer, parameter:: NF_MAX_DIMS = 100
  integer, parameter:: NF_MAX_ATTRS = 2000
  integer, parameter:: NF_MAX_VARS = 2000
  integer, parameter:: NF_MAX_NAME = 128
  integer, parameter:: NF_MAX_VAR_DIMS = NF_MAX_DIMS

  !
  ! error codes:
  !

  integer, parameter:: NF_NOERR = 0
  integer, parameter:: NF_EBADID = -33
  integer, parameter:: NF_EEXIST = -35
  integer, parameter:: NF_EINVAL = -36
  integer, parameter:: NF_EPERM = -37
  integer, parameter:: NF_ENOTINDEFINE = -38
  integer, parameter:: NF_EINDEFINE = -39
  integer, parameter:: NF_EINVALCOORDS = -40
  integer, parameter:: NF_EMAXDIMS = -41
  integer, parameter:: NF_ENAMEINUSE = -42
  integer, parameter:: NF_ENOTATT = -43
  integer, parameter:: NF_EMAXATTS = -44
  integer, parameter:: NF_EBADTYPE = -45
  integer, parameter:: NF_EBADDIM = -46
  integer, parameter:: NF_EUNLIMPOS = -47
  integer, parameter:: NF_EMAXVARS = -48
  integer, parameter:: NF_ENOTVAR = -49
  integer, parameter:: NF_EGLOBAL = -50
  integer, parameter:: NF_ENOTNC = -51
  integer, parameter:: NF_ESTS = -52
  integer, parameter:: NF_EMAXNAME = -53
  integer, parameter:: NF_EUNLIMIT = -54
  integer, parameter:: NF_ENORECVARS = -55
  integer, parameter:: NF_ECHAR = -56
  integer, parameter:: NF_EEDGE = -57
  integer, parameter:: NF_ESTRIDE = -58
  integer, parameter:: NF_EBADNAME = -59
  integer, parameter:: NF_ERANGE = -60
  integer, parameter:: NF_ENOMEM = -61

  !
  ! error handling modes:
  !

  integer, parameter:: NF_FATAL = 1
  integer, parameter:: NF_VERBOSE = 2

  !
  ! --- interfaces ---
  !

  interface
    
    function nf_inq_libvers(ncerr)
      character*80   nf_inq_libvers
      integer   ncerr
    end function   nf_inq_libvers
      
    function nf_strerror(ncerr)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_STRERROR' :: NF_STRERROR
      character*80   nf_strerror
      integer   ncerr
    end function   nf_strerror
    
    function nf_issyserr(ncerr)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_ISSYSERR' :: NF_ISSYSERR
      logical  nf_issyserr
      integer  ncerr
    end function nf_issyserr
    
! control routines:
!
    function nf_inq_base_pe(ncid,pe)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_BASE_PE' :: NF_INQ_BASE_PE
      integer  nf_inq_base_pe
      integer  ncid
      integer  pe
    end function nf_inq_base_pe
    
    function nf_set_base_pe(ncid,pe)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_SET_BASE_PE' :: NF_SET_BASE_PE
      integer  nf_set_base_pe
      integer  ncid,pe
    end function nf_set_base_pe
    
    function nf_create(path,cmode,ncid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_CREATE' :: NF_CREATE
      integer  nf_create
      character(*)  path
      integer cmode, ncid
    end function nf_create
    
    function nf__create(path, cmode, initialsz, chunksizehint, ncid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF__CREATE' :: NF__CREATE
      integer  nf__create
      character*(*)       path
      integer  cmode, initialsz, chunksizehint, ncid
    end function  nf__create
    
    function nf__create_mp(path, cmode, initialsz, basepe, chunksizehint, ncid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF__CREATE_MP' :: NF__CREATE_MP
      integer nf__create_mp
      character*(*)       path
      integer  cmode, initialsz, basepe, chunksizehint, ncid
    end function nf__create_mp
    
    function nf_open(path, mode, ncid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_OPEN' :: NF_OPEN
      integer  nf_open
      character(*)  path
      integer  mode, ncid
    end function nf_open
    
    function nf__open(path, mode, chunksizehint, ncid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF__OPEN' :: NF__OPEN
      integer  nf__open
      character(*) path
      integer  mode,chunksizehint, ncid
    end function  nf__open
    
    function nf__open_mp(path, mode, basepe, chunksizehint, ncid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF__OPEN_MP' :: NF__OPEN_MP
      integer nf__open_mp
      character(*)   path
      integer   mode, basepe, chunksizehint, ncid
    end function nf__open_mp
    
    function nf_set_fill(ncid, fillmode, old_mode)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_SET_FILL' :: NF_SET_FILL
      integer  nf_set_fill
      integer  ncid, fillmode, old_mode
    end function  nf_set_fill
    
    function nf_set_default_format(format, old_format)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_SET_DEFAULT_FORMAT' :: NF_SET_DEFAULT_FORMAT
      integer  nf_set_default_format
      integer  format,  old_format
    end function  nf_set_default_format
    
    function nf_redef(ncid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_REDEF' :: NF_REDEF
      integer  nf_redef
      integer  ncid
    end function   nf_redef
    
    function nf_enddef(ncid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_ENDDEF' :: NF_ENDDEF
      integer  nf_enddef
      integer  ncid
    end function   nf_enddef
    
    function nf__enddef(ncid, h_minfree, v_align, v_minfree, r_align)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF__ENDDEF' :: NF__ENDDEF
      integer  nf__enddef
      integer  ncid, h_minfree, v_align, v_minfree, r_align
    end function nf__enddef
    
    function nf_sync(ncid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_SYNC' :: NF_SYNC
      integer  nf_sync
      integer  ncid
    end function  nf_sync
    
    function nf_abort(ncid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_ABORT' :: NF_ABORT
      integer   nf_abort
      integer   ncid
    end function  nf_abort
    
    function nf_close(ncid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_CLOSE' :: NF_CLOSE
      integer nf_close
      integer ncid
    end function  nf_close
    
    function nf_delete(ncid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_DELETE' :: NF_DELETE
      integer  nf_delete
      character(*) ncid
    end function nf_delete

!
! general inquiry routines:
!

    function nf_inq(ncid, ndims, nvars, ngatts, unlimdimid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ' :: NF_INQ
      integer  nf_inq
      integer  ncid, ndims, nvars, ngatts, unlimdimid
    end function  nf_inq
    
    function nf_inq_ndims(ncid, ndims)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_NDIMS' :: NF_INQ_NDIMS
      integer nf_inq_ndims
      integer ncid, ndims
    end function nf_inq_ndims
    
    function nf_inq_nvars(ncid, nvars)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_NVARS' :: NF_INQ_NVARS
      integer  nf_inq_nvars
      integer  ncid, nvars
    end function nf_inq_nvars

    function nf_inq_natts(ncid, ngatts)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_NATTS' :: NF_INQ_NATTS
      integer   nf_inq_natts
      integer  ncid, ngatts
    end function nf_inq_natts

    function nf_inq_unlimdim(ncid, unlimdimid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_UNLIMDIM' :: NF_INQ_UNLIMDIM
      integer   nf_inq_unlimdim
      integer   ncid, unlimdimid
    end function nf_inq_unlimdim

!
! dimension routines:
!

    function nf_def_dim(ncid, name, len, dimid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_DEF_DIM' :: NF_DEF_DIM
      integer   nf_def_dim
      integer   ncid
      character(*)  name
      integer  len, dimid
    end function nf_def_dim

    function nf_inq_dimid(ncid,name, dimid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_DIMID' :: NF_INQ_DIMID
      integer   nf_inq_dimid
      integer   ncid
      character(*) name
      integer  dimid
    end function nf_inq_dimid

    function nf_inq_dim(ncid, dimid, name, len)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_DIM' :: NF_INQ_DIM
      integer   nf_inq_dim
      integer   ncid, dimid
      character(*) name
      integer   len
    end function nf_inq_dim

    function nf_inq_dimname(ncid, dimid, name)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_DIMNAME' :: NF_INQ_DIMNAME
      integer   nf_inq_dimname
      integer   ncid, dimid
      character(*) name
    end function nf_inq_dimname

    function nf_inq_dimlen(ncid, dimid, len)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_DIMLEN' :: NF_INQ_DIMLEN
      integer   nf_inq_dimlen
      integer   ncid, dimid,len
    end function nf_inq_dimlen

    function nf_rename_dim(ncid, dimid, name)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_RENAME_DIM' :: NF_RENAME_DIM
      integer   nf_rename_dim
      integer   ncid, dimid
      character(*) name
    end function nf_rename_dim

!
! general attribute routines:
!

    function nf_inq_att(ncid, varid, name, xtype, len)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_ATT' :: NF_INQ_ATT
      integer   nf_inq_att
      integer   ncid, varid
      character(*) name
      integer   xtype, len
    end function nf_inq_att

    function nf_inq_attid(ncid, varid, name, attnum)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_ATTID' :: NF_INQ_ATTID
      integer   nf_inq_attid
      integer   ncid, varid
      character(*) name
      integer   attnum
    end function nf_inq_attid

    function nf_inq_atttype(ncid, varid, name, xtype)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_ATTTYPE' :: NF_INQ_ATTTYPE
      integer   nf_inq_atttype
      integer   ncid, varid
      character(*) name
      integer   xtype
    end function nf_inq_atttype

    function nf_inq_attlen(ncid, varid, name, len)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_ATTLEN' :: NF_INQ_ATTLEN
      integer   nf_inq_attlen
      integer   ncid, varid
      character(*) name
      integer   len
    end function nf_inq_attlen

    function nf_inq_attname(ncid, varid, attnum, name)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_ATTNAME' :: NF_INQ_ATTNAME
      integer   nf_inq_attname
      integer   ncid, varid, attnum
      character(*) name
    end function nf_inq_attname

    function nf_copy_att(ncid_in, varid_in, name, ncid_out, varid_out)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_COPY_ATT' :: NF_COPY_ATT
      integer   nf_copy_att
      integer   ncid_in, varid_in
      character(*) name
      integer   ncid_out, varid_out
    end function nf_copy_att

    function nf_rename_att(ncid, varid, curname, newname)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_RENAME_ATT' :: NF_RENAME_ATT
      integer   nf_rename_att
      integer   ncid,  varid
      character(*) curname, newname
    end function nf_rename_att

    function nf_del_att(ncid, varid, name)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_DEL_ATT' :: NF_DEL_ATT
      integer   nf_del_att
      integer   ncid, varid
      character(*) name
    end function nf_del_att

!
! attribute put/get routines:
!

    function nf_put_att_text(ncid, varid, name, len, text)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_ATT_TEXT' :: NF_PUT_ATT_TEXT
      integer   nf_put_att_text
      integer   ncid, varid
      character(*) name
      integer   len
      character(*) text
    end function nf_put_att_text

    function nf_get_att_text(ncid, varid, name, text)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_ATT_TEXT' :: NF_GET_ATT_TEXT
      integer   nf_get_att_text
      integer   ncid, varid
      character(*) name
      character(*) text
    end function nf_get_att_text

    function nf_put_att_int1(ncid, varid, name, xtype, len, i1vals )
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_ATT_INT1' :: NF_PUT_ATT_INT1
      integer   nf_put_att_int1
      integer   ncid,varid
      character(*) name
      integer   xtype,len
      integer*1  i1vals(1)
    end function nf_put_att_int1

    function nf_get_att_int1(ncid, varid, name, i1vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_ATT_INT1' :: NF_GET_ATT_INT1
      integer   nf_get_att_int1
      integer   ncid, varid
      character(*) name
      integer*1   i1vals(1)
    end function nf_get_att_int1

    function nf_put_att_int2(ncid, varid, name, xtype, len, i2vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_ATT_INT2' :: NF_PUT_ATT_INT2
      integer   nf_put_att_int2
      integer   ncid, varid
      character(*) name
      integer   xtype, len
      integer*2   i2vals(1)
    end function nf_put_att_int2

    function nf_get_att_int2(ncid, varid, name, i2vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_ATT_INT2' :: NF_GET_ATT_INT2
      integer   nf_get_att_int2
      integer   ncid, varid
      character(*) name
      integer*2   i2vals(1)
    end function nf_get_att_int2

    function nf_put_att_int(ncid, varid, name, xtype, len, ivals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_ATT_INT' :: NF_PUT_ATT_INT
      integer   nf_put_att_int
      integer   ncid, varid
      character(*) name
      integer   xtype,len
      integer   ivals(1)
    end function nf_put_att_int

    function nf_get_att_int(ncid, varid, name, ivals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_ATT_INT' :: NF_GET_ATT_INT
      integer   nf_get_att_int
      integer   ncid, varid
      character(*) name
      integer   ivals(1)
    end function nf_get_att_int

    function nf_put_att_real(ncid, varid, name, xtype, len, rvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_ATT_REAL' :: NF_PUT_ATT_REAL
      integer   nf_put_att_real
      integer   ncid, varid
      character(*) name
      integer   xtype, len
      real   rvals(1)
    end function nf_put_att_real

    function nf_get_att_real(ncid, varid, name, rvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_ATT_REAL' :: NF_GET_ATT_REAL
      integer   nf_get_att_real
      integer   ncid, varid
      character(*) name
      real  rvals(1)
    end function nf_get_att_real

    function nf_put_att_double(ncid, varid, name, xtype, len, dvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_ATT_DOUBLE' :: NF_PUT_ATT_DOUBLE
      integer   nf_put_att_double
      integer   ncid, varid
      character(*) name
      integer   xtype, len
      double precision  dvals(1)
    end function nf_put_att_double

    function nf_get_att_double(ncid, varid, name, dvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_ATT_DOUBLE' :: NF_GET_ATT_DOUBLE
      integer   nf_get_att_double
      integer   ncid, varid
      character(*) name
      double precision  dvals(1)
    end function nf_get_att_double

!
! general variable routines:
!

!      FUNCTION NF_DEF_VAR(NCID, NAME, DATATYPE, NDIMS, DIMIDS, VARID)
    function nf_def_var(ncid, name, xtype, ndims, dimids, varid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_DEF_VAR' :: NF_DEF_VAR
      integer   nf_def_var
      integer   ncid
      character(*) name
!      integer   datatype, ndims
      integer   xtype, ndims
      integer   dimids(1)
      integer   varid
    end function nf_def_var

    function nf_inq_var(ncid, varid, name, datatype, ndims, dimids, natts)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_VAR' :: NF_INQ_VAR
      integer   nf_inq_var
      integer   ncid, varid
      character(*) name
      integer   datatype, ndims
      integer   dimids(1)
      integer   natts
    end function nf_inq_var

    function nf_inq_varid(ncid, name, varid)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_VARID' :: NF_INQ_VARID
      integer   nf_inq_varid
      integer   ncid
      character(*) name
      integer   varid
    end function nf_inq_varid

    function nf_inq_varname(ncid, varid, name)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_VARNAME' :: NF_INQ_VARNAME
      integer   nf_inq_varname
      integer   ncid,  varid
      character(*) name
    end function nf_inq_varname

    function nf_inq_vartype(ncid, varid, xtype)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_VARTYPE' :: NF_INQ_VARTYPE
      integer   nf_inq_vartype
      integer   ncid, varid, xtype
    end function nf_inq_vartype

    function nf_inq_varndims(ncid, varid, ndims)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_VARNDIMS' :: NF_INQ_VARNDIMS
      integer   nf_inq_varndims
      integer   ncid,  varid, ndims
    end function nf_inq_varndims

    function nf_inq_vardimid(ncid, varid, dimids)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_VARDIMID' :: NF_INQ_VARDIMID
      integer   nf_inq_vardimid
      integer   ncid, varid
      integer   dimids(1)
    end function nf_inq_vardimid

    function nf_inq_varnatts(ncid, varid, natts)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_INQ_VARNATTS' :: NF_INQ_VARNATTS
      integer   nf_inq_varnatts
      integer   ncid, varid, natts
    end function nf_inq_varnatts

    function nf_rename_var(ncid, varid, name)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_RENAME_VAR' :: NF_RENAME_VAR
      integer   nf_rename_var
      integer   ncid,  varid
      character(*) name
    end function nf_rename_var

    function nf_copy_var(ncid_in, varid, ncid_out)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_COPY_VAR' :: NF_COPY_VAR
      integer   nf_copy_var
      integer   ncid_in, varid
      integer   ncid_out
    end function nf_copy_var

!
! entire variable put/get routines:
!

    function nf_put_var_text(ncid, varid, text)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VAR_TEXT' :: NF_PUT_VAR_TEXT
      integer   nf_put_var_text
      integer   ncid, varid
      character(*) text
    end function nf_put_var_text

    function nf_get_var_text(ncid, varid, text)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VAR_TEXT' :: NF_GET_VAR_TEXT
      integer   nf_get_var_text
      integer   ncid, varid
      character(*) text
    end function nf_get_var_text

    function nf_put_var_int1(ncid, varid, i1vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VAR_INT1' :: NF_PUT_VAR_INT1
      integer   nf_put_var_int1
      integer   ncid, varid
      integer*1   i1vals(1)
    end function nf_put_var_int1

    function nf_get_var_int1(ncid, varid, i1vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VAR_INT1' :: NF_GET_VAR_INT1
      integer   nf_get_var_int1
      integer   ncid,  varid
      integer*1   i1vals(1)
    end function nf_get_var_int1

    function nf_put_var_int2(ncid, varid, i2vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VAR_INT2' :: NF_PUT_VAR_INT2
      integer   nf_put_var_int2
      integer   ncid, varid
      integer*2   i2vals(1)
    end function nf_put_var_int2

    function nf_get_var_int2(ncid, varid, i2vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VAR_INT2' :: NF_GET_VAR_INT2
      integer   nf_get_var_int2
      integer   ncid, varid
      integer*2   i2vals(1)
    end function nf_get_var_int2

    function nf_put_var_int(ncid, varid, ivals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VAR_INT' :: NF_PUT_VAR_INT
      integer   nf_put_var_int
      integer   ncid, varid
      integer   ivals(1)
    end function nf_put_var_int

    function nf_get_var_int(ncid, varid, ivals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VAR_INT' :: NF_GET_VAR_INT
      integer   nf_get_var_int
      integer   ncid, varid
      integer   ivals(1)
    end function nf_get_var_int

    function nf_put_var_real(ncid, varid, rvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VAR_REAL' :: NF_PUT_VAR_REAL
      integer   nf_put_var_real
      integer   ncid, varid
      real  rvals(1)
    end function nf_put_var_real

    function nf_get_var_real(ncid, varid, rvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VAR_REAL' :: NF_GET_VAR_REAL
      integer   nf_get_var_real
      integer   ncid, varid
      real  rvals(1)
    end function nf_get_var_real

    function nf_put_var_double(ncid, varid, dvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VAR_DOUBLE' :: NF_PUT_VAR_DOUBLE
      integer   nf_put_var_double
      integer   ncid,  varid
      double precision     dvals(1)
    end function nf_put_var_double

    function nf_get_var_double(ncid, varid, dvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VAR_DOUBLE' :: NF_GET_VAR_DOUBLE
      integer   nf_get_var_double
      integer   ncid, varid
      double precision     dvals(1)
    end function nf_get_var_double

!
! single variable put/get routines:
!

    function nf_put_var1_text(ncid, varid, index, text)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VAR1_TEXT' :: NF_PUT_VAR1_TEXT
      integer   nf_put_var1_text
      integer   ncid, varid
      integer   index(1)
      character*1  text
    end function nf_put_var1_text

    function nf_get_var1_text(ncid, varid, index, text)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VAR1_TEXT' :: NF_GET_VAR1_TEXT
      integer   nf_get_var1_text
      integer   ncid,  varid
      integer   index(1)
      character*1     text
    end function nf_get_var1_text

    function nf_put_var1_int1(ncid, varid, index, i1val)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VAR1_INT1' :: NF_PUT_VAR1_INT1
      integer   nf_put_var1_int1
      integer   ncid, varid
      integer   index(1)
      integer*1       i1val
    end function nf_put_var1_int1

    function nf_get_var1_int1(ncid, varid, index, i1val)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VAR1_INT1' :: NF_GET_VAR1_INT1
      integer   nf_get_var1_int1
      integer   ncid, varid
      integer   index(1)
      integer*1      i1val
    end function nf_get_var1_int1

    function nf_put_var1_int2(ncid, varid, index, i2val)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VAR1_INT2' :: NF_PUT_VAR1_INT2
      integer   nf_put_var1_int2
      integer   ncid, varid
      integer   index(1)
      integer*2   i2val
    end function nf_put_var1_int2

    function nf_get_var1_int2(ncid, varid, index, i2val)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VAR1_INT2' :: NF_GET_VAR1_INT2
      integer   nf_get_var1_int2
      integer   ncid,  varid
      integer   index(1)
      integer*2   i2val
    end function nf_get_var1_int2

    function nf_put_var1_int(ncid, varid, index, ival)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VAR1_INT' :: NF_PUT_VAR1_INT
      integer   nf_put_var1_int
      integer   ncid, varid
      integer   index(1)
      integer   ival
    end function nf_put_var1_int

    function nf_get_var1_int(ncid, varid, index, ivla)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VAR1_INT' :: NF_GET_VAR1_INT
      integer   nf_get_var1_int
      integer   ncid, varid
      integer   index(1)
      integer   ival
    end function nf_get_var1_int

    function nf_put_var1_real(ncid, varid, index, rval)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VAR1_REAL' :: NF_PUT_VAR1_REAL
      integer   nf_put_var1_real
      integer   ncid, varid
      integer   index(1)
      real  rval
    end function nf_put_var1_real

    function nf_get_var1_real(ncid, varid, index, rval)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VAR1_REAL' :: NF_GET_VAR1_REAL
      integer   nf_get_var1_real
      integer   ncid, varid
      integer   index(1)
      real  rval
    end function nf_get_var1_real

    function nf_put_var1_double(ncid, varid, index, dval)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VAR1_DOUBLE' :: NF_PUT_VAR1_DOUBLE
      integer   nf_put_var1_double
      integer   ncid, varid
      integer   index(1)
      double precision     dval
    end function nf_put_var1_double

    function nf_get_var1_double(ncid, varid, index, dval)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VAR1_DOUBLE' :: NF_GET_VAR1_DOUBLE
      integer   nf_get_var1_double
      integer   ncid, varid
      integer   index(1)
      double precision     dval
    end function nf_get_var1_double

!
! variable array put/get routines:
!

    function nf_put_vara_text(ncid, varid, start, count, text)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARA_TEXT' :: NF_PUT_VARA_TEXT
      integer   nf_put_vara_text
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      character(*) text
    end function nf_put_vara_text

    function nf_get_vara_text(ncid, varid, start,count, text)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARA_TEXT' :: NF_GET_VARA_TEXT
      integer   nf_get_vara_text
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      character(*) text
    end function nf_get_vara_text

    function nf_put_vara_int1(ncid, varid, start, count, ivals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARA_INT1' :: NF_PUT_VARA_INT1
      integer   nf_put_vara_int1
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      integer*1       i1vals(1)
    end function nf_put_vara_int1

    function nf_get_vara_int1(ncid, varid, start,count, i1vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARA_INT1' :: NF_GET_VARA_INT1
      integer   nf_get_vara_int1
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      integer*1       i1vals(1)
    end function nf_get_vara_int1

    function nf_put_vara_int2(ncid, varid, start, count, i2vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARA_INT2' :: NF_PUT_VARA_INT2
      integer   nf_put_vara_int2
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      integer*2   i2vals(1)
    end function nf_put_vara_int2

    function nf_get_vara_int2(ncid, varid, start, count, i2vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARA_INT2' :: NF_GET_VARA_INT2
      integer   nf_get_vara_int2
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      integer*2   i2vals(1)
    end function nf_get_vara_int2

    function nf_put_vara_int(ncid, varid, start, count, ivals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARA_INT' :: NF_PUT_VARA_INT
      integer   nf_put_vara_int
      integer   ncid,  varid
      integer   start(1)
      integer   count(1)
      integer   ivals(1)
    end function nf_put_vara_int

    function nf_get_vara_int(ncid, varid, start, count, ivals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARA_INT' :: NF_GET_VARA_INT
      integer   nf_get_vara_int
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      integer   ivals(1)
    end function nf_get_vara_int

    function nf_put_vara_real(ncid, varid, start, count, rvals) 
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARA_REAL' :: NF_PUT_VARA_REAL
      integer   nf_put_vara_real
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      real  rvals(1)
    end function nf_put_vara_real

    function nf_get_vara_real(ncid, varid, start, count, rvals)   
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARA_REAL' :: NF_GET_VARA_REAL
      integer   nf_get_vara_real
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      real  rvals(1)
    end function nf_get_vara_real

    function nf_put_vara_double(ncid, varid, start, count, dvals) 
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARA_DOUBLE' :: NF_PUT_VARA_DOUBLE
      integer   nf_put_vara_double
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      double precision     dvals(1)
    end function nf_put_vara_double

    function nf_get_vara_double(ncid, varid, start, count, dvals) 
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARA_DOUBLE' :: NF_GET_VARA_DOUBLE
      integer   nf_get_vara_double
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      double precision     dvals(1)
    end function nf_get_vara_double

!
! strided variable put/get routines:
!

    function nf_put_vars_text(ncid, varid, start, count, stride, text)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARS_TEXT' :: NF_PUT_VARS_TEXT
      integer   nf_put_vars_text
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      integer   stride(1)
      character(*) text
    end function nf_put_vars_text

    function nf_get_vars_text(ncid, varid, start, count, stride, text)
      integer   nf_get_vars_text
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARS_TEXT' :: NF_GET_VARS_TEXT
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      integer   stride(1)
      character(*) text
    end function nf_get_vars_text

    function nf_put_vars_int1(ncid, varid, start, count, stride, i1vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARS_INT1' :: NF_PUT_VARS_INT1
      integer   nf_put_vars_int1
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      integer   stride(1)
      integer*1       i1vals(1)
    end function nf_put_vars_int1

    function nf_get_vars_int1(ncid, varid, start, count, stride, i1vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARS_INT1' :: NF_GET_VARS_INT1
      integer   nf_get_vars_int1
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      integer   stride(1)
      integer*1        i1vals(1)
    end function nf_get_vars_int1

    function nf_put_vars_int2(ncid, varid, start, count, stride, i2vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARS_INT2' :: NF_PUT_VARS_INT2
      integer   nf_put_vars_int2
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      integer   stride(1)
      integer*2   i2vals(1)
    end function nf_put_vars_int2

    function nf_get_vars_int2(ncid, varid, start, count, stride, i2vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARS_INT2' :: NF_GET_VARS_INT2
      integer   nf_get_vars_int2
      integer   ncid,  varid
      integer   start(1)
      integer   count(1)
      integer   stride(1)
      integer*2   i2vals(1)
    end function nf_get_vars_int2

    function nf_put_vars_int(ncid, varid, start, count, stride, ivals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARS_INT' :: NF_PUT_VARS_INT
      integer   nf_put_vars_int
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      integer   stride(1)
      integer   ivals(1)
    end function nf_put_vars_int

    function nf_get_vars_int(ncid, varid, start, count, stride, ivals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARS_INT2' :: NF_GET_VARS_INT
      integer   nf_get_vars_int
      integer   ncid,  varid
      integer   start(1)
      integer   count(1)
      integer   stride(1)
      integer   ivals(1)
    end function nf_get_vars_int

    function nf_put_vars_real(ncid, varid, start, count, stride, rvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARS_REAL' :: NF_PUT_VARS_REAL
      integer   nf_put_vars_real
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      integer   stride(1)
      real  rvals(1)
    end function nf_put_vars_real

    function nf_get_vars_real(ncid, varid, start, count, stride, rvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARS_REAL' :: NF_GET_VARS_REAL
      integer   nf_get_vars_real
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      integer   stride(1)
      real  rvals(1)
    end function nf_get_vars_real

    function nf_put_vars_double(ncid, varid, start, count, stride, dvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARS_DOUBLE' :: NF_PUT_VARS_DOUBLE
      integer   nf_put_vars_double
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      integer   stride(1)
      double precision     dvals(1)
    end function nf_put_vars_double

    function nf_get_vars_double(ncid, varid, start, count, stride, dvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARS_DOUBLE' :: NF_GET_VARS_DOUBLE
      integer   nf_get_vars_double
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      integer   stride(1)
      double precision     dvals(1)
    end function nf_get_vars_double

!
! mapped variable put/get routines:
!

    function nf_put_varm_text(ncid, varid, start, count, stride, imap, text)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARM_TEXT' :: NF_PUT_VARM_TEXT
      integer   nf_put_varm_text
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      integer   stride(1)
      integer   imap(1)
      character(*) text
    end function nf_put_varm_text

    function nf_get_varm_text(ncid, varid, start, count, stride, imap, text)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARM_TEXT' :: NF_GET_VARM_TEXT
      integer   nf_get_varm_text
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      integer   stride(1)
      integer   imap(1)
      character(*) text
    end function nf_get_varm_text

    function nf_put_varm_int1(ncid, varid, start, count, stride, imap, i1vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARM_INT1' :: NF_PUT_VARM_INT1
      integer   nf_put_varm_int1
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      integer   stride(1)
      integer   imap(1)
      integer*1    i1vals(1)
    end function nf_put_varm_int1

    function nf_get_varm_int1(ncid, varid, start, count, stride, imap, i1vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARM_INT1' :: NF_GET_VARM_INT1
      integer   nf_get_varm_int1
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      integer   stride(1)
      integer   imap(1)
      integer*1   i1vals(1)
    end function nf_get_varm_int1

    function nf_put_varm_int2(ncid, varid, start, count, stride, imap, i2vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARM_INT2' :: NF_PUT_VARM_INT2
      integer   nf_put_varm_int2
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      integer   stride(1)
      integer   imap(1)
      integer*2   i2vals(1)
    end function nf_put_varm_int2

    function nf_get_varm_int2(ncid, varid, start, count, stride, imap, i2vals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARM_INT2' :: NF_GET_VARM_INT2
      integer   nf_get_varm_int2
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      integer   stride(1)
      integer   imap(1)
      integer*2   i2vals(1)
    end function nf_get_varm_int2

    function nf_put_varm_int(ncid, varid, start, count, stride, imap, ivals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARM_INT' :: NF_PUT_VARM_INT
      integer   nf_put_varm_int
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      integer   stride(1)
      integer   imap(1)
      integer   ivals(1)
    end function nf_put_varm_int

    function nf_get_varm_int(ncid, varid, start, count, stride, imap, ivals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARM_INT1' :: NF_GET_VARM_INT
      integer   nf_get_varm_int
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      integer   stride(1)
      integer   imap(1)
      integer   ivals(1)
    end function nf_get_varm_int

    function nf_put_varm_real(ncid, varid, start, count, stride, imap, rvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARM_REAL' :: NF_PUT_VARM_REAL
      integer   nf_put_varm_real
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      integer   stride(1)
      integer   imap(1)
      real  rvals(1)
    end function nf_put_varm_real

    function nf_get_varm_real(ncid, varid, start, count, stride, imap, rvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARM_REAL' :: NF_GET_VARM_REAL
      integer   nf_get_varm_real
      integer   ncid,  varid
      integer   start(1)
      integer   count(1)
      integer   stride(1)
      integer   imap(1)
      real  rvals(1)
    end function nf_get_varm_real

    function nf_put_varm_double(ncid, varid, start, count, stride, imap, dvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_PUT_VARM_DOUBLE' :: NF_PUT_VARM_DOUBLE
      integer   nf_put_varm_double
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      integer   stride(1)
      integer   imap(1)
      double precision     dvals(1)
    end function nf_put_varm_double

    function nf_get_varm_double(ncid, varid, start, count, stride, imap, dvals)
!DEC$ ATTRIBUTES STDCALL, REFERENCE, MIXED_STR_LEN_ARG, DECORATE, ALIAS:'NF_GET_VARM_DOUBLE' :: NF_GET_VARM_DOUBLE
      integer   nf_get_varm_double
      integer   ncid, varid
      integer   start(1)
      integer   count(1)
      integer   stride(1)
      integer   imap(1)
      double precision     dvals(1)
    end function nf_get_varm_double

  end interface
end module netcdf_f77
