!
!==  (abstruct) netCDF 󥿡ե
!
! Authors::   Eizi TOYODA, Yasuhiro MORIKAWA
! Version::   $Id: an_generic.f90,v 1.3 2006/10/09 10:35:42 morikawa Exp $
! Tag Name::  $Name: gt4f90io-20070417 $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2005. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! This file provides an_generic
!

module an_generic
  !
  !==  netCDF 󥿡ե
  !

  use an_types, only: an_variable

  implicit none
  !
  ! === ܳư ===
  !

  !
  ! an 饤֥Ǥϡ֥եפǤϤʤѿפ򳫤Ĥꤹ롣
  ! ٤ƤΤΤѿȤ°Ǥ롣

  interface open
    ! 
    ! open(var, url, [writable], [err])  url Ǽ̤
    ! ѿ򳫤 var ˳Ǽ롣ѿȤ netCDF ѿޤ
    ! netCDF Ǥ롣Ʊ̾ netCDF ѿˤξԤ
    ! Ʊ뤵롣writable 򿿤˻ꤹȽ񤭹߲ĤǳȤ롣
    ! ǥեȤ writable=.FALSE. Ǥ롣顼ȯ
    ! err Ȥʤ롣err ͿʤХץߤ롣
    !
    recursive subroutine ANVarOpen(var, url, writable, err)
      use an_types, only: AN_VARIABLE
      type(AN_VARIABLE), intent(out):: var
      character(len = *), intent(in):: url
      logical, intent(in), optional:: writable
      logical, intent(out), optional:: err
    end subroutine ANVarOpen
    !
    ! an 饤֥ѿ netCDF ѿȼ礷
    ! Ǥ롣¤Τ¸ߤʤǡan ΩǤ
    ! ѿǤոĤμȸƤФѿĤȤȤˤʤ롣
    ! 輡ѿȸƤФƤΤϡѿʬȤΤߤ
    ! ȤƤľؤ
    !
    ! open(var, src_var, dimord, [count_compact], [err]) 
    ! ˳줿ѿ src_var  ord ܤμˤѿ
    !  var ˳Ǽ롣 ord ϸߤϰϤ
    ! ˤʤäƤ (ѥȲƤˤФ
    ! Ǥ뤬count_compact ˿ꤹ
    ! ٤ƤμΤʤνˤʤ롣
    !
    subroutine ANVarOpenByDimOrd(var, src_var, dimord, err)
      use an_types, only: AN_VARIABLE
      type(AN_VARIABLE), intent(out):: var
      type(AN_VARIABLE), intent(in):: src_var
      integer, intent(in):: dimord
      logical, intent(out), optional:: err
    end subroutine ANVarOpenByDimOrd
  end interface

  interface search_dim
    integer function an_search_dim(var, dimname)
      use an_types, only: an_variable
      type(an_variable), intent(in):: var
      character(len = *), intent(in):: dimname
    end function an_search_dim
  end interface

  interface create
    !
    ! °ѿ create
    !
    ! create(var, url, dims, [xtype], [overwrite], [err]) 
    !  url ˼ dims äѿ򳫤
    ! Τ var ˳Ǽ롣 xtype ά real 
    ! ߤʤ롣¸ѿȤԤ뤬
    ! overwrite Ǥ³Ԥ롣
    ! ѿˤ dims ĹϤȡ
    !
    subroutine ANVarCreate(var, url, xtype, dims, overwrite, err)
      use an_types, only: AN_VARIABLE
      type(AN_VARIABLE), intent(out):: var
      character(len = *), intent(in):: url
      character(len = *), intent(in):: xtype
      type(AN_VARIABLE), intent(in):: dims(:)
      logical, intent(in), optional:: overwrite
      logical, intent(out), optional:: err
    end subroutine ANVarCreate
    !
    ! ѿ create
    !
    ! create(var, url, xtype, length, [overwrite], [err]) 
    ! Ĺ length μѿ롣
    !
    subroutine ANVarCreateD(var, url, xtype, length, overwrite, err)
      use an_types, only: AN_VARIABLE
      type(AN_VARIABLE), intent(out):: var
      character(len = *), intent(in):: url
      character(len = *), intent(in):: xtype
      integer, intent(in):: length
      logical, intent(in), optional:: overwrite
      logical, intent(out), optional:: err
    end subroutine ANVarCreateD
  end interface

  interface
    subroutine ANVarDel(varname, hint, stat)
      character(len = *), intent(in):: varname
      character(len = *), intent(in):: hint
      integer, intent(out):: stat
    end subroutine ANVarDel
  end interface

  interface close
    subroutine ANVarClose(var, err)
      use an_types, only: AN_VARIABLE
      type(AN_VARIABLE), intent(in):: var
      logical, intent(out), optional:: err
    end subroutine ANVarClose
  end interface

  !
  ! === ѿ˴ؤ䤤碌 ===
  !

  ! mainly for PRINT debugging
  interface toString
    function ANVarToString(var) result(result)
      use dc_types, only: STRING
      use an_types, only: AN_VARIABLE
      character(string):: result
      type(AN_VARIABLE), intent(in):: var
    end function ANVarToString
  end interface

  interface inquire

    subroutine ANVarInquire(var, ndims, dimlen, growable, name, url, xtype)
      use an_types, only: an_variable
      type(an_variable), intent(in):: var
      ! ѿμ
      integer, intent(out), optional:: ndims
      ! ѿǤ硢Ĺ
      integer, intent(out), optional:: dimlen
      ! ѿĹǽĤ
      logical, intent(out), optional:: growable
      ! ʸûͤڤͤ᤬ꤦ
      ! '?' ΤȤѿ̾
      character(*), intent(out), optional:: name
      ! ѿ̾ʤȤե̾ޤࡢʤ٤Ĺ̾
      character(*), intent(out), optional:: url
      ! ѿη̾
      character(*), intent(out), optional:: xtype
    end subroutine ANVarInquire

    !  ndims ĤǤʤФʤʤ
    subroutine ANVarInquireIA(var, dimlen)
      use an_types, only: AN_VARIABLE
      type(AN_VARIABLE), intent(in):: var
      integer, intent(out):: dimlen(:)
    end subroutine ANVarInquireIA

    subroutine ANAttrInquire(var, attrname, xtype)
      use an_types, only: AN_VARIABLE
      type(AN_VARIABLE), intent(in):: var
      character(len=*), intent(in):: attrname
      character(len=*), intent(out), optional:: xtype
    end subroutine ANAttrInquire

  end interface

  !
  ! === °ط ===
  !

  ! ٤ƤѿȤ an 饤֥Ω줫顢
  ! °ѿ°Ȥߤʤ롣
  ! °ɤ߼ˤѿ°μ°򸡺롣
  ! °񤭹߻ˤϰ㳰ѿ°Ȥƽ񤭹ࡣ
  ! gtool4 °ȵꤵ줿° Conventions,
  ! gt_version, title, gt_subtitle, comment, source,
  ! institution, production, history ˤĤƤϤޤ
  ! °Ȥƽ񤭹⤦Ȥ롣¸ͤä
  !  Conventions, gt_version  gtool4 ƱΤʤ
  ! ǿ礭ʤ褦ˤ롣history ϵɤ
  ! ɲưԤ¾°̾ˤĤƤϴ¸Ȱۤʤ
  ! °ͤѿ°Ȥƽ񤭹ࡣ

  !
  ! --- ° ---
  !

  ! ѿ var տ路°򤹤٤ƼˤϤޤ
  ! attr_rewind(var) ƤӽФƤ̵¥롼פ
  ! attr_next(var, name, [end]) ƤӽФname ҤȤ
  ! ҤȤĤ°̾Ϳ롣name ʸˤʤäȤ
  ! ٤Ƥ°õȤˤʤ롣ΤȤ end 
  ! ͿƤФ줬ˤʤ뤳ȤǤȽǤ롣

  interface attr_rewind
    subroutine ANVarAttrRewind(var)
      use an_types, only: AN_VARIABLE
      type(AN_VARIABLE), intent(in):: var
    end subroutine ANVarAttrRewind
  end interface

  interface attr_next
    subroutine ANVarAttrNext(var, name, end)
      use an_types, only: AN_VARIABLE
      type(AN_VARIABLE), intent(in):: var
      character(len = *), intent(out):: name
      logical, intent(out), optional:: end
    end subroutine ANVarAttrNext
  end interface

  ! ѿ var ° name  value ˳Ǽ롣
  ! °¸ߤʤ value Ĺ­Ƥ
  ! default 롣°ηϤʤǤ褯Ѵ򤹤롣

  interface get_attr

    subroutine ANAttrGetChar(var, name, value, default, stat)
      use an_types, only: AN_VARIABLE
      type(AN_VARIABLE), intent(in):: var
      character(len = *), intent(in):: name
      character(len = *), intent(out):: value
      character(len = *), intent(in):: default
      integer, intent(out):: stat
    end subroutine ANAttrGetChar

    subroutine ANVarGetAttrLogical(var, name, value, default)
      use an_types, only: AN_VARIABLE
      type(AN_VARIABLE), intent(in):: var
      character(len = *), intent(in):: name
      logical, intent(out):: value
      logical, intent(in), optional:: default
    end subroutine ANVarGetAttrLogical

    ! ͸ǤϤʤɡΤʤ󥿡եȤȤ....
    ! stat = -1:  °¸ߤʤä
    ! stat = 0 ... size(value):  °ɤ߼ä stat 
    ! stat > size(value):  Ĺ­Τ°ɤ߼ʤä
    !                       stat ɬ

    subroutine AnAttrGetReal(var, name, value, stat, default)
      use an_types, only: AN_VARIABLE
      type(AN_VARIABLE), intent(in):: var
      character(len = *), intent(in):: name
      real, intent(out):: value(:)
      integer, intent(out):: stat
      real, intent(in), optional:: default
    end subroutine AnAttrGetReal

    subroutine AnAttrGetDouble(var, name, value, stat, default)
      use an_types, only: AN_VARIABLE
      type(AN_VARIABLE), intent(in):: var
      character(len = *), intent(in):: name
      double precision, intent(out):: value(:)
      integer, intent(out):: stat
      double precision, intent(in), optional:: default
    end subroutine AnAttrGetDouble

    subroutine AnAttrGetInt(var, name, value, stat, default)
      use an_types, only: AN_VARIABLE
      type(AN_VARIABLE), intent(in):: var
      character(len = *), intent(in):: name
      integer, intent(out):: value(:)
      integer, intent(out):: stat
      integer, intent(in), optional:: default
    end subroutine AnAttrGetInt

  end interface

  ! ѿ var ° name  value Ǽ롣
  ! °η value ηŬ礹褦ꤵ롣
  !  1 ʸʸȤƳǼ졢 T,
  !  F Ȥʤ롣

  interface put_attr

    subroutine ANVarPutAttrReal(var, name, value, err)
      use an_types, only: AN_VARIABLE
      type(AN_VARIABLE), intent(in):: var
      character(len = *), intent(in):: name
      real, intent(in):: value(:)
      logical, intent(out), optional:: err
    end subroutine ANVarPutAttrReal

    subroutine ANVarPutAttrDouble(var, name, value, err)
      use an_types, only: AN_VARIABLE
      type(AN_VARIABLE), intent(in):: var
      character(len = *), intent(in):: name
      double precision, intent(in):: value(:)
      logical, intent(out), optional:: err
    end subroutine ANVarPutAttrDouble

    subroutine ANVarPutAttrInt(var, name, value, err)
      use an_types, only: AN_VARIABLE
      type(AN_VARIABLE), intent(in):: var
      character(len = *), intent(in):: name
      integer, intent(in):: value(:)
      logical, intent(out), optional:: err
    end subroutine ANVarPutAttrInt

    subroutine ANVarPutAttrLogical(var, name, value, err)
      use an_types, only: AN_VARIABLE
      type(AN_VARIABLE), intent(in):: var
      character(len = *), intent(in):: name
      logical, intent(in):: value
      logical, intent(out), optional:: err
    end subroutine ANVarPutAttrLogical

    subroutine ANVarPutAttrChar(var, name, value, xtype, err)
      use an_types, only: AN_VARIABLE
      type(AN_VARIABLE), intent(in):: var
      character(len = *), intent(in):: name
      character(len = *), intent(in):: value
      character(len = *), intent(in), optional:: xtype
      logical, intent(out), optional:: err
    end subroutine ANVarPutAttrChar

  end interface

  interface del_attr
    subroutine ANVarDelAttr(var, name, err)
      use an_types, only: AN_VARIABLE
      type(AN_VARIABLE), intent(in):: var
      character(len = *), intent(in):: name
      logical, intent(out), optional:: err
    end subroutine ANVarDelAttr
  end interface

  interface copy_attr
    subroutine ANVarAttrCopy(to, attrname, from, stat)
      use an_types, only: AN_VARIABLE
      type(AN_VARIABLE), intent(in):: to
      character(len = *), intent(in):: attrname
      type(AN_VARIABLE), intent(in):: from
      integer, intent(out):: stat
    end subroutine ANVarAttrCopy
  end interface

  !
  ! 
  !

  interface get

    subroutine anvargetreal(var, start, count, stride, imap, &
      & siz, value, iostat)
      use an_types, only: AN_VARIABLE
      type(AN_VARIABLE), intent(in):: var
      integer, intent(in):: start(:)
      integer, intent(in):: count(:)
      integer, intent(in):: stride(:)
      integer, intent(in):: imap(:)
      integer, intent(in):: siz
      real, intent(out):: value(siz)
      integer, intent(out):: iostat
    end subroutine anvargetreal

    subroutine anvargetdouble(var, start, count, stride, imap, &
      & siz, value, iostat)
      use an_types, only: AN_VARIABLE
      type(AN_VARIABLE), intent(in):: var
      integer, intent(in):: start(:)
      integer, intent(in):: count(:)
      integer, intent(in):: stride(:)
      integer, intent(in):: imap(:)
      integer, intent(in):: siz
      double precision, intent(out):: value(siz)
      integer, intent(out):: iostat
    end subroutine anvargetdouble

  end interface

  interface put

    subroutine anvarputreal(var, start, count, stride, imap, &
      & siz, value, iostat)
      use an_types, only: AN_VARIABLE
      type(AN_VARIABLE), intent(in):: var
      integer, intent(in):: start(:)
      integer, intent(in):: count(:)
      integer, intent(in):: stride(:)
      integer, intent(in):: imap(:)
      integer, intent(in):: siz
      real, intent(in):: value(siz)
      integer, intent(out):: iostat
    end subroutine anvarputreal

    subroutine anvarputdouble(var, start, count, stride, imap, &
      & siz, value, iostat)
      use an_types, only: AN_VARIABLE
      type(AN_VARIABLE), intent(in):: var
      integer, intent(in):: start(:)
      integer, intent(in):: count(:)
      integer, intent(in):: stride(:)
      integer, intent(in):: imap(:)
      integer, intent(in):: siz
      double precision, intent(in):: value(siz)
      integer, intent(out):: iostat
    end subroutine anvarputdouble

  end interface

  !
  ! === ե̾ѿ򤵤 ===
  !

  interface var_search
        
    subroutine ANVarSearchInit(iter, urlBase)
      use an_types, only: AN_VARIABLE_SEARCH
      type(AN_VARIABLE_SEARCH), intent(out):: iter
      character(len = *), intent(in):: urlBase
    end subroutine ANVarSearchInit

    subroutine ANVarSearchNext(iter, url, end)
      use an_types, only: AN_VARIABLE_SEARCH
      type(AN_VARIABLE_SEARCH), intent(inout):: iter
      character(len = *), intent(out):: url
      logical, intent(out):: end
    end subroutine ANVarSearchNext

  end interface

  !
  ! æѡΥ롼 SysDepAbort ƤФ뤿ᡢ
  ! ʬ StoreError 뤳ȤϤʤ
  !

  interface
    subroutine ANVarSync(var, stat)
      use an_types, only: AN_VARIABLE
      type(AN_VARIABLE), intent(in), optional:: var
      integer, intent(out), optional:: stat
    end subroutine ANVarSync
  end interface

  !
  ! an ؤŪѤΤΥ롼
  !
  interface
    subroutine ANXTypeName(ixtype, xtype)
      integer, intent(in):: ixtype
      character(*), intent(out):: xtype
    end subroutine ANXTypeName
  end interface

end module an_generic
