!== Command line arguments parser
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: dc_args.f90,v 1.5 2006/10/09 11:00:06 morikawa Exp $
! Tag Name::  $Name: gt4f90io-20061025 $
! Copyright:: Copyright (C) GFD Dennou Club, 2005. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! This file provides dc_args
!

module dc_args
  !
  !== Overview
  !
  ! ޥɥ饤βϤԤޤ.
  !
  ! ä, إץåɽ˴ؤʥ֥롼
  ! ѰդƤޤ.
  !
  !== List
  !
  ! Open     :: ¤ ARGS ѿν
  ! Close    :: ¤ ARGS ѿνλ
  ! Get      :: ޥɥ饤μ
  ! Number   :: ޥɥ饤ο֤
  ! Option   :: ޥɥ饤ץ뤿
  ! Debug    :: ǥХåץμư
  ! Help     :: إץץμư
  ! HelpMsg  :: إץå
  ! Strict   :: ̵ʥץ󤬻ꤵ줿˷ٹɽ褦
  ! Put_Line :: ¤ ARGS ѿƤ
  !
  !
  !== Usage
  !
  ! ¤ ARGS ѿ, Open, Get Ѥ뤳Ȥ
  ! ޥɥ饤뤳ȤǤޤ.
  !
  !       use dc_types
  !       use dc_string, only: StoA
  !       use dc_args
  !       implicit none
  !       type(ARGS) :: arg
  !       character(TOKEN), pointer :: argv(:) => null()
  !       integer :: i
  !
  !       call Open(arg)
  !       call Debug(arg) ; call Help(arg) ; call Strict(arg)
  !       call Get(arg, argv)
  !       do i = 1, size(argv)
  !         write(*,*) argv(i)
  !       end do
  !       deallocate(argv)
  !       call Close(arg)
  !
  ! ˥ץꤷˤ, Option ֥롼
  ! ѤƤ. ץν񼰤˴ؤƤ Option 
  ! ֥ץν񼰡פ򻲾ȤƤ.
  !
  !       use dc_types
  !       use dc_string, only: StoA
  !       use dc_args
  !       implicit none
  !       type(ARGS) :: arg
  !       logical :: OPT_size
  !       logical :: OPT_namelist
  !       character(STRING) :: VAL_namelist
  !
  !       call Open(arg)
  !       call Option(arg, StoA('-s', '--size'), &
  !         & OPT_size, help="Return number of arguments")
  !       call Option(arg, StoA('-N', '--namelist'), &
  !         & OPT_namelist, VAL_namelist, help="Namelist filename")
  !       call Debug(arg); call Help(arg) ; call Strict(arg)
  !
  !       if (OPT_size) then
  !         write(*,*) 'number of arguments :: ', Number(arg)
  !       end if
  !       if (OPT_namelist) then
  !         write(*,*) '--namelist=', trim(VAL_namelist)
  !       else
  !         write(*,*) '--namelist is not found'
  !       end if
  !       call Close(arg)
  !
  ! ޥɥ饤 '-h', '-H', '--help' ΤŤ줫Υץ
  ! ꤹ뤳Ȥ, ץΰɸϤɽޤ.
  !
  ! إץåƤ򽼼¤ˤ HelpMsg 
  ! ȤƤ.
  !

  use dc_types, only : STRING
  use dc_hash, only: HASH
  implicit none
  private

  public:: ARGS
  public:: Open, Close, Option, Put_Line, Debug, Help, HelpMsg, Strict, Get
  public:: Number

  type ARGS
    !
    ! ޥɥ饤Ѥι¤ΤǤ.
    ! ˤ Open , λˤ Close Ѥޤ.
    ! ޥɥ饤Ϳ, ץ 
    ! Option, HelpMsg ֥롼ˤäͿ줿
    ! Ǽޤ.
    !
    ! ܤȤ dc_args  Usage 򻲾Ȥ.
    !
    private
    type(OPT_ENTRY), pointer :: opt_table(:) => null()
                              ! Option ֥롼ǻꤵ
                              ! ץΥꥹ
    logical :: initialized = .false.
    type(CMD_OPTS_INTERNAL), pointer :: cmd_opts_list(:) => null()
                              ! ޥɥ饤Τ, ץ
                              ! Ƽ̤ΤΤΥꥹ.
    type(HASH) :: helpmsg
  end type ARGS

  type OPT_ENTRY
    character(STRING), pointer:: options(:) => null()
                              ! ץ̾ꥹ
    character(STRING) :: help_message
                              ! إץå
    logical :: optvalue_flag
                              ! ץ̵ͤͭ
  end type OPT_ENTRY

  type CMD_OPTS_INTERNAL
    character(STRING) :: name  ! ץ̾
    character(STRING) :: value ! 
    logical:: flag_called = .false.
                              ! Υץ̾ Option ǸƤФ줿
                              ! ɤȽ̤ե饰
  end type CMD_OPTS_INTERNAL

  interface Open
    module procedure DCArgsOpen
  end interface

  interface Close
    module procedure DCArgsClose
  end interface

  interface Option
    module procedure DCArgsOption
  end interface

  interface Put_Line
    module procedure DCArgsPut_Line
  end interface

  interface Debug
    module procedure DCArgsDebug
  end interface

  interface Help
    module procedure DCArgsHelp
  end interface

  interface HelpMsg
    module procedure DCArgsHelpMsg
  end interface

  interface Strict
    module procedure DCArgsStrict
  end interface

  interface Get
    module procedure DCArgsGet
  end interface

  interface Number
    module procedure DCArgsNumber
  end interface


  !=== BuildArgTable ꤵѿ
  character(STRING), allocatable, save:: argstr_table(:)
                              ! . (ץ󤫤ɤʤ
                              ! Ƚ̤ϹԤäƤʤ). BuildArgTable
                              ! ꤵ.

  integer, save:: argind_count = -1
                              ! ο. BuildArgTable 
                              ! ꤵ.

  !=== SortArgTable ꤵѿ
  type(CMD_OPTS_INTERNAL), allocatable, save :: cmd_opts_list(:)
                              ! ޥɥ饤Τ, ץ
                              ! Ƽ̤ΤΤΥꥹ
                              ! . SortArgTable ꤵ.

  character(STRING), allocatable, save:: cmd_argv_list(:)
                              ! ޥɥ饤Τ, ץ
                              ! ϤʤΥꥹ. SortArgTable 
                              ! ꤵ.

contains

  subroutine DCArgsOpen(arg)
    !
    !=== ARGS νѥ֥롼
    !
    ! ARGS ѿѤݤˤϤޤΥ֥롼ˤä
    ! ԤäƤ.
    !
    use dc_message, only: MessageNotify
    use dc_types, only: STRING
    implicit none
    type(ARGS), intent(out) :: arg
    integer:: cmd_opts_max
    character(len = *), parameter :: subname = 'DCArgsOpen'
  continue
    if (arg % initialized) then
      call MessageNotify('W', subname, 'This argument (type ARGS) is already opend.')
      return
    end if
    call BuildArgTable
    call SortArgTable
    cmd_opts_max = size(cmd_opts_list)
    allocate(arg % cmd_opts_list(cmd_opts_max))
    arg % cmd_opts_list = cmd_opts_list
    allocate(arg % opt_table(0))
    arg % initialized = .true.
  end subroutine DCArgsOpen

  subroutine DCArgsClose(arg)
    !
    !=== ARGS νλ֥롼
    !
    ! ARGS ѿ򥯥ޤ.
    !
    use dc_hash, only: Delete
    implicit none
    type(ARGS), intent(inout) :: arg
    integer :: i
  continue
    if (arg % initialized) then
       do i = 1, size(arg % opt_table)
        deallocate(arg % opt_table(i) % options)
      end do

      deallocate(arg % opt_table)
      deallocate(arg % cmd_opts_list)
      call Delete(arg % helpmsg)
    end if
  end subroutine DCArgsClose

  subroutine DCArgsOption(arg, options, flag, value, help)
    !
    !=== ץϿȼ
    !
    ! ޥɥ饤Τ, *options* Ϳ륪ץ˴ؤ
    !  *flag*  *value* ˼ޤ. *options* ޥɥ饤
    ! ͿƤ *flag*  .true. , Ǥʤ 
    ! .false. ֤ޤ. ץͤꤵ *value* 
    ! ֤ͤޤ. ץΤͿƤʤˤ
    ! *value* ˤ϶ʸ֤ޤ.
    !
    ! *help* ˤ *options* ˴ؤإץå *arg* 
    ! Ͽޤ. ֥롼 Help (ޤ DCArgsHelp) 
    ! Ѥݤ, ΥåϤޤ.
    ! *value* ͿƤ뤫ɤǤΥåѲޤ.
    !
    !==== ץν
    !
    ! ޥɥ饤Τ, ץȽꤵΤϰʲξǤ.
    !
    ! * 1 ʸܤ '-' ξ. ξûץȤʤ, '-'
    !   μΰʸΤߤץȤͭˤʤޤ.
    !
    ! * 1-2ʸܤ '--' (ϥե 2 ʸ) ξ.
    !   ξĹץȤʤ,
    !   '--' ʹߤʸ󤬥ץȤͭˤʤޤ.
    !
    ! ץͤ, "=" ʸˤʤޤ.
    !
    ! 
    !
    ! <b>ޥɥ饤</b>  :: <b>ץ̾,       </b>
    ! -h                         ::    -h,           ̵
    ! --help                     ::    --help,       ̵
    ! -D=6                       ::    -D,            6
    ! -debug=                    ::    -d,           ̵
    ! --include=/usr             ::    --include,    /usr
    !

    use dc_message, only: MessageNotify
    implicit none
    type(ARGS), intent(inout) :: arg
    character(len = *), intent(in) :: options(:)
    logical, intent(out) :: flag
    character(len = *), intent(out), optional :: value
    character(len = *), intent(in), optional :: help
    integer :: i, j, options_size, table_size
    type(OPT_ENTRY), allocatable :: local_tables(:)
    character(len = *), parameter  :: subname = 'DCArgsOption'
  continue
    flag = .false.
    if (present(value)) value = ''
    if (.not. arg % initialized) then
      call MessageNotify('W', subname, 'Call Open before Option in dc_args.')
      call DCArgsOpen(arg)
    end if
    options_size = size(options)
    if (options_size < 1) then
      return
    end if

    !== ¤ ARGS ؤΥإץåѤξϿ
    !=== ޤϥơ֥ arg % opt_table Ĺ.
    table_size = size(arg % opt_table)
    allocate(local_tables(table_size))
    local_tables(1:table_size) = arg % opt_table(1:table_size)
    deallocate(arg % opt_table)
    allocate(arg % opt_table(table_size + 1))
    arg % opt_table(1:table_size) = local_tables(1:table_size)
    deallocate(local_tables)
    !=== ͤ
    allocate(arg % opt_table(table_size + 1) % options(options_size))
    arg % opt_table(table_size + 1) % options = options
    arg % opt_table(table_size + 1) % help_message = ''
    if (present(help)) then
      arg % opt_table(table_size + 1) % help_message = help
    end if
    arg % opt_table(table_size + 1) % optvalue_flag = present(value)

    ! arg % cmd_opts_list õ flag, value ؤ
    ! ƤФ줿Τ˴ؤƤ arg % cmd_opts_list % flag_called 
    ! .true. 
    do i = 1, options_size
      do j = 1, size(arg % cmd_opts_list)
        if (trim(options(i)) == trim(arg % cmd_opts_list(j) % name)) then
          flag = .true.
          if (present(value)) then
            value = arg % cmd_opts_list(j) % value
          end if
          arg % cmd_opts_list(j) % flag_called = .true.
        end if
      end do
    end do
  end subroutine DCArgsOption

  subroutine DCArgsDebug(arg)
    !
    !=== ǥХåץưꥵ֥롼
    !
    ! -D ⤷ --debug ꤵ줿, ưŪ
    ! dc_trace#SetDebug ƤӽФ褦 *arg* ꤷޤ.
    !
    use dc_types, only: STRING
    use dc_string, only: StoA, StoI
    use dc_trace, only: SetDebug
    use dc_message, only: MessageNotify
    implicit none
    type(ARGS), intent(inout) :: arg
    logical :: OPT_debug
    character(STRING) :: VAL_debug
    character(len = *), parameter  :: subname = 'DCArgsDebug'
  continue
    if (.not. arg % initialized) then
      call MessageNotify('W', subname, 'Call Open before Debug in dc_args.')
      call DCArgsOpen(arg)
    end if
    call Option(arg, StoA('-D', '--debug'), OPT_debug, VAL_debug, &
      & help="call dc_trace#SetDebug (display a lot of messages for debug). " // &
      & "VAL is unit number (default is standard output)")
    if (OPT_debug) then
      if (trim(VAL_debug) == '') then
        call SetDebug
      else
        call SetDebug(StoI(VAL_debug))
      end if
    end if
    return
  end subroutine DCArgsDebug


  subroutine DCArgsHelp(arg, force)
    !
    !=== إץץưꥵ֥롼
    !
    ! -h, -H, --help ΤŤ줫ꤵ줿, ưŪ *arg* ꤵ줿
    ! إץåȤɽ, ץλޤ.
    ! §Ū, Υ֥롼 Option, Debug Υ֥롼
    ! Ƥǲ.
    !
    ! *force*  .true. ꤵ, -H, --help ץͿ
    ! ʤǤإץåɽ, ץλ
    ! ޤ.
    !
    ! إץåɽ, Option, HelpMsg ֥롼
    ! ˤäղä뤳ȤǽǤ.
    !
    use dc_types, only: STRING
    use dc_string, only: StoA, StoI, Printf, Concat, JoinChar, UChar, LChar
    use dc_present, only: present_and_true
    use dc_message, only: MessageNotify
    use dc_hash, only: Get, Delete, Rewind, Next
    implicit none
    type(ARGS), intent(inout) :: arg
    logical, intent(in), optional :: force
    logical :: OPT_help, found, end
    character(STRING) :: VAL_help, options_msg, help_msg, category
    character(STRING), pointer :: localopts(:) => null()
    integer :: unit, i
    character(len = *), parameter  :: subname = 'DCArgsHelp'
  continue
    if (.not. arg % initialized) then
      call MessageNotify('W', subname, 'Call Open before Help in dc_args.')
      call DCArgsOpen(arg)
    end if
    call Option(arg, StoA('-h', '-H', '--help'), OPT_help, VAL_help, &
      & help="display this help and exit. " // &
      & "VAL is unit number (default is standard output)")
    if (.not. OPT_help .and. .not. present_and_true(force)) then
      return
    end if
    if (trim(VAL_help) == '') then
      unit = 6
    else
      unit = StoI(VAL_help)
    end if

    call Printf(unit, '')

    call Get(arg % helpmsg, 'TITLE', help_msg, found)
    if (found) then
      call Printf(unit, '%c', c1=trim(help_msg))
      call Printf(unit, '')
      call Delete(arg % helpmsg, 'TITLE')
    end if

    call Get(arg % helpmsg, 'OVERVIEW', help_msg, found)
    if (found) then
      call Printf(unit, 'Overview::')
      call PrintAutoLinefeed(unit, help_msg, indent='     ')
      call Printf(unit, '')
      call Delete(arg % helpmsg, 'OVERVIEW')
    end if

    call Get(arg % helpmsg, 'USAGE', help_msg, found)
    if (found) then
      call Printf(unit, 'Usage::')
      call PrintAutoLinefeed(unit, help_msg, indent='     ')
      call Printf(unit, '')
      call Delete(arg % helpmsg, 'USAGE')
    end if

    call Printf(unit, 'Options::')
    do i = 1, size(arg % opt_table)
      options_msg = ' '
      if (arg % opt_table(i) % optvalue_flag) then
        call Concat(arg % opt_table(i) % options, '=VAL', localopts)
      else
        allocate(localopts(size(arg % opt_table(i) % options)))
        localopts = arg % opt_table(i) % options
      end if
      options_msg = trim(options_msg) // trim(JoinChar(localopts))
      deallocate(localopts)
      call Printf(unit, ' %c', c1=trim(options_msg))
      call PrintAutoLinefeed(unit, &
        & arg % opt_table(i) % help_message, indent='     ')
      call Printf(unit, '')
    end do

    call Rewind(arg % helpmsg)
    do
      call Next(arg % helpmsg, category, help_msg, end)
      if (end) exit

      call Printf(unit, '%c%c::', &
        & c1=trim(UChar(category(1:1))), c2=trim(LChar(category(2:))))
      call PrintAutoLinefeed(unit, help_msg, indent='     ')
      call Printf(unit, '')

    enddo

    call DCArgsClose(arg)

    stop
  end subroutine DCArgsHelp

  subroutine DCArgsHelpMsg(arg, category, msg)
    !
    !=== إץåɲå֥롼
    !
    ! ֥롼 Help Ѥݤ˽Ϥå
    ! ղäޤ. *category*  +Title+, +Overview+, +Usage+ 
    ! ꤵ줿Τ +Options+ ,
    ! ʳΤΤϲɽޤ.
    ! *msg* ˤϥåͿƤ.
    !
    !==== 
    !
    !       use dc_types
    !       use dc_string, only: StoA
    !       use dc_args
    !       implicit none
    !       type(ARGS) :: arg
    !       logical :: OPT_namelist
    !       character(STRING) :: VAL_namelist
    !       character(TOKEN), pointer :: argv(:) => null()
    !       integer :: i
    !
    !       call Open(arg)
    !       call HelpMsg(arg, 'Title', 'dcargs $Revision: 1.5 $ :: Test program of dc_args')
    !       call HelpMsg(arg, 'Usage', 'dcargs [Options] arg1, arg2, ...')
    !       call Option(arg, StoA('-N', '--namelist'), & 
    !         & OPT_namelist, VAL_namelist, help="Namelist filename")
    !       call HelpMsg(arg, 'DESCRIPTION', &
    !         & '(1) Define type "HASH". ' // &
    !         & '(2) Open the variable. ' // &
    !         & '(3) set HelpMsg. ' // &
    !         & '(4) set Options. ' // &
    !         & '(5) call Debug. ' // &
    !         & '(6) call Help. ' // &
    !         & '(7) call Strict.')
    !       call HelpMsg(arg, 'Copyright', &
    !         & 'Copyright (C) GFD Dennou Club, 2006. All rights reserved.')
    !       call Debug(arg)
    !       call Help(arg)
    !       call Strict(arg)
    !       call Get(arg, argv)
    !       write(*,*) '--namelist=', trim(VAL_namelist)
    !       do i = 1, size(argv)
    !         write(*,*) argv(i)
    !       end do
    !       deallocate(argv)
    !       call Close(arg)
    !
    ! ޥɥ饤 '-h', '-H', '--help' ΤŤ줫Υץ
    ! ꤹ뤳Ȥ, HelpMsg Ϳå, ץΰ
    ! ɸϤɽޤ.
    !
    use dc_hash, only: Put
    use dc_string, only: UChar
    use dc_message, only: MessageNotify
    implicit none
    type(ARGS), intent(inout) :: arg
    character(*), intent(in) :: category
    character(*), intent(in) :: msg
    character(len = *), parameter  :: subname = 'DCArgsHelpMsg'
  continue
    if (.not. arg % initialized) then
      call MessageNotify('W', subname, 'Call Open before Help in dc_args.')
      call DCArgsOpen(arg)
    end if
    call Put(arg % helpmsg, key=UChar(category), value=msg)
  end subroutine DCArgsHelpMsg
  

  subroutine DCArgsStrict(arg, severe)
    !
    !=== ץå֥롼
    !
    ! ޥɥ饤ΥץȤƻꤵ줿Τ,
    ! Option ֥롼ꤵƤʤΤ¸ߤ
    ! ˤϷٹ֤ޤ. *severe*  .true. ꤹ
    ! 顼֤ƽλޤ.
    ! Υ֥롼Ƥ, Option, Debug, Help ֥롼
    ! ƤǤ.
    !
    ! ¤ ARGS ѿФƤΥ֥롼ŬѤƤ
    ! Ȥ, ޥɥ饤ȤͿץ
    ! ץबǧƤ뤫ɤå뤳ȤǤޤ.
    !
    !
    use dc_types, only: STRING
    use dc_present, only: present_and_true
    use dc_message, only: MessageNotify
    implicit none
    type(ARGS), intent(inout) :: arg
    logical, intent(in), optional :: severe
    character(STRING) :: err_mess
    integer :: i
    character(len = *), parameter  :: subname = 'DCArgsStrict'
  continue
    if (.not. arg % initialized) then
      call MessageNotify('W', subname, 'Call Open before Help in dc_args.')
      call DCArgsOpen(arg)
    end if
    do i = 1, size(arg % cmd_opts_list)
      err_mess = trim(arg % cmd_opts_list(i) % name) // ' is invalid option.'
      if (.not. arg % cmd_opts_list(i) % flag_called) then
        if (present_and_true(severe)) then
          call MessageNotify('E', subname, err_mess)
        else
          call MessageNotify('W', subname, err_mess)
        end if
      end if
    end do
  end subroutine DCArgsStrict


  subroutine DCArgsGet(arg, argv)
    !
    !=== ֥롼
    !
    ! ޥɥ饤Τ, ץǤϤʤΤ
    ! *argv* ֤ޤ.
    !
    ! *argv* ʸΥݥ󥿤Ǥ.
    ! ȤͿˤɬ֤ͿƤ.
    !
    use dc_types, only: STRING
    use dc_string, only: StoA, StoI, Printf, Concat, JoinChar
    use dc_present, only: present_and_true
    use dc_message, only: MessageNotify
    implicit none
    type(ARGS), intent(inout) :: arg
    character(*), pointer :: argv(:) !(out)
    integer :: i, cmd_argv_max
    character(len = *), parameter  :: subname = 'DCArgsGet'
  continue
    if (.not. arg % initialized) then
      call MessageNotify('W', subname, 'Call Open before Help in dc_args.')
      call DCArgsOpen(arg)
    end if
    cmd_argv_max = size(cmd_argv_list)
    allocate(argv(cmd_argv_max))
    do i = 1, cmd_argv_max
      argv(i) = cmd_argv_list(i)
    end do
  end subroutine DCArgsGet

  function DCArgsNumber(arg) result(result)
    !
    !=== ޥɥ饤ο֤
    !
    ! ޥɥ饤ȤͿ줿ο֤ޤ.
    !
    use dc_message, only: MessageNotify
    implicit none
    type(ARGS), intent(inout) :: arg
    integer :: result
    character(len = *), parameter  :: subname = 'DCArgsGet'
  continue
    if (.not. arg % initialized) then
      call MessageNotify('W', subname, 'Call Open before Help in dc_args.')
      call DCArgsOpen(arg)
    end if
    result = size(cmd_argv_list)
  end function DCArgsNumber

  subroutine DCArgsPut_Line(arg)
    !
    !=== ΰ
    !
    ! *arg* ˴ؤɸϤɽޤ.
    !
    use dc_string, only: Printf, JoinChar
    implicit none
    type(ARGS), intent(in) :: arg
    integer :: i
  continue
    if (.not. arg % initialized) then
      call Printf(6, '#<ARGS:: @initialized=%y>', l=(/arg % initialized/))
      return
    end if
    call Printf(6, '#<ARGS:: @initialized=%y,', l=(/arg % initialized/))
    call Printf(6, '  @opt_table(:)=')
    do i = 1, size(arg % opt_table)
      call Printf(6, '    #<OPT_ENTRY:: ')
      call Printf(6, '      @options=%c, @help_message=%c, @optvalue_flag=%y', &
        & c1=trim(JoinChar(arg % opt_table(i) % options)), &
        & c2=trim(arg % opt_table(i) % help_message), &
        & l=(/arg % opt_table(i) % optvalue_flag/))
      call Printf(6, '    >')
    end do
    call Printf(6, '  ,')
    call Printf(6, '  @cmd_opts_list(:)=')
    do i = 1, size(arg % cmd_opts_list)
      call Printf(6, '    #<CMD_OPTS_INTERNAL:: ')
      call Printf(6, '      @name=%c, @value=%c, @flag_called=%y', &
        & c1=trim(arg % cmd_opts_list(i) % name), &
        & c2=trim(arg % cmd_opts_list(i) % value), &
        & l=(/arg % cmd_opts_list(i) % flag_called/))
      call Printf(6, '    >')
    end do
    call Printf(6, '  ,')
    call Printf(6, '  @cmd_argv_list(:)=%c', &
      & c1=trim(JoinChar(cmd_argv_list)))
    call Printf(6, '>')

  end subroutine DCArgsPut_Line

  subroutine PrintAutoLinefeed(unit, fmt, length, indent)
    !
    !== ưԽϥ֥롼
    !
    ! Υ⥸塼Ѥ뤿Υ֥롼Ǥ.
    !
    ! *fmt* Ϳ줿ʸϤʸ *length* (ꤵʤ 70)
    ! ˲Ԥ, Ϥޤ. Ϥκ, *indent* ꤵƤ
    ! ʸƬƽϤԤޤ.
    ! ϥǥեȤɸϤȤʤޤ. *unit* ˽ֹ
    ! ꤹ뤳ȤǽѹǤޤ.
    !
    use dc_types, only: STRING
    use dc_string, only: Split
    implicit none
    character(*), intent(in) :: fmt
    integer,      intent(in), optional :: length ! ԤĹ
    character(*), intent(in), optional :: indent ! ʸ
    integer,      intent(in), optional :: unit   ! 
    character(STRING), pointer :: carray_tmp(:) => null()
    character(STRING) :: store_str
    integer, parameter :: default_len = 70, default_unit = 6
    integer :: i, split_len, indent_len, unit_num
    logical :: new_line_flag
  continue
    if (present(unit)) then
      unit_num = unit
    else
      unit_num = default_unit
    end if

    if (present(indent)) then
      indent_len = len(indent)
    else
      indent_len = 0
    end if

    if (present(length)) then
      split_len = length - indent_len
    else
      split_len = default_len - indent_len
    end if


    nullify(carray_tmp)
    call Split(fmt, carray_tmp, '')
    store_str = ''
    new_line_flag = .true.
    i = 1
    do
      if (i > size(carray_tmp)) then
        write(unit_num, '(A)') trim(store_str)
        exit
      end if

      if (len(trim(store_str)) + len(trim(carray_tmp(i))) > split_len) then
        if (new_line_flag) then
          write(unit_num, '(A)') trim(carray_tmp(i))
          i = i + 1
        else
          write(unit_num, '(A)') trim(store_str)
          store_str = ''
          new_line_flag = .true.
        end if
        cycle
      end if

      if (new_line_flag .and. present(indent)) then
        store_str = indent // trim(carray_tmp(i))
      else
        store_str = trim(store_str) // ' ' // trim(carray_tmp(i))
      end if
      new_line_flag = .false.
      i = i + 1
    end do

  end subroutine PrintAutoLinefeed

  subroutine SortArgTable
    !
    !=== ʬ֥롼
    !
    ! BuildArgTable ꤵ줿 argind_count, argstr_table 
    ! Ѥ, cmd_argv_list, cmd_opts_list ꤷޤ.
    !
    ! ˰٤ǤƤФƤ, ⤻˽λޤ.
    !
    use dc_types, only: STRING
    implicit none
    character(STRING):: raw_arg, name, value
    integer:: i, cmd_argv_count, cmd_opts_count, cmd_argv_max, cmd_opts_max
  continue
    if (allocated(cmd_opts_list)) return
    cmd_argv_count = 0
    cmd_opts_count = 0
    check_count: do, i = 1, argind_count
      raw_arg = argstr_table(i)
      if (DCOptionFormC(raw_arg, name, value)) then
        cmd_opts_count = cmd_opts_count + 1
      else
        cmd_argv_count = cmd_argv_count + 1
      end if
    end do check_count

    cmd_argv_max = cmd_argv_count
    cmd_opts_max = cmd_opts_count

    allocate(cmd_argv_list(cmd_argv_max))
    allocate(cmd_opts_list(cmd_opts_max))

    cmd_argv_count = 0
    cmd_opts_count = 0
    arg_get : do, i = 1, argind_count
      raw_arg = argstr_table(i)
      if (DCOptionFormC(raw_arg, name, value)) then
        cmd_opts_count = cmd_opts_count + 1
        cmd_opts_list(cmd_opts_count) % name = name
        cmd_opts_list(cmd_opts_count) % value = value
        cmd_opts_list(cmd_opts_count) % flag_called = .false.
      else
        cmd_argv_count = cmd_argv_count + 1
        cmd_argv_list(cmd_argv_count) = raw_arg
      end if
    end do arg_get
  end subroutine SortArgTable

  subroutine BuildArgTable
    !
    !=== ֥롼
    !
    ! ⥸塼 sysdep  sysdep#SysdepArgCount, sysdep#ArgGet
    ! ƤӽФ, Ƥ argind_count  argstr_table ˳Ǽޤ.
    !
    ! ˰٤ǤƤФƤ, ⤻˽λޤ.
    !
    use sysdep, only: SysdepArgCount, SysdepArgGet
    use dc_types, only: STRING
    implicit none
    integer:: i, narg, nargmax
    character(len = STRING):: value
    character(len = STRING), allocatable:: localtab(:)
  continue
    if (argind_count >= 0) return
    nargmax = SysdepArgCount()
    allocate(localtab(nargmax))
    narg = 0
    do, i = 1, nargmax
      call SysdepArgGet(i, value)
      narg = narg + 1
      localtab(narg) = value
    enddo
    argind_count = narg
    allocate(argstr_table(narg))
    argstr_table(1: narg) = localtab(1: narg)
    deallocate(localtab)
  end subroutine BuildArgTable

  function DCOptionFormC(argument, name, value) result(result)
    !
    ! ȤƤ줿ʸ *argument* ϤȤ,
    ! 줬ץʤΤǤʤΤȽ̤, ⤷
    ! ץȽ̤ˤͤ .true. ֤,
    ! name ˥ץ̾, *value* ˤ֤ͤ.
    ! ץͤղäʤ *value* ˤ϶֤.
    !
    ! ץǤϤʤͤ .false. ֤,
    ! *name*, *value* ˤ϶֤.
    !
    ! ץȽꤵΤϰʲξǤ.
    !
    ! * ʸܤ '-' ξ. ξûץȤʤ, '-'
    !   μΰʸΤߤץȤͭˤʤޤ.
    !
    ! * 1-2ʸܤ '--' ξ. ξĹץȤʤ,
    !   '--' ʹߤʸ󤬥ץȤͭˤʤޤ.
    !
    ! ץͤ, "=" ʸˤʤޤ.
    !
    !=== 
    !
    ! *argument*    :: <b>name,      value, ֤</b>
    ! arg           ::    ,      ,  .false.
    ! -O            ::    -O,        ,  .true.
    ! -debug        ::    -d,        ,  .true.
    ! --debug       ::    --debug,   ,  .true.
    ! -I=/usr       ::    -I,        /usr,  .true.
    ! --include=/usr::    --include, /usr,  .true.
    !
    implicit none
    character(len = *), intent(in):: argument
    character(len = *), intent(out):: name, value
    logical :: result
    integer:: equal
  continue
    equal = index(argument, '=')
    if (argument(1:1) == '-' .and. argument(2:2) /= '-') then
      ! Short Option
      if (equal == 0) then
        name = argument(1:2)
        value = ""
      else
        name = argument(1:2)
        value = argument(equal+1: )
      endif
      result = .true.
    elseif (argument(1:2) == '--') then
      ! Long Option
      if (equal == 0) then
        name = argument
        value = ""
      else
        name = argument(1:equal-1)
        value = argument(equal+1: )
      endif
      result = .true.
!    elseif (equal == 0 .and. &
!      &     verify(argument(1:equal-1), WORDCHARS) == 0) then
!      ! ???
!      name = argument(1:equal-1)
!      value = argument(equal+1: )
!      result = .true.
    else
      ! No Option (normal arguments)
      name = ""
      value = ""
      result = .false.
    endif
  end function DCOptionFormC



end module dc_args
