#
#== Fortran90 code generator as macro for intrinsic types of Fortran
#
#Authors::   Yasuhiro MORIKAWA
#Version::   $Id: lib-rb2f90-macro-intrinsic_types.rb,v 1.1 2009-03-25 08:17:36 morikawa Exp $
#Tag Name::  $Name: gtool5-20090704 $
#Copyright:: Copyright (C) GFD Dennou Club, 2005-2009. All rights reserved.
#License::   See link:../COPYRIGHT
#
#These variables are used to generate f90 code files from Ruby code 
#files. They are expected to help ruby code approximates f90 code for
#as long as possible.
#
#[JAPANESE]
#
#ѿ Ruby ǵҤ줿ե뤫 F90 ե
#뤿ѿǤ. δؿˤ, Ǥ F90 ɤ
#ᤤ Ruby Υɤ򵭽ҤǤ뤳ȤԤޤ.
#

$type_intent_out = {"Real"    => "real",
                    "Double"  => "real(DP)",
                    "Logical" => "logical",
                    "Int"     => "integer",
                    "Char"    => "character(STRING)"}
$type_intent_in  = {"Real"    => "real",
                    "Double"  => "real(DP)",
                    "Logical" => "logical",
                    "Int"     => "integer",
                    "Char"    => "character(*)"}
$type_intent_inout = $type_intent_in
$type_internal   = {"Real"    => "real",
                    "Double"  => "real(DP)",
                    "Logical" => "logical",
                    "Int"     => "integer",
                    "Char"    => "character(STRING)"}

#
# This format is conformd with "Cprintf" in "dc_string" module
#
$type_fmt        = {"Real"    => "r",
                    "Double"  => "f",
                    "Logical" => "y",
                    "Int"     => "d",
                    "Char"    => "c"}
$type_fmtarg     = {"Real"    => "r",
                    "Double"  => "d",
                    "Logical" => "l",
                    "Int"     => "i",
                    "Char"    => "c1"}

#
# This format is conformd with "SP", "DP" in "dc_types" module
#
$type_numsuf     = {"Real"    => ".0",
                    "Double"  => ".0_DP",
                    "Int"     => ""}

$type_dpsuf     = {"Real"    => "",
                   "Double"  => "_DP"}

#
# This format is conformd with MPI library
#
$mpi_type      = {"Real"    => "MPI_REAL",
                  "Double"  => "MPI_DOUBLE_PRECISION",
                  "Int"     => "MPI_INTEGER"}
