program regex_test
  use dc_regex, only: Match
  use dc_types, only: STRING
  use dc_test, only: AssertEqual
  implicit none

  integer:: start, length
  character(STRING) :: pattern, text
  continue
  pattern = "->"
  text    = "time->0.0,x->hoge"
  call match(trim(pattern), trim(text), start, length)
  ! pattern= -> : text= time->0.0,x->hoge : start= 5 : length= 2
  call AssertEqual( message = 'dc_regex#match Test 1, text', &
    & answer = "time->0.0,x->hoge", &
    & check  = trim(text) )
  call AssertEqual( message = 'dc_regex#match Test 1, start', &
    & answer = 5, &
    & check  = start )
  call AssertEqual( message = 'dc_regex#match Test 1, length', &
    & answer = 2, &
    & check  = length )

  pattern = "^##+"
  text    = "####### hoge"
  call match(trim(pattern), trim(text), start, length)
  ! pattern= ^##+ : text= ####### hoge : start= 1 : length= 7
  call AssertEqual( message = 'dc_regex#match Test 2, text', &
    & answer = "####### hoge", &
    & check  = trim(text) )
  call AssertEqual( message = 'dc_regex#match Test 2, start', &
    & answer = 1, &
    & check  = start )
  call AssertEqual( message = 'dc_regex#match Test 2, length', &
    & answer = 7, &
    & check  = length )

  pattern = "@+$"
  text    = "# hoge @@@"
  call match(trim(pattern), trim(text), start, length)
  ! pattern= @+$ : text= # hoge @@@ : start= 8 : length= 3
  call AssertEqual( message = 'dc_regex#match Test 3, text', &
    & answer = "# hoge @@@", &
    & check  = trim(text) )
  call AssertEqual( message = 'dc_regex#match Test 3, start', &
    & answer = 8, &
    & check  = start )
  call AssertEqual( message = 'dc_regex#match Test 3, length', &
    & answer = 3, &
    & check  = length )

  pattern = "^[\+-][0-9]+:[0-9]+$"
  text    = "+09:00"
  call match(trim(pattern), trim(text), start, length)
  ! pattern= "^[#+-][0-9]+:[0-9]+$": text = "+09:00": start = 1: length = 6
  call AssertEqual( message = 'dc_regex#match Test 4, text', &
    & answer = "+09:00", &
    & check  = trim(text) )
  call AssertEqual( message = 'dc_regex#match Test 4, start', &
    & answer = 1, &
    & check  = start )
  call AssertEqual( message = 'dc_regex#match Test 4, length', &
    & answer = 6, &
    & check  = length )

  ! pattern = "[:print:]*[0-9]+-[0-9]+-[0-9]+[[:alpha:]]+[0-9]+:[0-9]+:[0-9]+"
  pattern = "[#w]*#d+-#d+-#d+[#w#s]+#d+:#d+:#d+"
  text = "s since 2009-06-17T11:23:45+09:00"
  call match( trim(pattern), trim(text), start, length)
  call AssertEqual( message = 'dc_regex#match Test 5, text', &
    & answer = "s since 2009-06-17T11:23:45+09:00", &
    & check  = trim(text) )
  call AssertEqual( message = 'dc_regex#match Test 5, start', &
    & answer = 9, &
    & check  = start )
  call AssertEqual( message = 'dc_regex#match Test 5, length', &
    & answer = 19, &
    & check  = length )
  stop
end program regex_test
