! -*- coding: utf-8; mode: f90 -*-
!-------------------------------------------------------------------------------------
! Copyright (c) 2000-2016 Gtool Development Group. All rights reserved.
!-------------------------------------------------------------------------------------
! ** Important**
!
! This file is generated from historyget.erb by ERB included Ruby 2.3.3.
! Please do not edit this file directly. @see "historyget.erb"
!-------------------------------------------------------------------------------------
!
!
!= gtool4 netCDF データの入力
!= Input gtool4 netCDF data
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: historyget.rb2f90,v 1.3 2009-07-04 05:04:42 morikawa Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
! 以下のサブルーチン, 関数は gtool_history から gtool_history_generic#HistoryGet
! もしくは gtool_history_generic#HistoryGetPointer として提供されます.
!
! Following subroutines and functions are provided as
! gtool_history_generic#HistoryGet or gtool_history_generic#HistoryGetPointer from
! gtool_history.
!
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
                                            !
  ! netCDF データを入力します. gtool4 netCDF 規約に基づくデータを想定
  ! していますが, 大抵の netCDF データの入力は可能であると期待されます.
  !
  ! デフォルトでは, ファイル内の最新データ, すなわちデータを
  ! 時刻最大で切り出したものを入力します. 別の時刻または
  ! 別の次元で切り出したデータを
  ! 入力したい場合には, 下記の *time* オプションもしくは
  ! *range* オプションを利用してください.
  !
  ! *file* にファイル名を, *varname* に変数名を与えます.
  ! *array* にはファイルから入力されたデータが返ります.
  ! ポインタの配列へデータを入力を行う場合は,
  ! HistoryGetPointer を利用してください.
  !
  ! ある時刻のデータを明示したい場合には, その時刻を
  ! *time* に与えます.
  ! 整数型, 単精度実数型, 倍精度実数型の数値を与えることが可能です.
  !
  ! *range* には gtool4 のコンマ記法
  ! ({gtool4 netCDF 規約}[link:../xref.htm#label-6] の「5.4 コンマ記法」参照)
  ! を与えることで, 任意の次元で入力データを切り出すことが可能です.
  ! *range* に空文字を与えた場合は切り出しを行いません.
  !
  ! *HistoryGet* は複数のサブルーチンの総称名です. *array* には
  ! 0 〜 7 次元の整数型, 単精度実数型,
  ! 倍精度実数型の配列を与えることが可能です.
  !
  ! デフォルトでは, データの入力時にどのファイルのどの変数が
  ! どの次元で切り出されて入力されたのかを表示します.
  ! メッセージ出力が不要な場合は *quiet* に .true. を与えてください.
  !
  ! Input netCDF data. NetCDF data with gtool4 conventions is assumed,
  ! but most netCDF data is expected to be input.
  !
  ! Give filename to *file*, variable name to *varname*.
  ! Input data is returned to *array*.
  ! If you want to use pointer array, use "HistoryGetPointer".
  !
  ! By default, recent data, that is to say, data clipped with
  ! maximum time is input. In order to input data clipped with
  ! other time or other dimension,
  ! use *time* option or *range* option as follows.
  !
  ! In order to get data at certain time, specify the time to *time*.
  ! Type is integer or single precision real or double precision.
  !
  ! Give gtool4 comma-graphy
  ! (See "5.4 gtool4 comma-graphy" in {gtool4 netCDF Convention}[link:../xref.htm#label-6])
  ! to *range*, then input data can be clipped by an arbitrary dimension.
  ! If null character is given to *range*, data is not clipped.
  !
  ! *HistoryGet* is generic name of multiple subroutines.
  ! Integer, single precision real, and double precision real
  ! 0 -- 7 rank array can be given to *array*.
  !
  ! By default, when data is input, filename and variable name and
  ! clipping information is printed.
  ! The message is suppressed when .true. is given to *quiet*
  !
subroutine HistoryGetDouble0(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar, Split, JoinChar, StoA
  use dc_url, only: GT_ATMARK, GT_COMMA, GT_EQUAL, UrlSplit, UrlMerge
  use dc_present, only: present_select, present_and_not_empty, present_and_true
  use dc_regex, only: match
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  use dc_error, only: StoreError, DC_NOERR, GT_ENOTURL, GT_ERANKMISMATCH, &
    & GT_EARGSIZEMISMATCH
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical,  intent(in),  optional:: quiet
  logical,  intent(in),  optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical,  intent(out), optional:: flag_time_exist
  logical,  intent(out), optional:: err
  real(DP), intent(out) :: array
  real(DP) :: array_tmp(1)
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  integer:: rank, alldims, array_rank
  integer:: domain
  character(STRING):: tname
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter :: subname = "HistoryGetDouble0"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  cause_c = ''
  stat = DC_NOERR
  file_work = file
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 最新時刻の URL 取得
  ! Get URL of latest time
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  ! ファイルオープン
  ! File open
  call Open( var, url, err = err )
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  !-------------------------------------------------------------------
  !  配列形状のチェック
  !  Check array shape
  !-------------------------------------------------------------------
  ! 入力ファイル中のデータの次元数
  ! Get size of dimesions in data of an input file
  !
  call Inquire( var = var, &           ! (in)
    & rank = rank, alldims = alldims ) ! (out)
  ! 引数の次元数のチェック (縮退されている場合には減らす)
  ! Check size of dimensions of an argument (If any dimension degenerated, size of dimensions is decreased)
  array_rank = 0
  ! 次元数の比較
  ! Compare sizes of dimensions
  !
  if ( .not. 0 == rank .and. .not. array_rank == rank ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Rank of data (%c) is "%d", rank of argument is "%d"', &
        & i = (/rank, 0/), c1 = trim(url) )
    end if
    stat = GT_ERANKMISMATCH
    cause_c = 'array'
    goto 999
  end if
  ! 入力ファイル中のデータの配列形状取得
  ! Get shape of data in an input file
  !-------------------------------------
  !  データ取得
  !  Get data
  call Inquire( var = var, & ! (in)
    & size = domain )        ! (out)
  call Get( var = var, & ! (inout)
    & nvalue = domain, & ! (in)
    & value = array_tmp) ! (out)
  array = array_tmp(1)
  call Close( var )
  !-------------------------------------
  !  データファイル名と切り出し範囲の印字
  !  Print data filename and clipping range
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url), rank_mpi = -1)
  end if
999 continue
  call StoreError(stat, subname, err, cause_c)
end subroutine HistoryGetDouble0
subroutine HistoryGetDouble1(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar, Split, JoinChar, StoA
  use dc_url, only: GT_ATMARK, GT_COMMA, GT_EQUAL, UrlSplit, UrlMerge
  use dc_present, only: present_select, present_and_not_empty, present_and_true
  use dc_regex, only: match
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  use dc_error, only: StoreError, DC_NOERR, GT_ENOTURL, GT_ERANKMISMATCH, &
    & GT_EARGSIZEMISMATCH
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical,  intent(in),  optional:: quiet
  logical,  intent(in),  optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical,  intent(out), optional:: flag_time_exist
  logical,  intent(out), optional:: err
  real(DP), intent(out) :: array(:)
  real(DP), allocatable  :: array_tmp(:)
  integer:: array_allsize
  integer:: array_shape(1), data_shape(1), array_shape_check(1)
  integer:: allcount
  integer:: i, sd
  logical:: inq_err
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  integer:: rank, alldims, array_rank
  integer:: domain
  character(STRING):: tname
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter :: subname = "HistoryGetDouble1"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  cause_c = ''
  stat = DC_NOERR
  file_work = file
  array_shape = shape( array )
  array_allsize = size( array )
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 最新時刻の URL 取得
  ! Get URL of latest time
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  ! ファイルオープン
  ! File open
  call Open( var, url, err = err )
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  !-------------------------------------------------------------------
  !  配列形状のチェック
  !  Check array shape
  !-------------------------------------------------------------------
  ! 入力ファイル中のデータの次元数
  ! Get size of dimesions in data of an input file
  !
  call Inquire( var = var, &           ! (in)
    & rank = rank, alldims = alldims ) ! (out)
  ! 引数の次元数のチェック (縮退されている場合には減らす)
  ! Check size of dimensions of an argument (If any dimension degenerated, size of dimensions is decreased)
  array_rank = 1
  if ( size( array, 1 ) == 1 ) array_rank = array_rank - 1
  ! 次元数の比較
  ! Compare sizes of dimensions
  !
  if ( .not. 1 == rank .and. .not. array_rank == rank ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Rank of data (%c) is "%d", rank of argument is "%d"', &
        & i = (/rank, 1/), c1 = trim(url) )
    end if
    stat = GT_ERANKMISMATCH
    cause_c = 'array'
    goto 999
  end if
  ! 入力ファイル中のデータの配列形状取得
  ! Get shape of data in an input file
  call Inquire( var = var , dimord = 1, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(1) = allcount
  else
    data_shape(1) = 1
  end if
  ! 引数の配列形状整形
  ! Arrange shape of an argument
  !
  array_shape_check = array_shape
  sd = 1
  do i = 1, 1 - 1
    if ( array_shape_check(sd) == 1 ) then
      array_shape_check(sd:1) = cshift( array_shape_check(sd:1), 1, 1 )
    else
      sd = sd + 1
    end if
  end do
  ! 配列形状の比較
  ! Compare shapes
  !
  if ( .not. all( array_shape_check == data_shape ) ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Shape of data (%c) is (%c), shape of argument is (%c)', &
        & c1 = trim( url ), &
        & c2 = trim( toChar( data_shape(1:rank) ) ), &
        & c3 = trim( toChar( array_shape_check(1:rank) ) ) )
    end if
    stat = GT_EARGSIZEMISMATCH
    cause_c = 'array'
    goto 999
  end if
  !-------------------------------------
  !  データ取得
  !  Get data
  call Inquire( var = var, & ! (in)
    & size = domain )        ! (out)
  if ( allocated( array_tmp ) ) deallocate( array_tmp )
  allocate( array_tmp(array_allsize) )
  call Get( var, array_tmp, domain )
  array = reshape( array_tmp, array_shape )
  deallocate( array_tmp )
  call Close( var )
  !-------------------------------------
  !  データファイル名と切り出し範囲の印字
  !  Print data filename and clipping range
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url), rank_mpi = -1)
  end if
999 continue
  call StoreError(stat, subname, err, cause_c)
end subroutine HistoryGetDouble1
subroutine HistoryGetDouble2(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar, Split, JoinChar, StoA
  use dc_url, only: GT_ATMARK, GT_COMMA, GT_EQUAL, UrlSplit, UrlMerge
  use dc_present, only: present_select, present_and_not_empty, present_and_true
  use dc_regex, only: match
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  use dc_error, only: StoreError, DC_NOERR, GT_ENOTURL, GT_ERANKMISMATCH, &
    & GT_EARGSIZEMISMATCH
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical,  intent(in),  optional:: quiet
  logical,  intent(in),  optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical,  intent(out), optional:: flag_time_exist
  logical,  intent(out), optional:: err
  real(DP), intent(out) :: array(:,:)
  real(DP), allocatable  :: array_tmp(:)
  integer:: array_allsize
  integer:: array_shape(2), data_shape(2), array_shape_check(2)
  integer:: allcount
  integer:: i, sd
  logical:: inq_err
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  integer:: rank, alldims, array_rank
  integer:: domain
  character(STRING):: tname
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter :: subname = "HistoryGetDouble2"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  cause_c = ''
  stat = DC_NOERR
  file_work = file
  array_shape = shape( array )
  array_allsize = size( array )
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 最新時刻の URL 取得
  ! Get URL of latest time
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  ! ファイルオープン
  ! File open
  call Open( var, url, err = err )
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  !-------------------------------------------------------------------
  !  配列形状のチェック
  !  Check array shape
  !-------------------------------------------------------------------
  ! 入力ファイル中のデータの次元数
  ! Get size of dimesions in data of an input file
  !
  call Inquire( var = var, &           ! (in)
    & rank = rank, alldims = alldims ) ! (out)
  ! 引数の次元数のチェック (縮退されている場合には減らす)
  ! Check size of dimensions of an argument (If any dimension degenerated, size of dimensions is decreased)
  array_rank = 2
  if ( size( array, 1 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 2 ) == 1 ) array_rank = array_rank - 1
  ! 次元数の比較
  ! Compare sizes of dimensions
  !
  if ( .not. 2 == rank .and. .not. array_rank == rank ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Rank of data (%c) is "%d", rank of argument is "%d"', &
        & i = (/rank, 2/), c1 = trim(url) )
    end if
    stat = GT_ERANKMISMATCH
    cause_c = 'array'
    goto 999
  end if
  ! 入力ファイル中のデータの配列形状取得
  ! Get shape of data in an input file
  call Inquire( var = var , dimord = 1, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(1) = allcount
  else
    data_shape(1) = 1
  end if
  call Inquire( var = var , dimord = 2, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(2) = allcount
  else
    data_shape(2) = 1
  end if
  ! 引数の配列形状整形
  ! Arrange shape of an argument
  !
  array_shape_check = array_shape
  sd = 1
  do i = 1, 2 - 1
    if ( array_shape_check(sd) == 1 ) then
      array_shape_check(sd:2) = cshift( array_shape_check(sd:2), 1, 1 )
    else
      sd = sd + 1
    end if
  end do
  ! 配列形状の比較
  ! Compare shapes
  !
  if ( .not. all( array_shape_check == data_shape ) ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Shape of data (%c) is (%c), shape of argument is (%c)', &
        & c1 = trim( url ), &
        & c2 = trim( toChar( data_shape(1:rank) ) ), &
        & c3 = trim( toChar( array_shape_check(1:rank) ) ) )
    end if
    stat = GT_EARGSIZEMISMATCH
    cause_c = 'array'
    goto 999
  end if
  !-------------------------------------
  !  データ取得
  !  Get data
  call Inquire( var = var, & ! (in)
    & size = domain )        ! (out)
  if ( allocated( array_tmp ) ) deallocate( array_tmp )
  allocate( array_tmp(array_allsize) )
  call Get( var, array_tmp, domain )
  array = reshape( array_tmp, array_shape )
  deallocate( array_tmp )
  call Close( var )
  !-------------------------------------
  !  データファイル名と切り出し範囲の印字
  !  Print data filename and clipping range
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url), rank_mpi = -1)
  end if
999 continue
  call StoreError(stat, subname, err, cause_c)
end subroutine HistoryGetDouble2
subroutine HistoryGetDouble3(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar, Split, JoinChar, StoA
  use dc_url, only: GT_ATMARK, GT_COMMA, GT_EQUAL, UrlSplit, UrlMerge
  use dc_present, only: present_select, present_and_not_empty, present_and_true
  use dc_regex, only: match
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  use dc_error, only: StoreError, DC_NOERR, GT_ENOTURL, GT_ERANKMISMATCH, &
    & GT_EARGSIZEMISMATCH
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical,  intent(in),  optional:: quiet
  logical,  intent(in),  optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical,  intent(out), optional:: flag_time_exist
  logical,  intent(out), optional:: err
  real(DP), intent(out) :: array(:,:,:)
  real(DP), allocatable  :: array_tmp(:)
  integer:: array_allsize
  integer:: array_shape(3), data_shape(3), array_shape_check(3)
  integer:: allcount
  integer:: i, sd
  logical:: inq_err
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  integer:: rank, alldims, array_rank
  integer:: domain
  character(STRING):: tname
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter :: subname = "HistoryGetDouble3"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  cause_c = ''
  stat = DC_NOERR
  file_work = file
  array_shape = shape( array )
  array_allsize = size( array )
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 最新時刻の URL 取得
  ! Get URL of latest time
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  ! ファイルオープン
  ! File open
  call Open( var, url, err = err )
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  !-------------------------------------------------------------------
  !  配列形状のチェック
  !  Check array shape
  !-------------------------------------------------------------------
  ! 入力ファイル中のデータの次元数
  ! Get size of dimesions in data of an input file
  !
  call Inquire( var = var, &           ! (in)
    & rank = rank, alldims = alldims ) ! (out)
  ! 引数の次元数のチェック (縮退されている場合には減らす)
  ! Check size of dimensions of an argument (If any dimension degenerated, size of dimensions is decreased)
  array_rank = 3
  if ( size( array, 1 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 2 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 3 ) == 1 ) array_rank = array_rank - 1
  ! 次元数の比較
  ! Compare sizes of dimensions
  !
  if ( .not. 3 == rank .and. .not. array_rank == rank ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Rank of data (%c) is "%d", rank of argument is "%d"', &
        & i = (/rank, 3/), c1 = trim(url) )
    end if
    stat = GT_ERANKMISMATCH
    cause_c = 'array'
    goto 999
  end if
  ! 入力ファイル中のデータの配列形状取得
  ! Get shape of data in an input file
  call Inquire( var = var , dimord = 1, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(1) = allcount
  else
    data_shape(1) = 1
  end if
  call Inquire( var = var , dimord = 2, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(2) = allcount
  else
    data_shape(2) = 1
  end if
  call Inquire( var = var , dimord = 3, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(3) = allcount
  else
    data_shape(3) = 1
  end if
  ! 引数の配列形状整形
  ! Arrange shape of an argument
  !
  array_shape_check = array_shape
  sd = 1
  do i = 1, 3 - 1
    if ( array_shape_check(sd) == 1 ) then
      array_shape_check(sd:3) = cshift( array_shape_check(sd:3), 1, 1 )
    else
      sd = sd + 1
    end if
  end do
  ! 配列形状の比較
  ! Compare shapes
  !
  if ( .not. all( array_shape_check == data_shape ) ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Shape of data (%c) is (%c), shape of argument is (%c)', &
        & c1 = trim( url ), &
        & c2 = trim( toChar( data_shape(1:rank) ) ), &
        & c3 = trim( toChar( array_shape_check(1:rank) ) ) )
    end if
    stat = GT_EARGSIZEMISMATCH
    cause_c = 'array'
    goto 999
  end if
  !-------------------------------------
  !  データ取得
  !  Get data
  call Inquire( var = var, & ! (in)
    & size = domain )        ! (out)
  if ( allocated( array_tmp ) ) deallocate( array_tmp )
  allocate( array_tmp(array_allsize) )
  call Get( var, array_tmp, domain )
  array = reshape( array_tmp, array_shape )
  deallocate( array_tmp )
  call Close( var )
  !-------------------------------------
  !  データファイル名と切り出し範囲の印字
  !  Print data filename and clipping range
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url), rank_mpi = -1)
  end if
999 continue
  call StoreError(stat, subname, err, cause_c)
end subroutine HistoryGetDouble3
subroutine HistoryGetDouble4(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar, Split, JoinChar, StoA
  use dc_url, only: GT_ATMARK, GT_COMMA, GT_EQUAL, UrlSplit, UrlMerge
  use dc_present, only: present_select, present_and_not_empty, present_and_true
  use dc_regex, only: match
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  use dc_error, only: StoreError, DC_NOERR, GT_ENOTURL, GT_ERANKMISMATCH, &
    & GT_EARGSIZEMISMATCH
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical,  intent(in),  optional:: quiet
  logical,  intent(in),  optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical,  intent(out), optional:: flag_time_exist
  logical,  intent(out), optional:: err
  real(DP), intent(out) :: array(:,:,:,:)
  real(DP), allocatable  :: array_tmp(:)
  integer:: array_allsize
  integer:: array_shape(4), data_shape(4), array_shape_check(4)
  integer:: allcount
  integer:: i, sd
  logical:: inq_err
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  integer:: rank, alldims, array_rank
  integer:: domain
  character(STRING):: tname
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter :: subname = "HistoryGetDouble4"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  cause_c = ''
  stat = DC_NOERR
  file_work = file
  array_shape = shape( array )
  array_allsize = size( array )
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 最新時刻の URL 取得
  ! Get URL of latest time
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  ! ファイルオープン
  ! File open
  call Open( var, url, err = err )
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  !-------------------------------------------------------------------
  !  配列形状のチェック
  !  Check array shape
  !-------------------------------------------------------------------
  ! 入力ファイル中のデータの次元数
  ! Get size of dimesions in data of an input file
  !
  call Inquire( var = var, &           ! (in)
    & rank = rank, alldims = alldims ) ! (out)
  ! 引数の次元数のチェック (縮退されている場合には減らす)
  ! Check size of dimensions of an argument (If any dimension degenerated, size of dimensions is decreased)
  array_rank = 4
  if ( size( array, 1 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 2 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 3 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 4 ) == 1 ) array_rank = array_rank - 1
  ! 次元数の比較
  ! Compare sizes of dimensions
  !
  if ( .not. 4 == rank .and. .not. array_rank == rank ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Rank of data (%c) is "%d", rank of argument is "%d"', &
        & i = (/rank, 4/), c1 = trim(url) )
    end if
    stat = GT_ERANKMISMATCH
    cause_c = 'array'
    goto 999
  end if
  ! 入力ファイル中のデータの配列形状取得
  ! Get shape of data in an input file
  call Inquire( var = var , dimord = 1, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(1) = allcount
  else
    data_shape(1) = 1
  end if
  call Inquire( var = var , dimord = 2, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(2) = allcount
  else
    data_shape(2) = 1
  end if
  call Inquire( var = var , dimord = 3, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(3) = allcount
  else
    data_shape(3) = 1
  end if
  call Inquire( var = var , dimord = 4, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(4) = allcount
  else
    data_shape(4) = 1
  end if
  ! 引数の配列形状整形
  ! Arrange shape of an argument
  !
  array_shape_check = array_shape
  sd = 1
  do i = 1, 4 - 1
    if ( array_shape_check(sd) == 1 ) then
      array_shape_check(sd:4) = cshift( array_shape_check(sd:4), 1, 1 )
    else
      sd = sd + 1
    end if
  end do
  ! 配列形状の比較
  ! Compare shapes
  !
  if ( .not. all( array_shape_check == data_shape ) ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Shape of data (%c) is (%c), shape of argument is (%c)', &
        & c1 = trim( url ), &
        & c2 = trim( toChar( data_shape(1:rank) ) ), &
        & c3 = trim( toChar( array_shape_check(1:rank) ) ) )
    end if
    stat = GT_EARGSIZEMISMATCH
    cause_c = 'array'
    goto 999
  end if
  !-------------------------------------
  !  データ取得
  !  Get data
  call Inquire( var = var, & ! (in)
    & size = domain )        ! (out)
  if ( allocated( array_tmp ) ) deallocate( array_tmp )
  allocate( array_tmp(array_allsize) )
  call Get( var, array_tmp, domain )
  array = reshape( array_tmp, array_shape )
  deallocate( array_tmp )
  call Close( var )
  !-------------------------------------
  !  データファイル名と切り出し範囲の印字
  !  Print data filename and clipping range
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url), rank_mpi = -1)
  end if
999 continue
  call StoreError(stat, subname, err, cause_c)
end subroutine HistoryGetDouble4
subroutine HistoryGetDouble5(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar, Split, JoinChar, StoA
  use dc_url, only: GT_ATMARK, GT_COMMA, GT_EQUAL, UrlSplit, UrlMerge
  use dc_present, only: present_select, present_and_not_empty, present_and_true
  use dc_regex, only: match
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  use dc_error, only: StoreError, DC_NOERR, GT_ENOTURL, GT_ERANKMISMATCH, &
    & GT_EARGSIZEMISMATCH
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical,  intent(in),  optional:: quiet
  logical,  intent(in),  optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical,  intent(out), optional:: flag_time_exist
  logical,  intent(out), optional:: err
  real(DP), intent(out) :: array(:,:,:,:,:)
  real(DP), allocatable  :: array_tmp(:)
  integer:: array_allsize
  integer:: array_shape(5), data_shape(5), array_shape_check(5)
  integer:: allcount
  integer:: i, sd
  logical:: inq_err
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  integer:: rank, alldims, array_rank
  integer:: domain
  character(STRING):: tname
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter :: subname = "HistoryGetDouble5"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  cause_c = ''
  stat = DC_NOERR
  file_work = file
  array_shape = shape( array )
  array_allsize = size( array )
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 最新時刻の URL 取得
  ! Get URL of latest time
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  ! ファイルオープン
  ! File open
  call Open( var, url, err = err )
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  !-------------------------------------------------------------------
  !  配列形状のチェック
  !  Check array shape
  !-------------------------------------------------------------------
  ! 入力ファイル中のデータの次元数
  ! Get size of dimesions in data of an input file
  !
  call Inquire( var = var, &           ! (in)
    & rank = rank, alldims = alldims ) ! (out)
  ! 引数の次元数のチェック (縮退されている場合には減らす)
  ! Check size of dimensions of an argument (If any dimension degenerated, size of dimensions is decreased)
  array_rank = 5
  if ( size( array, 1 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 2 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 3 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 4 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 5 ) == 1 ) array_rank = array_rank - 1
  ! 次元数の比較
  ! Compare sizes of dimensions
  !
  if ( .not. 5 == rank .and. .not. array_rank == rank ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Rank of data (%c) is "%d", rank of argument is "%d"', &
        & i = (/rank, 5/), c1 = trim(url) )
    end if
    stat = GT_ERANKMISMATCH
    cause_c = 'array'
    goto 999
  end if
  ! 入力ファイル中のデータの配列形状取得
  ! Get shape of data in an input file
  call Inquire( var = var , dimord = 1, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(1) = allcount
  else
    data_shape(1) = 1
  end if
  call Inquire( var = var , dimord = 2, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(2) = allcount
  else
    data_shape(2) = 1
  end if
  call Inquire( var = var , dimord = 3, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(3) = allcount
  else
    data_shape(3) = 1
  end if
  call Inquire( var = var , dimord = 4, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(4) = allcount
  else
    data_shape(4) = 1
  end if
  call Inquire( var = var , dimord = 5, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(5) = allcount
  else
    data_shape(5) = 1
  end if
  ! 引数の配列形状整形
  ! Arrange shape of an argument
  !
  array_shape_check = array_shape
  sd = 1
  do i = 1, 5 - 1
    if ( array_shape_check(sd) == 1 ) then
      array_shape_check(sd:5) = cshift( array_shape_check(sd:5), 1, 1 )
    else
      sd = sd + 1
    end if
  end do
  ! 配列形状の比較
  ! Compare shapes
  !
  if ( .not. all( array_shape_check == data_shape ) ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Shape of data (%c) is (%c), shape of argument is (%c)', &
        & c1 = trim( url ), &
        & c2 = trim( toChar( data_shape(1:rank) ) ), &
        & c3 = trim( toChar( array_shape_check(1:rank) ) ) )
    end if
    stat = GT_EARGSIZEMISMATCH
    cause_c = 'array'
    goto 999
  end if
  !-------------------------------------
  !  データ取得
  !  Get data
  call Inquire( var = var, & ! (in)
    & size = domain )        ! (out)
  if ( allocated( array_tmp ) ) deallocate( array_tmp )
  allocate( array_tmp(array_allsize) )
  call Get( var, array_tmp, domain )
  array = reshape( array_tmp, array_shape )
  deallocate( array_tmp )
  call Close( var )
  !-------------------------------------
  !  データファイル名と切り出し範囲の印字
  !  Print data filename and clipping range
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url), rank_mpi = -1)
  end if
999 continue
  call StoreError(stat, subname, err, cause_c)
end subroutine HistoryGetDouble5
subroutine HistoryGetDouble6(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar, Split, JoinChar, StoA
  use dc_url, only: GT_ATMARK, GT_COMMA, GT_EQUAL, UrlSplit, UrlMerge
  use dc_present, only: present_select, present_and_not_empty, present_and_true
  use dc_regex, only: match
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  use dc_error, only: StoreError, DC_NOERR, GT_ENOTURL, GT_ERANKMISMATCH, &
    & GT_EARGSIZEMISMATCH
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical,  intent(in),  optional:: quiet
  logical,  intent(in),  optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical,  intent(out), optional:: flag_time_exist
  logical,  intent(out), optional:: err
  real(DP), intent(out) :: array(:,:,:,:,:,:)
  real(DP), allocatable  :: array_tmp(:)
  integer:: array_allsize
  integer:: array_shape(6), data_shape(6), array_shape_check(6)
  integer:: allcount
  integer:: i, sd
  logical:: inq_err
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  integer:: rank, alldims, array_rank
  integer:: domain
  character(STRING):: tname
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter :: subname = "HistoryGetDouble6"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  cause_c = ''
  stat = DC_NOERR
  file_work = file
  array_shape = shape( array )
  array_allsize = size( array )
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 最新時刻の URL 取得
  ! Get URL of latest time
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  ! ファイルオープン
  ! File open
  call Open( var, url, err = err )
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  !-------------------------------------------------------------------
  !  配列形状のチェック
  !  Check array shape
  !-------------------------------------------------------------------
  ! 入力ファイル中のデータの次元数
  ! Get size of dimesions in data of an input file
  !
  call Inquire( var = var, &           ! (in)
    & rank = rank, alldims = alldims ) ! (out)
  ! 引数の次元数のチェック (縮退されている場合には減らす)
  ! Check size of dimensions of an argument (If any dimension degenerated, size of dimensions is decreased)
  array_rank = 6
  if ( size( array, 1 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 2 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 3 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 4 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 5 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 6 ) == 1 ) array_rank = array_rank - 1
  ! 次元数の比較
  ! Compare sizes of dimensions
  !
  if ( .not. 6 == rank .and. .not. array_rank == rank ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Rank of data (%c) is "%d", rank of argument is "%d"', &
        & i = (/rank, 6/), c1 = trim(url) )
    end if
    stat = GT_ERANKMISMATCH
    cause_c = 'array'
    goto 999
  end if
  ! 入力ファイル中のデータの配列形状取得
  ! Get shape of data in an input file
  call Inquire( var = var , dimord = 1, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(1) = allcount
  else
    data_shape(1) = 1
  end if
  call Inquire( var = var , dimord = 2, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(2) = allcount
  else
    data_shape(2) = 1
  end if
  call Inquire( var = var , dimord = 3, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(3) = allcount
  else
    data_shape(3) = 1
  end if
  call Inquire( var = var , dimord = 4, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(4) = allcount
  else
    data_shape(4) = 1
  end if
  call Inquire( var = var , dimord = 5, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(5) = allcount
  else
    data_shape(5) = 1
  end if
  call Inquire( var = var , dimord = 6, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(6) = allcount
  else
    data_shape(6) = 1
  end if
  ! 引数の配列形状整形
  ! Arrange shape of an argument
  !
  array_shape_check = array_shape
  sd = 1
  do i = 1, 6 - 1
    if ( array_shape_check(sd) == 1 ) then
      array_shape_check(sd:6) = cshift( array_shape_check(sd:6), 1, 1 )
    else
      sd = sd + 1
    end if
  end do
  ! 配列形状の比較
  ! Compare shapes
  !
  if ( .not. all( array_shape_check == data_shape ) ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Shape of data (%c) is (%c), shape of argument is (%c)', &
        & c1 = trim( url ), &
        & c2 = trim( toChar( data_shape(1:rank) ) ), &
        & c3 = trim( toChar( array_shape_check(1:rank) ) ) )
    end if
    stat = GT_EARGSIZEMISMATCH
    cause_c = 'array'
    goto 999
  end if
  !-------------------------------------
  !  データ取得
  !  Get data
  call Inquire( var = var, & ! (in)
    & size = domain )        ! (out)
  if ( allocated( array_tmp ) ) deallocate( array_tmp )
  allocate( array_tmp(array_allsize) )
  call Get( var, array_tmp, domain )
  array = reshape( array_tmp, array_shape )
  deallocate( array_tmp )
  call Close( var )
  !-------------------------------------
  !  データファイル名と切り出し範囲の印字
  !  Print data filename and clipping range
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url), rank_mpi = -1)
  end if
999 continue
  call StoreError(stat, subname, err, cause_c)
end subroutine HistoryGetDouble6
subroutine HistoryGetDouble7(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar, Split, JoinChar, StoA
  use dc_url, only: GT_ATMARK, GT_COMMA, GT_EQUAL, UrlSplit, UrlMerge
  use dc_present, only: present_select, present_and_not_empty, present_and_true
  use dc_regex, only: match
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  use dc_error, only: StoreError, DC_NOERR, GT_ENOTURL, GT_ERANKMISMATCH, &
    & GT_EARGSIZEMISMATCH
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical,  intent(in),  optional:: quiet
  logical,  intent(in),  optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical,  intent(out), optional:: flag_time_exist
  logical,  intent(out), optional:: err
  real(DP), intent(out) :: array(:,:,:,:,:,:,:)
  real(DP), allocatable  :: array_tmp(:)
  integer:: array_allsize
  integer:: array_shape(7), data_shape(7), array_shape_check(7)
  integer:: allcount
  integer:: i, sd
  logical:: inq_err
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  integer:: rank, alldims, array_rank
  integer:: domain
  character(STRING):: tname
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter :: subname = "HistoryGetDouble7"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  cause_c = ''
  stat = DC_NOERR
  file_work = file
  array_shape = shape( array )
  array_allsize = size( array )
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 最新時刻の URL 取得
  ! Get URL of latest time
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  ! ファイルオープン
  ! File open
  call Open( var, url, err = err )
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  !-------------------------------------------------------------------
  !  配列形状のチェック
  !  Check array shape
  !-------------------------------------------------------------------
  ! 入力ファイル中のデータの次元数
  ! Get size of dimesions in data of an input file
  !
  call Inquire( var = var, &           ! (in)
    & rank = rank, alldims = alldims ) ! (out)
  ! 引数の次元数のチェック (縮退されている場合には減らす)
  ! Check size of dimensions of an argument (If any dimension degenerated, size of dimensions is decreased)
  array_rank = 7
  if ( size( array, 1 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 2 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 3 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 4 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 5 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 6 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 7 ) == 1 ) array_rank = array_rank - 1
  ! 次元数の比較
  ! Compare sizes of dimensions
  !
  if ( .not. 7 == rank .and. .not. array_rank == rank ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Rank of data (%c) is "%d", rank of argument is "%d"', &
        & i = (/rank, 7/), c1 = trim(url) )
    end if
    stat = GT_ERANKMISMATCH
    cause_c = 'array'
    goto 999
  end if
  ! 入力ファイル中のデータの配列形状取得
  ! Get shape of data in an input file
  call Inquire( var = var , dimord = 1, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(1) = allcount
  else
    data_shape(1) = 1
  end if
  call Inquire( var = var , dimord = 2, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(2) = allcount
  else
    data_shape(2) = 1
  end if
  call Inquire( var = var , dimord = 3, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(3) = allcount
  else
    data_shape(3) = 1
  end if
  call Inquire( var = var , dimord = 4, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(4) = allcount
  else
    data_shape(4) = 1
  end if
  call Inquire( var = var , dimord = 5, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(5) = allcount
  else
    data_shape(5) = 1
  end if
  call Inquire( var = var , dimord = 6, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(6) = allcount
  else
    data_shape(6) = 1
  end if
  call Inquire( var = var , dimord = 7, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(7) = allcount
  else
    data_shape(7) = 1
  end if
  ! 引数の配列形状整形
  ! Arrange shape of an argument
  !
  array_shape_check = array_shape
  sd = 1
  do i = 1, 7 - 1
    if ( array_shape_check(sd) == 1 ) then
      array_shape_check(sd:7) = cshift( array_shape_check(sd:7), 1, 1 )
    else
      sd = sd + 1
    end if
  end do
  ! 配列形状の比較
  ! Compare shapes
  !
  if ( .not. all( array_shape_check == data_shape ) ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Shape of data (%c) is (%c), shape of argument is (%c)', &
        & c1 = trim( url ), &
        & c2 = trim( toChar( data_shape(1:rank) ) ), &
        & c3 = trim( toChar( array_shape_check(1:rank) ) ) )
    end if
    stat = GT_EARGSIZEMISMATCH
    cause_c = 'array'
    goto 999
  end if
  !-------------------------------------
  !  データ取得
  !  Get data
  call Inquire( var = var, & ! (in)
    & size = domain )        ! (out)
  if ( allocated( array_tmp ) ) deallocate( array_tmp )
  allocate( array_tmp(array_allsize) )
  call Get( var, array_tmp, domain )
  array = reshape( array_tmp, array_shape )
  deallocate( array_tmp )
  call Close( var )
  !-------------------------------------
  !  データファイル名と切り出し範囲の印字
  !  Print data filename and clipping range
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url), rank_mpi = -1)
  end if
999 continue
  call StoreError(stat, subname, err, cause_c)
end subroutine HistoryGetDouble7
subroutine HistoryGetReal0(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar, Split, JoinChar, StoA
  use dc_url, only: GT_ATMARK, GT_COMMA, GT_EQUAL, UrlSplit, UrlMerge
  use dc_present, only: present_select, present_and_not_empty, present_and_true
  use dc_regex, only: match
  use dc_types, only: STRING, DP, SP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  use dc_error, only: StoreError, DC_NOERR, GT_ENOTURL, GT_ERANKMISMATCH, &
    & GT_EARGSIZEMISMATCH
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical,  intent(in),  optional:: quiet
  logical,  intent(in),  optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical,  intent(out), optional:: flag_time_exist
  logical,  intent(out), optional:: err
  real(SP), intent(out) :: array
  real(SP) :: array_tmp(1)
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  integer:: rank, alldims, array_rank
  integer:: domain
  character(STRING):: tname
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter :: subname = "HistoryGetReal0"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  cause_c = ''
  stat = DC_NOERR
  file_work = file
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 最新時刻の URL 取得
  ! Get URL of latest time
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  ! ファイルオープン
  ! File open
  call Open( var, url, err = err )
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  !-------------------------------------------------------------------
  !  配列形状のチェック
  !  Check array shape
  !-------------------------------------------------------------------
  ! 入力ファイル中のデータの次元数
  ! Get size of dimesions in data of an input file
  !
  call Inquire( var = var, &           ! (in)
    & rank = rank, alldims = alldims ) ! (out)
  ! 引数の次元数のチェック (縮退されている場合には減らす)
  ! Check size of dimensions of an argument (If any dimension degenerated, size of dimensions is decreased)
  array_rank = 0
  ! 次元数の比較
  ! Compare sizes of dimensions
  !
  if ( .not. 0 == rank .and. .not. array_rank == rank ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Rank of data (%c) is "%d", rank of argument is "%d"', &
        & i = (/rank, 0/), c1 = trim(url) )
    end if
    stat = GT_ERANKMISMATCH
    cause_c = 'array'
    goto 999
  end if
  ! 入力ファイル中のデータの配列形状取得
  ! Get shape of data in an input file
  !-------------------------------------
  !  データ取得
  !  Get data
  call Inquire( var = var, & ! (in)
    & size = domain )        ! (out)
  call Get( var = var, & ! (inout)
    & nvalue = domain, & ! (in)
    & value = array_tmp) ! (out)
  array = array_tmp(1)
  call Close( var )
  !-------------------------------------
  !  データファイル名と切り出し範囲の印字
  !  Print data filename and clipping range
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url), rank_mpi = -1)
  end if
999 continue
  call StoreError(stat, subname, err, cause_c)
end subroutine HistoryGetReal0
subroutine HistoryGetReal1(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar, Split, JoinChar, StoA
  use dc_url, only: GT_ATMARK, GT_COMMA, GT_EQUAL, UrlSplit, UrlMerge
  use dc_present, only: present_select, present_and_not_empty, present_and_true
  use dc_regex, only: match
  use dc_types, only: STRING, DP, SP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  use dc_error, only: StoreError, DC_NOERR, GT_ENOTURL, GT_ERANKMISMATCH, &
    & GT_EARGSIZEMISMATCH
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical,  intent(in),  optional:: quiet
  logical,  intent(in),  optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical,  intent(out), optional:: flag_time_exist
  logical,  intent(out), optional:: err
  real(SP), intent(out) :: array(:)
  real(SP), allocatable  :: array_tmp(:)
  integer:: array_allsize
  integer:: array_shape(1), data_shape(1), array_shape_check(1)
  integer:: allcount
  integer:: i, sd
  logical:: inq_err
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  integer:: rank, alldims, array_rank
  integer:: domain
  character(STRING):: tname
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter :: subname = "HistoryGetReal1"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  cause_c = ''
  stat = DC_NOERR
  file_work = file
  array_shape = shape( array )
  array_allsize = size( array )
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 最新時刻の URL 取得
  ! Get URL of latest time
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  ! ファイルオープン
  ! File open
  call Open( var, url, err = err )
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  !-------------------------------------------------------------------
  !  配列形状のチェック
  !  Check array shape
  !-------------------------------------------------------------------
  ! 入力ファイル中のデータの次元数
  ! Get size of dimesions in data of an input file
  !
  call Inquire( var = var, &           ! (in)
    & rank = rank, alldims = alldims ) ! (out)
  ! 引数の次元数のチェック (縮退されている場合には減らす)
  ! Check size of dimensions of an argument (If any dimension degenerated, size of dimensions is decreased)
  array_rank = 1
  if ( size( array, 1 ) == 1 ) array_rank = array_rank - 1
  ! 次元数の比較
  ! Compare sizes of dimensions
  !
  if ( .not. 1 == rank .and. .not. array_rank == rank ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Rank of data (%c) is "%d", rank of argument is "%d"', &
        & i = (/rank, 1/), c1 = trim(url) )
    end if
    stat = GT_ERANKMISMATCH
    cause_c = 'array'
    goto 999
  end if
  ! 入力ファイル中のデータの配列形状取得
  ! Get shape of data in an input file
  call Inquire( var = var , dimord = 1, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(1) = allcount
  else
    data_shape(1) = 1
  end if
  ! 引数の配列形状整形
  ! Arrange shape of an argument
  !
  array_shape_check = array_shape
  sd = 1
  do i = 1, 1 - 1
    if ( array_shape_check(sd) == 1 ) then
      array_shape_check(sd:1) = cshift( array_shape_check(sd:1), 1, 1 )
    else
      sd = sd + 1
    end if
  end do
  ! 配列形状の比較
  ! Compare shapes
  !
  if ( .not. all( array_shape_check == data_shape ) ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Shape of data (%c) is (%c), shape of argument is (%c)', &
        & c1 = trim( url ), &
        & c2 = trim( toChar( data_shape(1:rank) ) ), &
        & c3 = trim( toChar( array_shape_check(1:rank) ) ) )
    end if
    stat = GT_EARGSIZEMISMATCH
    cause_c = 'array'
    goto 999
  end if
  !-------------------------------------
  !  データ取得
  !  Get data
  call Inquire( var = var, & ! (in)
    & size = domain )        ! (out)
  if ( allocated( array_tmp ) ) deallocate( array_tmp )
  allocate( array_tmp(array_allsize) )
  call Get( var, array_tmp, domain )
  array = reshape( array_tmp, array_shape )
  deallocate( array_tmp )
  call Close( var )
  !-------------------------------------
  !  データファイル名と切り出し範囲の印字
  !  Print data filename and clipping range
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url), rank_mpi = -1)
  end if
999 continue
  call StoreError(stat, subname, err, cause_c)
end subroutine HistoryGetReal1
subroutine HistoryGetReal2(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar, Split, JoinChar, StoA
  use dc_url, only: GT_ATMARK, GT_COMMA, GT_EQUAL, UrlSplit, UrlMerge
  use dc_present, only: present_select, present_and_not_empty, present_and_true
  use dc_regex, only: match
  use dc_types, only: STRING, DP, SP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  use dc_error, only: StoreError, DC_NOERR, GT_ENOTURL, GT_ERANKMISMATCH, &
    & GT_EARGSIZEMISMATCH
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical,  intent(in),  optional:: quiet
  logical,  intent(in),  optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical,  intent(out), optional:: flag_time_exist
  logical,  intent(out), optional:: err
  real(SP), intent(out) :: array(:,:)
  real(SP), allocatable  :: array_tmp(:)
  integer:: array_allsize
  integer:: array_shape(2), data_shape(2), array_shape_check(2)
  integer:: allcount
  integer:: i, sd
  logical:: inq_err
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  integer:: rank, alldims, array_rank
  integer:: domain
  character(STRING):: tname
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter :: subname = "HistoryGetReal2"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  cause_c = ''
  stat = DC_NOERR
  file_work = file
  array_shape = shape( array )
  array_allsize = size( array )
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 最新時刻の URL 取得
  ! Get URL of latest time
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  ! ファイルオープン
  ! File open
  call Open( var, url, err = err )
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  !-------------------------------------------------------------------
  !  配列形状のチェック
  !  Check array shape
  !-------------------------------------------------------------------
  ! 入力ファイル中のデータの次元数
  ! Get size of dimesions in data of an input file
  !
  call Inquire( var = var, &           ! (in)
    & rank = rank, alldims = alldims ) ! (out)
  ! 引数の次元数のチェック (縮退されている場合には減らす)
  ! Check size of dimensions of an argument (If any dimension degenerated, size of dimensions is decreased)
  array_rank = 2
  if ( size( array, 1 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 2 ) == 1 ) array_rank = array_rank - 1
  ! 次元数の比較
  ! Compare sizes of dimensions
  !
  if ( .not. 2 == rank .and. .not. array_rank == rank ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Rank of data (%c) is "%d", rank of argument is "%d"', &
        & i = (/rank, 2/), c1 = trim(url) )
    end if
    stat = GT_ERANKMISMATCH
    cause_c = 'array'
    goto 999
  end if
  ! 入力ファイル中のデータの配列形状取得
  ! Get shape of data in an input file
  call Inquire( var = var , dimord = 1, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(1) = allcount
  else
    data_shape(1) = 1
  end if
  call Inquire( var = var , dimord = 2, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(2) = allcount
  else
    data_shape(2) = 1
  end if
  ! 引数の配列形状整形
  ! Arrange shape of an argument
  !
  array_shape_check = array_shape
  sd = 1
  do i = 1, 2 - 1
    if ( array_shape_check(sd) == 1 ) then
      array_shape_check(sd:2) = cshift( array_shape_check(sd:2), 1, 1 )
    else
      sd = sd + 1
    end if
  end do
  ! 配列形状の比較
  ! Compare shapes
  !
  if ( .not. all( array_shape_check == data_shape ) ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Shape of data (%c) is (%c), shape of argument is (%c)', &
        & c1 = trim( url ), &
        & c2 = trim( toChar( data_shape(1:rank) ) ), &
        & c3 = trim( toChar( array_shape_check(1:rank) ) ) )
    end if
    stat = GT_EARGSIZEMISMATCH
    cause_c = 'array'
    goto 999
  end if
  !-------------------------------------
  !  データ取得
  !  Get data
  call Inquire( var = var, & ! (in)
    & size = domain )        ! (out)
  if ( allocated( array_tmp ) ) deallocate( array_tmp )
  allocate( array_tmp(array_allsize) )
  call Get( var, array_tmp, domain )
  array = reshape( array_tmp, array_shape )
  deallocate( array_tmp )
  call Close( var )
  !-------------------------------------
  !  データファイル名と切り出し範囲の印字
  !  Print data filename and clipping range
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url), rank_mpi = -1)
  end if
999 continue
  call StoreError(stat, subname, err, cause_c)
end subroutine HistoryGetReal2
subroutine HistoryGetReal3(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar, Split, JoinChar, StoA
  use dc_url, only: GT_ATMARK, GT_COMMA, GT_EQUAL, UrlSplit, UrlMerge
  use dc_present, only: present_select, present_and_not_empty, present_and_true
  use dc_regex, only: match
  use dc_types, only: STRING, DP, SP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  use dc_error, only: StoreError, DC_NOERR, GT_ENOTURL, GT_ERANKMISMATCH, &
    & GT_EARGSIZEMISMATCH
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical,  intent(in),  optional:: quiet
  logical,  intent(in),  optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical,  intent(out), optional:: flag_time_exist
  logical,  intent(out), optional:: err
  real(SP), intent(out) :: array(:,:,:)
  real(SP), allocatable  :: array_tmp(:)
  integer:: array_allsize
  integer:: array_shape(3), data_shape(3), array_shape_check(3)
  integer:: allcount
  integer:: i, sd
  logical:: inq_err
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  integer:: rank, alldims, array_rank
  integer:: domain
  character(STRING):: tname
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter :: subname = "HistoryGetReal3"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  cause_c = ''
  stat = DC_NOERR
  file_work = file
  array_shape = shape( array )
  array_allsize = size( array )
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 最新時刻の URL 取得
  ! Get URL of latest time
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  ! ファイルオープン
  ! File open
  call Open( var, url, err = err )
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  !-------------------------------------------------------------------
  !  配列形状のチェック
  !  Check array shape
  !-------------------------------------------------------------------
  ! 入力ファイル中のデータの次元数
  ! Get size of dimesions in data of an input file
  !
  call Inquire( var = var, &           ! (in)
    & rank = rank, alldims = alldims ) ! (out)
  ! 引数の次元数のチェック (縮退されている場合には減らす)
  ! Check size of dimensions of an argument (If any dimension degenerated, size of dimensions is decreased)
  array_rank = 3
  if ( size( array, 1 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 2 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 3 ) == 1 ) array_rank = array_rank - 1
  ! 次元数の比較
  ! Compare sizes of dimensions
  !
  if ( .not. 3 == rank .and. .not. array_rank == rank ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Rank of data (%c) is "%d", rank of argument is "%d"', &
        & i = (/rank, 3/), c1 = trim(url) )
    end if
    stat = GT_ERANKMISMATCH
    cause_c = 'array'
    goto 999
  end if
  ! 入力ファイル中のデータの配列形状取得
  ! Get shape of data in an input file
  call Inquire( var = var , dimord = 1, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(1) = allcount
  else
    data_shape(1) = 1
  end if
  call Inquire( var = var , dimord = 2, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(2) = allcount
  else
    data_shape(2) = 1
  end if
  call Inquire( var = var , dimord = 3, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(3) = allcount
  else
    data_shape(3) = 1
  end if
  ! 引数の配列形状整形
  ! Arrange shape of an argument
  !
  array_shape_check = array_shape
  sd = 1
  do i = 1, 3 - 1
    if ( array_shape_check(sd) == 1 ) then
      array_shape_check(sd:3) = cshift( array_shape_check(sd:3), 1, 1 )
    else
      sd = sd + 1
    end if
  end do
  ! 配列形状の比較
  ! Compare shapes
  !
  if ( .not. all( array_shape_check == data_shape ) ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Shape of data (%c) is (%c), shape of argument is (%c)', &
        & c1 = trim( url ), &
        & c2 = trim( toChar( data_shape(1:rank) ) ), &
        & c3 = trim( toChar( array_shape_check(1:rank) ) ) )
    end if
    stat = GT_EARGSIZEMISMATCH
    cause_c = 'array'
    goto 999
  end if
  !-------------------------------------
  !  データ取得
  !  Get data
  call Inquire( var = var, & ! (in)
    & size = domain )        ! (out)
  if ( allocated( array_tmp ) ) deallocate( array_tmp )
  allocate( array_tmp(array_allsize) )
  call Get( var, array_tmp, domain )
  array = reshape( array_tmp, array_shape )
  deallocate( array_tmp )
  call Close( var )
  !-------------------------------------
  !  データファイル名と切り出し範囲の印字
  !  Print data filename and clipping range
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url), rank_mpi = -1)
  end if
999 continue
  call StoreError(stat, subname, err, cause_c)
end subroutine HistoryGetReal3
subroutine HistoryGetReal4(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar, Split, JoinChar, StoA
  use dc_url, only: GT_ATMARK, GT_COMMA, GT_EQUAL, UrlSplit, UrlMerge
  use dc_present, only: present_select, present_and_not_empty, present_and_true
  use dc_regex, only: match
  use dc_types, only: STRING, DP, SP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  use dc_error, only: StoreError, DC_NOERR, GT_ENOTURL, GT_ERANKMISMATCH, &
    & GT_EARGSIZEMISMATCH
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical,  intent(in),  optional:: quiet
  logical,  intent(in),  optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical,  intent(out), optional:: flag_time_exist
  logical,  intent(out), optional:: err
  real(SP), intent(out) :: array(:,:,:,:)
  real(SP), allocatable  :: array_tmp(:)
  integer:: array_allsize
  integer:: array_shape(4), data_shape(4), array_shape_check(4)
  integer:: allcount
  integer:: i, sd
  logical:: inq_err
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  integer:: rank, alldims, array_rank
  integer:: domain
  character(STRING):: tname
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter :: subname = "HistoryGetReal4"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  cause_c = ''
  stat = DC_NOERR
  file_work = file
  array_shape = shape( array )
  array_allsize = size( array )
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 最新時刻の URL 取得
  ! Get URL of latest time
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  ! ファイルオープン
  ! File open
  call Open( var, url, err = err )
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  !-------------------------------------------------------------------
  !  配列形状のチェック
  !  Check array shape
  !-------------------------------------------------------------------
  ! 入力ファイル中のデータの次元数
  ! Get size of dimesions in data of an input file
  !
  call Inquire( var = var, &           ! (in)
    & rank = rank, alldims = alldims ) ! (out)
  ! 引数の次元数のチェック (縮退されている場合には減らす)
  ! Check size of dimensions of an argument (If any dimension degenerated, size of dimensions is decreased)
  array_rank = 4
  if ( size( array, 1 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 2 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 3 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 4 ) == 1 ) array_rank = array_rank - 1
  ! 次元数の比較
  ! Compare sizes of dimensions
  !
  if ( .not. 4 == rank .and. .not. array_rank == rank ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Rank of data (%c) is "%d", rank of argument is "%d"', &
        & i = (/rank, 4/), c1 = trim(url) )
    end if
    stat = GT_ERANKMISMATCH
    cause_c = 'array'
    goto 999
  end if
  ! 入力ファイル中のデータの配列形状取得
  ! Get shape of data in an input file
  call Inquire( var = var , dimord = 1, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(1) = allcount
  else
    data_shape(1) = 1
  end if
  call Inquire( var = var , dimord = 2, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(2) = allcount
  else
    data_shape(2) = 1
  end if
  call Inquire( var = var , dimord = 3, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(3) = allcount
  else
    data_shape(3) = 1
  end if
  call Inquire( var = var , dimord = 4, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(4) = allcount
  else
    data_shape(4) = 1
  end if
  ! 引数の配列形状整形
  ! Arrange shape of an argument
  !
  array_shape_check = array_shape
  sd = 1
  do i = 1, 4 - 1
    if ( array_shape_check(sd) == 1 ) then
      array_shape_check(sd:4) = cshift( array_shape_check(sd:4), 1, 1 )
    else
      sd = sd + 1
    end if
  end do
  ! 配列形状の比較
  ! Compare shapes
  !
  if ( .not. all( array_shape_check == data_shape ) ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Shape of data (%c) is (%c), shape of argument is (%c)', &
        & c1 = trim( url ), &
        & c2 = trim( toChar( data_shape(1:rank) ) ), &
        & c3 = trim( toChar( array_shape_check(1:rank) ) ) )
    end if
    stat = GT_EARGSIZEMISMATCH
    cause_c = 'array'
    goto 999
  end if
  !-------------------------------------
  !  データ取得
  !  Get data
  call Inquire( var = var, & ! (in)
    & size = domain )        ! (out)
  if ( allocated( array_tmp ) ) deallocate( array_tmp )
  allocate( array_tmp(array_allsize) )
  call Get( var, array_tmp, domain )
  array = reshape( array_tmp, array_shape )
  deallocate( array_tmp )
  call Close( var )
  !-------------------------------------
  !  データファイル名と切り出し範囲の印字
  !  Print data filename and clipping range
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url), rank_mpi = -1)
  end if
999 continue
  call StoreError(stat, subname, err, cause_c)
end subroutine HistoryGetReal4
subroutine HistoryGetReal5(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar, Split, JoinChar, StoA
  use dc_url, only: GT_ATMARK, GT_COMMA, GT_EQUAL, UrlSplit, UrlMerge
  use dc_present, only: present_select, present_and_not_empty, present_and_true
  use dc_regex, only: match
  use dc_types, only: STRING, DP, SP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  use dc_error, only: StoreError, DC_NOERR, GT_ENOTURL, GT_ERANKMISMATCH, &
    & GT_EARGSIZEMISMATCH
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical,  intent(in),  optional:: quiet
  logical,  intent(in),  optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical,  intent(out), optional:: flag_time_exist
  logical,  intent(out), optional:: err
  real(SP), intent(out) :: array(:,:,:,:,:)
  real(SP), allocatable  :: array_tmp(:)
  integer:: array_allsize
  integer:: array_shape(5), data_shape(5), array_shape_check(5)
  integer:: allcount
  integer:: i, sd
  logical:: inq_err
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  integer:: rank, alldims, array_rank
  integer:: domain
  character(STRING):: tname
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter :: subname = "HistoryGetReal5"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  cause_c = ''
  stat = DC_NOERR
  file_work = file
  array_shape = shape( array )
  array_allsize = size( array )
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 最新時刻の URL 取得
  ! Get URL of latest time
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  ! ファイルオープン
  ! File open
  call Open( var, url, err = err )
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  !-------------------------------------------------------------------
  !  配列形状のチェック
  !  Check array shape
  !-------------------------------------------------------------------
  ! 入力ファイル中のデータの次元数
  ! Get size of dimesions in data of an input file
  !
  call Inquire( var = var, &           ! (in)
    & rank = rank, alldims = alldims ) ! (out)
  ! 引数の次元数のチェック (縮退されている場合には減らす)
  ! Check size of dimensions of an argument (If any dimension degenerated, size of dimensions is decreased)
  array_rank = 5
  if ( size( array, 1 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 2 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 3 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 4 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 5 ) == 1 ) array_rank = array_rank - 1
  ! 次元数の比較
  ! Compare sizes of dimensions
  !
  if ( .not. 5 == rank .and. .not. array_rank == rank ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Rank of data (%c) is "%d", rank of argument is "%d"', &
        & i = (/rank, 5/), c1 = trim(url) )
    end if
    stat = GT_ERANKMISMATCH
    cause_c = 'array'
    goto 999
  end if
  ! 入力ファイル中のデータの配列形状取得
  ! Get shape of data in an input file
  call Inquire( var = var , dimord = 1, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(1) = allcount
  else
    data_shape(1) = 1
  end if
  call Inquire( var = var , dimord = 2, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(2) = allcount
  else
    data_shape(2) = 1
  end if
  call Inquire( var = var , dimord = 3, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(3) = allcount
  else
    data_shape(3) = 1
  end if
  call Inquire( var = var , dimord = 4, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(4) = allcount
  else
    data_shape(4) = 1
  end if
  call Inquire( var = var , dimord = 5, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(5) = allcount
  else
    data_shape(5) = 1
  end if
  ! 引数の配列形状整形
  ! Arrange shape of an argument
  !
  array_shape_check = array_shape
  sd = 1
  do i = 1, 5 - 1
    if ( array_shape_check(sd) == 1 ) then
      array_shape_check(sd:5) = cshift( array_shape_check(sd:5), 1, 1 )
    else
      sd = sd + 1
    end if
  end do
  ! 配列形状の比較
  ! Compare shapes
  !
  if ( .not. all( array_shape_check == data_shape ) ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Shape of data (%c) is (%c), shape of argument is (%c)', &
        & c1 = trim( url ), &
        & c2 = trim( toChar( data_shape(1:rank) ) ), &
        & c3 = trim( toChar( array_shape_check(1:rank) ) ) )
    end if
    stat = GT_EARGSIZEMISMATCH
    cause_c = 'array'
    goto 999
  end if
  !-------------------------------------
  !  データ取得
  !  Get data
  call Inquire( var = var, & ! (in)
    & size = domain )        ! (out)
  if ( allocated( array_tmp ) ) deallocate( array_tmp )
  allocate( array_tmp(array_allsize) )
  call Get( var, array_tmp, domain )
  array = reshape( array_tmp, array_shape )
  deallocate( array_tmp )
  call Close( var )
  !-------------------------------------
  !  データファイル名と切り出し範囲の印字
  !  Print data filename and clipping range
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url), rank_mpi = -1)
  end if
999 continue
  call StoreError(stat, subname, err, cause_c)
end subroutine HistoryGetReal5
subroutine HistoryGetReal6(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar, Split, JoinChar, StoA
  use dc_url, only: GT_ATMARK, GT_COMMA, GT_EQUAL, UrlSplit, UrlMerge
  use dc_present, only: present_select, present_and_not_empty, present_and_true
  use dc_regex, only: match
  use dc_types, only: STRING, DP, SP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  use dc_error, only: StoreError, DC_NOERR, GT_ENOTURL, GT_ERANKMISMATCH, &
    & GT_EARGSIZEMISMATCH
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical,  intent(in),  optional:: quiet
  logical,  intent(in),  optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical,  intent(out), optional:: flag_time_exist
  logical,  intent(out), optional:: err
  real(SP), intent(out) :: array(:,:,:,:,:,:)
  real(SP), allocatable  :: array_tmp(:)
  integer:: array_allsize
  integer:: array_shape(6), data_shape(6), array_shape_check(6)
  integer:: allcount
  integer:: i, sd
  logical:: inq_err
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  integer:: rank, alldims, array_rank
  integer:: domain
  character(STRING):: tname
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter :: subname = "HistoryGetReal6"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  cause_c = ''
  stat = DC_NOERR
  file_work = file
  array_shape = shape( array )
  array_allsize = size( array )
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 最新時刻の URL 取得
  ! Get URL of latest time
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  ! ファイルオープン
  ! File open
  call Open( var, url, err = err )
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  !-------------------------------------------------------------------
  !  配列形状のチェック
  !  Check array shape
  !-------------------------------------------------------------------
  ! 入力ファイル中のデータの次元数
  ! Get size of dimesions in data of an input file
  !
  call Inquire( var = var, &           ! (in)
    & rank = rank, alldims = alldims ) ! (out)
  ! 引数の次元数のチェック (縮退されている場合には減らす)
  ! Check size of dimensions of an argument (If any dimension degenerated, size of dimensions is decreased)
  array_rank = 6
  if ( size( array, 1 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 2 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 3 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 4 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 5 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 6 ) == 1 ) array_rank = array_rank - 1
  ! 次元数の比較
  ! Compare sizes of dimensions
  !
  if ( .not. 6 == rank .and. .not. array_rank == rank ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Rank of data (%c) is "%d", rank of argument is "%d"', &
        & i = (/rank, 6/), c1 = trim(url) )
    end if
    stat = GT_ERANKMISMATCH
    cause_c = 'array'
    goto 999
  end if
  ! 入力ファイル中のデータの配列形状取得
  ! Get shape of data in an input file
  call Inquire( var = var , dimord = 1, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(1) = allcount
  else
    data_shape(1) = 1
  end if
  call Inquire( var = var , dimord = 2, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(2) = allcount
  else
    data_shape(2) = 1
  end if
  call Inquire( var = var , dimord = 3, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(3) = allcount
  else
    data_shape(3) = 1
  end if
  call Inquire( var = var , dimord = 4, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(4) = allcount
  else
    data_shape(4) = 1
  end if
  call Inquire( var = var , dimord = 5, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(5) = allcount
  else
    data_shape(5) = 1
  end if
  call Inquire( var = var , dimord = 6, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(6) = allcount
  else
    data_shape(6) = 1
  end if
  ! 引数の配列形状整形
  ! Arrange shape of an argument
  !
  array_shape_check = array_shape
  sd = 1
  do i = 1, 6 - 1
    if ( array_shape_check(sd) == 1 ) then
      array_shape_check(sd:6) = cshift( array_shape_check(sd:6), 1, 1 )
    else
      sd = sd + 1
    end if
  end do
  ! 配列形状の比較
  ! Compare shapes
  !
  if ( .not. all( array_shape_check == data_shape ) ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Shape of data (%c) is (%c), shape of argument is (%c)', &
        & c1 = trim( url ), &
        & c2 = trim( toChar( data_shape(1:rank) ) ), &
        & c3 = trim( toChar( array_shape_check(1:rank) ) ) )
    end if
    stat = GT_EARGSIZEMISMATCH
    cause_c = 'array'
    goto 999
  end if
  !-------------------------------------
  !  データ取得
  !  Get data
  call Inquire( var = var, & ! (in)
    & size = domain )        ! (out)
  if ( allocated( array_tmp ) ) deallocate( array_tmp )
  allocate( array_tmp(array_allsize) )
  call Get( var, array_tmp, domain )
  array = reshape( array_tmp, array_shape )
  deallocate( array_tmp )
  call Close( var )
  !-------------------------------------
  !  データファイル名と切り出し範囲の印字
  !  Print data filename and clipping range
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url), rank_mpi = -1)
  end if
999 continue
  call StoreError(stat, subname, err, cause_c)
end subroutine HistoryGetReal6
subroutine HistoryGetReal7(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar, Split, JoinChar, StoA
  use dc_url, only: GT_ATMARK, GT_COMMA, GT_EQUAL, UrlSplit, UrlMerge
  use dc_present, only: present_select, present_and_not_empty, present_and_true
  use dc_regex, only: match
  use dc_types, only: STRING, DP, SP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  use dc_error, only: StoreError, DC_NOERR, GT_ENOTURL, GT_ERANKMISMATCH, &
    & GT_EARGSIZEMISMATCH
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical,  intent(in),  optional:: quiet
  logical,  intent(in),  optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical,  intent(out), optional:: flag_time_exist
  logical,  intent(out), optional:: err
  real(SP), intent(out) :: array(:,:,:,:,:,:,:)
  real(SP), allocatable  :: array_tmp(:)
  integer:: array_allsize
  integer:: array_shape(7), data_shape(7), array_shape_check(7)
  integer:: allcount
  integer:: i, sd
  logical:: inq_err
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  integer:: rank, alldims, array_rank
  integer:: domain
  character(STRING):: tname
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter :: subname = "HistoryGetReal7"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  cause_c = ''
  stat = DC_NOERR
  file_work = file
  array_shape = shape( array )
  array_allsize = size( array )
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 最新時刻の URL 取得
  ! Get URL of latest time
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  ! ファイルオープン
  ! File open
  call Open( var, url, err = err )
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  !-------------------------------------------------------------------
  !  配列形状のチェック
  !  Check array shape
  !-------------------------------------------------------------------
  ! 入力ファイル中のデータの次元数
  ! Get size of dimesions in data of an input file
  !
  call Inquire( var = var, &           ! (in)
    & rank = rank, alldims = alldims ) ! (out)
  ! 引数の次元数のチェック (縮退されている場合には減らす)
  ! Check size of dimensions of an argument (If any dimension degenerated, size of dimensions is decreased)
  array_rank = 7
  if ( size( array, 1 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 2 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 3 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 4 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 5 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 6 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 7 ) == 1 ) array_rank = array_rank - 1
  ! 次元数の比較
  ! Compare sizes of dimensions
  !
  if ( .not. 7 == rank .and. .not. array_rank == rank ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Rank of data (%c) is "%d", rank of argument is "%d"', &
        & i = (/rank, 7/), c1 = trim(url) )
    end if
    stat = GT_ERANKMISMATCH
    cause_c = 'array'
    goto 999
  end if
  ! 入力ファイル中のデータの配列形状取得
  ! Get shape of data in an input file
  call Inquire( var = var , dimord = 1, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(1) = allcount
  else
    data_shape(1) = 1
  end if
  call Inquire( var = var , dimord = 2, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(2) = allcount
  else
    data_shape(2) = 1
  end if
  call Inquire( var = var , dimord = 3, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(3) = allcount
  else
    data_shape(3) = 1
  end if
  call Inquire( var = var , dimord = 4, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(4) = allcount
  else
    data_shape(4) = 1
  end if
  call Inquire( var = var , dimord = 5, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(5) = allcount
  else
    data_shape(5) = 1
  end if
  call Inquire( var = var , dimord = 6, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(6) = allcount
  else
    data_shape(6) = 1
  end if
  call Inquire( var = var , dimord = 7, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(7) = allcount
  else
    data_shape(7) = 1
  end if
  ! 引数の配列形状整形
  ! Arrange shape of an argument
  !
  array_shape_check = array_shape
  sd = 1
  do i = 1, 7 - 1
    if ( array_shape_check(sd) == 1 ) then
      array_shape_check(sd:7) = cshift( array_shape_check(sd:7), 1, 1 )
    else
      sd = sd + 1
    end if
  end do
  ! 配列形状の比較
  ! Compare shapes
  !
  if ( .not. all( array_shape_check == data_shape ) ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Shape of data (%c) is (%c), shape of argument is (%c)', &
        & c1 = trim( url ), &
        & c2 = trim( toChar( data_shape(1:rank) ) ), &
        & c3 = trim( toChar( array_shape_check(1:rank) ) ) )
    end if
    stat = GT_EARGSIZEMISMATCH
    cause_c = 'array'
    goto 999
  end if
  !-------------------------------------
  !  データ取得
  !  Get data
  call Inquire( var = var, & ! (in)
    & size = domain )        ! (out)
  if ( allocated( array_tmp ) ) deallocate( array_tmp )
  allocate( array_tmp(array_allsize) )
  call Get( var, array_tmp, domain )
  array = reshape( array_tmp, array_shape )
  deallocate( array_tmp )
  call Close( var )
  !-------------------------------------
  !  データファイル名と切り出し範囲の印字
  !  Print data filename and clipping range
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url), rank_mpi = -1)
  end if
999 continue
  call StoreError(stat, subname, err, cause_c)
end subroutine HistoryGetReal7
subroutine HistoryGetInt0(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar, Split, JoinChar, StoA
  use dc_url, only: GT_ATMARK, GT_COMMA, GT_EQUAL, UrlSplit, UrlMerge
  use dc_present, only: present_select, present_and_not_empty, present_and_true
  use dc_regex, only: match
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  use dc_error, only: StoreError, DC_NOERR, GT_ENOTURL, GT_ERANKMISMATCH, &
    & GT_EARGSIZEMISMATCH
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical,  intent(in),  optional:: quiet
  logical,  intent(in),  optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical,  intent(out), optional:: flag_time_exist
  logical,  intent(out), optional:: err
  integer, intent(out) :: array
  integer :: array_tmp(1)
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  integer:: rank, alldims, array_rank
  integer:: domain
  character(STRING):: tname
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter :: subname = "HistoryGetInt0"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  cause_c = ''
  stat = DC_NOERR
  file_work = file
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 最新時刻の URL 取得
  ! Get URL of latest time
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  ! ファイルオープン
  ! File open
  call Open( var, url, err = err )
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  !-------------------------------------------------------------------
  !  配列形状のチェック
  !  Check array shape
  !-------------------------------------------------------------------
  ! 入力ファイル中のデータの次元数
  ! Get size of dimesions in data of an input file
  !
  call Inquire( var = var, &           ! (in)
    & rank = rank, alldims = alldims ) ! (out)
  ! 引数の次元数のチェック (縮退されている場合には減らす)
  ! Check size of dimensions of an argument (If any dimension degenerated, size of dimensions is decreased)
  array_rank = 0
  ! 次元数の比較
  ! Compare sizes of dimensions
  !
  if ( .not. 0 == rank .and. .not. array_rank == rank ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Rank of data (%c) is "%d", rank of argument is "%d"', &
        & i = (/rank, 0/), c1 = trim(url) )
    end if
    stat = GT_ERANKMISMATCH
    cause_c = 'array'
    goto 999
  end if
  ! 入力ファイル中のデータの配列形状取得
  ! Get shape of data in an input file
  !-------------------------------------
  !  データ取得
  !  Get data
  call Inquire( var = var, & ! (in)
    & size = domain )        ! (out)
  call Get( var = var, & ! (inout)
    & nvalue = domain, & ! (in)
    & value = array_tmp) ! (out)
  array = array_tmp(1)
  call Close( var )
  !-------------------------------------
  !  データファイル名と切り出し範囲の印字
  !  Print data filename and clipping range
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url), rank_mpi = -1)
  end if
999 continue
  call StoreError(stat, subname, err, cause_c)
end subroutine HistoryGetInt0
subroutine HistoryGetInt1(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar, Split, JoinChar, StoA
  use dc_url, only: GT_ATMARK, GT_COMMA, GT_EQUAL, UrlSplit, UrlMerge
  use dc_present, only: present_select, present_and_not_empty, present_and_true
  use dc_regex, only: match
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  use dc_error, only: StoreError, DC_NOERR, GT_ENOTURL, GT_ERANKMISMATCH, &
    & GT_EARGSIZEMISMATCH
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical,  intent(in),  optional:: quiet
  logical,  intent(in),  optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical,  intent(out), optional:: flag_time_exist
  logical,  intent(out), optional:: err
  integer, intent(out) :: array(:)
  integer, allocatable  :: array_tmp(:)
  integer:: array_allsize
  integer:: array_shape(1), data_shape(1), array_shape_check(1)
  integer:: allcount
  integer:: i, sd
  logical:: inq_err
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  integer:: rank, alldims, array_rank
  integer:: domain
  character(STRING):: tname
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter :: subname = "HistoryGetInt1"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  cause_c = ''
  stat = DC_NOERR
  file_work = file
  array_shape = shape( array )
  array_allsize = size( array )
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 最新時刻の URL 取得
  ! Get URL of latest time
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  ! ファイルオープン
  ! File open
  call Open( var, url, err = err )
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  !-------------------------------------------------------------------
  !  配列形状のチェック
  !  Check array shape
  !-------------------------------------------------------------------
  ! 入力ファイル中のデータの次元数
  ! Get size of dimesions in data of an input file
  !
  call Inquire( var = var, &           ! (in)
    & rank = rank, alldims = alldims ) ! (out)
  ! 引数の次元数のチェック (縮退されている場合には減らす)
  ! Check size of dimensions of an argument (If any dimension degenerated, size of dimensions is decreased)
  array_rank = 1
  if ( size( array, 1 ) == 1 ) array_rank = array_rank - 1
  ! 次元数の比較
  ! Compare sizes of dimensions
  !
  if ( .not. 1 == rank .and. .not. array_rank == rank ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Rank of data (%c) is "%d", rank of argument is "%d"', &
        & i = (/rank, 1/), c1 = trim(url) )
    end if
    stat = GT_ERANKMISMATCH
    cause_c = 'array'
    goto 999
  end if
  ! 入力ファイル中のデータの配列形状取得
  ! Get shape of data in an input file
  call Inquire( var = var , dimord = 1, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(1) = allcount
  else
    data_shape(1) = 1
  end if
  ! 引数の配列形状整形
  ! Arrange shape of an argument
  !
  array_shape_check = array_shape
  sd = 1
  do i = 1, 1 - 1
    if ( array_shape_check(sd) == 1 ) then
      array_shape_check(sd:1) = cshift( array_shape_check(sd:1), 1, 1 )
    else
      sd = sd + 1
    end if
  end do
  ! 配列形状の比較
  ! Compare shapes
  !
  if ( .not. all( array_shape_check == data_shape ) ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Shape of data (%c) is (%c), shape of argument is (%c)', &
        & c1 = trim( url ), &
        & c2 = trim( toChar( data_shape(1:rank) ) ), &
        & c3 = trim( toChar( array_shape_check(1:rank) ) ) )
    end if
    stat = GT_EARGSIZEMISMATCH
    cause_c = 'array'
    goto 999
  end if
  !-------------------------------------
  !  データ取得
  !  Get data
  call Inquire( var = var, & ! (in)
    & size = domain )        ! (out)
  if ( allocated( array_tmp ) ) deallocate( array_tmp )
  allocate( array_tmp(array_allsize) )
  call Get( var, array_tmp, domain )
  array = reshape( array_tmp, array_shape )
  deallocate( array_tmp )
  call Close( var )
  !-------------------------------------
  !  データファイル名と切り出し範囲の印字
  !  Print data filename and clipping range
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url), rank_mpi = -1)
  end if
999 continue
  call StoreError(stat, subname, err, cause_c)
end subroutine HistoryGetInt1
subroutine HistoryGetInt2(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar, Split, JoinChar, StoA
  use dc_url, only: GT_ATMARK, GT_COMMA, GT_EQUAL, UrlSplit, UrlMerge
  use dc_present, only: present_select, present_and_not_empty, present_and_true
  use dc_regex, only: match
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  use dc_error, only: StoreError, DC_NOERR, GT_ENOTURL, GT_ERANKMISMATCH, &
    & GT_EARGSIZEMISMATCH
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical,  intent(in),  optional:: quiet
  logical,  intent(in),  optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical,  intent(out), optional:: flag_time_exist
  logical,  intent(out), optional:: err
  integer, intent(out) :: array(:,:)
  integer, allocatable  :: array_tmp(:)
  integer:: array_allsize
  integer:: array_shape(2), data_shape(2), array_shape_check(2)
  integer:: allcount
  integer:: i, sd
  logical:: inq_err
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  integer:: rank, alldims, array_rank
  integer:: domain
  character(STRING):: tname
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter :: subname = "HistoryGetInt2"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  cause_c = ''
  stat = DC_NOERR
  file_work = file
  array_shape = shape( array )
  array_allsize = size( array )
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 最新時刻の URL 取得
  ! Get URL of latest time
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  ! ファイルオープン
  ! File open
  call Open( var, url, err = err )
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  !-------------------------------------------------------------------
  !  配列形状のチェック
  !  Check array shape
  !-------------------------------------------------------------------
  ! 入力ファイル中のデータの次元数
  ! Get size of dimesions in data of an input file
  !
  call Inquire( var = var, &           ! (in)
    & rank = rank, alldims = alldims ) ! (out)
  ! 引数の次元数のチェック (縮退されている場合には減らす)
  ! Check size of dimensions of an argument (If any dimension degenerated, size of dimensions is decreased)
  array_rank = 2
  if ( size( array, 1 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 2 ) == 1 ) array_rank = array_rank - 1
  ! 次元数の比較
  ! Compare sizes of dimensions
  !
  if ( .not. 2 == rank .and. .not. array_rank == rank ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Rank of data (%c) is "%d", rank of argument is "%d"', &
        & i = (/rank, 2/), c1 = trim(url) )
    end if
    stat = GT_ERANKMISMATCH
    cause_c = 'array'
    goto 999
  end if
  ! 入力ファイル中のデータの配列形状取得
  ! Get shape of data in an input file
  call Inquire( var = var , dimord = 1, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(1) = allcount
  else
    data_shape(1) = 1
  end if
  call Inquire( var = var , dimord = 2, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(2) = allcount
  else
    data_shape(2) = 1
  end if
  ! 引数の配列形状整形
  ! Arrange shape of an argument
  !
  array_shape_check = array_shape
  sd = 1
  do i = 1, 2 - 1
    if ( array_shape_check(sd) == 1 ) then
      array_shape_check(sd:2) = cshift( array_shape_check(sd:2), 1, 1 )
    else
      sd = sd + 1
    end if
  end do
  ! 配列形状の比較
  ! Compare shapes
  !
  if ( .not. all( array_shape_check == data_shape ) ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Shape of data (%c) is (%c), shape of argument is (%c)', &
        & c1 = trim( url ), &
        & c2 = trim( toChar( data_shape(1:rank) ) ), &
        & c3 = trim( toChar( array_shape_check(1:rank) ) ) )
    end if
    stat = GT_EARGSIZEMISMATCH
    cause_c = 'array'
    goto 999
  end if
  !-------------------------------------
  !  データ取得
  !  Get data
  call Inquire( var = var, & ! (in)
    & size = domain )        ! (out)
  if ( allocated( array_tmp ) ) deallocate( array_tmp )
  allocate( array_tmp(array_allsize) )
  call Get( var, array_tmp, domain )
  array = reshape( array_tmp, array_shape )
  deallocate( array_tmp )
  call Close( var )
  !-------------------------------------
  !  データファイル名と切り出し範囲の印字
  !  Print data filename and clipping range
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url), rank_mpi = -1)
  end if
999 continue
  call StoreError(stat, subname, err, cause_c)
end subroutine HistoryGetInt2
subroutine HistoryGetInt3(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar, Split, JoinChar, StoA
  use dc_url, only: GT_ATMARK, GT_COMMA, GT_EQUAL, UrlSplit, UrlMerge
  use dc_present, only: present_select, present_and_not_empty, present_and_true
  use dc_regex, only: match
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  use dc_error, only: StoreError, DC_NOERR, GT_ENOTURL, GT_ERANKMISMATCH, &
    & GT_EARGSIZEMISMATCH
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical,  intent(in),  optional:: quiet
  logical,  intent(in),  optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical,  intent(out), optional:: flag_time_exist
  logical,  intent(out), optional:: err
  integer, intent(out) :: array(:,:,:)
  integer, allocatable  :: array_tmp(:)
  integer:: array_allsize
  integer:: array_shape(3), data_shape(3), array_shape_check(3)
  integer:: allcount
  integer:: i, sd
  logical:: inq_err
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  integer:: rank, alldims, array_rank
  integer:: domain
  character(STRING):: tname
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter :: subname = "HistoryGetInt3"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  cause_c = ''
  stat = DC_NOERR
  file_work = file
  array_shape = shape( array )
  array_allsize = size( array )
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 最新時刻の URL 取得
  ! Get URL of latest time
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  ! ファイルオープン
  ! File open
  call Open( var, url, err = err )
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  !-------------------------------------------------------------------
  !  配列形状のチェック
  !  Check array shape
  !-------------------------------------------------------------------
  ! 入力ファイル中のデータの次元数
  ! Get size of dimesions in data of an input file
  !
  call Inquire( var = var, &           ! (in)
    & rank = rank, alldims = alldims ) ! (out)
  ! 引数の次元数のチェック (縮退されている場合には減らす)
  ! Check size of dimensions of an argument (If any dimension degenerated, size of dimensions is decreased)
  array_rank = 3
  if ( size( array, 1 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 2 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 3 ) == 1 ) array_rank = array_rank - 1
  ! 次元数の比較
  ! Compare sizes of dimensions
  !
  if ( .not. 3 == rank .and. .not. array_rank == rank ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Rank of data (%c) is "%d", rank of argument is "%d"', &
        & i = (/rank, 3/), c1 = trim(url) )
    end if
    stat = GT_ERANKMISMATCH
    cause_c = 'array'
    goto 999
  end if
  ! 入力ファイル中のデータの配列形状取得
  ! Get shape of data in an input file
  call Inquire( var = var , dimord = 1, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(1) = allcount
  else
    data_shape(1) = 1
  end if
  call Inquire( var = var , dimord = 2, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(2) = allcount
  else
    data_shape(2) = 1
  end if
  call Inquire( var = var , dimord = 3, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(3) = allcount
  else
    data_shape(3) = 1
  end if
  ! 引数の配列形状整形
  ! Arrange shape of an argument
  !
  array_shape_check = array_shape
  sd = 1
  do i = 1, 3 - 1
    if ( array_shape_check(sd) == 1 ) then
      array_shape_check(sd:3) = cshift( array_shape_check(sd:3), 1, 1 )
    else
      sd = sd + 1
    end if
  end do
  ! 配列形状の比較
  ! Compare shapes
  !
  if ( .not. all( array_shape_check == data_shape ) ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Shape of data (%c) is (%c), shape of argument is (%c)', &
        & c1 = trim( url ), &
        & c2 = trim( toChar( data_shape(1:rank) ) ), &
        & c3 = trim( toChar( array_shape_check(1:rank) ) ) )
    end if
    stat = GT_EARGSIZEMISMATCH
    cause_c = 'array'
    goto 999
  end if
  !-------------------------------------
  !  データ取得
  !  Get data
  call Inquire( var = var, & ! (in)
    & size = domain )        ! (out)
  if ( allocated( array_tmp ) ) deallocate( array_tmp )
  allocate( array_tmp(array_allsize) )
  call Get( var, array_tmp, domain )
  array = reshape( array_tmp, array_shape )
  deallocate( array_tmp )
  call Close( var )
  !-------------------------------------
  !  データファイル名と切り出し範囲の印字
  !  Print data filename and clipping range
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url), rank_mpi = -1)
  end if
999 continue
  call StoreError(stat, subname, err, cause_c)
end subroutine HistoryGetInt3
subroutine HistoryGetInt4(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar, Split, JoinChar, StoA
  use dc_url, only: GT_ATMARK, GT_COMMA, GT_EQUAL, UrlSplit, UrlMerge
  use dc_present, only: present_select, present_and_not_empty, present_and_true
  use dc_regex, only: match
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  use dc_error, only: StoreError, DC_NOERR, GT_ENOTURL, GT_ERANKMISMATCH, &
    & GT_EARGSIZEMISMATCH
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical,  intent(in),  optional:: quiet
  logical,  intent(in),  optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical,  intent(out), optional:: flag_time_exist
  logical,  intent(out), optional:: err
  integer, intent(out) :: array(:,:,:,:)
  integer, allocatable  :: array_tmp(:)
  integer:: array_allsize
  integer:: array_shape(4), data_shape(4), array_shape_check(4)
  integer:: allcount
  integer:: i, sd
  logical:: inq_err
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  integer:: rank, alldims, array_rank
  integer:: domain
  character(STRING):: tname
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter :: subname = "HistoryGetInt4"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  cause_c = ''
  stat = DC_NOERR
  file_work = file
  array_shape = shape( array )
  array_allsize = size( array )
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 最新時刻の URL 取得
  ! Get URL of latest time
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  ! ファイルオープン
  ! File open
  call Open( var, url, err = err )
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  !-------------------------------------------------------------------
  !  配列形状のチェック
  !  Check array shape
  !-------------------------------------------------------------------
  ! 入力ファイル中のデータの次元数
  ! Get size of dimesions in data of an input file
  !
  call Inquire( var = var, &           ! (in)
    & rank = rank, alldims = alldims ) ! (out)
  ! 引数の次元数のチェック (縮退されている場合には減らす)
  ! Check size of dimensions of an argument (If any dimension degenerated, size of dimensions is decreased)
  array_rank = 4
  if ( size( array, 1 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 2 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 3 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 4 ) == 1 ) array_rank = array_rank - 1
  ! 次元数の比較
  ! Compare sizes of dimensions
  !
  if ( .not. 4 == rank .and. .not. array_rank == rank ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Rank of data (%c) is "%d", rank of argument is "%d"', &
        & i = (/rank, 4/), c1 = trim(url) )
    end if
    stat = GT_ERANKMISMATCH
    cause_c = 'array'
    goto 999
  end if
  ! 入力ファイル中のデータの配列形状取得
  ! Get shape of data in an input file
  call Inquire( var = var , dimord = 1, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(1) = allcount
  else
    data_shape(1) = 1
  end if
  call Inquire( var = var , dimord = 2, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(2) = allcount
  else
    data_shape(2) = 1
  end if
  call Inquire( var = var , dimord = 3, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(3) = allcount
  else
    data_shape(3) = 1
  end if
  call Inquire( var = var , dimord = 4, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(4) = allcount
  else
    data_shape(4) = 1
  end if
  ! 引数の配列形状整形
  ! Arrange shape of an argument
  !
  array_shape_check = array_shape
  sd = 1
  do i = 1, 4 - 1
    if ( array_shape_check(sd) == 1 ) then
      array_shape_check(sd:4) = cshift( array_shape_check(sd:4), 1, 1 )
    else
      sd = sd + 1
    end if
  end do
  ! 配列形状の比較
  ! Compare shapes
  !
  if ( .not. all( array_shape_check == data_shape ) ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Shape of data (%c) is (%c), shape of argument is (%c)', &
        & c1 = trim( url ), &
        & c2 = trim( toChar( data_shape(1:rank) ) ), &
        & c3 = trim( toChar( array_shape_check(1:rank) ) ) )
    end if
    stat = GT_EARGSIZEMISMATCH
    cause_c = 'array'
    goto 999
  end if
  !-------------------------------------
  !  データ取得
  !  Get data
  call Inquire( var = var, & ! (in)
    & size = domain )        ! (out)
  if ( allocated( array_tmp ) ) deallocate( array_tmp )
  allocate( array_tmp(array_allsize) )
  call Get( var, array_tmp, domain )
  array = reshape( array_tmp, array_shape )
  deallocate( array_tmp )
  call Close( var )
  !-------------------------------------
  !  データファイル名と切り出し範囲の印字
  !  Print data filename and clipping range
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url), rank_mpi = -1)
  end if
999 continue
  call StoreError(stat, subname, err, cause_c)
end subroutine HistoryGetInt4
subroutine HistoryGetInt5(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar, Split, JoinChar, StoA
  use dc_url, only: GT_ATMARK, GT_COMMA, GT_EQUAL, UrlSplit, UrlMerge
  use dc_present, only: present_select, present_and_not_empty, present_and_true
  use dc_regex, only: match
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  use dc_error, only: StoreError, DC_NOERR, GT_ENOTURL, GT_ERANKMISMATCH, &
    & GT_EARGSIZEMISMATCH
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical,  intent(in),  optional:: quiet
  logical,  intent(in),  optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical,  intent(out), optional:: flag_time_exist
  logical,  intent(out), optional:: err
  integer, intent(out) :: array(:,:,:,:,:)
  integer, allocatable  :: array_tmp(:)
  integer:: array_allsize
  integer:: array_shape(5), data_shape(5), array_shape_check(5)
  integer:: allcount
  integer:: i, sd
  logical:: inq_err
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  integer:: rank, alldims, array_rank
  integer:: domain
  character(STRING):: tname
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter :: subname = "HistoryGetInt5"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  cause_c = ''
  stat = DC_NOERR
  file_work = file
  array_shape = shape( array )
  array_allsize = size( array )
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 最新時刻の URL 取得
  ! Get URL of latest time
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  ! ファイルオープン
  ! File open
  call Open( var, url, err = err )
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  !-------------------------------------------------------------------
  !  配列形状のチェック
  !  Check array shape
  !-------------------------------------------------------------------
  ! 入力ファイル中のデータの次元数
  ! Get size of dimesions in data of an input file
  !
  call Inquire( var = var, &           ! (in)
    & rank = rank, alldims = alldims ) ! (out)
  ! 引数の次元数のチェック (縮退されている場合には減らす)
  ! Check size of dimensions of an argument (If any dimension degenerated, size of dimensions is decreased)
  array_rank = 5
  if ( size( array, 1 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 2 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 3 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 4 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 5 ) == 1 ) array_rank = array_rank - 1
  ! 次元数の比較
  ! Compare sizes of dimensions
  !
  if ( .not. 5 == rank .and. .not. array_rank == rank ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Rank of data (%c) is "%d", rank of argument is "%d"', &
        & i = (/rank, 5/), c1 = trim(url) )
    end if
    stat = GT_ERANKMISMATCH
    cause_c = 'array'
    goto 999
  end if
  ! 入力ファイル中のデータの配列形状取得
  ! Get shape of data in an input file
  call Inquire( var = var , dimord = 1, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(1) = allcount
  else
    data_shape(1) = 1
  end if
  call Inquire( var = var , dimord = 2, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(2) = allcount
  else
    data_shape(2) = 1
  end if
  call Inquire( var = var , dimord = 3, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(3) = allcount
  else
    data_shape(3) = 1
  end if
  call Inquire( var = var , dimord = 4, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(4) = allcount
  else
    data_shape(4) = 1
  end if
  call Inquire( var = var , dimord = 5, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(5) = allcount
  else
    data_shape(5) = 1
  end if
  ! 引数の配列形状整形
  ! Arrange shape of an argument
  !
  array_shape_check = array_shape
  sd = 1
  do i = 1, 5 - 1
    if ( array_shape_check(sd) == 1 ) then
      array_shape_check(sd:5) = cshift( array_shape_check(sd:5), 1, 1 )
    else
      sd = sd + 1
    end if
  end do
  ! 配列形状の比較
  ! Compare shapes
  !
  if ( .not. all( array_shape_check == data_shape ) ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Shape of data (%c) is (%c), shape of argument is (%c)', &
        & c1 = trim( url ), &
        & c2 = trim( toChar( data_shape(1:rank) ) ), &
        & c3 = trim( toChar( array_shape_check(1:rank) ) ) )
    end if
    stat = GT_EARGSIZEMISMATCH
    cause_c = 'array'
    goto 999
  end if
  !-------------------------------------
  !  データ取得
  !  Get data
  call Inquire( var = var, & ! (in)
    & size = domain )        ! (out)
  if ( allocated( array_tmp ) ) deallocate( array_tmp )
  allocate( array_tmp(array_allsize) )
  call Get( var, array_tmp, domain )
  array = reshape( array_tmp, array_shape )
  deallocate( array_tmp )
  call Close( var )
  !-------------------------------------
  !  データファイル名と切り出し範囲の印字
  !  Print data filename and clipping range
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url), rank_mpi = -1)
  end if
999 continue
  call StoreError(stat, subname, err, cause_c)
end subroutine HistoryGetInt5
subroutine HistoryGetInt6(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar, Split, JoinChar, StoA
  use dc_url, only: GT_ATMARK, GT_COMMA, GT_EQUAL, UrlSplit, UrlMerge
  use dc_present, only: present_select, present_and_not_empty, present_and_true
  use dc_regex, only: match
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  use dc_error, only: StoreError, DC_NOERR, GT_ENOTURL, GT_ERANKMISMATCH, &
    & GT_EARGSIZEMISMATCH
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical,  intent(in),  optional:: quiet
  logical,  intent(in),  optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical,  intent(out), optional:: flag_time_exist
  logical,  intent(out), optional:: err
  integer, intent(out) :: array(:,:,:,:,:,:)
  integer, allocatable  :: array_tmp(:)
  integer:: array_allsize
  integer:: array_shape(6), data_shape(6), array_shape_check(6)
  integer:: allcount
  integer:: i, sd
  logical:: inq_err
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  integer:: rank, alldims, array_rank
  integer:: domain
  character(STRING):: tname
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter :: subname = "HistoryGetInt6"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  cause_c = ''
  stat = DC_NOERR
  file_work = file
  array_shape = shape( array )
  array_allsize = size( array )
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 最新時刻の URL 取得
  ! Get URL of latest time
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  ! ファイルオープン
  ! File open
  call Open( var, url, err = err )
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  !-------------------------------------------------------------------
  !  配列形状のチェック
  !  Check array shape
  !-------------------------------------------------------------------
  ! 入力ファイル中のデータの次元数
  ! Get size of dimesions in data of an input file
  !
  call Inquire( var = var, &           ! (in)
    & rank = rank, alldims = alldims ) ! (out)
  ! 引数の次元数のチェック (縮退されている場合には減らす)
  ! Check size of dimensions of an argument (If any dimension degenerated, size of dimensions is decreased)
  array_rank = 6
  if ( size( array, 1 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 2 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 3 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 4 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 5 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 6 ) == 1 ) array_rank = array_rank - 1
  ! 次元数の比較
  ! Compare sizes of dimensions
  !
  if ( .not. 6 == rank .and. .not. array_rank == rank ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Rank of data (%c) is "%d", rank of argument is "%d"', &
        & i = (/rank, 6/), c1 = trim(url) )
    end if
    stat = GT_ERANKMISMATCH
    cause_c = 'array'
    goto 999
  end if
  ! 入力ファイル中のデータの配列形状取得
  ! Get shape of data in an input file
  call Inquire( var = var , dimord = 1, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(1) = allcount
  else
    data_shape(1) = 1
  end if
  call Inquire( var = var , dimord = 2, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(2) = allcount
  else
    data_shape(2) = 1
  end if
  call Inquire( var = var , dimord = 3, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(3) = allcount
  else
    data_shape(3) = 1
  end if
  call Inquire( var = var , dimord = 4, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(4) = allcount
  else
    data_shape(4) = 1
  end if
  call Inquire( var = var , dimord = 5, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(5) = allcount
  else
    data_shape(5) = 1
  end if
  call Inquire( var = var , dimord = 6, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(6) = allcount
  else
    data_shape(6) = 1
  end if
  ! 引数の配列形状整形
  ! Arrange shape of an argument
  !
  array_shape_check = array_shape
  sd = 1
  do i = 1, 6 - 1
    if ( array_shape_check(sd) == 1 ) then
      array_shape_check(sd:6) = cshift( array_shape_check(sd:6), 1, 1 )
    else
      sd = sd + 1
    end if
  end do
  ! 配列形状の比較
  ! Compare shapes
  !
  if ( .not. all( array_shape_check == data_shape ) ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Shape of data (%c) is (%c), shape of argument is (%c)', &
        & c1 = trim( url ), &
        & c2 = trim( toChar( data_shape(1:rank) ) ), &
        & c3 = trim( toChar( array_shape_check(1:rank) ) ) )
    end if
    stat = GT_EARGSIZEMISMATCH
    cause_c = 'array'
    goto 999
  end if
  !-------------------------------------
  !  データ取得
  !  Get data
  call Inquire( var = var, & ! (in)
    & size = domain )        ! (out)
  if ( allocated( array_tmp ) ) deallocate( array_tmp )
  allocate( array_tmp(array_allsize) )
  call Get( var, array_tmp, domain )
  array = reshape( array_tmp, array_shape )
  deallocate( array_tmp )
  call Close( var )
  !-------------------------------------
  !  データファイル名と切り出し範囲の印字
  !  Print data filename and clipping range
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url), rank_mpi = -1)
  end if
999 continue
  call StoreError(stat, subname, err, cause_c)
end subroutine HistoryGetInt6
subroutine HistoryGetInt7(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar, Split, JoinChar, StoA
  use dc_url, only: GT_ATMARK, GT_COMMA, GT_EQUAL, UrlSplit, UrlMerge
  use dc_present, only: present_select, present_and_not_empty, present_and_true
  use dc_regex, only: match
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  use dc_error, only: StoreError, DC_NOERR, GT_ENOTURL, GT_ERANKMISMATCH, &
    & GT_EARGSIZEMISMATCH
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical,  intent(in),  optional:: quiet
  logical,  intent(in),  optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical,  intent(out), optional:: flag_time_exist
  logical,  intent(out), optional:: err
  integer, intent(out) :: array(:,:,:,:,:,:,:)
  integer, allocatable  :: array_tmp(:)
  integer:: array_allsize
  integer:: array_shape(7), data_shape(7), array_shape_check(7)
  integer:: allcount
  integer:: i, sd
  logical:: inq_err
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  integer:: rank, alldims, array_rank
  integer:: domain
  character(STRING):: tname
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter :: subname = "HistoryGetInt7"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  cause_c = ''
  stat = DC_NOERR
  file_work = file
  array_shape = shape( array )
  array_allsize = size( array )
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 最新時刻の URL 取得
  ! Get URL of latest time
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  ! ファイルオープン
  ! File open
  call Open( var, url, err = err )
  if ( present_and_true(err) ) then
    stat = GT_ENOTURL
    cause_c = url
    goto 999
  end if
  !-------------------------------------------------------------------
  !  配列形状のチェック
  !  Check array shape
  !-------------------------------------------------------------------
  ! 入力ファイル中のデータの次元数
  ! Get size of dimesions in data of an input file
  !
  call Inquire( var = var, &           ! (in)
    & rank = rank, alldims = alldims ) ! (out)
  ! 引数の次元数のチェック (縮退されている場合には減らす)
  ! Check size of dimensions of an argument (If any dimension degenerated, size of dimensions is decreased)
  array_rank = 7
  if ( size( array, 1 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 2 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 3 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 4 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 5 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 6 ) == 1 ) array_rank = array_rank - 1
  if ( size( array, 7 ) == 1 ) array_rank = array_rank - 1
  ! 次元数の比較
  ! Compare sizes of dimensions
  !
  if ( .not. 7 == rank .and. .not. array_rank == rank ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Rank of data (%c) is "%d", rank of argument is "%d"', &
        & i = (/rank, 7/), c1 = trim(url) )
    end if
    stat = GT_ERANKMISMATCH
    cause_c = 'array'
    goto 999
  end if
  ! 入力ファイル中のデータの配列形状取得
  ! Get shape of data in an input file
  call Inquire( var = var , dimord = 1, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(1) = allcount
  else
    data_shape(1) = 1
  end if
  call Inquire( var = var , dimord = 2, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(2) = allcount
  else
    data_shape(2) = 1
  end if
  call Inquire( var = var , dimord = 3, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(3) = allcount
  else
    data_shape(3) = 1
  end if
  call Inquire( var = var , dimord = 4, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(4) = allcount
  else
    data_shape(4) = 1
  end if
  call Inquire( var = var , dimord = 5, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(5) = allcount
  else
    data_shape(5) = 1
  end if
  call Inquire( var = var , dimord = 6, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(6) = allcount
  else
    data_shape(6) = 1
  end if
  call Inquire( var = var , dimord = 7, &   ! (in)
    & allcount = allcount, err = inq_err )       ! (out)
  if ( .not. inq_err ) then
    data_shape(7) = allcount
  else
    data_shape(7) = 1
  end if
  ! 引数の配列形状整形
  ! Arrange shape of an argument
  !
  array_shape_check = array_shape
  sd = 1
  do i = 1, 7 - 1
    if ( array_shape_check(sd) == 1 ) then
      array_shape_check(sd:7) = cshift( array_shape_check(sd:7), 1, 1 )
    else
      sd = sd + 1
    end if
  end do
  ! 配列形状の比較
  ! Compare shapes
  !
  if ( .not. all( array_shape_check == data_shape ) ) then
    if ( .not. present_and_true(quiet) ) then
      call MessageNotify('W', subname, &
        & 'Shape of data (%c) is (%c), shape of argument is (%c)', &
        & c1 = trim( url ), &
        & c2 = trim( toChar( data_shape(1:rank) ) ), &
        & c3 = trim( toChar( array_shape_check(1:rank) ) ) )
    end if
    stat = GT_EARGSIZEMISMATCH
    cause_c = 'array'
    goto 999
  end if
  !-------------------------------------
  !  データ取得
  !  Get data
  call Inquire( var = var, & ! (in)
    & size = domain )        ! (out)
  if ( allocated( array_tmp ) ) deallocate( array_tmp )
  allocate( array_tmp(array_allsize) )
  call Get( var, array_tmp, domain )
  array = reshape( array_tmp, array_shape )
  deallocate( array_tmp )
  call Close( var )
  !-------------------------------------
  !  データファイル名と切り出し範囲の印字
  !  Print data filename and clipping range
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url), rank_mpi = -1)
  end if
999 continue
  call StoreError(stat, subname, err, cause_c)
end subroutine HistoryGetInt7
subroutine HistoryGetDouble0Pointer(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar
  use dc_present,only: present_select, present_and_true
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical, intent(in), optional:: quiet
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  integer:: domain
  real(DP), pointer :: array ! (out)
  real(DP), target :: array_tmp(1)
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble0Pointer"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 必要な情報を gtool 変数化
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  allocate(array)
  call DbgMessage('@ url =%c', c1=trim(url))
  ! いよいよデータ取得
  !
  call Open(var, url, err)
  call Inquire(var=var, size=domain)
  call Get(var, array_tmp, domain, err)
  array = array_tmp(1)
  call Close(var, err)
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url))
  end if
end subroutine HistoryGetDouble0Pointer
subroutine HistoryGetDouble1Pointer(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar
  use dc_present,only: present_select, present_and_true
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical, intent(in), optional:: quiet
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  integer:: domain
  real(DP), pointer :: array(:) ! (out)
  real(DP), target :: array_tmp(1)
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble1Pointer"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 必要な情報を gtool 変数化
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call DbgMessage('@ url =%c', c1=trim(url))
  ! いよいよデータ取得
  !
  call Open(var, url, err)
  call Get(var, array, err)
  call Close(var, err)
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url))
  end if
end subroutine HistoryGetDouble1Pointer
subroutine HistoryGetDouble2Pointer(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar
  use dc_present,only: present_select, present_and_true
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical, intent(in), optional:: quiet
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  integer:: domain
  real(DP), pointer :: array(:,:) ! (out)
  real(DP), target :: array_tmp(1)
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble2Pointer"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 必要な情報を gtool 変数化
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call DbgMessage('@ url =%c', c1=trim(url))
  ! いよいよデータ取得
  !
  call Open(var, url, err)
  call Get(var, array, err)
  call Close(var, err)
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url))
  end if
end subroutine HistoryGetDouble2Pointer
subroutine HistoryGetDouble3Pointer(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar
  use dc_present,only: present_select, present_and_true
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical, intent(in), optional:: quiet
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  integer:: domain
  real(DP), pointer :: array(:,:,:) ! (out)
  real(DP), target :: array_tmp(1)
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble3Pointer"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 必要な情報を gtool 変数化
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call DbgMessage('@ url =%c', c1=trim(url))
  ! いよいよデータ取得
  !
  call Open(var, url, err)
  call Get(var, array, err)
  call Close(var, err)
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url))
  end if
end subroutine HistoryGetDouble3Pointer
subroutine HistoryGetDouble4Pointer(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar
  use dc_present,only: present_select, present_and_true
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical, intent(in), optional:: quiet
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  integer:: domain
  real(DP), pointer :: array(:,:,:,:) ! (out)
  real(DP), target :: array_tmp(1)
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble4Pointer"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 必要な情報を gtool 変数化
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call DbgMessage('@ url =%c', c1=trim(url))
  ! いよいよデータ取得
  !
  call Open(var, url, err)
  call Get(var, array, err)
  call Close(var, err)
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url))
  end if
end subroutine HistoryGetDouble4Pointer
subroutine HistoryGetDouble5Pointer(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar
  use dc_present,only: present_select, present_and_true
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical, intent(in), optional:: quiet
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  integer:: domain
  real(DP), pointer :: array(:,:,:,:,:) ! (out)
  real(DP), target :: array_tmp(1)
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble5Pointer"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 必要な情報を gtool 変数化
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call DbgMessage('@ url =%c', c1=trim(url))
  ! いよいよデータ取得
  !
  call Open(var, url, err)
  call Get(var, array, err)
  call Close(var, err)
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url))
  end if
end subroutine HistoryGetDouble5Pointer
subroutine HistoryGetDouble6Pointer(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar
  use dc_present,only: present_select, present_and_true
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical, intent(in), optional:: quiet
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  integer:: domain
  real(DP), pointer :: array(:,:,:,:,:,:) ! (out)
  real(DP), target :: array_tmp(1)
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble6Pointer"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 必要な情報を gtool 変数化
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call DbgMessage('@ url =%c', c1=trim(url))
  ! いよいよデータ取得
  !
  call Open(var, url, err)
  call Get(var, array, err)
  call Close(var, err)
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url))
  end if
end subroutine HistoryGetDouble6Pointer
subroutine HistoryGetDouble7Pointer(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar
  use dc_present,only: present_select, present_and_true
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical, intent(in), optional:: quiet
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  integer:: domain
  real(DP), pointer :: array(:,:,:,:,:,:,:) ! (out)
  real(DP), target :: array_tmp(1)
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble7Pointer"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 必要な情報を gtool 変数化
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call DbgMessage('@ url =%c', c1=trim(url))
  ! いよいよデータ取得
  !
  call Open(var, url, err)
  call Get(var, array, err)
  call Close(var, err)
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url))
  end if
end subroutine HistoryGetDouble7Pointer
subroutine HistoryGetReal0Pointer(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar
  use dc_present,only: present_select, present_and_true
  use dc_types, only: STRING, DP, SP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical, intent(in), optional:: quiet
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  integer:: domain
  real(SP), pointer :: array ! (out)
  real(SP), target :: array_tmp(1)
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal0Pointer"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 必要な情報を gtool 変数化
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  allocate(array)
  call DbgMessage('@ url =%c', c1=trim(url))
  ! いよいよデータ取得
  !
  call Open(var, url, err)
  call Inquire(var=var, size=domain)
  call Get(var, array_tmp, domain, err)
  array = array_tmp(1)
  call Close(var, err)
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url))
  end if
end subroutine HistoryGetReal0Pointer
subroutine HistoryGetReal1Pointer(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar
  use dc_present,only: present_select, present_and_true
  use dc_types, only: STRING, DP, SP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical, intent(in), optional:: quiet
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  integer:: domain
  real(SP), pointer :: array(:) ! (out)
  real(SP), target :: array_tmp(1)
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal1Pointer"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 必要な情報を gtool 変数化
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call DbgMessage('@ url =%c', c1=trim(url))
  ! いよいよデータ取得
  !
  call Open(var, url, err)
  call Get(var, array, err)
  call Close(var, err)
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url))
  end if
end subroutine HistoryGetReal1Pointer
subroutine HistoryGetReal2Pointer(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar
  use dc_present,only: present_select, present_and_true
  use dc_types, only: STRING, DP, SP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical, intent(in), optional:: quiet
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  integer:: domain
  real(SP), pointer :: array(:,:) ! (out)
  real(SP), target :: array_tmp(1)
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal2Pointer"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 必要な情報を gtool 変数化
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call DbgMessage('@ url =%c', c1=trim(url))
  ! いよいよデータ取得
  !
  call Open(var, url, err)
  call Get(var, array, err)
  call Close(var, err)
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url))
  end if
end subroutine HistoryGetReal2Pointer
subroutine HistoryGetReal3Pointer(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar
  use dc_present,only: present_select, present_and_true
  use dc_types, only: STRING, DP, SP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical, intent(in), optional:: quiet
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  integer:: domain
  real(SP), pointer :: array(:,:,:) ! (out)
  real(SP), target :: array_tmp(1)
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal3Pointer"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 必要な情報を gtool 変数化
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call DbgMessage('@ url =%c', c1=trim(url))
  ! いよいよデータ取得
  !
  call Open(var, url, err)
  call Get(var, array, err)
  call Close(var, err)
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url))
  end if
end subroutine HistoryGetReal3Pointer
subroutine HistoryGetReal4Pointer(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar
  use dc_present,only: present_select, present_and_true
  use dc_types, only: STRING, DP, SP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical, intent(in), optional:: quiet
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  integer:: domain
  real(SP), pointer :: array(:,:,:,:) ! (out)
  real(SP), target :: array_tmp(1)
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal4Pointer"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 必要な情報を gtool 変数化
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call DbgMessage('@ url =%c', c1=trim(url))
  ! いよいよデータ取得
  !
  call Open(var, url, err)
  call Get(var, array, err)
  call Close(var, err)
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url))
  end if
end subroutine HistoryGetReal4Pointer
subroutine HistoryGetReal5Pointer(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar
  use dc_present,only: present_select, present_and_true
  use dc_types, only: STRING, DP, SP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical, intent(in), optional:: quiet
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  integer:: domain
  real(SP), pointer :: array(:,:,:,:,:) ! (out)
  real(SP), target :: array_tmp(1)
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal5Pointer"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 必要な情報を gtool 変数化
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call DbgMessage('@ url =%c', c1=trim(url))
  ! いよいよデータ取得
  !
  call Open(var, url, err)
  call Get(var, array, err)
  call Close(var, err)
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url))
  end if
end subroutine HistoryGetReal5Pointer
subroutine HistoryGetReal6Pointer(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar
  use dc_present,only: present_select, present_and_true
  use dc_types, only: STRING, DP, SP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical, intent(in), optional:: quiet
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  integer:: domain
  real(SP), pointer :: array(:,:,:,:,:,:) ! (out)
  real(SP), target :: array_tmp(1)
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal6Pointer"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 必要な情報を gtool 変数化
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call DbgMessage('@ url =%c', c1=trim(url))
  ! いよいよデータ取得
  !
  call Open(var, url, err)
  call Get(var, array, err)
  call Close(var, err)
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url))
  end if
end subroutine HistoryGetReal6Pointer
subroutine HistoryGetReal7Pointer(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar
  use dc_present,only: present_select, present_and_true
  use dc_types, only: STRING, DP, SP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical, intent(in), optional:: quiet
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  integer:: domain
  real(SP), pointer :: array(:,:,:,:,:,:,:) ! (out)
  real(SP), target :: array_tmp(1)
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal7Pointer"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 必要な情報を gtool 変数化
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call DbgMessage('@ url =%c', c1=trim(url))
  ! いよいよデータ取得
  !
  call Open(var, url, err)
  call Get(var, array, err)
  call Close(var, err)
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url))
  end if
end subroutine HistoryGetReal7Pointer
subroutine HistoryGetInt0Pointer(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar
  use dc_present,only: present_select, present_and_true
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical, intent(in), optional:: quiet
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  integer:: domain
  integer,  pointer :: array ! (out)
  integer,  target :: array_tmp(1)
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt0Pointer"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 必要な情報を gtool 変数化
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  allocate(array)
  call DbgMessage('@ url =%c', c1=trim(url))
  ! いよいよデータ取得
  !
  call Open(var, url, err)
  call Inquire(var=var, size=domain)
  call Get(var, array_tmp, domain, err)
  array = array_tmp(1)
  call Close(var, err)
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url))
  end if
end subroutine HistoryGetInt0Pointer
subroutine HistoryGetInt1Pointer(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar
  use dc_present,only: present_select, present_and_true
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical, intent(in), optional:: quiet
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  integer:: domain
  integer,  pointer :: array(:) ! (out)
  integer,  target :: array_tmp(1)
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt1Pointer"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 必要な情報を gtool 変数化
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call DbgMessage('@ url =%c', c1=trim(url))
  ! いよいよデータ取得
  !
  call Open(var, url, err)
  call Get(var, array, err)
  call Close(var, err)
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url))
  end if
end subroutine HistoryGetInt1Pointer
subroutine HistoryGetInt2Pointer(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar
  use dc_present,only: present_select, present_and_true
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical, intent(in), optional:: quiet
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  integer:: domain
  integer,  pointer :: array(:,:) ! (out)
  integer,  target :: array_tmp(1)
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt2Pointer"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 必要な情報を gtool 変数化
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call DbgMessage('@ url =%c', c1=trim(url))
  ! いよいよデータ取得
  !
  call Open(var, url, err)
  call Get(var, array, err)
  call Close(var, err)
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url))
  end if
end subroutine HistoryGetInt2Pointer
subroutine HistoryGetInt3Pointer(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar
  use dc_present,only: present_select, present_and_true
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical, intent(in), optional:: quiet
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  integer:: domain
  integer,  pointer :: array(:,:,:) ! (out)
  integer,  target :: array_tmp(1)
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt3Pointer"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 必要な情報を gtool 変数化
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call DbgMessage('@ url =%c', c1=trim(url))
  ! いよいよデータ取得
  !
  call Open(var, url, err)
  call Get(var, array, err)
  call Close(var, err)
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url))
  end if
end subroutine HistoryGetInt3Pointer
subroutine HistoryGetInt4Pointer(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar
  use dc_present,only: present_select, present_and_true
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical, intent(in), optional:: quiet
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  integer:: domain
  integer,  pointer :: array(:,:,:,:) ! (out)
  integer,  target :: array_tmp(1)
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt4Pointer"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 必要な情報を gtool 変数化
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call DbgMessage('@ url =%c', c1=trim(url))
  ! いよいよデータ取得
  !
  call Open(var, url, err)
  call Get(var, array, err)
  call Close(var, err)
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url))
  end if
end subroutine HistoryGetInt4Pointer
subroutine HistoryGetInt5Pointer(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar
  use dc_present,only: present_select, present_and_true
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical, intent(in), optional:: quiet
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  integer:: domain
  integer,  pointer :: array(:,:,:,:,:) ! (out)
  integer,  target :: array_tmp(1)
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt5Pointer"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 必要な情報を gtool 変数化
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call DbgMessage('@ url =%c', c1=trim(url))
  ! いよいよデータ取得
  !
  call Open(var, url, err)
  call Get(var, array, err)
  call Close(var, err)
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url))
  end if
end subroutine HistoryGetInt5Pointer
subroutine HistoryGetInt6Pointer(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar
  use dc_present,only: present_select, present_and_true
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical, intent(in), optional:: quiet
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  integer:: domain
  integer,  pointer :: array(:,:,:,:,:,:) ! (out)
  integer,  target :: array_tmp(1)
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt6Pointer"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 必要な情報を gtool 変数化
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call DbgMessage('@ url =%c', c1=trim(url))
  ! いよいよデータ取得
  !
  call Open(var, url, err)
  call Get(var, array, err)
  call Close(var, err)
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url))
  end if
end subroutine HistoryGetInt6Pointer
subroutine HistoryGetInt7Pointer(file, varname, array, range, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Inquire, Close, Get
  use dc_string, only: toChar
  use dc_present,only: present_select, present_and_true
  use dc_types, only: STRING, DP
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  implicit none
  character(*), intent(in):: file
  character(*), intent(in):: varname
  character(*), intent(in), optional:: range
  logical, intent(in), optional:: quiet
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time ! データの時刻
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  integer:: domain
  integer,  pointer :: array(:,:,:,:,:,:,:) ! (out)
  integer,  target :: array_tmp(1)
  type(GT_VARIABLE):: var
  character(STRING):: file_work, url, actual_url
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt7Pointer"
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    subroutine actual_iorange_dump(url, actual_url, returned_time, time_name, err)
      use dc_types, only: DP
      character(*), intent(in) :: url                ! 変数 URL
      character(*), intent(out), optional :: actual_url
      ! 正確な入出力範囲指定
      real(DP), intent(out), optional:: returned_time    ! データの時刻
      character(*), intent(in), optional:: time_name ! 時刻次元の名称
      logical, intent(out), optional :: err          ! エラーのフラグ
    end subroutine actual_iorange_dump
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  ! ファイル名の変更 (MPI 用)
  ! Change filename (for MPI)
  !
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  ! 必要な情報を gtool 変数化
  !
  call lookup_growable_url(file_work, varname, url, range, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call DbgMessage('@ url =%c', c1=trim(url))
  ! いよいよデータ取得
  !
  call Open(var, url, err)
  call Get(var, array, err)
  call Close(var, err)
  call actual_iorange_dump(url, &  ! (in)
    & actual_url, returned_time, & ! (out) optional
    & time_name = tname, &         ! (in)  optional
    & err = err)                   ! (out) optional
  if ( .not. present_and_true(quiet) ) then
    call MessageNotify('M', subname, 'Input %c', c1=trim(actual_url))
  end if
end subroutine HistoryGetInt7Pointer
subroutine HistoryGetDouble0TimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), intent(out) :: array
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble0TimeR"
  interface
    subroutine HistoryGetDouble0(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), intent(out) :: array
    end subroutine HistoryGetDouble0
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble0( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble0TimeR
subroutine HistoryGetDouble1TimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), intent(out) :: array(:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble1TimeR"
  interface
    subroutine HistoryGetDouble1(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), intent(out) :: array(:)
    end subroutine HistoryGetDouble1
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble1( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble1TimeR
subroutine HistoryGetDouble2TimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), intent(out) :: array(:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble2TimeR"
  interface
    subroutine HistoryGetDouble2(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), intent(out) :: array(:,:)
    end subroutine HistoryGetDouble2
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble2( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble2TimeR
subroutine HistoryGetDouble3TimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), intent(out) :: array(:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble3TimeR"
  interface
    subroutine HistoryGetDouble3(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), intent(out) :: array(:,:,:)
    end subroutine HistoryGetDouble3
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble3( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble3TimeR
subroutine HistoryGetDouble4TimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), intent(out) :: array(:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble4TimeR"
  interface
    subroutine HistoryGetDouble4(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), intent(out) :: array(:,:,:,:)
    end subroutine HistoryGetDouble4
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble4( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble4TimeR
subroutine HistoryGetDouble5TimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), intent(out) :: array(:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble5TimeR"
  interface
    subroutine HistoryGetDouble5(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), intent(out) :: array(:,:,:,:,:)
    end subroutine HistoryGetDouble5
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble5( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble5TimeR
subroutine HistoryGetDouble6TimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), intent(out) :: array(:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble6TimeR"
  interface
    subroutine HistoryGetDouble6(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), intent(out) :: array(:,:,:,:,:,:)
    end subroutine HistoryGetDouble6
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble6( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble6TimeR
subroutine HistoryGetDouble7TimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), intent(out) :: array(:,:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble7TimeR"
  interface
    subroutine HistoryGetDouble7(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), intent(out) :: array(:,:,:,:,:,:,:)
    end subroutine HistoryGetDouble7
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble7( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble7TimeR
subroutine HistoryGetDouble0PointerTimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), pointer :: array
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble0TimeR"
  interface
    subroutine HistoryGetDouble0Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), pointer :: array
    end subroutine HistoryGetDouble0Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble0Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble0PointerTimeR
subroutine HistoryGetDouble1PointerTimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), pointer :: array(:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble1TimeR"
  interface
    subroutine HistoryGetDouble1Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), pointer :: array(:)
    end subroutine HistoryGetDouble1Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble1Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble1PointerTimeR
subroutine HistoryGetDouble2PointerTimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), pointer :: array(:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble2TimeR"
  interface
    subroutine HistoryGetDouble2Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), pointer :: array(:,:)
    end subroutine HistoryGetDouble2Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble2Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble2PointerTimeR
subroutine HistoryGetDouble3PointerTimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), pointer :: array(:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble3TimeR"
  interface
    subroutine HistoryGetDouble3Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), pointer :: array(:,:,:)
    end subroutine HistoryGetDouble3Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble3Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble3PointerTimeR
subroutine HistoryGetDouble4PointerTimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), pointer :: array(:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble4TimeR"
  interface
    subroutine HistoryGetDouble4Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), pointer :: array(:,:,:,:)
    end subroutine HistoryGetDouble4Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble4Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble4PointerTimeR
subroutine HistoryGetDouble5PointerTimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), pointer :: array(:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble5TimeR"
  interface
    subroutine HistoryGetDouble5Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), pointer :: array(:,:,:,:,:)
    end subroutine HistoryGetDouble5Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble5Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble5PointerTimeR
subroutine HistoryGetDouble6PointerTimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), pointer :: array(:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble6TimeR"
  interface
    subroutine HistoryGetDouble6Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), pointer :: array(:,:,:,:,:,:)
    end subroutine HistoryGetDouble6Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble6Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble6PointerTimeR
subroutine HistoryGetDouble7PointerTimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), pointer :: array(:,:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble7TimeR"
  interface
    subroutine HistoryGetDouble7Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), pointer :: array(:,:,:,:,:,:,:)
    end subroutine HistoryGetDouble7Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble7Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble7PointerTimeR
subroutine HistoryGetReal0TimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), intent(out) :: array
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal0TimeR"
  interface
    subroutine HistoryGetReal0(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), intent(out) :: array
    end subroutine HistoryGetReal0
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal0( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal0TimeR
subroutine HistoryGetReal1TimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), intent(out) :: array(:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal1TimeR"
  interface
    subroutine HistoryGetReal1(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), intent(out) :: array(:)
    end subroutine HistoryGetReal1
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal1( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal1TimeR
subroutine HistoryGetReal2TimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), intent(out) :: array(:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal2TimeR"
  interface
    subroutine HistoryGetReal2(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), intent(out) :: array(:,:)
    end subroutine HistoryGetReal2
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal2( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal2TimeR
subroutine HistoryGetReal3TimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), intent(out) :: array(:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal3TimeR"
  interface
    subroutine HistoryGetReal3(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), intent(out) :: array(:,:,:)
    end subroutine HistoryGetReal3
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal3( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal3TimeR
subroutine HistoryGetReal4TimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), intent(out) :: array(:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal4TimeR"
  interface
    subroutine HistoryGetReal4(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), intent(out) :: array(:,:,:,:)
    end subroutine HistoryGetReal4
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal4( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal4TimeR
subroutine HistoryGetReal5TimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), intent(out) :: array(:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal5TimeR"
  interface
    subroutine HistoryGetReal5(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), intent(out) :: array(:,:,:,:,:)
    end subroutine HistoryGetReal5
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal5( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal5TimeR
subroutine HistoryGetReal6TimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), intent(out) :: array(:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal6TimeR"
  interface
    subroutine HistoryGetReal6(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), intent(out) :: array(:,:,:,:,:,:)
    end subroutine HistoryGetReal6
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal6( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal6TimeR
subroutine HistoryGetReal7TimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), intent(out) :: array(:,:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal7TimeR"
  interface
    subroutine HistoryGetReal7(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), intent(out) :: array(:,:,:,:,:,:,:)
    end subroutine HistoryGetReal7
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal7( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal7TimeR
subroutine HistoryGetReal0PointerTimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), pointer :: array
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal0TimeR"
  interface
    subroutine HistoryGetReal0Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), pointer :: array
    end subroutine HistoryGetReal0Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal0Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal0PointerTimeR
subroutine HistoryGetReal1PointerTimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), pointer :: array(:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal1TimeR"
  interface
    subroutine HistoryGetReal1Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), pointer :: array(:)
    end subroutine HistoryGetReal1Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal1Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal1PointerTimeR
subroutine HistoryGetReal2PointerTimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), pointer :: array(:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal2TimeR"
  interface
    subroutine HistoryGetReal2Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), pointer :: array(:,:)
    end subroutine HistoryGetReal2Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal2Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal2PointerTimeR
subroutine HistoryGetReal3PointerTimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), pointer :: array(:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal3TimeR"
  interface
    subroutine HistoryGetReal3Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), pointer :: array(:,:,:)
    end subroutine HistoryGetReal3Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal3Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal3PointerTimeR
subroutine HistoryGetReal4PointerTimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), pointer :: array(:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal4TimeR"
  interface
    subroutine HistoryGetReal4Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), pointer :: array(:,:,:,:)
    end subroutine HistoryGetReal4Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal4Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal4PointerTimeR
subroutine HistoryGetReal5PointerTimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), pointer :: array(:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal5TimeR"
  interface
    subroutine HistoryGetReal5Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), pointer :: array(:,:,:,:,:)
    end subroutine HistoryGetReal5Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal5Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal5PointerTimeR
subroutine HistoryGetReal6PointerTimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), pointer :: array(:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal6TimeR"
  interface
    subroutine HistoryGetReal6Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), pointer :: array(:,:,:,:,:,:)
    end subroutine HistoryGetReal6Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal6Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal6PointerTimeR
subroutine HistoryGetReal7PointerTimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), pointer :: array(:,:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal7TimeR"
  interface
    subroutine HistoryGetReal7Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), pointer :: array(:,:,:,:,:,:,:)
    end subroutine HistoryGetReal7Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal7Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal7PointerTimeR
subroutine HistoryGetInt0TimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, intent(out)  :: array
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt0TimeR"
  interface
    subroutine HistoryGetInt0(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, intent(out)  :: array
    end subroutine HistoryGetInt0
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt0( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt0TimeR
subroutine HistoryGetInt1TimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, intent(out)  :: array(:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt1TimeR"
  interface
    subroutine HistoryGetInt1(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, intent(out)  :: array(:)
    end subroutine HistoryGetInt1
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt1( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt1TimeR
subroutine HistoryGetInt2TimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, intent(out)  :: array(:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt2TimeR"
  interface
    subroutine HistoryGetInt2(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, intent(out)  :: array(:,:)
    end subroutine HistoryGetInt2
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt2( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt2TimeR
subroutine HistoryGetInt3TimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, intent(out)  :: array(:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt3TimeR"
  interface
    subroutine HistoryGetInt3(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, intent(out)  :: array(:,:,:)
    end subroutine HistoryGetInt3
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt3( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt3TimeR
subroutine HistoryGetInt4TimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, intent(out)  :: array(:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt4TimeR"
  interface
    subroutine HistoryGetInt4(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, intent(out)  :: array(:,:,:,:)
    end subroutine HistoryGetInt4
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt4( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt4TimeR
subroutine HistoryGetInt5TimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, intent(out)  :: array(:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt5TimeR"
  interface
    subroutine HistoryGetInt5(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, intent(out)  :: array(:,:,:,:,:)
    end subroutine HistoryGetInt5
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt5( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt5TimeR
subroutine HistoryGetInt6TimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, intent(out)  :: array(:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt6TimeR"
  interface
    subroutine HistoryGetInt6(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, intent(out)  :: array(:,:,:,:,:,:)
    end subroutine HistoryGetInt6
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt6( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt6TimeR
subroutine HistoryGetInt7TimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, intent(out)  :: array(:,:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt7TimeR"
  interface
    subroutine HistoryGetInt7(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, intent(out)  :: array(:,:,:,:,:,:,:)
    end subroutine HistoryGetInt7
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt7( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt7TimeR
subroutine HistoryGetInt0PointerTimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, pointer  :: array
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt0TimeR"
  interface
    subroutine HistoryGetInt0Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, pointer  :: array
    end subroutine HistoryGetInt0Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt0Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt0PointerTimeR
subroutine HistoryGetInt1PointerTimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, pointer  :: array(:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt1TimeR"
  interface
    subroutine HistoryGetInt1Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, pointer  :: array(:)
    end subroutine HistoryGetInt1Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt1Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt1PointerTimeR
subroutine HistoryGetInt2PointerTimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, pointer  :: array(:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt2TimeR"
  interface
    subroutine HistoryGetInt2Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, pointer  :: array(:,:)
    end subroutine HistoryGetInt2Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt2Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt2PointerTimeR
subroutine HistoryGetInt3PointerTimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, pointer  :: array(:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt3TimeR"
  interface
    subroutine HistoryGetInt3Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, pointer  :: array(:,:,:)
    end subroutine HistoryGetInt3Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt3Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt3PointerTimeR
subroutine HistoryGetInt4PointerTimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, pointer  :: array(:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt4TimeR"
  interface
    subroutine HistoryGetInt4Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, pointer  :: array(:,:,:,:)
    end subroutine HistoryGetInt4Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt4Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt4PointerTimeR
subroutine HistoryGetInt5PointerTimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, pointer  :: array(:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt5TimeR"
  interface
    subroutine HistoryGetInt5Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, pointer  :: array(:,:,:,:,:)
    end subroutine HistoryGetInt5Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt5Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt5PointerTimeR
subroutine HistoryGetInt6PointerTimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, pointer  :: array(:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt6TimeR"
  interface
    subroutine HistoryGetInt6Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, pointer  :: array(:,:,:,:,:,:)
    end subroutine HistoryGetInt6Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt6Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt6PointerTimeR
subroutine HistoryGetInt7PointerTimeR( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(SP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, pointer  :: array(:,:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt7TimeR"
  interface
    subroutine HistoryGetInt7Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, pointer  :: array(:,:,:,:,:,:,:)
    end subroutine HistoryGetInt7Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt7Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt7PointerTimeR
subroutine HistoryGetDouble0TimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), intent(out) :: array
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble0TimeD"
  interface
    subroutine HistoryGetDouble0(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), intent(out) :: array
    end subroutine HistoryGetDouble0
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble0( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble0TimeD
subroutine HistoryGetDouble1TimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), intent(out) :: array(:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble1TimeD"
  interface
    subroutine HistoryGetDouble1(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), intent(out) :: array(:)
    end subroutine HistoryGetDouble1
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble1( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble1TimeD
subroutine HistoryGetDouble2TimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), intent(out) :: array(:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble2TimeD"
  interface
    subroutine HistoryGetDouble2(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), intent(out) :: array(:,:)
    end subroutine HistoryGetDouble2
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble2( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble2TimeD
subroutine HistoryGetDouble3TimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), intent(out) :: array(:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble3TimeD"
  interface
    subroutine HistoryGetDouble3(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), intent(out) :: array(:,:,:)
    end subroutine HistoryGetDouble3
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble3( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble3TimeD
subroutine HistoryGetDouble4TimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), intent(out) :: array(:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble4TimeD"
  interface
    subroutine HistoryGetDouble4(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), intent(out) :: array(:,:,:,:)
    end subroutine HistoryGetDouble4
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble4( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble4TimeD
subroutine HistoryGetDouble5TimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), intent(out) :: array(:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble5TimeD"
  interface
    subroutine HistoryGetDouble5(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), intent(out) :: array(:,:,:,:,:)
    end subroutine HistoryGetDouble5
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble5( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble5TimeD
subroutine HistoryGetDouble6TimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), intent(out) :: array(:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble6TimeD"
  interface
    subroutine HistoryGetDouble6(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), intent(out) :: array(:,:,:,:,:,:)
    end subroutine HistoryGetDouble6
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble6( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble6TimeD
subroutine HistoryGetDouble7TimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), intent(out) :: array(:,:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble7TimeD"
  interface
    subroutine HistoryGetDouble7(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), intent(out) :: array(:,:,:,:,:,:,:)
    end subroutine HistoryGetDouble7
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble7( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble7TimeD
subroutine HistoryGetDouble0PointerTimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), pointer :: array
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble0TimeD"
  interface
    subroutine HistoryGetDouble0Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), pointer :: array
    end subroutine HistoryGetDouble0Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble0Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble0PointerTimeD
subroutine HistoryGetDouble1PointerTimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), pointer :: array(:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble1TimeD"
  interface
    subroutine HistoryGetDouble1Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), pointer :: array(:)
    end subroutine HistoryGetDouble1Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble1Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble1PointerTimeD
subroutine HistoryGetDouble2PointerTimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), pointer :: array(:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble2TimeD"
  interface
    subroutine HistoryGetDouble2Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), pointer :: array(:,:)
    end subroutine HistoryGetDouble2Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble2Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble2PointerTimeD
subroutine HistoryGetDouble3PointerTimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), pointer :: array(:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble3TimeD"
  interface
    subroutine HistoryGetDouble3Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), pointer :: array(:,:,:)
    end subroutine HistoryGetDouble3Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble3Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble3PointerTimeD
subroutine HistoryGetDouble4PointerTimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), pointer :: array(:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble4TimeD"
  interface
    subroutine HistoryGetDouble4Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), pointer :: array(:,:,:,:)
    end subroutine HistoryGetDouble4Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble4Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble4PointerTimeD
subroutine HistoryGetDouble5PointerTimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), pointer :: array(:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble5TimeD"
  interface
    subroutine HistoryGetDouble5Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), pointer :: array(:,:,:,:,:)
    end subroutine HistoryGetDouble5Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble5Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble5PointerTimeD
subroutine HistoryGetDouble6PointerTimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), pointer :: array(:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble6TimeD"
  interface
    subroutine HistoryGetDouble6Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), pointer :: array(:,:,:,:,:,:)
    end subroutine HistoryGetDouble6Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble6Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble6PointerTimeD
subroutine HistoryGetDouble7PointerTimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), pointer :: array(:,:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble7TimeD"
  interface
    subroutine HistoryGetDouble7Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), pointer :: array(:,:,:,:,:,:,:)
    end subroutine HistoryGetDouble7Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble7Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble7PointerTimeD
subroutine HistoryGetReal0TimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), intent(out) :: array
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal0TimeD"
  interface
    subroutine HistoryGetReal0(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), intent(out) :: array
    end subroutine HistoryGetReal0
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal0( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal0TimeD
subroutine HistoryGetReal1TimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), intent(out) :: array(:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal1TimeD"
  interface
    subroutine HistoryGetReal1(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), intent(out) :: array(:)
    end subroutine HistoryGetReal1
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal1( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal1TimeD
subroutine HistoryGetReal2TimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), intent(out) :: array(:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal2TimeD"
  interface
    subroutine HistoryGetReal2(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), intent(out) :: array(:,:)
    end subroutine HistoryGetReal2
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal2( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal2TimeD
subroutine HistoryGetReal3TimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), intent(out) :: array(:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal3TimeD"
  interface
    subroutine HistoryGetReal3(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), intent(out) :: array(:,:,:)
    end subroutine HistoryGetReal3
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal3( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal3TimeD
subroutine HistoryGetReal4TimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), intent(out) :: array(:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal4TimeD"
  interface
    subroutine HistoryGetReal4(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), intent(out) :: array(:,:,:,:)
    end subroutine HistoryGetReal4
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal4( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal4TimeD
subroutine HistoryGetReal5TimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), intent(out) :: array(:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal5TimeD"
  interface
    subroutine HistoryGetReal5(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), intent(out) :: array(:,:,:,:,:)
    end subroutine HistoryGetReal5
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal5( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal5TimeD
subroutine HistoryGetReal6TimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), intent(out) :: array(:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal6TimeD"
  interface
    subroutine HistoryGetReal6(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), intent(out) :: array(:,:,:,:,:,:)
    end subroutine HistoryGetReal6
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal6( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal6TimeD
subroutine HistoryGetReal7TimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), intent(out) :: array(:,:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal7TimeD"
  interface
    subroutine HistoryGetReal7(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), intent(out) :: array(:,:,:,:,:,:,:)
    end subroutine HistoryGetReal7
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal7( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal7TimeD
subroutine HistoryGetReal0PointerTimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), pointer :: array
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal0TimeD"
  interface
    subroutine HistoryGetReal0Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), pointer :: array
    end subroutine HistoryGetReal0Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal0Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal0PointerTimeD
subroutine HistoryGetReal1PointerTimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), pointer :: array(:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal1TimeD"
  interface
    subroutine HistoryGetReal1Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), pointer :: array(:)
    end subroutine HistoryGetReal1Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal1Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal1PointerTimeD
subroutine HistoryGetReal2PointerTimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), pointer :: array(:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal2TimeD"
  interface
    subroutine HistoryGetReal2Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), pointer :: array(:,:)
    end subroutine HistoryGetReal2Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal2Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal2PointerTimeD
subroutine HistoryGetReal3PointerTimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), pointer :: array(:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal3TimeD"
  interface
    subroutine HistoryGetReal3Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), pointer :: array(:,:,:)
    end subroutine HistoryGetReal3Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal3Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal3PointerTimeD
subroutine HistoryGetReal4PointerTimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), pointer :: array(:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal4TimeD"
  interface
    subroutine HistoryGetReal4Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), pointer :: array(:,:,:,:)
    end subroutine HistoryGetReal4Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal4Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal4PointerTimeD
subroutine HistoryGetReal5PointerTimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), pointer :: array(:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal5TimeD"
  interface
    subroutine HistoryGetReal5Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), pointer :: array(:,:,:,:,:)
    end subroutine HistoryGetReal5Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal5Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal5PointerTimeD
subroutine HistoryGetReal6PointerTimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), pointer :: array(:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal6TimeD"
  interface
    subroutine HistoryGetReal6Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), pointer :: array(:,:,:,:,:,:)
    end subroutine HistoryGetReal6Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal6Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal6PointerTimeD
subroutine HistoryGetReal7PointerTimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), pointer :: array(:,:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal7TimeD"
  interface
    subroutine HistoryGetReal7Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), pointer :: array(:,:,:,:,:,:,:)
    end subroutine HistoryGetReal7Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal7Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal7PointerTimeD
subroutine HistoryGetInt0TimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, intent(out)  :: array
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt0TimeD"
  interface
    subroutine HistoryGetInt0(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, intent(out)  :: array
    end subroutine HistoryGetInt0
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt0( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt0TimeD
subroutine HistoryGetInt1TimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, intent(out)  :: array(:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt1TimeD"
  interface
    subroutine HistoryGetInt1(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, intent(out)  :: array(:)
    end subroutine HistoryGetInt1
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt1( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt1TimeD
subroutine HistoryGetInt2TimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, intent(out)  :: array(:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt2TimeD"
  interface
    subroutine HistoryGetInt2(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, intent(out)  :: array(:,:)
    end subroutine HistoryGetInt2
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt2( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt2TimeD
subroutine HistoryGetInt3TimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, intent(out)  :: array(:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt3TimeD"
  interface
    subroutine HistoryGetInt3(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, intent(out)  :: array(:,:,:)
    end subroutine HistoryGetInt3
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt3( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt3TimeD
subroutine HistoryGetInt4TimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, intent(out)  :: array(:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt4TimeD"
  interface
    subroutine HistoryGetInt4(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, intent(out)  :: array(:,:,:,:)
    end subroutine HistoryGetInt4
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt4( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt4TimeD
subroutine HistoryGetInt5TimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, intent(out)  :: array(:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt5TimeD"
  interface
    subroutine HistoryGetInt5(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, intent(out)  :: array(:,:,:,:,:)
    end subroutine HistoryGetInt5
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt5( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt5TimeD
subroutine HistoryGetInt6TimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, intent(out)  :: array(:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt6TimeD"
  interface
    subroutine HistoryGetInt6(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, intent(out)  :: array(:,:,:,:,:,:)
    end subroutine HistoryGetInt6
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt6( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt6TimeD
subroutine HistoryGetInt7TimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, intent(out)  :: array(:,:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt7TimeD"
  interface
    subroutine HistoryGetInt7(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, intent(out)  :: array(:,:,:,:,:,:,:)
    end subroutine HistoryGetInt7
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt7( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt7TimeD
subroutine HistoryGetInt0PointerTimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, pointer  :: array
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt0TimeD"
  interface
    subroutine HistoryGetInt0Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, pointer  :: array
    end subroutine HistoryGetInt0Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt0Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt0PointerTimeD
subroutine HistoryGetInt1PointerTimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, pointer  :: array(:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt1TimeD"
  interface
    subroutine HistoryGetInt1Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, pointer  :: array(:)
    end subroutine HistoryGetInt1Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt1Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt1PointerTimeD
subroutine HistoryGetInt2PointerTimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, pointer  :: array(:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt2TimeD"
  interface
    subroutine HistoryGetInt2Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, pointer  :: array(:,:)
    end subroutine HistoryGetInt2Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt2Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt2PointerTimeD
subroutine HistoryGetInt3PointerTimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, pointer  :: array(:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt3TimeD"
  interface
    subroutine HistoryGetInt3Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, pointer  :: array(:,:,:)
    end subroutine HistoryGetInt3Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt3Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt3PointerTimeD
subroutine HistoryGetInt4PointerTimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, pointer  :: array(:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt4TimeD"
  interface
    subroutine HistoryGetInt4Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, pointer  :: array(:,:,:,:)
    end subroutine HistoryGetInt4Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt4Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt4PointerTimeD
subroutine HistoryGetInt5PointerTimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, pointer  :: array(:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt5TimeD"
  interface
    subroutine HistoryGetInt5Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, pointer  :: array(:,:,:,:,:)
    end subroutine HistoryGetInt5Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt5Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt5PointerTimeD
subroutine HistoryGetInt6PointerTimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, pointer  :: array(:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt6TimeD"
  interface
    subroutine HistoryGetInt6Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, pointer  :: array(:,:,:,:,:,:)
    end subroutine HistoryGetInt6Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt6Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt6PointerTimeD
subroutine HistoryGetInt7PointerTimeD( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  real(DP), intent(in):: time
  logical, intent(in), optional:: quiet
  integer, pointer  :: array(:,:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt7TimeD"
  interface
    subroutine HistoryGetInt7Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, pointer  :: array(:,:,:,:,:,:,:)
    end subroutine HistoryGetInt7Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt7Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt7PointerTimeD
subroutine HistoryGetDouble0TimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), intent(out) :: array
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble0TimeI"
  interface
    subroutine HistoryGetDouble0(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), intent(out) :: array
    end subroutine HistoryGetDouble0
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble0( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble0TimeI
subroutine HistoryGetDouble1TimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), intent(out) :: array(:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble1TimeI"
  interface
    subroutine HistoryGetDouble1(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), intent(out) :: array(:)
    end subroutine HistoryGetDouble1
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble1( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble1TimeI
subroutine HistoryGetDouble2TimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), intent(out) :: array(:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble2TimeI"
  interface
    subroutine HistoryGetDouble2(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), intent(out) :: array(:,:)
    end subroutine HistoryGetDouble2
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble2( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble2TimeI
subroutine HistoryGetDouble3TimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), intent(out) :: array(:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble3TimeI"
  interface
    subroutine HistoryGetDouble3(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), intent(out) :: array(:,:,:)
    end subroutine HistoryGetDouble3
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble3( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble3TimeI
subroutine HistoryGetDouble4TimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), intent(out) :: array(:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble4TimeI"
  interface
    subroutine HistoryGetDouble4(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), intent(out) :: array(:,:,:,:)
    end subroutine HistoryGetDouble4
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble4( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble4TimeI
subroutine HistoryGetDouble5TimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), intent(out) :: array(:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble5TimeI"
  interface
    subroutine HistoryGetDouble5(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), intent(out) :: array(:,:,:,:,:)
    end subroutine HistoryGetDouble5
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble5( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble5TimeI
subroutine HistoryGetDouble6TimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), intent(out) :: array(:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble6TimeI"
  interface
    subroutine HistoryGetDouble6(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), intent(out) :: array(:,:,:,:,:,:)
    end subroutine HistoryGetDouble6
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble6( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble6TimeI
subroutine HistoryGetDouble7TimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), intent(out) :: array(:,:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble7TimeI"
  interface
    subroutine HistoryGetDouble7(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), intent(out) :: array(:,:,:,:,:,:,:)
    end subroutine HistoryGetDouble7
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble7( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble7TimeI
subroutine HistoryGetDouble0PointerTimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), pointer :: array
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble0TimeI"
  interface
    subroutine HistoryGetDouble0Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), pointer :: array
    end subroutine HistoryGetDouble0Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble0Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble0PointerTimeI
subroutine HistoryGetDouble1PointerTimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), pointer :: array(:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble1TimeI"
  interface
    subroutine HistoryGetDouble1Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), pointer :: array(:)
    end subroutine HistoryGetDouble1Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble1Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble1PointerTimeI
subroutine HistoryGetDouble2PointerTimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), pointer :: array(:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble2TimeI"
  interface
    subroutine HistoryGetDouble2Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), pointer :: array(:,:)
    end subroutine HistoryGetDouble2Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble2Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble2PointerTimeI
subroutine HistoryGetDouble3PointerTimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), pointer :: array(:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble3TimeI"
  interface
    subroutine HistoryGetDouble3Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), pointer :: array(:,:,:)
    end subroutine HistoryGetDouble3Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble3Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble3PointerTimeI
subroutine HistoryGetDouble4PointerTimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), pointer :: array(:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble4TimeI"
  interface
    subroutine HistoryGetDouble4Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), pointer :: array(:,:,:,:)
    end subroutine HistoryGetDouble4Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble4Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble4PointerTimeI
subroutine HistoryGetDouble5PointerTimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), pointer :: array(:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble5TimeI"
  interface
    subroutine HistoryGetDouble5Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), pointer :: array(:,:,:,:,:)
    end subroutine HistoryGetDouble5Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble5Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble5PointerTimeI
subroutine HistoryGetDouble6PointerTimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), pointer :: array(:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble6TimeI"
  interface
    subroutine HistoryGetDouble6Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), pointer :: array(:,:,:,:,:,:)
    end subroutine HistoryGetDouble6Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble6Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble6PointerTimeI
subroutine HistoryGetDouble7PointerTimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(DP), pointer :: array(:,:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetDouble7TimeI"
  interface
    subroutine HistoryGetDouble7Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(DP), pointer :: array(:,:,:,:,:,:,:)
    end subroutine HistoryGetDouble7Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetDouble7Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetDouble7PointerTimeI
subroutine HistoryGetReal0TimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), intent(out) :: array
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal0TimeI"
  interface
    subroutine HistoryGetReal0(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), intent(out) :: array
    end subroutine HistoryGetReal0
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal0( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal0TimeI
subroutine HistoryGetReal1TimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), intent(out) :: array(:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal1TimeI"
  interface
    subroutine HistoryGetReal1(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), intent(out) :: array(:)
    end subroutine HistoryGetReal1
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal1( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal1TimeI
subroutine HistoryGetReal2TimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), intent(out) :: array(:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal2TimeI"
  interface
    subroutine HistoryGetReal2(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), intent(out) :: array(:,:)
    end subroutine HistoryGetReal2
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal2( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal2TimeI
subroutine HistoryGetReal3TimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), intent(out) :: array(:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal3TimeI"
  interface
    subroutine HistoryGetReal3(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), intent(out) :: array(:,:,:)
    end subroutine HistoryGetReal3
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal3( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal3TimeI
subroutine HistoryGetReal4TimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), intent(out) :: array(:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal4TimeI"
  interface
    subroutine HistoryGetReal4(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), intent(out) :: array(:,:,:,:)
    end subroutine HistoryGetReal4
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal4( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal4TimeI
subroutine HistoryGetReal5TimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), intent(out) :: array(:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal5TimeI"
  interface
    subroutine HistoryGetReal5(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), intent(out) :: array(:,:,:,:,:)
    end subroutine HistoryGetReal5
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal5( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal5TimeI
subroutine HistoryGetReal6TimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), intent(out) :: array(:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal6TimeI"
  interface
    subroutine HistoryGetReal6(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), intent(out) :: array(:,:,:,:,:,:)
    end subroutine HistoryGetReal6
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal6( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal6TimeI
subroutine HistoryGetReal7TimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), intent(out) :: array(:,:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal7TimeI"
  interface
    subroutine HistoryGetReal7(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), intent(out) :: array(:,:,:,:,:,:,:)
    end subroutine HistoryGetReal7
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal7( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal7TimeI
subroutine HistoryGetReal0PointerTimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), pointer :: array
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal0TimeI"
  interface
    subroutine HistoryGetReal0Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), pointer :: array
    end subroutine HistoryGetReal0Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal0Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal0PointerTimeI
subroutine HistoryGetReal1PointerTimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), pointer :: array(:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal1TimeI"
  interface
    subroutine HistoryGetReal1Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), pointer :: array(:)
    end subroutine HistoryGetReal1Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal1Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal1PointerTimeI
subroutine HistoryGetReal2PointerTimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), pointer :: array(:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal2TimeI"
  interface
    subroutine HistoryGetReal2Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), pointer :: array(:,:)
    end subroutine HistoryGetReal2Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal2Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal2PointerTimeI
subroutine HistoryGetReal3PointerTimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), pointer :: array(:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal3TimeI"
  interface
    subroutine HistoryGetReal3Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), pointer :: array(:,:,:)
    end subroutine HistoryGetReal3Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal3Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal3PointerTimeI
subroutine HistoryGetReal4PointerTimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), pointer :: array(:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal4TimeI"
  interface
    subroutine HistoryGetReal4Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), pointer :: array(:,:,:,:)
    end subroutine HistoryGetReal4Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal4Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal4PointerTimeI
subroutine HistoryGetReal5PointerTimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), pointer :: array(:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal5TimeI"
  interface
    subroutine HistoryGetReal5Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), pointer :: array(:,:,:,:,:)
    end subroutine HistoryGetReal5Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal5Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal5PointerTimeI
subroutine HistoryGetReal6PointerTimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), pointer :: array(:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal6TimeI"
  interface
    subroutine HistoryGetReal6Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), pointer :: array(:,:,:,:,:,:)
    end subroutine HistoryGetReal6Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal6Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal6PointerTimeI
subroutine HistoryGetReal7PointerTimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP, SP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  real(SP), pointer :: array(:,:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetReal7TimeI"
  interface
    subroutine HistoryGetReal7Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP, SP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      real(SP), pointer :: array(:,:,:,:,:,:,:)
    end subroutine HistoryGetReal7Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetReal7Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetReal7PointerTimeI
subroutine HistoryGetInt0TimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  integer, intent(out)  :: array
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt0TimeI"
  interface
    subroutine HistoryGetInt0(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, intent(out)  :: array
    end subroutine HistoryGetInt0
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt0( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt0TimeI
subroutine HistoryGetInt1TimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  integer, intent(out)  :: array(:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt1TimeI"
  interface
    subroutine HistoryGetInt1(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, intent(out)  :: array(:)
    end subroutine HistoryGetInt1
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt1( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt1TimeI
subroutine HistoryGetInt2TimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  integer, intent(out)  :: array(:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt2TimeI"
  interface
    subroutine HistoryGetInt2(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, intent(out)  :: array(:,:)
    end subroutine HistoryGetInt2
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt2( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt2TimeI
subroutine HistoryGetInt3TimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  integer, intent(out)  :: array(:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt3TimeI"
  interface
    subroutine HistoryGetInt3(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, intent(out)  :: array(:,:,:)
    end subroutine HistoryGetInt3
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt3( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt3TimeI
subroutine HistoryGetInt4TimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  integer, intent(out)  :: array(:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt4TimeI"
  interface
    subroutine HistoryGetInt4(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, intent(out)  :: array(:,:,:,:)
    end subroutine HistoryGetInt4
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt4( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt4TimeI
subroutine HistoryGetInt5TimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  integer, intent(out)  :: array(:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt5TimeI"
  interface
    subroutine HistoryGetInt5(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, intent(out)  :: array(:,:,:,:,:)
    end subroutine HistoryGetInt5
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt5( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt5TimeI
subroutine HistoryGetInt6TimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  integer, intent(out)  :: array(:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt6TimeI"
  interface
    subroutine HistoryGetInt6(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, intent(out)  :: array(:,:,:,:,:,:)
    end subroutine HistoryGetInt6
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt6( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt6TimeI
subroutine HistoryGetInt7TimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  integer, intent(out)  :: array(:,:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt7TimeI"
  interface
    subroutine HistoryGetInt7(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, intent(out)  :: array(:,:,:,:,:,:,:)
    end subroutine HistoryGetInt7
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt7( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt7TimeI
subroutine HistoryGetInt0PointerTimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  integer, pointer  :: array
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt0TimeI"
  interface
    subroutine HistoryGetInt0Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, pointer  :: array
    end subroutine HistoryGetInt0Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt0Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt0PointerTimeI
subroutine HistoryGetInt1PointerTimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  integer, pointer  :: array(:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt1TimeI"
  interface
    subroutine HistoryGetInt1Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, pointer  :: array(:)
    end subroutine HistoryGetInt1Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt1Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt1PointerTimeI
subroutine HistoryGetInt2PointerTimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  integer, pointer  :: array(:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt2TimeI"
  interface
    subroutine HistoryGetInt2Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, pointer  :: array(:,:)
    end subroutine HistoryGetInt2Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt2Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt2PointerTimeI
subroutine HistoryGetInt3PointerTimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  integer, pointer  :: array(:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt3TimeI"
  interface
    subroutine HistoryGetInt3Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, pointer  :: array(:,:,:)
    end subroutine HistoryGetInt3Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt3Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt3PointerTimeI
subroutine HistoryGetInt4PointerTimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  integer, pointer  :: array(:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt4TimeI"
  interface
    subroutine HistoryGetInt4Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, pointer  :: array(:,:,:,:)
    end subroutine HistoryGetInt4Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt4Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt4PointerTimeI
subroutine HistoryGetInt5PointerTimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  integer, pointer  :: array(:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt5TimeI"
  interface
    subroutine HistoryGetInt5Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, pointer  :: array(:,:,:,:,:)
    end subroutine HistoryGetInt5Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt5Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt5PointerTimeI
subroutine HistoryGetInt6PointerTimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  integer, pointer  :: array(:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt6TimeI"
  interface
    subroutine HistoryGetInt6Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, pointer  :: array(:,:,:,:,:,:)
    end subroutine HistoryGetInt6Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt6Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt6PointerTimeI
subroutine HistoryGetInt7PointerTimeI( &
  & file, varname, array, time, &
  & quiet, flag_mpi_split, returned_time, flag_time_exist, err)
  use dc_string, only: toChar, Split
  use dc_types, only: STRING, DP
  use dc_trace, only: DbgMessage
  use dc_url, only: Url_Chop_IOrange, GT_EQUAL
  use dc_present, only: present_and_true
  implicit none
  character(*), intent(in):: file, varname
  integer,  intent(in):: time
  logical, intent(in), optional:: quiet
  integer, pointer  :: array(:,:,:,:,:,:,:)
  logical, intent(in), optional:: flag_mpi_split
  real(DP), intent(out), optional:: returned_time
  logical, intent(out), optional:: flag_time_exist
  logical, intent(out), optional:: err
  character(STRING):: file_work, url, iorange, remainder, timevar_name, time_range
  character(STRING), pointer:: carray (:)
  character(STRING):: tname
  character(*), parameter :: subname = "HistoryGetInt7TimeI"
  interface
    subroutine HistoryGetInt7Pointer(&
      & file, varname, array, range, quiet, &
      & flag_mpi_split, returned_time, flag_time_exist, err)
      use dc_types, only: DP
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(in), optional:: range
      logical, intent(in), optional:: quiet
      logical, intent(in), optional:: flag_mpi_split
      real(DP), intent(out), optional:: returned_time
      logical, intent(out), optional:: flag_time_exist
      logical, intent(out), optional:: err
      integer, pointer  :: array(:,:,:,:,:,:,:)
    end subroutine HistoryGetInt7Pointer
  end interface
  interface
    subroutine lookup_growable_url(file, varname, url, range, flag_time_exist, time_name, err)
      character(*), intent(in):: file
      character(*), intent(in):: varname
      character(*), intent(out):: url
      character(*), intent(in), optional:: range
      logical, intent(out), optional:: flag_time_exist
      character(*), intent(out), optional:: time_name
      logical, intent(out), optional:: err
    end subroutine lookup_growable_url
  end interface
  interface
    function file_rename_mpi( file ) result(result)
      use dc_types, only: STRING
      character(*), intent(in):: file
      character(STRING):: result
    end function file_rename_mpi
  end interface
  continue
  file_work = file
  if ( present_and_true( flag_mpi_split ) ) &
    & file_work = file_rename_mpi( file_work )
  call lookup_growable_url(file = file_work, varname = varname, &
    & url = url, &
    & flag_time_exist = flag_time_exist, time_name = tname, err = err)
  call Url_Chop_IOrange( &
    & fullname = url, iorange = iorange, remainder = remainder )
  call Split( str = iorange, carray = carray, sep = GT_EQUAL )
  timevar_name = carray(1)
  deallocate( carray )
  time_range = trim(timevar_name) // GT_EQUAL // trim(toChar(time))
  call HistoryGetInt7Pointer( file = file, &
    & varname = varname, array = array, &
    & range = time_range, quiet = quiet, &
    & flag_mpi_split = flag_mpi_split, &
    & returned_time = returned_time, &
    & flag_time_exist = flag_time_exist, &
    & err = err )
end subroutine HistoryGetInt7PointerTimeI
subroutine lookup_growable_url( &
  & file, varname, & ! (in)
  & url, &           ! (out)
  & range, &         ! (in) optional
  & flag_time_exist, time_name, err) ! (out) optional
  !
  ! file の変数 varname が依存する次元の内, 時間の次元
  ! (growable == .TRUE. のもの, つまり無制限次元) の変数名,
  ! およびその最後の値を取得し, gtool 変数化
  ! ("file@varname,time=10.5" みたいな) して返す.
  !
  ! * もしも varname が次元変数である場合は「time=」を付けずに返す.
  ! * range を与えた場合, 以下のチェックを行った後, それを gtool4
  !   変数の iorange 部分に付加する.
  !   * range に空文字が与えられた場合, range が与えられない場合と
  !     同じ動作をする.
  !   * range 内に時間次元が設定されていない場合は, 自動的に
  !     時間次元に関する iorange ("time=0.5") が指定される.
  ! * 数値のみの文字列 (例: "20", "10.354") が与えられる場合,
  !   エラーを生じる.
  !
  ! *flag_time_exist* が与えられる場合には, 得られるデータに
  ! 時刻次元が含まれる場合には .true. を, 含まれない場合は
  ! .false. を返す.
  ! *time_name* が与えられる場合には, 得られるデータに
  ! 時刻次元が含まれる場合にはその時刻次元変数名を,
  ! 含まれない場合には空文字を返す.
  !
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Close, Inquire
  use dc_present,only: present_select, present_and_not_empty, present_and_true
  use dc_string, only: toChar
  use dc_error,  only: StoreError, DC_NOERR, GT_ENOUNLIMITDIM, &
    & NF90_EINVAL, GT_ENOTVAR, GT_EBADGT4COMMAGRAPHY
  use dc_url, only: GT_CIRCUMFLEX, GT_COMMA, GT_EQUAL
  use dc_url, only: UrlSplit, UrlMerge, UrlSearchIORange
  use dc_regex, only: match
  use dc_types, only: DP, STRING
  use dc_trace, only: Beginsub, Endsub, DbgMessage
  character(*), intent(in) :: file           ! ファイル名
  character(*), intent(in) :: varname        ! 変数名
  character(*), intent(out) :: url           ! gtool変数化した文字列
  character(*), intent(in), optional:: range ! 範囲限定や一点切り出し指定
  logical, intent(out), optional:: flag_time_exist ! 時刻次元の存在の有無
  character(*), intent(out), optional:: time_name  ! 時刻次元の名称
  logical, intent(out), optional :: err      ! エラーのフラグ
  !
  type(GT_VARIABLE)                       :: var
  type(GT_VARIABLE), allocatable          :: dimvar(:)
  character(STRING) :: time_url, tname, time_iorange
  character(STRING) :: iorange, cause_c
  logical:: growable, nounlimited
  integer:: allcount, timecount, nd, i, stat
  integer:: regex_stat, regex_len
  character(*), parameter :: subname = "lookup_growable_url"
continue
  call BeginSub(subname, '<file=%c varname=%c range=%c>', &
    & c1=trim(file), c2=trim(varname), &
    & c3=trim(present_select('', 'no-range', range)))
  stat = DC_NOERR
  cause_c = ""
  url = ""
  ! 引数の正当性をチェック
  if (.not. present_and_not_empty(file)) then
    stat = NF90_EINVAL
    cause_c = '"file" is not specified'
    goto 999
  elseif (.not. present_and_not_empty(varname)) then
    stat = NF90_EINVAL
    cause_c = '"varname" is not specified'
    goto 999
  end if
  ! 時刻次元の変数名, およびその最終時刻の
  ! 探査のために file@varname を open (まだデータを取得しない)
  call Open(var, UrlMerge(file, varname), err = err)
  if ( present_and_true(err) ) then
    stat = GT_ENOTVAR
    goto 999
  end if
  ! 次元の数を取得
  call Inquire(var=var, alldims=nd)
  call DbgMessage('@ alldims = %d', i=(/nd/))
  if (allocated(dimvar)) then
    deallocate(dimvar)
  end if
  allocate(dimvar(nd))
  !
  ! 変数が無制限変数を持たない場合, もしくは変数自体が
  ! 無制限次元変数である場合には, それに関する iorange を
  ! 付けないで返すよう, フラグを立てる.
  ! それ以外は .false. にする.
  nounlimited = .true.
  !
  ! 各次元毎に情報を取得し, growable == .TRUE. のもの (つまりは時間)
  ! の変数名 (tname) を取得する.
  call DbgMessage('[%c: growable-dim-search]', c1=trim(subname))
  tname = ''
  do, i = 1, nd
    call Open(var = dimvar(i), &        ! (out)
      & source_var = var, dimord = i, & ! (in)
      & count_compact = .TRUE., &       ! (in)
      & err = err)                      ! (out) optional
    ! まずは変数入り gtool4 変数を time_url に取得
    call Inquire(var = dimvar(i), &           ! (in)
      & growable = growable, &                ! (out)
      & allcount = allcount, url = time_url)  ! (out)
    call DbgMessage('  [dim=d>: growable=<%y>: url=<%c>]', &
      &  i = (/i/), L = (/growable/), c1 = trim(time_url))
    ! 変数部分だけ分離
    call UrlSplit( fullname = time_url, & ! (in)
      &            var = tname)           ! (out)
    ! 無制限次元で, かつ開こうとする変数自体が無制限次元でない場合
    !
    if ( growable .and. trim(tname) /= trim(varname) ) then
      ! 総数 = 最後の数を timecount に
      !
      timecount = allcount
      nounlimited = .false.
    endif
    call Close(dimvar(i))
    ! 時刻次元が見つかった場合にはループを抜ける
    !
    if ( .not. nounlimited ) then
      exit
    ! 時刻次元ではない場合, tname を空に
    !
    else
      tname = ''
    end if
  end do
  ! 探査を終了したので閉じる
  call Close(var)
  if (stat /= DC_NOERR) then
    goto 999
  end if
  ! 時刻次元名を返す
  !
  if ( present(time_name) ) time_name = tname
  ! 時刻部分の iorange を作成しておく.
  ! 格子点情報で取得されているので, 頭に "^" を付加する.
  if (nounlimited) then
    time_iorange = ''
    if ( present(flag_time_exist) ) flag_time_exist = .false.
!!$    if ( present(returned_time) ) returned_time = 0.
  else
    time_iorange = trim(tname) // GT_EQUAL // &
      & GT_CIRCUMFLEX // adjustl(toChar(timecount))
    if ( present(flag_time_exist) ) flag_time_exist = .true.
!!$    if ( present(returned_time) ) then
!!$      returned_time =
!!$    end if
  end if
  ! iorange を指定する.
  ! 時刻に関しては, range が存在しない場合には
  ! 自動取得した最後の時刻を付加する.
  ! range が存在する場合, "=" が含まれなければ, gtool4 のコンマ記法
  ! として不適切としてエラーを生じる.
  ! "=" が含まれる場合, iorange としてそのまま iorange になる.
  ! ただし, その iorange に時刻次元が含まれない場合,
  ! やはり先ほど自動取得した値が付加される.
  ! 当然, 時刻次元が存在しない場合には付加しない.
  if (.not. present_and_not_empty(range)) then
    iorange = time_iorange
  else
    ! range がコンマ記法になっているか, "=" があるかどうかで調べる
    call match(GT_EQUAL, range, regex_len, regex_stat)
    ! コンマ記法になってない場合は無制限次元の値と判定
    if (regex_stat < 0) then
      cause_c = range
      stat = GT_EBADGT4COMMAGRAPHY
      goto 999
!!$      iorange = trim(tname) // GT_EQUAL // adjustl(range)
    else
      ! コンマ記法になっている場合, まずその中に無制限次元が
      ! 存在しているか調べ, 存在してない場合のみ time_iorange を
      ! 付加する.
      if (trim(UrlSearchIORange(range, tname)) /= "") then
        iorange = range
      else
        if (trim(time_iorange) /= "") then
          iorange = range // GT_COMMA // time_iorange
        else
          iorange = range
        end if
      end if
    end if
  endif
  call DbgMessage('@ iorange=%c', c1=trim(iorange))
  ! file, varname, iorange を gtool変数化
  ! (「file@varname,time=10.5」のように)
  url = UrlMerge(file, varname, '', iorange)
999 continue
  call StoreError(stat, subname, err, cause_c)
  call EndSub(subname, '<url=%c>', c1=trim(url))
end subroutine lookup_growable_url
subroutine actual_iorange_dump( url, & ! (in)
  & actual_url, returned_time, &  ! (out) optional
  & time_name, &                  ! (in)  optional
  & err )                         ! (out) optional
  !
  ! 変数 URL *url* に対応するファイル, 変数からデータを取り出す際,
  ! 入出力範囲指定によって切り出される値の本当の位置を
  ! 標準出力に出力する. *actual_url* が与えられる場合には
  ! その引数に値を返し, 標準出力には出力しない.
  !
  ! HistoryGet, HistoryGetPointer が下層で呼び出している
  ! gtdata_generic#Get は, 入出力範囲が次元データに正確に一致しない
  ! 場合, 最も近い値を自動的に選択して切り出す. しかしその結果,
  ! 「本当はどこのデータを入力したか」がわからない場合があるため,
  ! このサブルーチンによって正確な位置をユーザに知らせる.
  !
  ! *time_name* と *returned_time* が与えられる場合には,
  ! *returned_time* に時刻の数値を返す.
  ! *returned_time* のみ与えられる場合には 0 を返す.
  !
  use dc_types, only: DP, STRING
  use dc_string, only: Split, JoinChar, toChar, RoundNum
  use dc_url, only: UrlSearchIORange, UrlMerge, UrlSplit
  use dc_url, only: GT_COMMA, GT_EQUAL, GT_COLON
  use dc_message, only: MessageNotify
  use dc_trace, only: DbgMessage
  use dc_regex, only: match
  use gtdata_types, only: GT_VARIABLE
  use gtdata_generic, only: Open, Close, Get
  use dc_error,  only: StoreError, DC_NOERR
  character(*), intent(in):: url            ! 変数 URL
  character(*), intent(out), optional:: actual_url
                                             ! 正確な入出力範囲指定に修正
                                             ! された変数 URL
  real(DP), intent(out), optional:: returned_time ! データの時刻
  character(*), intent(in), optional:: time_name  ! 時刻次元の名称
  logical, intent(out), optional:: err      ! エラーのフラグ
  character(STRING), pointer :: iorange_each(:) =>null()
  character(STRING), pointer :: range_values(:) =>null()
  character(STRING), pointer :: new_iorange_each(:) =>null()
  character(STRING), pointer :: new_range_values(:) =>null()
  character(STRING):: new_url, new_iorange, url_tmp, dimname
  character(STRING):: file, varname, range, cause_c
  type(GT_VARIABLE):: var
  real :: iorange_value(1)
  integer :: i, j, regex_len, regex_stat, stat
  character(*), parameter :: subname = "actual_iorange_dump"
  continue
  new_iorange = ''
  cause_c = ''
  stat = DC_NOERR
  if ( present(returned_time) ) then
    returned_time = 0.
  end if
  call UrlSplit(url, file, varname, iorange=range)
  call Split(range, iorange_each, GT_COMMA)
  allocate(new_iorange_each(size(iorange_each)))
  do i = 1, size(iorange_each)
    call match(GT_EQUAL, iorange_each(i), regex_len, regex_stat)
    if (regex_stat < 0 .or. regex_len < 2) then
      new_iorange_each(i) = trim(iorange_each(i))
    else
      dimname = iorange_each(i)(:regex_len-1)
      call Split(iorange_each(i)(regex_len+1:), range_values, GT_COLON)
      allocate(new_range_values(size(range_values)))
      do j = 1, size(range_values)
        url_tmp = UrlMerge(file, dimname, '', &
          & iorange=trim(dimname) // GT_EQUAL // trim(range_values(j)))
        call Open(var, url_tmp)
        call Get(var, iorange_value, 1)
        call Close(var)
        if ( present(time_name) .and. present(returned_time) ) then
          if ( trim(time_name) == trim(dimname) ) then
            returned_time = iorange_value(1)
          end if
        end if
        new_range_values(j) = RoundNum( toChar(iorange_value) )
      end do
      new_iorange_each(i) = &
        & trim(dimname) // GT_EQUAL // JoinChar(new_range_values, GT_COLON)
      deallocate(new_range_values)
      deallocate(range_values)
    end if
  end do
  new_iorange = JoinChar(new_iorange_each, GT_COMMA)
  deallocate(new_iorange_each)
  deallocate(iorange_each)
  new_url = UrlMerge(file, varname, '', new_iorange)
  if (present(actual_url)) then
    actual_url = new_url
  else
    call MessageNotify('M', subname, 'Input %c', c1=trim(new_url))
  end if
999 continue
  call StoreError(stat, subname, err, cause_c)
end subroutine actual_iorange_dump
function file_rename_mpi( file ) result(result)
  use dc_types, only: STRING, TOKEN
  use dc_string, only: CPrintf, LChar
  implicit none
  character(*), intent(in):: file
  character(STRING):: result
  continue
  result = file
  return
end function file_rename_mpi
