!-*- mode:f90 ; coding: utf-8 -*-
!-----------------------------------------------------------------------
! Copyright (c) 2000-2016 Gtool Development Group. All rights reserved.
!-----------------------------------------------------------------------
!
! ** Important**
!
! This file is generated from dcstringputline.erb by ERB included Ruby 2.3.3.
! Please do not edit this file directly.
!
! Authors::   Youhei SASAKI, Yasuhiro MORIKAWA, Eizi TOYODA
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2012. All rights reserved.
! License::   Expat. See COPYRIGHT[link:../../COPYRIGHT] in detail
!
!--
subroutine PutLineInt1( array, lbounds, ubounds, unit, indent, sd )
  use dc_types, only: DP, STRING, STDOUT
  use dc_string, only: toChar, Printf, CPrintf
  use dc_present, only: present_and_true
  implicit none
  integer, intent(in):: array(:)
  integer, intent(in), optional:: lbounds(1)
  integer, intent(in), optional:: ubounds(1)
  integer, intent(in), optional:: unit
  character(*), intent(in), optional:: indent
  logical, intent(in), optional:: sd
  integer:: out_unit
  integer:: indent_len
  character(STRING):: indent_str
  integer:: i
  integer:: alldim_size, lbound_nums(1), ubound_nums(1)
  character(STRING):: size_str, sd_str
  integer:: max_value, min_value
  integer, allocatable:: array_packed(:)
  real(DP) :: avg_value, variance_value, sd_value
  continue
  !-----------------------------------------------------------------
  !  オプショナル引数のチェック
  !  Check optional arguments
  !-----------------------------------------------------------------
  if ( present(unit) ) then
    out_unit = unit
  else
    out_unit = STDOUT
  end if
  indent_len = 0
  indent_str = ''
  if ( present(indent) ) then
    if (len(indent) /= 0) then
      indent_len = len(indent)
      indent_str(1:indent_len) = indent
    end if
  end if
  !-------------------------------------------------------------------
  !  配列サイズ
  !  Array size
  !-------------------------------------------------------------------
  if ( present(lbounds) .and. present(ubounds) ) then
    lbound_nums = lbounds
    ubound_nums = ubounds
  else
    lbound_nums(1) = lbound( array, 1 )
    ubound_nums(1) = ubound( array, 1 )
  end if
  size_str = '('
  size_str = trim(size_str) // trim(toChar(lbound_nums(1))) // ':'
  size_str = trim(size_str) // trim(toChar(ubound_nums(1)))
  size_str = trim(size_str) // ')'
  !-------------------------------------------------------------------
  !  最大値
  !  Maximum value
  !-------------------------------------------------------------------
  max_value = maxval(array)
  !-------------------------------------------------------------------
  !  最小値
  !  Minimum value
  !-------------------------------------------------------------------
  min_value = minval(array)
  !-------------------------------------------------------------------
  !  平均値
  !  Average value
  !-------------------------------------------------------------------
  alldim_size = size(array)
  avg_value = sum(array) / dble(alldim_size)
  !-------------------------------------------------------------------
  !  標準偏差
  !  Standard deviation
  !-------------------------------------------------------------------
  sd_value = 0.0D0
  variance_value = 0.0D0
  sd_str = ''
  if ( present_and_true( sd ) ) then
    if ( alldim_size > 1 ) then
      if (allocated(array_packed)) then
        deallocate(array_packed)
      end if
      allocate( array_packed(alldim_size) )
      array_packed = array
      do i = 1, alldim_size
        variance_value = variance_value + &
          & (array_packed(i) - avg_value) * (array_packed(i) - avg_value)
      end do
      variance_value = variance_value / dble(alldim_size)
      sd_value = sqrt( variance_value )
      sd_str = CPrintf ( ' @sd=%f', d = (/ sd_value /) )
    end if
  end if
  !-------------------------------------------------------------------
  !  印字
  !  Print
  !-------------------------------------------------------------------
  call Printf(out_unit, &
    & indent_str(1:indent_len) // &
    & '#<INT-ARRAY:: @size=%c, @max=%d, @min=%d, @avg=%f%c>', &
    & i = (/max_value, min_value/), d = (/avg_value/), &
    & c1 = trim(size_str), c2 = trim(sd_str) )
end subroutine PutLineInt1
subroutine PutLineInt2( array, lbounds, ubounds, unit, indent, sd )
  use dc_types, only: DP, STRING, STDOUT
  use dc_string, only: toChar, Printf, CPrintf
  use dc_present, only: present_and_true
  implicit none
  integer, intent(in):: array(:,:)
  integer, intent(in), optional:: lbounds(2)
  integer, intent(in), optional:: ubounds(2)
  integer, intent(in), optional:: unit
  character(*), intent(in), optional:: indent
  logical, intent(in), optional:: sd
  integer:: out_unit
  integer:: indent_len
  character(STRING):: indent_str
  integer:: i
  integer:: alldim_size, lbound_nums(2), ubound_nums(2)
  character(STRING):: size_str, sd_str
  integer:: max_value, min_value
  integer, allocatable:: array_packed(:)
  real(DP) :: avg_value, variance_value, sd_value
  continue
  !-----------------------------------------------------------------
  !  オプショナル引数のチェック
  !  Check optional arguments
  !-----------------------------------------------------------------
  if ( present(unit) ) then
    out_unit = unit
  else
    out_unit = STDOUT
  end if
  indent_len = 0
  indent_str = ''
  if ( present(indent) ) then
    if (len(indent) /= 0) then
      indent_len = len(indent)
      indent_str(1:indent_len) = indent
    end if
  end if
  !-------------------------------------------------------------------
  !  配列サイズ
  !  Array size
  !-------------------------------------------------------------------
  if ( present(lbounds) .and. present(ubounds) ) then
    lbound_nums = lbounds
    ubound_nums = ubounds
  else
    lbound_nums(1) = lbound( array, 1 )
    ubound_nums(1) = ubound( array, 1 )
    lbound_nums(2) = lbound( array, 2 )
    ubound_nums(2) = ubound( array, 2 )
  end if
  size_str = '('
  size_str = trim(size_str) // trim(toChar(lbound_nums(1))) // ':'
  size_str = trim(size_str) // trim(toChar(ubound_nums(1)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(2)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(2)))
  size_str = trim(size_str) // ')'
  !-------------------------------------------------------------------
  !  最大値
  !  Maximum value
  !-------------------------------------------------------------------
  max_value = maxval(array)
  !-------------------------------------------------------------------
  !  最小値
  !  Minimum value
  !-------------------------------------------------------------------
  min_value = minval(array)
  !-------------------------------------------------------------------
  !  平均値
  !  Average value
  !-------------------------------------------------------------------
  alldim_size = size(array)
  avg_value = sum(array) / dble(alldim_size)
  !-------------------------------------------------------------------
  !  標準偏差
  !  Standard deviation
  !-------------------------------------------------------------------
  sd_value = 0.0D0
  variance_value = 0.0D0
  sd_str = ''
  if ( present_and_true( sd ) ) then
    if ( alldim_size > 1 ) then
      if (allocated(array_packed)) then
        deallocate(array_packed)
      end if
      allocate( array_packed(alldim_size) )
      array_packed = pack(array, .true.)
      do i = 1, alldim_size
        variance_value = variance_value + &
          & (array_packed(i) - avg_value) * (array_packed(i) - avg_value)
      end do
      variance_value = variance_value / dble(alldim_size)
      sd_value = sqrt( variance_value )
      sd_str = CPrintf ( ' @sd=%f', d = (/ sd_value /) )
    end if
  end if
  !-------------------------------------------------------------------
  !  印字
  !  Print
  !-------------------------------------------------------------------
  call Printf(out_unit, &
    & indent_str(1:indent_len) // &
    & '#<INT-ARRAY:: @size=%c, @max=%d, @min=%d, @avg=%f%c>', &
    & i = (/max_value, min_value/), d = (/avg_value/), &
    & c1 = trim(size_str), c2 = trim(sd_str) )
end subroutine PutLineInt2
subroutine PutLineInt3( array, lbounds, ubounds, unit, indent, sd )
  use dc_types, only: DP, STRING, STDOUT
  use dc_string, only: toChar, Printf, CPrintf
  use dc_present, only: present_and_true
  implicit none
  integer, intent(in):: array(:,:,:)
  integer, intent(in), optional:: lbounds(3)
  integer, intent(in), optional:: ubounds(3)
  integer, intent(in), optional:: unit
  character(*), intent(in), optional:: indent
  logical, intent(in), optional:: sd
  integer:: out_unit
  integer:: indent_len
  character(STRING):: indent_str
  integer:: i
  integer:: alldim_size, lbound_nums(3), ubound_nums(3)
  character(STRING):: size_str, sd_str
  integer:: max_value, min_value
  integer, allocatable:: array_packed(:)
  real(DP) :: avg_value, variance_value, sd_value
  continue
  !-----------------------------------------------------------------
  !  オプショナル引数のチェック
  !  Check optional arguments
  !-----------------------------------------------------------------
  if ( present(unit) ) then
    out_unit = unit
  else
    out_unit = STDOUT
  end if
  indent_len = 0
  indent_str = ''
  if ( present(indent) ) then
    if (len(indent) /= 0) then
      indent_len = len(indent)
      indent_str(1:indent_len) = indent
    end if
  end if
  !-------------------------------------------------------------------
  !  配列サイズ
  !  Array size
  !-------------------------------------------------------------------
  if ( present(lbounds) .and. present(ubounds) ) then
    lbound_nums = lbounds
    ubound_nums = ubounds
  else
    lbound_nums(1) = lbound( array, 1 )
    ubound_nums(1) = ubound( array, 1 )
    lbound_nums(2) = lbound( array, 2 )
    ubound_nums(2) = ubound( array, 2 )
    lbound_nums(3) = lbound( array, 3 )
    ubound_nums(3) = ubound( array, 3 )
  end if
  size_str = '('
  size_str = trim(size_str) // trim(toChar(lbound_nums(1))) // ':'
  size_str = trim(size_str) // trim(toChar(ubound_nums(1)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(2)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(2)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(3)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(3)))
  size_str = trim(size_str) // ')'
  !-------------------------------------------------------------------
  !  最大値
  !  Maximum value
  !-------------------------------------------------------------------
  max_value = maxval(array)
  !-------------------------------------------------------------------
  !  最小値
  !  Minimum value
  !-------------------------------------------------------------------
  min_value = minval(array)
  !-------------------------------------------------------------------
  !  平均値
  !  Average value
  !-------------------------------------------------------------------
  alldim_size = size(array)
  avg_value = sum(array) / dble(alldim_size)
  !-------------------------------------------------------------------
  !  標準偏差
  !  Standard deviation
  !-------------------------------------------------------------------
  sd_value = 0.0D0
  variance_value = 0.0D0
  sd_str = ''
  if ( present_and_true( sd ) ) then
    if ( alldim_size > 1 ) then
      if (allocated(array_packed)) then
        deallocate(array_packed)
      end if
      allocate( array_packed(alldim_size) )
      array_packed = pack(array, .true.)
      do i = 1, alldim_size
        variance_value = variance_value + &
          & (array_packed(i) - avg_value) * (array_packed(i) - avg_value)
      end do
      variance_value = variance_value / dble(alldim_size)
      sd_value = sqrt( variance_value )
      sd_str = CPrintf ( ' @sd=%f', d = (/ sd_value /) )
    end if
  end if
  !-------------------------------------------------------------------
  !  印字
  !  Print
  !-------------------------------------------------------------------
  call Printf(out_unit, &
    & indent_str(1:indent_len) // &
    & '#<INT-ARRAY:: @size=%c, @max=%d, @min=%d, @avg=%f%c>', &
    & i = (/max_value, min_value/), d = (/avg_value/), &
    & c1 = trim(size_str), c2 = trim(sd_str) )
end subroutine PutLineInt3
subroutine PutLineInt4( array, lbounds, ubounds, unit, indent, sd )
  use dc_types, only: DP, STRING, STDOUT
  use dc_string, only: toChar, Printf, CPrintf
  use dc_present, only: present_and_true
  implicit none
  integer, intent(in):: array(:,:,:,:)
  integer, intent(in), optional:: lbounds(4)
  integer, intent(in), optional:: ubounds(4)
  integer, intent(in), optional:: unit
  character(*), intent(in), optional:: indent
  logical, intent(in), optional:: sd
  integer:: out_unit
  integer:: indent_len
  character(STRING):: indent_str
  integer:: i
  integer:: alldim_size, lbound_nums(4), ubound_nums(4)
  character(STRING):: size_str, sd_str
  integer:: max_value, min_value
  integer, allocatable:: array_packed(:)
  real(DP) :: avg_value, variance_value, sd_value
  continue
  !-----------------------------------------------------------------
  !  オプショナル引数のチェック
  !  Check optional arguments
  !-----------------------------------------------------------------
  if ( present(unit) ) then
    out_unit = unit
  else
    out_unit = STDOUT
  end if
  indent_len = 0
  indent_str = ''
  if ( present(indent) ) then
    if (len(indent) /= 0) then
      indent_len = len(indent)
      indent_str(1:indent_len) = indent
    end if
  end if
  !-------------------------------------------------------------------
  !  配列サイズ
  !  Array size
  !-------------------------------------------------------------------
  if ( present(lbounds) .and. present(ubounds) ) then
    lbound_nums = lbounds
    ubound_nums = ubounds
  else
    lbound_nums(1) = lbound( array, 1 )
    ubound_nums(1) = ubound( array, 1 )
    lbound_nums(2) = lbound( array, 2 )
    ubound_nums(2) = ubound( array, 2 )
    lbound_nums(3) = lbound( array, 3 )
    ubound_nums(3) = ubound( array, 3 )
    lbound_nums(4) = lbound( array, 4 )
    ubound_nums(4) = ubound( array, 4 )
  end if
  size_str = '('
  size_str = trim(size_str) // trim(toChar(lbound_nums(1))) // ':'
  size_str = trim(size_str) // trim(toChar(ubound_nums(1)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(2)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(2)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(3)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(3)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(4)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(4)))
  size_str = trim(size_str) // ')'
  !-------------------------------------------------------------------
  !  最大値
  !  Maximum value
  !-------------------------------------------------------------------
  max_value = maxval(array)
  !-------------------------------------------------------------------
  !  最小値
  !  Minimum value
  !-------------------------------------------------------------------
  min_value = minval(array)
  !-------------------------------------------------------------------
  !  平均値
  !  Average value
  !-------------------------------------------------------------------
  alldim_size = size(array)
  avg_value = sum(array) / dble(alldim_size)
  !-------------------------------------------------------------------
  !  標準偏差
  !  Standard deviation
  !-------------------------------------------------------------------
  sd_value = 0.0D0
  variance_value = 0.0D0
  sd_str = ''
  if ( present_and_true( sd ) ) then
    if ( alldim_size > 1 ) then
      if (allocated(array_packed)) then
        deallocate(array_packed)
      end if
      allocate( array_packed(alldim_size) )
      array_packed = pack(array, .true.)
      do i = 1, alldim_size
        variance_value = variance_value + &
          & (array_packed(i) - avg_value) * (array_packed(i) - avg_value)
      end do
      variance_value = variance_value / dble(alldim_size)
      sd_value = sqrt( variance_value )
      sd_str = CPrintf ( ' @sd=%f', d = (/ sd_value /) )
    end if
  end if
  !-------------------------------------------------------------------
  !  印字
  !  Print
  !-------------------------------------------------------------------
  call Printf(out_unit, &
    & indent_str(1:indent_len) // &
    & '#<INT-ARRAY:: @size=%c, @max=%d, @min=%d, @avg=%f%c>', &
    & i = (/max_value, min_value/), d = (/avg_value/), &
    & c1 = trim(size_str), c2 = trim(sd_str) )
end subroutine PutLineInt4
subroutine PutLineInt5( array, lbounds, ubounds, unit, indent, sd )
  use dc_types, only: DP, STRING, STDOUT
  use dc_string, only: toChar, Printf, CPrintf
  use dc_present, only: present_and_true
  implicit none
  integer, intent(in):: array(:,:,:,:,:)
  integer, intent(in), optional:: lbounds(5)
  integer, intent(in), optional:: ubounds(5)
  integer, intent(in), optional:: unit
  character(*), intent(in), optional:: indent
  logical, intent(in), optional:: sd
  integer:: out_unit
  integer:: indent_len
  character(STRING):: indent_str
  integer:: i
  integer:: alldim_size, lbound_nums(5), ubound_nums(5)
  character(STRING):: size_str, sd_str
  integer:: max_value, min_value
  integer, allocatable:: array_packed(:)
  real(DP) :: avg_value, variance_value, sd_value
  continue
  !-----------------------------------------------------------------
  !  オプショナル引数のチェック
  !  Check optional arguments
  !-----------------------------------------------------------------
  if ( present(unit) ) then
    out_unit = unit
  else
    out_unit = STDOUT
  end if
  indent_len = 0
  indent_str = ''
  if ( present(indent) ) then
    if (len(indent) /= 0) then
      indent_len = len(indent)
      indent_str(1:indent_len) = indent
    end if
  end if
  !-------------------------------------------------------------------
  !  配列サイズ
  !  Array size
  !-------------------------------------------------------------------
  if ( present(lbounds) .and. present(ubounds) ) then
    lbound_nums = lbounds
    ubound_nums = ubounds
  else
    lbound_nums(1) = lbound( array, 1 )
    ubound_nums(1) = ubound( array, 1 )
    lbound_nums(2) = lbound( array, 2 )
    ubound_nums(2) = ubound( array, 2 )
    lbound_nums(3) = lbound( array, 3 )
    ubound_nums(3) = ubound( array, 3 )
    lbound_nums(4) = lbound( array, 4 )
    ubound_nums(4) = ubound( array, 4 )
    lbound_nums(5) = lbound( array, 5 )
    ubound_nums(5) = ubound( array, 5 )
  end if
  size_str = '('
  size_str = trim(size_str) // trim(toChar(lbound_nums(1))) // ':'
  size_str = trim(size_str) // trim(toChar(ubound_nums(1)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(2)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(2)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(3)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(3)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(4)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(4)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(5)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(5)))
  size_str = trim(size_str) // ')'
  !-------------------------------------------------------------------
  !  最大値
  !  Maximum value
  !-------------------------------------------------------------------
  max_value = maxval(array)
  !-------------------------------------------------------------------
  !  最小値
  !  Minimum value
  !-------------------------------------------------------------------
  min_value = minval(array)
  !-------------------------------------------------------------------
  !  平均値
  !  Average value
  !-------------------------------------------------------------------
  alldim_size = size(array)
  avg_value = sum(array) / dble(alldim_size)
  !-------------------------------------------------------------------
  !  標準偏差
  !  Standard deviation
  !-------------------------------------------------------------------
  sd_value = 0.0D0
  variance_value = 0.0D0
  sd_str = ''
  if ( present_and_true( sd ) ) then
    if ( alldim_size > 1 ) then
      if (allocated(array_packed)) then
        deallocate(array_packed)
      end if
      allocate( array_packed(alldim_size) )
      array_packed = pack(array, .true.)
      do i = 1, alldim_size
        variance_value = variance_value + &
          & (array_packed(i) - avg_value) * (array_packed(i) - avg_value)
      end do
      variance_value = variance_value / dble(alldim_size)
      sd_value = sqrt( variance_value )
      sd_str = CPrintf ( ' @sd=%f', d = (/ sd_value /) )
    end if
  end if
  !-------------------------------------------------------------------
  !  印字
  !  Print
  !-------------------------------------------------------------------
  call Printf(out_unit, &
    & indent_str(1:indent_len) // &
    & '#<INT-ARRAY:: @size=%c, @max=%d, @min=%d, @avg=%f%c>', &
    & i = (/max_value, min_value/), d = (/avg_value/), &
    & c1 = trim(size_str), c2 = trim(sd_str) )
end subroutine PutLineInt5
subroutine PutLineInt6( array, lbounds, ubounds, unit, indent, sd )
  use dc_types, only: DP, STRING, STDOUT
  use dc_string, only: toChar, Printf, CPrintf
  use dc_present, only: present_and_true
  implicit none
  integer, intent(in):: array(:,:,:,:,:,:)
  integer, intent(in), optional:: lbounds(6)
  integer, intent(in), optional:: ubounds(6)
  integer, intent(in), optional:: unit
  character(*), intent(in), optional:: indent
  logical, intent(in), optional:: sd
  integer:: out_unit
  integer:: indent_len
  character(STRING):: indent_str
  integer:: i
  integer:: alldim_size, lbound_nums(6), ubound_nums(6)
  character(STRING):: size_str, sd_str
  integer:: max_value, min_value
  integer, allocatable:: array_packed(:)
  real(DP) :: avg_value, variance_value, sd_value
  continue
  !-----------------------------------------------------------------
  !  オプショナル引数のチェック
  !  Check optional arguments
  !-----------------------------------------------------------------
  if ( present(unit) ) then
    out_unit = unit
  else
    out_unit = STDOUT
  end if
  indent_len = 0
  indent_str = ''
  if ( present(indent) ) then
    if (len(indent) /= 0) then
      indent_len = len(indent)
      indent_str(1:indent_len) = indent
    end if
  end if
  !-------------------------------------------------------------------
  !  配列サイズ
  !  Array size
  !-------------------------------------------------------------------
  if ( present(lbounds) .and. present(ubounds) ) then
    lbound_nums = lbounds
    ubound_nums = ubounds
  else
    lbound_nums(1) = lbound( array, 1 )
    ubound_nums(1) = ubound( array, 1 )
    lbound_nums(2) = lbound( array, 2 )
    ubound_nums(2) = ubound( array, 2 )
    lbound_nums(3) = lbound( array, 3 )
    ubound_nums(3) = ubound( array, 3 )
    lbound_nums(4) = lbound( array, 4 )
    ubound_nums(4) = ubound( array, 4 )
    lbound_nums(5) = lbound( array, 5 )
    ubound_nums(5) = ubound( array, 5 )
    lbound_nums(6) = lbound( array, 6 )
    ubound_nums(6) = ubound( array, 6 )
  end if
  size_str = '('
  size_str = trim(size_str) // trim(toChar(lbound_nums(1))) // ':'
  size_str = trim(size_str) // trim(toChar(ubound_nums(1)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(2)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(2)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(3)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(3)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(4)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(4)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(5)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(5)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(6)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(6)))
  size_str = trim(size_str) // ')'
  !-------------------------------------------------------------------
  !  最大値
  !  Maximum value
  !-------------------------------------------------------------------
  max_value = maxval(array)
  !-------------------------------------------------------------------
  !  最小値
  !  Minimum value
  !-------------------------------------------------------------------
  min_value = minval(array)
  !-------------------------------------------------------------------
  !  平均値
  !  Average value
  !-------------------------------------------------------------------
  alldim_size = size(array)
  avg_value = sum(array) / dble(alldim_size)
  !-------------------------------------------------------------------
  !  標準偏差
  !  Standard deviation
  !-------------------------------------------------------------------
  sd_value = 0.0D0
  variance_value = 0.0D0
  sd_str = ''
  if ( present_and_true( sd ) ) then
    if ( alldim_size > 1 ) then
      if (allocated(array_packed)) then
        deallocate(array_packed)
      end if
      allocate( array_packed(alldim_size) )
      array_packed = pack(array, .true.)
      do i = 1, alldim_size
        variance_value = variance_value + &
          & (array_packed(i) - avg_value) * (array_packed(i) - avg_value)
      end do
      variance_value = variance_value / dble(alldim_size)
      sd_value = sqrt( variance_value )
      sd_str = CPrintf ( ' @sd=%f', d = (/ sd_value /) )
    end if
  end if
  !-------------------------------------------------------------------
  !  印字
  !  Print
  !-------------------------------------------------------------------
  call Printf(out_unit, &
    & indent_str(1:indent_len) // &
    & '#<INT-ARRAY:: @size=%c, @max=%d, @min=%d, @avg=%f%c>', &
    & i = (/max_value, min_value/), d = (/avg_value/), &
    & c1 = trim(size_str), c2 = trim(sd_str) )
end subroutine PutLineInt6
subroutine PutLineInt7( array, lbounds, ubounds, unit, indent, sd )
  use dc_types, only: DP, STRING, STDOUT
  use dc_string, only: toChar, Printf, CPrintf
  use dc_present, only: present_and_true
  implicit none
  integer, intent(in):: array(:,:,:,:,:,:,:)
  integer, intent(in), optional:: lbounds(7)
  integer, intent(in), optional:: ubounds(7)
  integer, intent(in), optional:: unit
  character(*), intent(in), optional:: indent
  logical, intent(in), optional:: sd
  integer:: out_unit
  integer:: indent_len
  character(STRING):: indent_str
  integer:: i
  integer:: alldim_size, lbound_nums(7), ubound_nums(7)
  character(STRING):: size_str, sd_str
  integer:: max_value, min_value
  integer, allocatable:: array_packed(:)
  real(DP) :: avg_value, variance_value, sd_value
  continue
  !-----------------------------------------------------------------
  !  オプショナル引数のチェック
  !  Check optional arguments
  !-----------------------------------------------------------------
  if ( present(unit) ) then
    out_unit = unit
  else
    out_unit = STDOUT
  end if
  indent_len = 0
  indent_str = ''
  if ( present(indent) ) then
    if (len(indent) /= 0) then
      indent_len = len(indent)
      indent_str(1:indent_len) = indent
    end if
  end if
  !-------------------------------------------------------------------
  !  配列サイズ
  !  Array size
  !-------------------------------------------------------------------
  if ( present(lbounds) .and. present(ubounds) ) then
    lbound_nums = lbounds
    ubound_nums = ubounds
  else
    lbound_nums(1) = lbound( array, 1 )
    ubound_nums(1) = ubound( array, 1 )
    lbound_nums(2) = lbound( array, 2 )
    ubound_nums(2) = ubound( array, 2 )
    lbound_nums(3) = lbound( array, 3 )
    ubound_nums(3) = ubound( array, 3 )
    lbound_nums(4) = lbound( array, 4 )
    ubound_nums(4) = ubound( array, 4 )
    lbound_nums(5) = lbound( array, 5 )
    ubound_nums(5) = ubound( array, 5 )
    lbound_nums(6) = lbound( array, 6 )
    ubound_nums(6) = ubound( array, 6 )
    lbound_nums(7) = lbound( array, 7 )
    ubound_nums(7) = ubound( array, 7 )
  end if
  size_str = '('
  size_str = trim(size_str) // trim(toChar(lbound_nums(1))) // ':'
  size_str = trim(size_str) // trim(toChar(ubound_nums(1)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(2)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(2)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(3)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(3)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(4)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(4)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(5)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(5)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(6)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(6)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(7)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(7)))
  size_str = trim(size_str) // ')'
  !-------------------------------------------------------------------
  !  最大値
  !  Maximum value
  !-------------------------------------------------------------------
  max_value = maxval(array)
  !-------------------------------------------------------------------
  !  最小値
  !  Minimum value
  !-------------------------------------------------------------------
  min_value = minval(array)
  !-------------------------------------------------------------------
  !  平均値
  !  Average value
  !-------------------------------------------------------------------
  alldim_size = size(array)
  avg_value = sum(array) / dble(alldim_size)
  !-------------------------------------------------------------------
  !  標準偏差
  !  Standard deviation
  !-------------------------------------------------------------------
  sd_value = 0.0D0
  variance_value = 0.0D0
  sd_str = ''
  if ( present_and_true( sd ) ) then
    if ( alldim_size > 1 ) then
      if (allocated(array_packed)) then
        deallocate(array_packed)
      end if
      allocate( array_packed(alldim_size) )
      array_packed = pack(array, .true.)
      do i = 1, alldim_size
        variance_value = variance_value + &
          & (array_packed(i) - avg_value) * (array_packed(i) - avg_value)
      end do
      variance_value = variance_value / dble(alldim_size)
      sd_value = sqrt( variance_value )
      sd_str = CPrintf ( ' @sd=%f', d = (/ sd_value /) )
    end if
  end if
  !-------------------------------------------------------------------
  !  印字
  !  Print
  !-------------------------------------------------------------------
  call Printf(out_unit, &
    & indent_str(1:indent_len) // &
    & '#<INT-ARRAY:: @size=%c, @max=%d, @min=%d, @avg=%f%c>', &
    & i = (/max_value, min_value/), d = (/avg_value/), &
    & c1 = trim(size_str), c2 = trim(sd_str) )
end subroutine PutLineInt7
subroutine PutLineReal1( array, lbounds, ubounds, unit, indent, sd )
  use dc_types, only: DP, STRING, STDOUT,SP
  use dc_string, only: toChar, Printf, CPrintf
  use dc_present, only: present_and_true
  implicit none
  real(SP), intent(in):: array(:)
  integer, intent(in), optional:: lbounds(1)
  integer, intent(in), optional:: ubounds(1)
  integer, intent(in), optional:: unit
  character(*), intent(in), optional:: indent
  logical, intent(in), optional:: sd
  integer:: out_unit
  integer:: indent_len
  character(STRING):: indent_str
  integer:: i
  integer:: alldim_size, lbound_nums(1), ubound_nums(1)
  character(STRING):: size_str, sd_str
  real(SP) :: max_value, min_value
  real(SP), allocatable :: array_packed(:)
  real(DP) :: avg_value, variance_value, sd_value
  continue
  !-----------------------------------------------------------------
  !  オプショナル引数のチェック
  !  Check optional arguments
  !-----------------------------------------------------------------
  if ( present(unit) ) then
    out_unit = unit
  else
    out_unit = STDOUT
  end if
  indent_len = 0
  indent_str = ''
  if ( present(indent) ) then
    if (len(indent) /= 0) then
      indent_len = len(indent)
      indent_str(1:indent_len) = indent
    end if
  end if
  !-------------------------------------------------------------------
  !  配列サイズ
  !  Array size
  !-------------------------------------------------------------------
  if ( present(lbounds) .and. present(ubounds) ) then
    lbound_nums = lbounds
    ubound_nums = ubounds
  else
    lbound_nums(1) = lbound( array, 1 )
    ubound_nums(1) = ubound( array, 1 )
  end if
  size_str = '('
  size_str = trim(size_str) // trim(toChar(lbound_nums(1))) // ':'
  size_str = trim(size_str) // trim(toChar(ubound_nums(1)))
  size_str = trim(size_str) // ')'
  !-------------------------------------------------------------------
  !  最大値
  !  Maximum value
  !-------------------------------------------------------------------
  max_value = maxval(array)
  !-------------------------------------------------------------------
  !  最小値
  !  Minimum value
  !-------------------------------------------------------------------
  min_value = minval(array)
  !-------------------------------------------------------------------
  !  平均値
  !  Average value
  !-------------------------------------------------------------------
  alldim_size = size(array)
  avg_value = sum(array) / dble(alldim_size)
  !-------------------------------------------------------------------
  !  標準偏差
  !  Standard deviation
  !-------------------------------------------------------------------
  sd_value = 0.0D0
  variance_value = 0.0D0
  sd_str = ''
  if ( present_and_true( sd ) ) then
    if ( alldim_size > 1 ) then
      if (allocated(array_packed)) then
        deallocate(array_packed)
      end if
      allocate( array_packed(alldim_size) )
      array_packed = array
      do i = 1, alldim_size
        variance_value = variance_value + &
          & (array_packed(i) - avg_value) * (array_packed(i) - avg_value)
      end do
      variance_value = variance_value / dble(alldim_size)
      sd_value = sqrt( variance_value )
      sd_str = CPrintf ( ' @sd=%f', d = (/ sd_value /) )
    end if
  end if
  !-------------------------------------------------------------------
  !  印字
  !  Print
  !-------------------------------------------------------------------
  call Printf(out_unit, &
    & indent_str(1:indent_len) // &
    & '#<SP-ARRAY:: @size=%c, @max=%r, @min=%r, @avg=%f%c>', &
    & r = (/max_value, min_value/), d = (/avg_value/), &
    & c1 = trim(size_str), c2 = trim(sd_str) )
end subroutine PutLineReal1
subroutine PutLineReal2( array, lbounds, ubounds, unit, indent, sd )
  use dc_types, only: DP, STRING, STDOUT,SP
  use dc_string, only: toChar, Printf, CPrintf
  use dc_present, only: present_and_true
  implicit none
  real(SP), intent(in):: array(:,:)
  integer, intent(in), optional:: lbounds(2)
  integer, intent(in), optional:: ubounds(2)
  integer, intent(in), optional:: unit
  character(*), intent(in), optional:: indent
  logical, intent(in), optional:: sd
  integer:: out_unit
  integer:: indent_len
  character(STRING):: indent_str
  integer:: i
  integer:: alldim_size, lbound_nums(2), ubound_nums(2)
  character(STRING):: size_str, sd_str
  real(SP) :: max_value, min_value
  real(SP), allocatable :: array_packed(:)
  real(DP) :: avg_value, variance_value, sd_value
  continue
  !-----------------------------------------------------------------
  !  オプショナル引数のチェック
  !  Check optional arguments
  !-----------------------------------------------------------------
  if ( present(unit) ) then
    out_unit = unit
  else
    out_unit = STDOUT
  end if
  indent_len = 0
  indent_str = ''
  if ( present(indent) ) then
    if (len(indent) /= 0) then
      indent_len = len(indent)
      indent_str(1:indent_len) = indent
    end if
  end if
  !-------------------------------------------------------------------
  !  配列サイズ
  !  Array size
  !-------------------------------------------------------------------
  if ( present(lbounds) .and. present(ubounds) ) then
    lbound_nums = lbounds
    ubound_nums = ubounds
  else
    lbound_nums(1) = lbound( array, 1 )
    ubound_nums(1) = ubound( array, 1 )
    lbound_nums(2) = lbound( array, 2 )
    ubound_nums(2) = ubound( array, 2 )
  end if
  size_str = '('
  size_str = trim(size_str) // trim(toChar(lbound_nums(1))) // ':'
  size_str = trim(size_str) // trim(toChar(ubound_nums(1)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(2)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(2)))
  size_str = trim(size_str) // ')'
  !-------------------------------------------------------------------
  !  最大値
  !  Maximum value
  !-------------------------------------------------------------------
  max_value = maxval(array)
  !-------------------------------------------------------------------
  !  最小値
  !  Minimum value
  !-------------------------------------------------------------------
  min_value = minval(array)
  !-------------------------------------------------------------------
  !  平均値
  !  Average value
  !-------------------------------------------------------------------
  alldim_size = size(array)
  avg_value = sum(array) / dble(alldim_size)
  !-------------------------------------------------------------------
  !  標準偏差
  !  Standard deviation
  !-------------------------------------------------------------------
  sd_value = 0.0D0
  variance_value = 0.0D0
  sd_str = ''
  if ( present_and_true( sd ) ) then
    if ( alldim_size > 1 ) then
      if (allocated(array_packed)) then
        deallocate(array_packed)
      end if
      allocate( array_packed(alldim_size) )
      array_packed = pack(array, .true.)
      do i = 1, alldim_size
        variance_value = variance_value + &
          & (array_packed(i) - avg_value) * (array_packed(i) - avg_value)
      end do
      variance_value = variance_value / dble(alldim_size)
      sd_value = sqrt( variance_value )
      sd_str = CPrintf ( ' @sd=%f', d = (/ sd_value /) )
    end if
  end if
  !-------------------------------------------------------------------
  !  印字
  !  Print
  !-------------------------------------------------------------------
  call Printf(out_unit, &
    & indent_str(1:indent_len) // &
    & '#<SP-ARRAY:: @size=%c, @max=%r, @min=%r, @avg=%f%c>', &
    & r = (/max_value, min_value/), d = (/avg_value/), &
    & c1 = trim(size_str), c2 = trim(sd_str) )
end subroutine PutLineReal2
subroutine PutLineReal3( array, lbounds, ubounds, unit, indent, sd )
  use dc_types, only: DP, STRING, STDOUT,SP
  use dc_string, only: toChar, Printf, CPrintf
  use dc_present, only: present_and_true
  implicit none
  real(SP), intent(in):: array(:,:,:)
  integer, intent(in), optional:: lbounds(3)
  integer, intent(in), optional:: ubounds(3)
  integer, intent(in), optional:: unit
  character(*), intent(in), optional:: indent
  logical, intent(in), optional:: sd
  integer:: out_unit
  integer:: indent_len
  character(STRING):: indent_str
  integer:: i
  integer:: alldim_size, lbound_nums(3), ubound_nums(3)
  character(STRING):: size_str, sd_str
  real(SP) :: max_value, min_value
  real(SP), allocatable :: array_packed(:)
  real(DP) :: avg_value, variance_value, sd_value
  continue
  !-----------------------------------------------------------------
  !  オプショナル引数のチェック
  !  Check optional arguments
  !-----------------------------------------------------------------
  if ( present(unit) ) then
    out_unit = unit
  else
    out_unit = STDOUT
  end if
  indent_len = 0
  indent_str = ''
  if ( present(indent) ) then
    if (len(indent) /= 0) then
      indent_len = len(indent)
      indent_str(1:indent_len) = indent
    end if
  end if
  !-------------------------------------------------------------------
  !  配列サイズ
  !  Array size
  !-------------------------------------------------------------------
  if ( present(lbounds) .and. present(ubounds) ) then
    lbound_nums = lbounds
    ubound_nums = ubounds
  else
    lbound_nums(1) = lbound( array, 1 )
    ubound_nums(1) = ubound( array, 1 )
    lbound_nums(2) = lbound( array, 2 )
    ubound_nums(2) = ubound( array, 2 )
    lbound_nums(3) = lbound( array, 3 )
    ubound_nums(3) = ubound( array, 3 )
  end if
  size_str = '('
  size_str = trim(size_str) // trim(toChar(lbound_nums(1))) // ':'
  size_str = trim(size_str) // trim(toChar(ubound_nums(1)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(2)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(2)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(3)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(3)))
  size_str = trim(size_str) // ')'
  !-------------------------------------------------------------------
  !  最大値
  !  Maximum value
  !-------------------------------------------------------------------
  max_value = maxval(array)
  !-------------------------------------------------------------------
  !  最小値
  !  Minimum value
  !-------------------------------------------------------------------
  min_value = minval(array)
  !-------------------------------------------------------------------
  !  平均値
  !  Average value
  !-------------------------------------------------------------------
  alldim_size = size(array)
  avg_value = sum(array) / dble(alldim_size)
  !-------------------------------------------------------------------
  !  標準偏差
  !  Standard deviation
  !-------------------------------------------------------------------
  sd_value = 0.0D0
  variance_value = 0.0D0
  sd_str = ''
  if ( present_and_true( sd ) ) then
    if ( alldim_size > 1 ) then
      if (allocated(array_packed)) then
        deallocate(array_packed)
      end if
      allocate( array_packed(alldim_size) )
      array_packed = pack(array, .true.)
      do i = 1, alldim_size
        variance_value = variance_value + &
          & (array_packed(i) - avg_value) * (array_packed(i) - avg_value)
      end do
      variance_value = variance_value / dble(alldim_size)
      sd_value = sqrt( variance_value )
      sd_str = CPrintf ( ' @sd=%f', d = (/ sd_value /) )
    end if
  end if
  !-------------------------------------------------------------------
  !  印字
  !  Print
  !-------------------------------------------------------------------
  call Printf(out_unit, &
    & indent_str(1:indent_len) // &
    & '#<SP-ARRAY:: @size=%c, @max=%r, @min=%r, @avg=%f%c>', &
    & r = (/max_value, min_value/), d = (/avg_value/), &
    & c1 = trim(size_str), c2 = trim(sd_str) )
end subroutine PutLineReal3
subroutine PutLineReal4( array, lbounds, ubounds, unit, indent, sd )
  use dc_types, only: DP, STRING, STDOUT,SP
  use dc_string, only: toChar, Printf, CPrintf
  use dc_present, only: present_and_true
  implicit none
  real(SP), intent(in):: array(:,:,:,:)
  integer, intent(in), optional:: lbounds(4)
  integer, intent(in), optional:: ubounds(4)
  integer, intent(in), optional:: unit
  character(*), intent(in), optional:: indent
  logical, intent(in), optional:: sd
  integer:: out_unit
  integer:: indent_len
  character(STRING):: indent_str
  integer:: i
  integer:: alldim_size, lbound_nums(4), ubound_nums(4)
  character(STRING):: size_str, sd_str
  real(SP) :: max_value, min_value
  real(SP), allocatable :: array_packed(:)
  real(DP) :: avg_value, variance_value, sd_value
  continue
  !-----------------------------------------------------------------
  !  オプショナル引数のチェック
  !  Check optional arguments
  !-----------------------------------------------------------------
  if ( present(unit) ) then
    out_unit = unit
  else
    out_unit = STDOUT
  end if
  indent_len = 0
  indent_str = ''
  if ( present(indent) ) then
    if (len(indent) /= 0) then
      indent_len = len(indent)
      indent_str(1:indent_len) = indent
    end if
  end if
  !-------------------------------------------------------------------
  !  配列サイズ
  !  Array size
  !-------------------------------------------------------------------
  if ( present(lbounds) .and. present(ubounds) ) then
    lbound_nums = lbounds
    ubound_nums = ubounds
  else
    lbound_nums(1) = lbound( array, 1 )
    ubound_nums(1) = ubound( array, 1 )
    lbound_nums(2) = lbound( array, 2 )
    ubound_nums(2) = ubound( array, 2 )
    lbound_nums(3) = lbound( array, 3 )
    ubound_nums(3) = ubound( array, 3 )
    lbound_nums(4) = lbound( array, 4 )
    ubound_nums(4) = ubound( array, 4 )
  end if
  size_str = '('
  size_str = trim(size_str) // trim(toChar(lbound_nums(1))) // ':'
  size_str = trim(size_str) // trim(toChar(ubound_nums(1)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(2)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(2)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(3)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(3)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(4)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(4)))
  size_str = trim(size_str) // ')'
  !-------------------------------------------------------------------
  !  最大値
  !  Maximum value
  !-------------------------------------------------------------------
  max_value = maxval(array)
  !-------------------------------------------------------------------
  !  最小値
  !  Minimum value
  !-------------------------------------------------------------------
  min_value = minval(array)
  !-------------------------------------------------------------------
  !  平均値
  !  Average value
  !-------------------------------------------------------------------
  alldim_size = size(array)
  avg_value = sum(array) / dble(alldim_size)
  !-------------------------------------------------------------------
  !  標準偏差
  !  Standard deviation
  !-------------------------------------------------------------------
  sd_value = 0.0D0
  variance_value = 0.0D0
  sd_str = ''
  if ( present_and_true( sd ) ) then
    if ( alldim_size > 1 ) then
      if (allocated(array_packed)) then
        deallocate(array_packed)
      end if
      allocate( array_packed(alldim_size) )
      array_packed = pack(array, .true.)
      do i = 1, alldim_size
        variance_value = variance_value + &
          & (array_packed(i) - avg_value) * (array_packed(i) - avg_value)
      end do
      variance_value = variance_value / dble(alldim_size)
      sd_value = sqrt( variance_value )
      sd_str = CPrintf ( ' @sd=%f', d = (/ sd_value /) )
    end if
  end if
  !-------------------------------------------------------------------
  !  印字
  !  Print
  !-------------------------------------------------------------------
  call Printf(out_unit, &
    & indent_str(1:indent_len) // &
    & '#<SP-ARRAY:: @size=%c, @max=%r, @min=%r, @avg=%f%c>', &
    & r = (/max_value, min_value/), d = (/avg_value/), &
    & c1 = trim(size_str), c2 = trim(sd_str) )
end subroutine PutLineReal4
subroutine PutLineReal5( array, lbounds, ubounds, unit, indent, sd )
  use dc_types, only: DP, STRING, STDOUT,SP
  use dc_string, only: toChar, Printf, CPrintf
  use dc_present, only: present_and_true
  implicit none
  real(SP), intent(in):: array(:,:,:,:,:)
  integer, intent(in), optional:: lbounds(5)
  integer, intent(in), optional:: ubounds(5)
  integer, intent(in), optional:: unit
  character(*), intent(in), optional:: indent
  logical, intent(in), optional:: sd
  integer:: out_unit
  integer:: indent_len
  character(STRING):: indent_str
  integer:: i
  integer:: alldim_size, lbound_nums(5), ubound_nums(5)
  character(STRING):: size_str, sd_str
  real(SP) :: max_value, min_value
  real(SP), allocatable :: array_packed(:)
  real(DP) :: avg_value, variance_value, sd_value
  continue
  !-----------------------------------------------------------------
  !  オプショナル引数のチェック
  !  Check optional arguments
  !-----------------------------------------------------------------
  if ( present(unit) ) then
    out_unit = unit
  else
    out_unit = STDOUT
  end if
  indent_len = 0
  indent_str = ''
  if ( present(indent) ) then
    if (len(indent) /= 0) then
      indent_len = len(indent)
      indent_str(1:indent_len) = indent
    end if
  end if
  !-------------------------------------------------------------------
  !  配列サイズ
  !  Array size
  !-------------------------------------------------------------------
  if ( present(lbounds) .and. present(ubounds) ) then
    lbound_nums = lbounds
    ubound_nums = ubounds
  else
    lbound_nums(1) = lbound( array, 1 )
    ubound_nums(1) = ubound( array, 1 )
    lbound_nums(2) = lbound( array, 2 )
    ubound_nums(2) = ubound( array, 2 )
    lbound_nums(3) = lbound( array, 3 )
    ubound_nums(3) = ubound( array, 3 )
    lbound_nums(4) = lbound( array, 4 )
    ubound_nums(4) = ubound( array, 4 )
    lbound_nums(5) = lbound( array, 5 )
    ubound_nums(5) = ubound( array, 5 )
  end if
  size_str = '('
  size_str = trim(size_str) // trim(toChar(lbound_nums(1))) // ':'
  size_str = trim(size_str) // trim(toChar(ubound_nums(1)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(2)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(2)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(3)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(3)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(4)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(4)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(5)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(5)))
  size_str = trim(size_str) // ')'
  !-------------------------------------------------------------------
  !  最大値
  !  Maximum value
  !-------------------------------------------------------------------
  max_value = maxval(array)
  !-------------------------------------------------------------------
  !  最小値
  !  Minimum value
  !-------------------------------------------------------------------
  min_value = minval(array)
  !-------------------------------------------------------------------
  !  平均値
  !  Average value
  !-------------------------------------------------------------------
  alldim_size = size(array)
  avg_value = sum(array) / dble(alldim_size)
  !-------------------------------------------------------------------
  !  標準偏差
  !  Standard deviation
  !-------------------------------------------------------------------
  sd_value = 0.0D0
  variance_value = 0.0D0
  sd_str = ''
  if ( present_and_true( sd ) ) then
    if ( alldim_size > 1 ) then
      if (allocated(array_packed)) then
        deallocate(array_packed)
      end if
      allocate( array_packed(alldim_size) )
      array_packed = pack(array, .true.)
      do i = 1, alldim_size
        variance_value = variance_value + &
          & (array_packed(i) - avg_value) * (array_packed(i) - avg_value)
      end do
      variance_value = variance_value / dble(alldim_size)
      sd_value = sqrt( variance_value )
      sd_str = CPrintf ( ' @sd=%f', d = (/ sd_value /) )
    end if
  end if
  !-------------------------------------------------------------------
  !  印字
  !  Print
  !-------------------------------------------------------------------
  call Printf(out_unit, &
    & indent_str(1:indent_len) // &
    & '#<SP-ARRAY:: @size=%c, @max=%r, @min=%r, @avg=%f%c>', &
    & r = (/max_value, min_value/), d = (/avg_value/), &
    & c1 = trim(size_str), c2 = trim(sd_str) )
end subroutine PutLineReal5
subroutine PutLineReal6( array, lbounds, ubounds, unit, indent, sd )
  use dc_types, only: DP, STRING, STDOUT,SP
  use dc_string, only: toChar, Printf, CPrintf
  use dc_present, only: present_and_true
  implicit none
  real(SP), intent(in):: array(:,:,:,:,:,:)
  integer, intent(in), optional:: lbounds(6)
  integer, intent(in), optional:: ubounds(6)
  integer, intent(in), optional:: unit
  character(*), intent(in), optional:: indent
  logical, intent(in), optional:: sd
  integer:: out_unit
  integer:: indent_len
  character(STRING):: indent_str
  integer:: i
  integer:: alldim_size, lbound_nums(6), ubound_nums(6)
  character(STRING):: size_str, sd_str
  real(SP) :: max_value, min_value
  real(SP), allocatable :: array_packed(:)
  real(DP) :: avg_value, variance_value, sd_value
  continue
  !-----------------------------------------------------------------
  !  オプショナル引数のチェック
  !  Check optional arguments
  !-----------------------------------------------------------------
  if ( present(unit) ) then
    out_unit = unit
  else
    out_unit = STDOUT
  end if
  indent_len = 0
  indent_str = ''
  if ( present(indent) ) then
    if (len(indent) /= 0) then
      indent_len = len(indent)
      indent_str(1:indent_len) = indent
    end if
  end if
  !-------------------------------------------------------------------
  !  配列サイズ
  !  Array size
  !-------------------------------------------------------------------
  if ( present(lbounds) .and. present(ubounds) ) then
    lbound_nums = lbounds
    ubound_nums = ubounds
  else
    lbound_nums(1) = lbound( array, 1 )
    ubound_nums(1) = ubound( array, 1 )
    lbound_nums(2) = lbound( array, 2 )
    ubound_nums(2) = ubound( array, 2 )
    lbound_nums(3) = lbound( array, 3 )
    ubound_nums(3) = ubound( array, 3 )
    lbound_nums(4) = lbound( array, 4 )
    ubound_nums(4) = ubound( array, 4 )
    lbound_nums(5) = lbound( array, 5 )
    ubound_nums(5) = ubound( array, 5 )
    lbound_nums(6) = lbound( array, 6 )
    ubound_nums(6) = ubound( array, 6 )
  end if
  size_str = '('
  size_str = trim(size_str) // trim(toChar(lbound_nums(1))) // ':'
  size_str = trim(size_str) // trim(toChar(ubound_nums(1)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(2)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(2)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(3)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(3)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(4)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(4)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(5)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(5)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(6)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(6)))
  size_str = trim(size_str) // ')'
  !-------------------------------------------------------------------
  !  最大値
  !  Maximum value
  !-------------------------------------------------------------------
  max_value = maxval(array)
  !-------------------------------------------------------------------
  !  最小値
  !  Minimum value
  !-------------------------------------------------------------------
  min_value = minval(array)
  !-------------------------------------------------------------------
  !  平均値
  !  Average value
  !-------------------------------------------------------------------
  alldim_size = size(array)
  avg_value = sum(array) / dble(alldim_size)
  !-------------------------------------------------------------------
  !  標準偏差
  !  Standard deviation
  !-------------------------------------------------------------------
  sd_value = 0.0D0
  variance_value = 0.0D0
  sd_str = ''
  if ( present_and_true( sd ) ) then
    if ( alldim_size > 1 ) then
      if (allocated(array_packed)) then
        deallocate(array_packed)
      end if
      allocate( array_packed(alldim_size) )
      array_packed = pack(array, .true.)
      do i = 1, alldim_size
        variance_value = variance_value + &
          & (array_packed(i) - avg_value) * (array_packed(i) - avg_value)
      end do
      variance_value = variance_value / dble(alldim_size)
      sd_value = sqrt( variance_value )
      sd_str = CPrintf ( ' @sd=%f', d = (/ sd_value /) )
    end if
  end if
  !-------------------------------------------------------------------
  !  印字
  !  Print
  !-------------------------------------------------------------------
  call Printf(out_unit, &
    & indent_str(1:indent_len) // &
    & '#<SP-ARRAY:: @size=%c, @max=%r, @min=%r, @avg=%f%c>', &
    & r = (/max_value, min_value/), d = (/avg_value/), &
    & c1 = trim(size_str), c2 = trim(sd_str) )
end subroutine PutLineReal6
subroutine PutLineReal7( array, lbounds, ubounds, unit, indent, sd )
  use dc_types, only: DP, STRING, STDOUT,SP
  use dc_string, only: toChar, Printf, CPrintf
  use dc_present, only: present_and_true
  implicit none
  real(SP), intent(in):: array(:,:,:,:,:,:,:)
  integer, intent(in), optional:: lbounds(7)
  integer, intent(in), optional:: ubounds(7)
  integer, intent(in), optional:: unit
  character(*), intent(in), optional:: indent
  logical, intent(in), optional:: sd
  integer:: out_unit
  integer:: indent_len
  character(STRING):: indent_str
  integer:: i
  integer:: alldim_size, lbound_nums(7), ubound_nums(7)
  character(STRING):: size_str, sd_str
  real(SP) :: max_value, min_value
  real(SP), allocatable :: array_packed(:)
  real(DP) :: avg_value, variance_value, sd_value
  continue
  !-----------------------------------------------------------------
  !  オプショナル引数のチェック
  !  Check optional arguments
  !-----------------------------------------------------------------
  if ( present(unit) ) then
    out_unit = unit
  else
    out_unit = STDOUT
  end if
  indent_len = 0
  indent_str = ''
  if ( present(indent) ) then
    if (len(indent) /= 0) then
      indent_len = len(indent)
      indent_str(1:indent_len) = indent
    end if
  end if
  !-------------------------------------------------------------------
  !  配列サイズ
  !  Array size
  !-------------------------------------------------------------------
  if ( present(lbounds) .and. present(ubounds) ) then
    lbound_nums = lbounds
    ubound_nums = ubounds
  else
    lbound_nums(1) = lbound( array, 1 )
    ubound_nums(1) = ubound( array, 1 )
    lbound_nums(2) = lbound( array, 2 )
    ubound_nums(2) = ubound( array, 2 )
    lbound_nums(3) = lbound( array, 3 )
    ubound_nums(3) = ubound( array, 3 )
    lbound_nums(4) = lbound( array, 4 )
    ubound_nums(4) = ubound( array, 4 )
    lbound_nums(5) = lbound( array, 5 )
    ubound_nums(5) = ubound( array, 5 )
    lbound_nums(6) = lbound( array, 6 )
    ubound_nums(6) = ubound( array, 6 )
    lbound_nums(7) = lbound( array, 7 )
    ubound_nums(7) = ubound( array, 7 )
  end if
  size_str = '('
  size_str = trim(size_str) // trim(toChar(lbound_nums(1))) // ':'
  size_str = trim(size_str) // trim(toChar(ubound_nums(1)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(2)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(2)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(3)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(3)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(4)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(4)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(5)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(5)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(6)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(6)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(7)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(7)))
  size_str = trim(size_str) // ')'
  !-------------------------------------------------------------------
  !  最大値
  !  Maximum value
  !-------------------------------------------------------------------
  max_value = maxval(array)
  !-------------------------------------------------------------------
  !  最小値
  !  Minimum value
  !-------------------------------------------------------------------
  min_value = minval(array)
  !-------------------------------------------------------------------
  !  平均値
  !  Average value
  !-------------------------------------------------------------------
  alldim_size = size(array)
  avg_value = sum(array) / dble(alldim_size)
  !-------------------------------------------------------------------
  !  標準偏差
  !  Standard deviation
  !-------------------------------------------------------------------
  sd_value = 0.0D0
  variance_value = 0.0D0
  sd_str = ''
  if ( present_and_true( sd ) ) then
    if ( alldim_size > 1 ) then
      if (allocated(array_packed)) then
        deallocate(array_packed)
      end if
      allocate( array_packed(alldim_size) )
      array_packed = pack(array, .true.)
      do i = 1, alldim_size
        variance_value = variance_value + &
          & (array_packed(i) - avg_value) * (array_packed(i) - avg_value)
      end do
      variance_value = variance_value / dble(alldim_size)
      sd_value = sqrt( variance_value )
      sd_str = CPrintf ( ' @sd=%f', d = (/ sd_value /) )
    end if
  end if
  !-------------------------------------------------------------------
  !  印字
  !  Print
  !-------------------------------------------------------------------
  call Printf(out_unit, &
    & indent_str(1:indent_len) // &
    & '#<SP-ARRAY:: @size=%c, @max=%r, @min=%r, @avg=%f%c>', &
    & r = (/max_value, min_value/), d = (/avg_value/), &
    & c1 = trim(size_str), c2 = trim(sd_str) )
end subroutine PutLineReal7
subroutine PutLineDouble1( array, lbounds, ubounds, unit, indent, sd )
  use dc_types, only: DP, STRING, STDOUT
  use dc_string, only: toChar, Printf, CPrintf
  use dc_present, only: present_and_true
  implicit none
  real(DP), intent(in):: array(:)
  integer, intent(in), optional:: lbounds(1)
  integer, intent(in), optional:: ubounds(1)
  integer, intent(in), optional:: unit
  character(*), intent(in), optional:: indent
  logical, intent(in), optional:: sd
  integer:: out_unit
  integer:: indent_len
  character(STRING):: indent_str
  integer:: i
  integer:: alldim_size, lbound_nums(1), ubound_nums(1)
  character(STRING):: size_str, sd_str
  real(DP) :: max_value, min_value
  real(DP), allocatable :: array_packed(:)
  real(DP) :: avg_value, variance_value, sd_value
  continue
  !-----------------------------------------------------------------
  !  オプショナル引数のチェック
  !  Check optional arguments
  !-----------------------------------------------------------------
  if ( present(unit) ) then
    out_unit = unit
  else
    out_unit = STDOUT
  end if
  indent_len = 0
  indent_str = ''
  if ( present(indent) ) then
    if (len(indent) /= 0) then
      indent_len = len(indent)
      indent_str(1:indent_len) = indent
    end if
  end if
  !-------------------------------------------------------------------
  !  配列サイズ
  !  Array size
  !-------------------------------------------------------------------
  if ( present(lbounds) .and. present(ubounds) ) then
    lbound_nums = lbounds
    ubound_nums = ubounds
  else
    lbound_nums(1) = lbound( array, 1 )
    ubound_nums(1) = ubound( array, 1 )
  end if
  size_str = '('
  size_str = trim(size_str) // trim(toChar(lbound_nums(1))) // ':'
  size_str = trim(size_str) // trim(toChar(ubound_nums(1)))
  size_str = trim(size_str) // ')'
  !-------------------------------------------------------------------
  !  最大値
  !  Maximum value
  !-------------------------------------------------------------------
  max_value = maxval(array)
  !-------------------------------------------------------------------
  !  最小値
  !  Minimum value
  !-------------------------------------------------------------------
  min_value = minval(array)
  !-------------------------------------------------------------------
  !  平均値
  !  Average value
  !-------------------------------------------------------------------
  alldim_size = size(array)
  avg_value = sum(array) / dble(alldim_size)
  !-------------------------------------------------------------------
  !  標準偏差
  !  Standard deviation
  !-------------------------------------------------------------------
  sd_value = 0.0D0
  variance_value = 0.0D0
  sd_str = ''
  if ( present_and_true( sd ) ) then
    if ( alldim_size > 1 ) then
      if (allocated(array_packed)) then
        deallocate(array_packed)
      end if
      allocate( array_packed(alldim_size) )
      array_packed = array
      do i = 1, alldim_size
        variance_value = variance_value + &
          & (array_packed(i) - avg_value) * (array_packed(i) - avg_value)
      end do
      variance_value = variance_value / dble(alldim_size)
      sd_value = sqrt( variance_value )
      sd_str = CPrintf ( ' @sd=%f', d = (/ sd_value /) )
    end if
  end if
  !-------------------------------------------------------------------
  !  印字
  !  Print
  !-------------------------------------------------------------------
  call Printf(out_unit, &
    & indent_str(1:indent_len) // &
    & '#<DP-ARRAY:: @size=%c, @max=%f, @min=%f, @avg=%f%c>', &
    & d = (/max_value, min_value, avg_value/), &
    & c1 = trim(size_str), c2 = trim(sd_str) )
end subroutine PutLineDouble1
subroutine PutLineDouble2( array, lbounds, ubounds, unit, indent, sd )
  use dc_types, only: DP, STRING, STDOUT
  use dc_string, only: toChar, Printf, CPrintf
  use dc_present, only: present_and_true
  implicit none
  real(DP), intent(in):: array(:,:)
  integer, intent(in), optional:: lbounds(2)
  integer, intent(in), optional:: ubounds(2)
  integer, intent(in), optional:: unit
  character(*), intent(in), optional:: indent
  logical, intent(in), optional:: sd
  integer:: out_unit
  integer:: indent_len
  character(STRING):: indent_str
  integer:: i
  integer:: alldim_size, lbound_nums(2), ubound_nums(2)
  character(STRING):: size_str, sd_str
  real(DP) :: max_value, min_value
  real(DP), allocatable :: array_packed(:)
  real(DP) :: avg_value, variance_value, sd_value
  continue
  !-----------------------------------------------------------------
  !  オプショナル引数のチェック
  !  Check optional arguments
  !-----------------------------------------------------------------
  if ( present(unit) ) then
    out_unit = unit
  else
    out_unit = STDOUT
  end if
  indent_len = 0
  indent_str = ''
  if ( present(indent) ) then
    if (len(indent) /= 0) then
      indent_len = len(indent)
      indent_str(1:indent_len) = indent
    end if
  end if
  !-------------------------------------------------------------------
  !  配列サイズ
  !  Array size
  !-------------------------------------------------------------------
  if ( present(lbounds) .and. present(ubounds) ) then
    lbound_nums = lbounds
    ubound_nums = ubounds
  else
    lbound_nums(1) = lbound( array, 1 )
    ubound_nums(1) = ubound( array, 1 )
    lbound_nums(2) = lbound( array, 2 )
    ubound_nums(2) = ubound( array, 2 )
  end if
  size_str = '('
  size_str = trim(size_str) // trim(toChar(lbound_nums(1))) // ':'
  size_str = trim(size_str) // trim(toChar(ubound_nums(1)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(2)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(2)))
  size_str = trim(size_str) // ')'
  !-------------------------------------------------------------------
  !  最大値
  !  Maximum value
  !-------------------------------------------------------------------
  max_value = maxval(array)
  !-------------------------------------------------------------------
  !  最小値
  !  Minimum value
  !-------------------------------------------------------------------
  min_value = minval(array)
  !-------------------------------------------------------------------
  !  平均値
  !  Average value
  !-------------------------------------------------------------------
  alldim_size = size(array)
  avg_value = sum(array) / dble(alldim_size)
  !-------------------------------------------------------------------
  !  標準偏差
  !  Standard deviation
  !-------------------------------------------------------------------
  sd_value = 0.0D0
  variance_value = 0.0D0
  sd_str = ''
  if ( present_and_true( sd ) ) then
    if ( alldim_size > 1 ) then
      if (allocated(array_packed)) then
        deallocate(array_packed)
      end if
      allocate( array_packed(alldim_size) )
      array_packed = pack(array, .true.)
      do i = 1, alldim_size
        variance_value = variance_value + &
          & (array_packed(i) - avg_value) * (array_packed(i) - avg_value)
      end do
      variance_value = variance_value / dble(alldim_size)
      sd_value = sqrt( variance_value )
      sd_str = CPrintf ( ' @sd=%f', d = (/ sd_value /) )
    end if
  end if
  !-------------------------------------------------------------------
  !  印字
  !  Print
  !-------------------------------------------------------------------
  call Printf(out_unit, &
    & indent_str(1:indent_len) // &
    & '#<DP-ARRAY:: @size=%c, @max=%f, @min=%f, @avg=%f%c>', &
    & d = (/max_value, min_value, avg_value/), &
    & c1 = trim(size_str), c2 = trim(sd_str) )
end subroutine PutLineDouble2
subroutine PutLineDouble3( array, lbounds, ubounds, unit, indent, sd )
  use dc_types, only: DP, STRING, STDOUT
  use dc_string, only: toChar, Printf, CPrintf
  use dc_present, only: present_and_true
  implicit none
  real(DP), intent(in):: array(:,:,:)
  integer, intent(in), optional:: lbounds(3)
  integer, intent(in), optional:: ubounds(3)
  integer, intent(in), optional:: unit
  character(*), intent(in), optional:: indent
  logical, intent(in), optional:: sd
  integer:: out_unit
  integer:: indent_len
  character(STRING):: indent_str
  integer:: i
  integer:: alldim_size, lbound_nums(3), ubound_nums(3)
  character(STRING):: size_str, sd_str
  real(DP) :: max_value, min_value
  real(DP), allocatable :: array_packed(:)
  real(DP) :: avg_value, variance_value, sd_value
  continue
  !-----------------------------------------------------------------
  !  オプショナル引数のチェック
  !  Check optional arguments
  !-----------------------------------------------------------------
  if ( present(unit) ) then
    out_unit = unit
  else
    out_unit = STDOUT
  end if
  indent_len = 0
  indent_str = ''
  if ( present(indent) ) then
    if (len(indent) /= 0) then
      indent_len = len(indent)
      indent_str(1:indent_len) = indent
    end if
  end if
  !-------------------------------------------------------------------
  !  配列サイズ
  !  Array size
  !-------------------------------------------------------------------
  if ( present(lbounds) .and. present(ubounds) ) then
    lbound_nums = lbounds
    ubound_nums = ubounds
  else
    lbound_nums(1) = lbound( array, 1 )
    ubound_nums(1) = ubound( array, 1 )
    lbound_nums(2) = lbound( array, 2 )
    ubound_nums(2) = ubound( array, 2 )
    lbound_nums(3) = lbound( array, 3 )
    ubound_nums(3) = ubound( array, 3 )
  end if
  size_str = '('
  size_str = trim(size_str) // trim(toChar(lbound_nums(1))) // ':'
  size_str = trim(size_str) // trim(toChar(ubound_nums(1)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(2)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(2)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(3)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(3)))
  size_str = trim(size_str) // ')'
  !-------------------------------------------------------------------
  !  最大値
  !  Maximum value
  !-------------------------------------------------------------------
  max_value = maxval(array)
  !-------------------------------------------------------------------
  !  最小値
  !  Minimum value
  !-------------------------------------------------------------------
  min_value = minval(array)
  !-------------------------------------------------------------------
  !  平均値
  !  Average value
  !-------------------------------------------------------------------
  alldim_size = size(array)
  avg_value = sum(array) / dble(alldim_size)
  !-------------------------------------------------------------------
  !  標準偏差
  !  Standard deviation
  !-------------------------------------------------------------------
  sd_value = 0.0D0
  variance_value = 0.0D0
  sd_str = ''
  if ( present_and_true( sd ) ) then
    if ( alldim_size > 1 ) then
      if (allocated(array_packed)) then
        deallocate(array_packed)
      end if
      allocate( array_packed(alldim_size) )
      array_packed = pack(array, .true.)
      do i = 1, alldim_size
        variance_value = variance_value + &
          & (array_packed(i) - avg_value) * (array_packed(i) - avg_value)
      end do
      variance_value = variance_value / dble(alldim_size)
      sd_value = sqrt( variance_value )
      sd_str = CPrintf ( ' @sd=%f', d = (/ sd_value /) )
    end if
  end if
  !-------------------------------------------------------------------
  !  印字
  !  Print
  !-------------------------------------------------------------------
  call Printf(out_unit, &
    & indent_str(1:indent_len) // &
    & '#<DP-ARRAY:: @size=%c, @max=%f, @min=%f, @avg=%f%c>', &
    & d = (/max_value, min_value, avg_value/), &
    & c1 = trim(size_str), c2 = trim(sd_str) )
end subroutine PutLineDouble3
subroutine PutLineDouble4( array, lbounds, ubounds, unit, indent, sd )
  use dc_types, only: DP, STRING, STDOUT
  use dc_string, only: toChar, Printf, CPrintf
  use dc_present, only: present_and_true
  implicit none
  real(DP), intent(in):: array(:,:,:,:)
  integer, intent(in), optional:: lbounds(4)
  integer, intent(in), optional:: ubounds(4)
  integer, intent(in), optional:: unit
  character(*), intent(in), optional:: indent
  logical, intent(in), optional:: sd
  integer:: out_unit
  integer:: indent_len
  character(STRING):: indent_str
  integer:: i
  integer:: alldim_size, lbound_nums(4), ubound_nums(4)
  character(STRING):: size_str, sd_str
  real(DP) :: max_value, min_value
  real(DP), allocatable :: array_packed(:)
  real(DP) :: avg_value, variance_value, sd_value
  continue
  !-----------------------------------------------------------------
  !  オプショナル引数のチェック
  !  Check optional arguments
  !-----------------------------------------------------------------
  if ( present(unit) ) then
    out_unit = unit
  else
    out_unit = STDOUT
  end if
  indent_len = 0
  indent_str = ''
  if ( present(indent) ) then
    if (len(indent) /= 0) then
      indent_len = len(indent)
      indent_str(1:indent_len) = indent
    end if
  end if
  !-------------------------------------------------------------------
  !  配列サイズ
  !  Array size
  !-------------------------------------------------------------------
  if ( present(lbounds) .and. present(ubounds) ) then
    lbound_nums = lbounds
    ubound_nums = ubounds
  else
    lbound_nums(1) = lbound( array, 1 )
    ubound_nums(1) = ubound( array, 1 )
    lbound_nums(2) = lbound( array, 2 )
    ubound_nums(2) = ubound( array, 2 )
    lbound_nums(3) = lbound( array, 3 )
    ubound_nums(3) = ubound( array, 3 )
    lbound_nums(4) = lbound( array, 4 )
    ubound_nums(4) = ubound( array, 4 )
  end if
  size_str = '('
  size_str = trim(size_str) // trim(toChar(lbound_nums(1))) // ':'
  size_str = trim(size_str) // trim(toChar(ubound_nums(1)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(2)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(2)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(3)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(3)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(4)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(4)))
  size_str = trim(size_str) // ')'
  !-------------------------------------------------------------------
  !  最大値
  !  Maximum value
  !-------------------------------------------------------------------
  max_value = maxval(array)
  !-------------------------------------------------------------------
  !  最小値
  !  Minimum value
  !-------------------------------------------------------------------
  min_value = minval(array)
  !-------------------------------------------------------------------
  !  平均値
  !  Average value
  !-------------------------------------------------------------------
  alldim_size = size(array)
  avg_value = sum(array) / dble(alldim_size)
  !-------------------------------------------------------------------
  !  標準偏差
  !  Standard deviation
  !-------------------------------------------------------------------
  sd_value = 0.0D0
  variance_value = 0.0D0
  sd_str = ''
  if ( present_and_true( sd ) ) then
    if ( alldim_size > 1 ) then
      if (allocated(array_packed)) then
        deallocate(array_packed)
      end if
      allocate( array_packed(alldim_size) )
      array_packed = pack(array, .true.)
      do i = 1, alldim_size
        variance_value = variance_value + &
          & (array_packed(i) - avg_value) * (array_packed(i) - avg_value)
      end do
      variance_value = variance_value / dble(alldim_size)
      sd_value = sqrt( variance_value )
      sd_str = CPrintf ( ' @sd=%f', d = (/ sd_value /) )
    end if
  end if
  !-------------------------------------------------------------------
  !  印字
  !  Print
  !-------------------------------------------------------------------
  call Printf(out_unit, &
    & indent_str(1:indent_len) // &
    & '#<DP-ARRAY:: @size=%c, @max=%f, @min=%f, @avg=%f%c>', &
    & d = (/max_value, min_value, avg_value/), &
    & c1 = trim(size_str), c2 = trim(sd_str) )
end subroutine PutLineDouble4
subroutine PutLineDouble5( array, lbounds, ubounds, unit, indent, sd )
  use dc_types, only: DP, STRING, STDOUT
  use dc_string, only: toChar, Printf, CPrintf
  use dc_present, only: present_and_true
  implicit none
  real(DP), intent(in):: array(:,:,:,:,:)
  integer, intent(in), optional:: lbounds(5)
  integer, intent(in), optional:: ubounds(5)
  integer, intent(in), optional:: unit
  character(*), intent(in), optional:: indent
  logical, intent(in), optional:: sd
  integer:: out_unit
  integer:: indent_len
  character(STRING):: indent_str
  integer:: i
  integer:: alldim_size, lbound_nums(5), ubound_nums(5)
  character(STRING):: size_str, sd_str
  real(DP) :: max_value, min_value
  real(DP), allocatable :: array_packed(:)
  real(DP) :: avg_value, variance_value, sd_value
  continue
  !-----------------------------------------------------------------
  !  オプショナル引数のチェック
  !  Check optional arguments
  !-----------------------------------------------------------------
  if ( present(unit) ) then
    out_unit = unit
  else
    out_unit = STDOUT
  end if
  indent_len = 0
  indent_str = ''
  if ( present(indent) ) then
    if (len(indent) /= 0) then
      indent_len = len(indent)
      indent_str(1:indent_len) = indent
    end if
  end if
  !-------------------------------------------------------------------
  !  配列サイズ
  !  Array size
  !-------------------------------------------------------------------
  if ( present(lbounds) .and. present(ubounds) ) then
    lbound_nums = lbounds
    ubound_nums = ubounds
  else
    lbound_nums(1) = lbound( array, 1 )
    ubound_nums(1) = ubound( array, 1 )
    lbound_nums(2) = lbound( array, 2 )
    ubound_nums(2) = ubound( array, 2 )
    lbound_nums(3) = lbound( array, 3 )
    ubound_nums(3) = ubound( array, 3 )
    lbound_nums(4) = lbound( array, 4 )
    ubound_nums(4) = ubound( array, 4 )
    lbound_nums(5) = lbound( array, 5 )
    ubound_nums(5) = ubound( array, 5 )
  end if
  size_str = '('
  size_str = trim(size_str) // trim(toChar(lbound_nums(1))) // ':'
  size_str = trim(size_str) // trim(toChar(ubound_nums(1)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(2)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(2)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(3)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(3)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(4)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(4)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(5)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(5)))
  size_str = trim(size_str) // ')'
  !-------------------------------------------------------------------
  !  最大値
  !  Maximum value
  !-------------------------------------------------------------------
  max_value = maxval(array)
  !-------------------------------------------------------------------
  !  最小値
  !  Minimum value
  !-------------------------------------------------------------------
  min_value = minval(array)
  !-------------------------------------------------------------------
  !  平均値
  !  Average value
  !-------------------------------------------------------------------
  alldim_size = size(array)
  avg_value = sum(array) / dble(alldim_size)
  !-------------------------------------------------------------------
  !  標準偏差
  !  Standard deviation
  !-------------------------------------------------------------------
  sd_value = 0.0D0
  variance_value = 0.0D0
  sd_str = ''
  if ( present_and_true( sd ) ) then
    if ( alldim_size > 1 ) then
      if (allocated(array_packed)) then
        deallocate(array_packed)
      end if
      allocate( array_packed(alldim_size) )
      array_packed = pack(array, .true.)
      do i = 1, alldim_size
        variance_value = variance_value + &
          & (array_packed(i) - avg_value) * (array_packed(i) - avg_value)
      end do
      variance_value = variance_value / dble(alldim_size)
      sd_value = sqrt( variance_value )
      sd_str = CPrintf ( ' @sd=%f', d = (/ sd_value /) )
    end if
  end if
  !-------------------------------------------------------------------
  !  印字
  !  Print
  !-------------------------------------------------------------------
  call Printf(out_unit, &
    & indent_str(1:indent_len) // &
    & '#<DP-ARRAY:: @size=%c, @max=%f, @min=%f, @avg=%f%c>', &
    & d = (/max_value, min_value, avg_value/), &
    & c1 = trim(size_str), c2 = trim(sd_str) )
end subroutine PutLineDouble5
subroutine PutLineDouble6( array, lbounds, ubounds, unit, indent, sd )
  use dc_types, only: DP, STRING, STDOUT
  use dc_string, only: toChar, Printf, CPrintf
  use dc_present, only: present_and_true
  implicit none
  real(DP), intent(in):: array(:,:,:,:,:,:)
  integer, intent(in), optional:: lbounds(6)
  integer, intent(in), optional:: ubounds(6)
  integer, intent(in), optional:: unit
  character(*), intent(in), optional:: indent
  logical, intent(in), optional:: sd
  integer:: out_unit
  integer:: indent_len
  character(STRING):: indent_str
  integer:: i
  integer:: alldim_size, lbound_nums(6), ubound_nums(6)
  character(STRING):: size_str, sd_str
  real(DP) :: max_value, min_value
  real(DP), allocatable :: array_packed(:)
  real(DP) :: avg_value, variance_value, sd_value
  continue
  !-----------------------------------------------------------------
  !  オプショナル引数のチェック
  !  Check optional arguments
  !-----------------------------------------------------------------
  if ( present(unit) ) then
    out_unit = unit
  else
    out_unit = STDOUT
  end if
  indent_len = 0
  indent_str = ''
  if ( present(indent) ) then
    if (len(indent) /= 0) then
      indent_len = len(indent)
      indent_str(1:indent_len) = indent
    end if
  end if
  !-------------------------------------------------------------------
  !  配列サイズ
  !  Array size
  !-------------------------------------------------------------------
  if ( present(lbounds) .and. present(ubounds) ) then
    lbound_nums = lbounds
    ubound_nums = ubounds
  else
    lbound_nums(1) = lbound( array, 1 )
    ubound_nums(1) = ubound( array, 1 )
    lbound_nums(2) = lbound( array, 2 )
    ubound_nums(2) = ubound( array, 2 )
    lbound_nums(3) = lbound( array, 3 )
    ubound_nums(3) = ubound( array, 3 )
    lbound_nums(4) = lbound( array, 4 )
    ubound_nums(4) = ubound( array, 4 )
    lbound_nums(5) = lbound( array, 5 )
    ubound_nums(5) = ubound( array, 5 )
    lbound_nums(6) = lbound( array, 6 )
    ubound_nums(6) = ubound( array, 6 )
  end if
  size_str = '('
  size_str = trim(size_str) // trim(toChar(lbound_nums(1))) // ':'
  size_str = trim(size_str) // trim(toChar(ubound_nums(1)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(2)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(2)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(3)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(3)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(4)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(4)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(5)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(5)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(6)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(6)))
  size_str = trim(size_str) // ')'
  !-------------------------------------------------------------------
  !  最大値
  !  Maximum value
  !-------------------------------------------------------------------
  max_value = maxval(array)
  !-------------------------------------------------------------------
  !  最小値
  !  Minimum value
  !-------------------------------------------------------------------
  min_value = minval(array)
  !-------------------------------------------------------------------
  !  平均値
  !  Average value
  !-------------------------------------------------------------------
  alldim_size = size(array)
  avg_value = sum(array) / dble(alldim_size)
  !-------------------------------------------------------------------
  !  標準偏差
  !  Standard deviation
  !-------------------------------------------------------------------
  sd_value = 0.0D0
  variance_value = 0.0D0
  sd_str = ''
  if ( present_and_true( sd ) ) then
    if ( alldim_size > 1 ) then
      if (allocated(array_packed)) then
        deallocate(array_packed)
      end if
      allocate( array_packed(alldim_size) )
      array_packed = pack(array, .true.)
      do i = 1, alldim_size
        variance_value = variance_value + &
          & (array_packed(i) - avg_value) * (array_packed(i) - avg_value)
      end do
      variance_value = variance_value / dble(alldim_size)
      sd_value = sqrt( variance_value )
      sd_str = CPrintf ( ' @sd=%f', d = (/ sd_value /) )
    end if
  end if
  !-------------------------------------------------------------------
  !  印字
  !  Print
  !-------------------------------------------------------------------
  call Printf(out_unit, &
    & indent_str(1:indent_len) // &
    & '#<DP-ARRAY:: @size=%c, @max=%f, @min=%f, @avg=%f%c>', &
    & d = (/max_value, min_value, avg_value/), &
    & c1 = trim(size_str), c2 = trim(sd_str) )
end subroutine PutLineDouble6
subroutine PutLineDouble7( array, lbounds, ubounds, unit, indent, sd )
  use dc_types, only: DP, STRING, STDOUT
  use dc_string, only: toChar, Printf, CPrintf
  use dc_present, only: present_and_true
  implicit none
  real(DP), intent(in):: array(:,:,:,:,:,:,:)
  integer, intent(in), optional:: lbounds(7)
  integer, intent(in), optional:: ubounds(7)
  integer, intent(in), optional:: unit
  character(*), intent(in), optional:: indent
  logical, intent(in), optional:: sd
  integer:: out_unit
  integer:: indent_len
  character(STRING):: indent_str
  integer:: i
  integer:: alldim_size, lbound_nums(7), ubound_nums(7)
  character(STRING):: size_str, sd_str
  real(DP) :: max_value, min_value
  real(DP), allocatable :: array_packed(:)
  real(DP) :: avg_value, variance_value, sd_value
  continue
  !-----------------------------------------------------------------
  !  オプショナル引数のチェック
  !  Check optional arguments
  !-----------------------------------------------------------------
  if ( present(unit) ) then
    out_unit = unit
  else
    out_unit = STDOUT
  end if
  indent_len = 0
  indent_str = ''
  if ( present(indent) ) then
    if (len(indent) /= 0) then
      indent_len = len(indent)
      indent_str(1:indent_len) = indent
    end if
  end if
  !-------------------------------------------------------------------
  !  配列サイズ
  !  Array size
  !-------------------------------------------------------------------
  if ( present(lbounds) .and. present(ubounds) ) then
    lbound_nums = lbounds
    ubound_nums = ubounds
  else
    lbound_nums(1) = lbound( array, 1 )
    ubound_nums(1) = ubound( array, 1 )
    lbound_nums(2) = lbound( array, 2 )
    ubound_nums(2) = ubound( array, 2 )
    lbound_nums(3) = lbound( array, 3 )
    ubound_nums(3) = ubound( array, 3 )
    lbound_nums(4) = lbound( array, 4 )
    ubound_nums(4) = ubound( array, 4 )
    lbound_nums(5) = lbound( array, 5 )
    ubound_nums(5) = ubound( array, 5 )
    lbound_nums(6) = lbound( array, 6 )
    ubound_nums(6) = ubound( array, 6 )
    lbound_nums(7) = lbound( array, 7 )
    ubound_nums(7) = ubound( array, 7 )
  end if
  size_str = '('
  size_str = trim(size_str) // trim(toChar(lbound_nums(1))) // ':'
  size_str = trim(size_str) // trim(toChar(ubound_nums(1)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(2)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(2)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(3)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(3)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(4)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(4)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(5)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(5)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(6)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(6)))
  size_str = trim(size_str) // ',' // trim(toChar(lbound_nums(7)))
  size_str = trim(size_str) // ':' // trim(toChar(ubound_nums(7)))
  size_str = trim(size_str) // ')'
  !-------------------------------------------------------------------
  !  最大値
  !  Maximum value
  !-------------------------------------------------------------------
  max_value = maxval(array)
  !-------------------------------------------------------------------
  !  最小値
  !  Minimum value
  !-------------------------------------------------------------------
  min_value = minval(array)
  !-------------------------------------------------------------------
  !  平均値
  !  Average value
  !-------------------------------------------------------------------
  alldim_size = size(array)
  avg_value = sum(array) / dble(alldim_size)
  !-------------------------------------------------------------------
  !  標準偏差
  !  Standard deviation
  !-------------------------------------------------------------------
  sd_value = 0.0D0
  variance_value = 0.0D0
  sd_str = ''
  if ( present_and_true( sd ) ) then
    if ( alldim_size > 1 ) then
      if (allocated(array_packed)) then
        deallocate(array_packed)
      end if
      allocate( array_packed(alldim_size) )
      array_packed = pack(array, .true.)
      do i = 1, alldim_size
        variance_value = variance_value + &
          & (array_packed(i) - avg_value) * (array_packed(i) - avg_value)
      end do
      variance_value = variance_value / dble(alldim_size)
      sd_value = sqrt( variance_value )
      sd_str = CPrintf ( ' @sd=%f', d = (/ sd_value /) )
    end if
  end if
  !-------------------------------------------------------------------
  !  印字
  !  Print
  !-------------------------------------------------------------------
  call Printf(out_unit, &
    & indent_str(1:indent_len) // &
    & '#<DP-ARRAY:: @size=%c, @max=%f, @min=%f, @avg=%f%c>', &
    & d = (/max_value, min_value, avg_value/), &
    & c1 = trim(size_str), c2 = trim(sd_str) )
end subroutine PutLineDouble7
