! Copyright (C) GFD Dennou Club, 2000-2001.  All rights reserved.

SUBROUTINE GTVARGETDOUBLE(VAR, VALUE, NVALUE, ERR)
    USE GTDATA_TYPES, ONLY: GT_VARIABLE
    USE GT_MAP, ONLY: VAR_CLASS, VTB_CLASS_NETCDF, &
        & MAP_TO_INTERNAL_SPECS, GTVAR_DUMP
    USE AN_GENERIC, ONLY: GET, AN_VARIABLE
    USE DC_TRACE, ONLY: BEGINSUB, ENDSUB
    USE DC_ERROR
    IMPLICIT NONE
    TYPE(GT_VARIABLE), INTENT(INOUT):: VAR
    DOUBLE PRECISION, INTENT(OUT):: VALUE(*)
    INTEGER, INTENT(IN):: NVALUE
    LOGICAL, INTENT(OUT), OPTIONAL:: ERR
    INTEGER:: CLASS, CID, STAT
    INTEGER, POINTER:: SPECS(:, :)
    CALL VAR_CLASS(VAR, CLASS, CID)
    CALL BEGINSUB('gtvargetDOUBLE')
    CALL GTVAR_DUMP(VAR)
    CALL MAP_TO_INTERNAL_SPECS(VAR, SPECS)
    IF (CLASS == VTB_CLASS_NETCDF) THEN
        CALL GET(AN_VARIABLE(CID), START=SPECS(:, 1), COUNT=SPECS(:, 2), &
            & STRIDE=SPECS(:, 3), IMAP=SPECS(:, 4), SIZ=NVALUE, VALUE=VALUE, &
            & IOSTAT=STAT)
    ELSE
        STAT = GT_EFAKE
    ENDIF
    IF (ASSOCIATED(SPECS)) DEALLOCATE(SPECS)
    CALL STOREERROR(STAT, "gtvargetDOUBLE", ERR)
    CALL ENDSUB('gtvargetDOUBLE', 'stat=%d', I=(/STAT/))
END SUBROUTINE
