! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

subroutine GtObjClear(obj)
    use gtgraph_types, only: GT_OBJECT
    use dc_trace, only: beginsub, endsub
    implicit none
    type(GT_OBJECT), intent(out):: obj
    call beginsub('gtobjclear')
    nullify(obj%axis, obj%cont, obj%line)
    nullify(obj%fig, obj%frame, obj%next)
    call endsub('gtobjclear')
end subroutine

subroutine GtObjOpen(obj)
    use gtgraph_types, only: GT_OBJECT
    use dc_trace, only: beginsub, endsub
    implicit none
    type(GT_OBJECT), intent(out):: obj
    call beginsub('gtobjopen')
    call GtObjClear(obj)
    call endsub('gtobjopen')
end subroutine

recursive subroutine GTObjLoadC2(obj, vnam1, vnam2, slice_spec)
    use gtgraph_types, only: GT_OBJECT
    use gtgraph_generic, only: Load
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: Open, Slice
    use dc_trace, only: beginsub, endsub
    use dc_types, only: STRING
    implicit none
    type(GT_OBJECT), intent(out):: obj
    character(len = STRING), intent(in):: vnam1, vnam2
    character(len = string), intent(in):: slice_spec
    type(GT_VARIABLE):: var1, var2
    logical:: err
    call beginsub('gtobjload', '%c %c', c1=trim(vnam1), c2=trim(vnam2))
    call Open(var1, vnam1)
    call Open(var2, vnam2)
    if (slice_spec /= "") then
        call slice(var1, slice_spec, err)
        call slice(var2, slice_spec, err)
    endif
    call Load(obj, var1, var2)
    call endsub('gtobjload')
end subroutine

recursive subroutine GTObjLoadC(obj, varname, slice_spec)
    use gtgraph_types, only: GT_OBJECT
    use gtgraph_generic, only: Load
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: Open, Slice
    use dc_trace, only: beginsub, endsub
    use dc_types, only: STRING
    implicit none
    type(GT_OBJECT), intent(out):: obj
    character(len = STRING), intent(in):: varname
    character(len = string), intent(in):: slice_spec
    type(GT_VARIABLE):: var
    logical:: err
    call beginsub('gtobjload', '%c', c1=trim(varname))
    call Open(var, varname)
    if (slice_spec /= "") then
        call slice(var, slice_spec, err)
    endif
    call Load(obj, var)
    call endsub('gtobjload')
end subroutine

recursive subroutine GTObjLoadVar2(obj, var1, var2)
    use gtgraph_types, only: GT_OBJECT
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: get_attr, inquire
    use gtgraph_generic, only: Open, Clear, Load
    use dc_string, only: VSTRING, operator(==)
    use dc_trace, only: beginsub, endsub, message
    use dc_error
    implicit none
    type(GT_OBJECT), intent(out):: obj
    type(GT_VARIABLE), intent(in):: var1, var2
    integer:: ndims1, ndims2
continue
    call beginsub('gtobjloadvar2', 'var=%d %d', i=(/var1%mapid, var2%mapid/))
    call Clear(obj)
    call inquire(var1, rank=ndims1)
    call inquire(var2, rank=ndims2)
    call message('# rank = %d %d', i=(/ndims1, ndims2/))
    if (ndims1 == 1 .and. ndims2 == 1) then
	call StoreError(GT_EFAKE, 'GtObjLoadVar2(ndims = 1, 1)')
    else if (ndims1 >= 2 .and. ndims2 >= 2) then
	allocate(obj%vect)
	call Open(obj%vect, var1, var2)
    else
	call StoreError(GT_EFAKE, 'GtObjLoadVar2(bad ndims)')
    endif
    call endsub('gtobjloadvar2')
end subroutine

recursive subroutine GTObjLoadVar(obj, var)
    use gtgraph_types, only: GT_OBJECT
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: get_attr, inquire
    use gtgraph_generic, only: Open, Clear, Load
    use dc_string, only: VSTRING, operator(==)
    use dc_trace, only: beginsub, endsub, message
    use dc_error
    implicit none
    type(GT_OBJECT), intent(out):: obj
    type(GT_VARIABLE), intent(in):: var
    type(VSTRING):: var_class
    integer:: ndims
continue
    call beginsub('gtobjloadvar', 'var.mapid=%d', i=(/var%mapid/))
    call Clear(obj)
    call get_attr(var, "gt_structure_class", var_class, default="data")
    if (var_class == "frame") then
        allocate(obj%frame)
        call Open(obj%frame)
        call Load(obj%frame, var)
    else if (var_class == "figure") then
        allocate(obj%fig)
        call Open(obj%fig)
        call Load(obj%fig, var)
    else if (var_class == "contours") then
        allocate(obj%cont)
        call Load(obj%cont, var)
    else if (var_class == "vectors") then
        allocate(obj%vect)
        call Load(obj%vect, var)
    else if (var_class == "line") then
        allocate(obj%line)
        call Load(obj%line, var)
    else if (var_class == "axis") then
        allocate(obj%axis)
        call Load(obj%line, var)
    else
        call inquire(var, rank=ndims)
        call message('# rank = %d', i=(/ndims/))
        select case(ndims)
        case(1)
            allocate(obj%line)
            call Open(obj%line, var)
        case(2:)
            allocate(obj%cont)
            call Open(obj%cont, var)
        case default
            call StoreError(GT_EFAKE, 'GtObjLoadVar(ndims = 0)')
        end select
    endif
    call endsub('gtobjloadvar')
end subroutine

recursive subroutine GtObjClose(obj)
    use gtgraph_types, only: GT_OBJECT
    use gtgraph_generic, only: GTAxisClose, GTLineClose, GTContClose, &
        & GTFigClose, GTFrameClose, GTVectClose
    use dc_trace, only: beginsub, endsub, message
    implicit none
    type(GT_OBJECT), intent(out):: obj
    call beginsub('gtobjclose')
    if (associated(obj%next)) then
        call GtObjClose(obj%next)
        deallocate(obj%next)
    endif
    if (associated(obj%axis)) then
        deallocate(obj%axis)
        call GTAxisClose(obj%axis)
    endif
    if (associated(obj%cont)) then
        call GTContClose(obj%cont)
        deallocate(obj%cont)
    endif
    if (associated(obj%vect)) then
        call GTVectClose(obj%Vect)
        deallocate(obj%Vect)
    endif
    if (associated(obj%line)) then
        call GTLineClose(obj%line)
        deallocate(obj%line)
    endif
    if (associated(obj%fig)) then
        call GTFigClose(obj%fig)
        deallocate(obj%fig)
    endif
    if (associated(obj%frame)) then
        call GTFrameClose(obj%frame)
        deallocate(obj%frame)
    endif
    call endsub('gtobjclose')
end subroutine

subroutine GtObjInquire(obj, type)
    use gtgraph_types, only: GT_OBJECT
    use dc_trace, only: beginsub, endsub, message
    implicit none
    type(GT_OBJECT), intent(in):: obj
    character(len = *), intent(out), optional:: type
    call beginsub('gtobjinquire')
    if (present(type)) then
        if (associated(obj%axis)) then
            type = "axis"
        else if (associated(obj%cont)) then
            type = "contours"
        else if (associated(obj%vect)) then
            type = "vectors"
        else if (associated(obj%line)) then
            type = "line"
        else if (associated(obj%fig)) then
            type = "figure"
        else if (associated(obj%frame)) then
            type = "frame"
        else
            type = ""
        endif
    endif
    call endsub('gtobjinquire')
end subroutine

subroutine GtObjOption(obj, optname, value, err)
    use gtgraph_types, only: GT_OBJECT
    use gtgraph_generic, only: Option
    use dc_trace, only: beginsub, endsub, message
    implicit none
    type(GT_OBJECT), intent(inout):: obj
    character(len = *), intent(in):: optname
    character(len = *), intent(in):: value
    logical, intent(out):: err
continue
    call beginsub('gtobjoption', '<%c=%c>', c1=optname, c2=value)
    if (associated(obj%cont)) then
        call message('forwarding obj to cont')
        call Option(obj%cont, optname, value, err)
    else if (associated(obj%vect)) then
        call message('forwarding obj to vect')
        call Option(obj%vect, optname, value, err)
    else if (associated(obj%line)) then
        call message('forwarding obj to line')
        call Option(obj%line, optname, value, err)
    else if (associated(obj%fig)) then
        call message('forwarding obj to fig')
        call Option(obj%fig, optname, value, err)
    else
        err = .TRUE.
    endif
    call endsub('gtobjoption')
end subroutine

    ! --- GtObjBindObj --- 
    ! bind ̌
    !  child  parent ̂ʂ̃NX̂̂ێB
    !  ʃNX̏ꍇ͒NX쐬҂˂ށB
    !  (҂Ƃ frame ̏ꍇ next ɘA)
subroutine GTObjBindObj(parent, child)
    use gtgraph_types, only: GT_OBJECT
    use gtgraph_generic, only: Inquire, Bind, Clear, Open
    use dc_trace, only: beginsub, endsub, message
    implicit none
    type(GT_OBJECT), intent(inout), target:: parent
    type(GT_OBJECT), intent(inout):: child
    character(len = 8):: child_type, parent_type
    type(GT_OBJECT), pointer:: objp
continue
    call beginsub('gtobjbindobj')
    call Inquire(child, type=child_type)
    call Inquire(parent, type=parent_type)
    ! --- ǂ炩ȂłȂق parent  ---
    if (child_type == "") return
    if (parent_type == "") then
        ! eȂ炽ڂ
        parent = child
        call Clear(child)
        return
    endif
    ! --- next Nꍇ ---
    ! Ƃ肠ȗ
    ! --- }`vfǂ̑ ---
    if (parent_type == "frame") then
        ! eqƂɘgȂAAȊÔ̂͘gɐݒu
        select case(child_type)
        case("frame")
            goto 1000
        case("figure")
            call Bind(parent%frame, child%fig)
        case("contours")
            allocate(child%fig)
            call Bind(child%fig, child%cont)
            call Bind(parent%frame, child%fig)
        case("vectors")
            allocate(child%fig)
            call Bind(child%fig, child%vect)
            call Bind(parent%frame, child%fig)
        case("line")
            allocate(child%fig)
            call Bind(child%fig, child%line)
            call Bind(parent%frame, child%fig)
        case("axis")
            allocate(child%fig)
            call Bind(child%fig, child%axis)
            call Bind(parent%frame, child%fig)
        end select
    else if (child_type == "frame") then
        ! e͘gȉȂ̂Ŏq̒ɐݒu
        select case(parent_type)
        case("figure")
            call Bind(child%frame, parent%fig)
        case("vectors")
            allocate(parent%fig)
            call Bind(parent%fig, parent%vect)
            call Bind(child%frame, parent%fig)
        case("contours")
            allocate(parent%fig)
            call Bind(parent%fig, parent%cont)
            call Bind(child%frame, parent%fig)
        case("line")
            allocate(parent%fig)
            call Bind(parent%fig, parent%line)
            call Bind(child%frame, parent%fig)
        case("axis")
            allocate(parent%fig)
            call Bind(parent%fig, parent%axis)
            call Bind(child%frame, parent%fig)
        end select
        call Clear(parent)
        parent%frame => child%frame
    else if (parent_type == "figure") then
        select case(child_type)
        case("figure")
            allocate(parent%frame)
            call Open(parent%frame)
            call Bind(parent%frame, parent%fig)
            nullify(parent%fig)
            call Bind(parent%frame, child%fig)
        case("vectors")
            call Bind(parent%fig, child%vect)
        case("contours")
            call Bind(parent%fig, child%cont)
        case("line")
            call Bind(parent%fig, child%line)
        case("axis")
            call Bind(parent%fig, child%axis)
        end select
    else if (child_type == "figure") then
        ! e͐}ȉȂ̂Ŏq̐}̒ɐe̗vfu
        select case(parent_type)
        case("vectors")
            call Bind(child%fig, parent%vect)
        case("contours")
            call Bind(child%fig, parent%cont)
        case("line")
            call Bind(child%fig, parent%line)
        case("axis")
            call Bind(child%fig, parent%axis)
        end select
        call Clear(parent)
        parent%fig => child%fig
    else
        ! eq}ȉ̏ꍇ͂Ƃɂ}ė
        allocate(parent%fig)
        call Open(parent%fig)
        select case(parent_type)
        case("vectors")
            call Bind(parent%fig, parent%vect)
            nullify(parent%vect)
        case("contours")
            call Bind(parent%fig, parent%cont)
            nullify(parent%cont)
        case("line")
            call Bind(parent%fig, parent%line)
            nullify(parent%line)
        case("axis")
            call Bind(parent%fig, parent%axis)
            nullify(parent%axis)
        end select
        select case(child_type)
        case("vectors")
            call Bind(parent%fig, child%vect)
        case("contours")
            call Bind(parent%fig, child%cont)
        case("line")
            call Bind(parent%fig, child%line)
        case("axis")
            call Bind(parent%fig, child%axis)
        end select
    endif
    call Clear(child)
    call endsub('gtobjbindobj')
    return

    1000 continue
        objp => parent
        do
            if (.not. associated(objp%next)) exit
            objp => objp%next
        enddo
        ! child ւ̃|C^͓Tu[`𔲂ƖɂȂ̂ŁA
        ! ʎ̂蓖ĂĂBF̃|C^Ȃ̂ōB
        allocate(objp%next)
        objp%next = child
        call Clear(child)
        call endsub('gtobjbindobj')
    return
end subroutine
