#!/bin/sh

set -e

test ! -f gtgraph.nc || rm -f gtgraph.nc
test ! -f dcl.ps || rm -f dcl.ps

../gtview/gtview wsn=2 -save ../gtview/gtool.nc?ps

ncdump gtgraph.nc > gtgraph.cdl
diff gtgraph.cdl - <<END_OF_NETCDF
netcdf gtgraph {
variables:
	int gr1 ;
		gr1:long_name = "surface pressure [mb]" ;
		gr1:gt_structure_class = "figure" ;
		gr1:gt_structure_member = "gr2 " ;
		gr1:gt_structure_link_gr2 = "gtgraph.nc@gr2" ;
	int gr2 ;
		gr2:long_name = "contours of surface pressure" ;
		gr2:gt_structure_class = "contours" ;
		gr2:gt_contours_draw_shade = "false" ;
		gr2:gt_contours_draw_contours = "true" ;
		gr2:gt_structure_member = "data vaxis haxis " ;
		gr2:gt_structure_link_data = "../gtview/gtool.nc?ps" ;
		gr2:gt_structure_link_vaxis = "gtgraph.nc@gr3" ;
		gr2:gt_structure_link_haxis = "gtgraph.nc@gr4" ;
	int gr3 ;
		gr3:long_name = "horizontal axis of lat" ;
		gr3:gt_structure_class = "axis" ;
		gr3:gt_axis_vertical = "false" ;
		gr3:gt_structure_member = "data " ;
		gr3:gt_structure_link_data = "../gtview/gtool.nc?lat" ;
	int gr4 ;
		gr4:long_name = "horizontal axis of lon" ;
		gr4:gt_structure_class = "axis" ;
		gr4:gt_axis_vertical = "false" ;
		gr4:gt_structure_member = "data " ;
		gr4:gt_structure_link_data = "../gtview/gtool.nc?lon" ;
data:

 gr1 = _ ;

 gr2 = _ ;

 gr3 = _ ;

 gr4 = _ ;
}
END_OF_NETCDF

mv -f dcl.ps dcl.ps.bak

../gtview/gtview wsn=2 gtgraph.nc 

diff dcl.ps dcl.ps.bak

rm -f dcl.ps dcl.ps.bak gtgraph.nc  gtgraph.cdl

echo okay
