program test
    integer:: case
    write(*, *) '1: token;  2: parse'
    read(*, *) case
    if (case == 1) then
        call test_token
    else
        call test_parse
    endif
end program

subroutine test_parse
    use dc_units
    implicit none
    character(STRING):: buffer, output, op
    integer:: ios
    type(units):: u, v
    call clear(u)
    call clear(v)
    do
        write(*, fmt='(A)', advance='NO') 'units> '
        read(*, '(A)', iostat=ios) buffer
        if (ios /= 0) exit
	u = buffer

        write(*, fmt='(A)', advance='NO') 'op>    '
        read(*, '(A)', iostat=ios) op
        if (ios /= 0) exit

	if (op == '' .or. op == '=') then
	    output = u
	    write(*, "(A)") trim(output)
	    cycle
        endif
	write(*, fmt='(A)', advance='NO') 'operand> '
	read(*, '(A)', iostat=ios) buffer
	if (ios /= 0) exit
	v = buffer
	if (op == '*' .or. op == '.') then
	    u = u * v
	else if (op == '/') then
	    u = u / v
	else if (op == '+') then
	    u = u + v
	endif
	output = u
	write(*, "(A)") trim(output)

    enddo
end subroutine

subroutine test_token
    use dc_units
    use dcunits_com
    implicit none
    character(STRING):: buffer, cvalue
    integer:: ios, tokentype, ivalue(5)
    double precision:: dvalue
    do
        write(*, fmt='(A)', advance='NO') '> '
        read(*, '(A)', iostat=ios) buffer
        if (ios /= 0) exit
        write(*, fmt='(A,A,A)') '[', trim(buffer), ']'
        call DCUnitsSetLine(buffer)
        do
            call DCUnitsGetToken(tokentype, ivalue, dvalue, cvalue)
            select case (tokentype)
            case (S_EOF)
                print "('EOF')"
                exit
            case (S_SHIFT)
                print "('SHIFT @')"
            case (S_TEXT)
                print "('TEXT <', a, '>')", trim(cvalue)
            case (S_MULTIPLY)
                print "('MULTIPLY *')"
            case (S_DIVIDE)
                print "('DIVIDE /')"
            case (S_EXPONENT)
                print "('EXPONENT ^')"
            case (S_OPENPAR)
                print "('OPENPAR (')"
            case (S_CLOSEPAR)
                print "('CLOSEPAR )')"
            case (S_REAL)
                print "('REAL', g10.3)", dvalue
            case (S_INTEGER)
                print "('INTEGER', i6)", ivalue(1)
            case default
                print "(A, i4)", "unknown token type", tokentype
            end select
        enddo
    enddo
end subroutine
