!= Module TimeFilter
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: timefilter.f90,v 1.1 2011-04-26 04:08:11 sugiyama Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
!åλ֥ե륿. leap-frog θŬ. 
! 
!== Error Handling
!
!== Bugs
!
!== Note
!
!== Future Plans
!
!

module TimeFilter

  !⥸塼ɤ߹
  use dc_types, only : DP
  use gridset, only: imin,    & !x β
    &                imax,    & !x ξ
    &                jmin,    & !y β
    &                jmax,    & !y ξ
    &                kmin,    & !z β
    &                kmax       !z ξ

  !ۤηػ
  implicit none

  !°
  private

  !ؿ public °
  public AsselinFilter

  !ѿ
  real(DP) :: tfil = 1.0d-1  !åλ֥ե륿η

  !ͤ save 
  save tfil
  
contains
  
  subroutine AsselinFilter(VarA, VarN, VarB)
    !
    ! ֥ե륿; Asselin Υե륿
    !

    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in)     :: VarA(imin:imax,jmin:jmax,kmin:kmax)
    real(DP), intent(inout)  :: VarN(imin:imax,jmin:jmax,kmin:kmax)  
    real(DP), intent(in)     :: VarB(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)                 :: Var(imin:imax,jmin:jmax,kmin:kmax)


    !֥ե륿
    Var  = VarN + tfil * ( VarB  - 2.0d0 * VarN + VarA ) 
    VarN = Var
    
  end subroutine AsselinFilter
  
end module TimeFilter
