!= Module Turbulence_kw1978
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA, Masatsugu
! Version::   $Id: turbulence_kw1978.f90,v 1.27 2015/02/19 02:17:24 sugiyama Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]


module Turbulence_kw1978
  !
  ! Klemp and Wilhelmson (1978) ή
  ! ήͥ륮λȯŸ򤯤ȤήȻ
  !

  !⥸塼ɤ߹ 
  use dc_types, only: DP, STRING
  use dc_iounit,  only: FileOpen
  use dc_message, only: MessageNotify
  use gtool_historyauto, only: HistoryAutoAddVariable, HistoryAutoPut

  use mpi_wrapper,only: myrank
  use timeset, only:  DelTimeLong, TimeN
  use gridset, only:  imin,           &! x β
    &                 imax,           &! x ξ
    &                 jmin,           &! y β
    &                 jmax,           &! y ξ
    &                 kmin,           &! z β
    &                 kmax,           &! z ξ
    &                 nx,ny,nz,ncmax,FlagCalc3D      ! 
  use basicset, only: xyz_PTempBZ,    &!ܾβ
    &                 xyzf_QMixBZ,    &!ܾκ
    &                 xyz_QMixBZ,    &!ܾκ
    &                 xyz_QMixBZPerMolWt,    &!ܾκ
    &                 xyz_EffMolWtBZ, &!ܾκ
    &                 xyz_VelSoundBZ,  &! ®
    &                 xyz_VPTempBZ,    &! 
    &                 xyz_ExnerBZ,     &!ܾΥʡؿ
    &                 xyz_DensBZ,      &!ܾ̩
    &                 pyz_DensBZ,      &!ܾ̩
    &                 xqz_DensBZ,      &!ܾ̩
    &                 xyr_DensBZ       !ܾ̩
  use constants,only: Grav,          &
    &                 MolWtDry,      & 
    &                 CpDry
  use composition, only: MolWtWet,      &
    &                 SpcWetSymbol,      &
    &                 SpcWetID,      &
    &                 CondNum,          &!ŷο
    &                 IdxCG,            &!ŷ()ź
    &                 IdxCC,            &!ŷ()ź
!    &                 IdxNH3,           &!NH3()ź
!    &                 IdxH2S,           &!H2S()ź
    &                 GasNum,           &!Το
    &                 IdxG               !Τź
  use ChemCalc, only: xyz_LatentHeat     !Ǯ
!    &                 ReactHeatNH4SH     !NH4SH ȿǮ
  use axesset, only: &  
    &                 x_dx,           &! x γʻֳ
    &                 y_dy,           &! y γʻֳ
    &                 z_dz,           &! z γʻֳ
    &                 xyz_pyz, xyr_pyr, xqz_pqz, &
    &                 pyz_xyz, pyr_xyr, pqz_xqz, &
    &                 xyz_xqz, pyz_pqz, xyr_xqr, &
    &                 xqz_xyz, pqz_pyz, xqr_xyr, &
    &                 xyz_xyr, pyz_pyr, xqz_xqr, &
    &                 xyr_xyz, pyr_pyz, xqr_xqz, &
    &                 pqz_xyz, pyr_xyz, xqr_xyz, &
    &                 xyz_pqz, xyz_pyr, xyz_xqr
  use xyz_deriv_module, only: xyz_dx_pyz, xyz_dy_xqz, xyz_dz_xyr, &
    &                         pyz_dx_xyz, xqz_dy_xyz, xyr_dz_xyz, &
    &                         pqz_dx_xqz, pqz_dy_pyz, pyz_dy_pqz, &
    &                         pyr_dx_xyr, pyz_dz_pyr, pyr_dz_pyz, &
    &                         pyr_dz_pyz, pyr_dx_xyr, xyr_dx_pyr, &
    &                         xqr_dz_xqz, xqr_dy_xyr, xyr_dy_xqr, &
    &                         pqz_dy_pyz, pqz_dx_xqz, xqz_dx_pqz, &
    &                         xqr_dy_xyr, xqr_dz_xqz, xqz_dz_xqr  
  use namelist_util, only: namelist_filename
  use setmargin, only: SetMargin_xyz
  use DExnerDt,  only: xyz_DExnerDt_xyz

  !ۤηػ
  implicit none

  !°λ
  private

  !ؿ public 
  public Turbulence_KW1978_Init
  public Turbulence_KW1978_Forcing

  !ѿ
  real(DP), save :: Cm     = 2.0d-1          !ήͥ륮Ǽη 
  real(DP), save :: MixLen = 0.0d0           !ʿѺΥ
  real(DP), save :: KmMax  = 0.0d0           !ήȻκ
  logical,  save :: FlagDExnerDtTurb =.true. !ήȻθ뤫Υå

  character(*), parameter:: module_name = 'turbulence_kw1978'


contains

!!!------------------------------------------------------------------------!!!
  subroutine turbulence_kw1978_init
    !
    ! Turbulence ⥸塼ν롼
    ! 

    !ۤηػ
    implicit none

    real(DP):: MinDelX
    real(DP):: MinDelY
    real(DP):: MinDelZ
    integer :: l
    integer :: unit

    ! NAMELIST 
    NAMELIST /turbulence_kw1978_nml/ &
      & Cm, KmMax,                   &
      & FlagDExnerDtTurb

    call FileOpen(unit, file=namelist_filename, mode='r')
    read(unit, NML=turbulence_kw1978_nml)
    close(unit)

    ! Υ
    ! 2 ׻ξˤ DelY ˰¸ʤ褦ˤ뤿 if ʸ.
    ! 
    MinDelX = minval(x_dx)
    MinDelY = minval(y_dy)
    MinDelZ = minval(z_dz)

    if ( FlagCalc3D ) then 
      MixLen = ( MinDelZ * MinDelX * MinDelY ) ** (1.0 / 3.0)
    else
      MixLen = sqrt(MinDelX * MinDelZ) 
    end if
    
    ! KmMax ꤵƤʤ. 
    ! ϤǤ, dt / l**2 < 0.5 ɬפ. Ǥ 0.1 ˤƤ. 
    !
    if (KmMax == 0.0d0) then 
       KmMax = 0.1 * ( MixLen * MixLen ) / ( DelTimeLong * 2.0d0 ) !LeapFrog
    end if

    ! Output
    !
    if (myrank == 0) then 
      call MessageNotify( "M", &
        & module_name, "Cm = %f", d=(/Cm/))
      call MessageNotify( "M", &
        & module_name, "KmMax = %f", d=(/KmMax/))
      call MessageNotify( "M", &
        & module_name, "MixLen= %f", d=(/MixLen/))
      call MessageNotify( "M", &
        & module_name, "FlagDExnerDtTurb= %b", l=(/ FlagDExnerDtTurb /))
    end if

    call HistoryAutoAddVariable(  &
      & varname='VelXTurb',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Turbulence term of velocity (x)', &
      & units='m.s-2',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelYTurb',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Turbulence term of velocity (y)', &
      & units='m.s-2',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='VelZTurb',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Turbulence term of velocity (z)', &
      & units='m.s-2',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='PTempTurb',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Turbulence term of potential temperature', &
      & units='K.s-1',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='PTempDisp',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Dissipation term of potential temperature', &
      & units='K.s-1',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='ExnerDisp',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Dissipation term of exner function', &
      & units='s-1',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='CDensTurb',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Turbulence term of cloud density', &
      & units='kg.m-3.s-1',    &
      & xtype='float')

    do l = 1, ncmax
      call HistoryAutoAddVariable(  &
        & varname=trim(SpcWetSymbol(l))//'_Turb', & 
        & dims=(/'x','y','z','t'/),     &
        & longname='Turbulence term of '          &
        &           //trim(SpcWetSymbol(l))//' mixing ratio',  &
        & units='kg.kg-1.s-1',    &
        & xtype='float')
    end do

    call HistoryAutoAddVariable(  &
      & varname='KmDiff',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Diffusion term of Km', &
      & units='s-1',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='KmBuoyT',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Buoyancy term of Km (temperature)', &
      & units='s-1',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='KmBuoyM',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Buoyancy term of Km (composition)', &
      & units='s-1',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='KmShear',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Shear term of Km', &
      & units='s-1',    &
      & xtype='float')

    call HistoryAutoAddVariable(  &
      & varname='KmDisp',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Dissipation term of Km', &
      & units='s-1',    &
      & xtype='float')


  end subroutine turbulence_kw1978_init

!!!------------------------------------------------------------------------!!!
  subroutine turbulence_KW1978_forcing(        &
    & pyz_VelXBl, xqz_VelYBl,   xyr_VelZBl,    &
    & xyz_PTempBl, xyz_ExnerBl, xyzf_QMixBl,   &
    & xyz_KmBl,    xyz_KhBl,    xyz_CDensBl,   &
    & pyz_DVelXDt, xqz_DVelYDt,  xyr_DVelZDt,  &
    & xyz_DPTempDt,xyz_DExnerDt, xyzf_DQMixDt, &
    & xyz_DKmDt,   xyz_DCDensDt,               &
    & xyz_KmAl, xyz_KhAl &
    )

    implicit none

    real(DP),intent(in) :: pyz_VelXBl(imin:imax,jmin:jmax,kmin:kmax)
                                                    !ʿ®
    real(DP),intent(in) :: xqz_VelYBl(imin:imax,jmin:jmax,kmin:kmax)
                                                    !ʿ®
    real(DP),intent(in) :: xyr_VelZBl(imin:imax,jmin:jmax,kmin:kmax)
                                                    !ľ®
    real(DP),intent(in) :: xyz_PTempBl(imin:imax,jmin:jmax,kmin:kmax)
                                                    !
    real(DP),intent(in) :: xyz_ExnerBl(imin:imax,jmin:jmax,kmin:kmax)
                                                    !̵
    real(DP),intent(in) :: xyzf_QMixBl(imin:imax,jmin:jmax,kmin:kmax, ncmax)
                                                    !Žʬκ
    real(DP),intent(in) :: xyz_KmBl(imin:imax,jmin:jmax,kmin:kmax)
                                                    !ήȻ
    real(DP),intent(in) :: xyz_KhBl(imin:imax,jmin:jmax,kmin:kmax)
                                                    !ήȻ
    real(DP),intent(in) :: xyz_CDensBl(imin:imax,jmin:jmax,kmin:kmax)

    real(DP),intent(inout):: pyz_DVelXDt(imin:imax,jmin:jmax,kmin:kmax)
                                                    !顼̤οʿήȻ
    real(DP),intent(inout):: xqz_DVelYDt(imin:imax,jmin:jmax,kmin:kmax)
                                                    !顼̤οʿήȻ
    real(DP),intent(inout):: xyr_DVelZDt(imin:imax,jmin:jmax,kmin:kmax)
                                                    !顼̤οʿήȻ
    real(DP),intent(inout):: xyz_DPTempDt(imin:imax,jmin:jmax,kmin:kmax)

    real(DP),intent(inout):: xyz_DExnerDt(imin:imax,jmin:jmax,kmin:kmax)

    real(DP),intent(inout):: xyzf_DQMixDt(imin:imax,jmin:jmax,kmin:kmax, ncmax)

    real(DP),intent(inout):: xyz_DKmDt(imin:imax,jmin:jmax,kmin:kmax)

    real(DP),intent(inout) :: xyz_DCDensDt(imin:imax,jmin:jmax,kmin:kmax)
    
    real(DP),intent(out):: xyz_KmAl(imin:imax,jmin:jmax,kmin:kmax)
                                                    !ήȻ
    real(DP),intent(out):: xyz_KhAl(imin:imax,jmin:jmax,kmin:kmax)
                                                    !ήȻ
    real(DP)            :: xyz_Buoy(imin:imax,jmin:jmax,kmin:kmax)
                                                    !Ǵ
    real(DP)            :: xyz_BuoyT(imin:imax,jmin:jmax,kmin:kmax)
                                                    !Ǵ
    real(DP)            :: xyz_BuoyM(imin:imax,jmin:jmax,kmin:kmax)
                                                    !Ǵ
    real(DP)            :: xyz_Shear(imin:imax,jmin:jmax,kmin:kmax)
                                                    !Ǵ
    real(DP)            :: xyz_Diff(imin:imax,jmin:jmax,kmin:kmax)
                                                    !Ǵ
    real(DP)            :: xyz_Disp(imin:imax,jmin:jmax,kmin:kmax)
                                                    !ήͥ륮ξû
    real(DP)            :: xyz_DispPI(imin:imax,jmin:jmax,kmin:kmax)
                                                    !ήͥ륮ξû
    real(DP)            :: xyz_DispHeat(imin:imax,jmin:jmax,kmin:kmax)
                                                    !ήͥ륮ξû
    real(DP)            :: xyz_Turb(imin:imax,jmin:jmax,kmin:kmax)
                                                    !
    real(DP)            :: xyzf_Turb(imin:imax,jmin:jmax,kmin:kmax, ncmax)
                                                    !顼̤οʿήȻ
    real(DP)            :: pyz_Turb(imin:imax,jmin:jmax,kmin:kmax)

    real(DP)            :: xqz_Turb(imin:imax,jmin:jmax,kmin:kmax)

    real(DP)            :: xyr_Turb(imin:imax,jmin:jmax,kmin:kmax)

    real(DP)            :: pyz_DVelXDt0(imin:imax,jmin:jmax,kmin:kmax)
                                                    !顼̤οʿήȻ
    real(DP)            :: xqz_DVelYDt0(imin:imax,jmin:jmax,kmin:kmax)
                                                    !顼̤οʿήȻ
    real(DP)            :: xyr_DVelZDt0(imin:imax,jmin:jmax,kmin:kmax)
                                                    !顼̤οʿήȻ
    real(DP)            :: xyz_DPTempDt0(imin:imax,jmin:jmax,kmin:kmax)

    real(DP)            :: xyz_DExnerDt0(imin:imax,jmin:jmax,kmin:kmax)

    real(DP)            :: xyzf_DQMixDt0(imin:imax,jmin:jmax,kmin:kmax, ncmax)

    real(DP)            :: xyz_DKmDt0(imin:imax,jmin:jmax,kmin:kmax)

    real(DP)            :: xyz_DCDensDt0(imin:imax,jmin:jmax,kmin:kmax)

    real(DP)            :: xyz_PTempBlAll(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)            :: xyzf_QMixBlAll(imin:imax,jmin:jmax,kmin:kmax, ncmax)
    integer             :: f


    !----------------------------------
    ! 
    !
    xyz_PTempBlAll = xyz_PTempBl + xyz_PTempBZ
    xyzf_QMixBlAll  = xyzf_QMixBl + xyzf_QMixBZ 
    pyz_DVelXDt0 = pyz_DVelXDt
    xqz_DVelYDt0 = xqz_DVelYDt
    xyr_DVelZDt0 = xyr_DVelZDt
    xyz_DPTempDt0 = xyz_DPTempDt
    xyz_DExnerDt0 = xyz_DExnerDt
    xyzf_DQMixDt0 = xyzf_DQMixDt
    xyz_DKmDt0    = xyz_DKmDt
    xyz_DCDensDt0 = xyz_DCDensDt
    
    !----------------------------------
    ! ȻλȯŸ (ͥ륮 Km μѷ)
    !

    ! Buoyancy term
    !
    xyz_Buoy = xyz_BuoyMoistKm(xyz_PTempBl, xyz_ExnerBl, xyzf_QMixBl) 
    xyz_BuoyT =                                                    &
        &  - 3.0d0 * Grav * ( Cm * Cm ) * ( MixLen * MixLen )      &
        &       * xyz_xyr( xyr_dz_xyz( xyz_PTempBlAll ) )          &
        &       / ( 2.0d0 * xyz_PTempBZ )
    xyz_BuoyM = xyz_Buoy - xyz_BuoyT


    xyz_Shear =                                                    &
      &   ( Cm * Cm ) * ( MixLen * MixLen )                        &
      & * (                                                        &
      &      ( xyz_dx_pyz( pyz_VelXBl ) ) ** 2.0d0                 &
      &    + ( xyz_dy_xqz( xqz_VelYBl ) ) ** 2.0d0                 &
      &    + ( xyz_dz_xyr( xyr_VelZBl ) ) ** 2.0d0                 &
      &    + 5.0d-1                                                &
      &      * (                                                   &
      &          (                                                 &
      &              xyz_pyr( pyr_dz_pyz( pyz_VelXBl ) )           &
      &            + xyz_pyr( pyr_dx_xyr( xyr_VelZBl ) )           &
      &           ) ** 2.0d0                                       &
      &        + (                                                 &
      &              xyz_xqr( xqr_dy_xyr( xyr_VelZBl ) )           &
      &            + xyz_xqr( xqr_dz_xqz( xqz_VelYBl ) )           &
      &           ) ** 2.0d0                                       &
      &        + (                                                 &
      &              xyz_pqz( pqz_dx_xqz( xqz_VelYBl ) )           &
      &            + xyz_pqz( pqz_dy_pyz( pyz_VelXBl ) )           &
      &           ) ** 2.0d0                                       &
      &        )                                                   &
      &   )                                                        &
      & - xyz_KmBl * (  xyz_dx_pyz( pyz_VelXBl )                   &
      &               + xyz_dy_xqz( xqz_VelYBl )                   &
      &               + xyz_dz_xyr( xyr_VelZBl ) ) / 3.0d0

    xyz_Diff =                                                     &
      &   5.0d-1                                                   &
      &   * (                                                      &
      &         xyz_dx_pyz(pyz_dx_xyz(xyz_KmBl ** 2.0d0))          &
      &       + xyz_dy_xqz(xqz_dy_xyz(xyz_KmBl ** 2.0d0))          &
      &       + xyz_dz_xyr(xyr_dz_xyz(xyz_KmBl ** 2.0d0))          &
      &     )                                                      &
      & + (                                                        &
      &      (xyz_pyz(pyz_dx_xyz(xyz_KmBl))) ** 2.0d0              &
      &    + (xyz_xqz(xqz_dy_xyz(xyz_KmBl))) ** 2.0d0              &
      &    + (xyz_xyr(xyr_dz_xyz(xyz_KmBl))) ** 2.0d0              &
      &   )
    
    ! t - \Delta t ɾ
    !
    xyz_Disp = - (xyz_KmBl ** 2.0d0) * 5.0d-1 / (MixLen ** 2.0d0)

    ! tendency
    !
    xyz_DKmDt = xyz_DKmDt0 + xyz_Buoy + xyz_Shear + xyz_Diff + xyz_Disp

    call HistoryAutoPut(TimeN, 'KmBuoyT', xyz_BuoyT(1:nx,1:ny,1:nz))    
    call HistoryAutoPut(TimeN, 'KmBuoyM', xyz_BuoyM(1:nx,1:ny,1:nz))    
    call HistoryAutoPut(TimeN, 'KmShear', xyz_Shear(1:nx,1:ny,1:nz))    
    call HistoryAutoPut(TimeN, 'KmDiff', xyz_Diff(1:nx,1:ny,1:nz))    
    call HistoryAutoPut(TimeN, 'KmDisp', xyz_Disp(1:nx,1:ny,1:nz))    
   
    ! ʬ
    !
    xyz_KmAl = xyz_KmBl + (2.0d0 * DelTimeLong) * xyz_DKmDt

    ! ͤ
    !
    xyz_KmAl = max( 0.0d0, min( xyz_KmAl, KmMax ) )

    ! Kh 
    !
    xyz_KhAl = 3.0d0 * xyz_KmAl

    !--------------------------------
    ! ̩٤ tendency
    !
    xyz_Turb =                                                              &
      &   xyz_dx_pyz( pyz_xyz( xyz_KhBl ) * pyz_dx_xyz( xyz_CDensBl ) ) &
      & + xyz_dy_xqz( xqz_xyz( xyz_KhBl ) * xqz_dy_xyz( xyz_CDensBl ) ) &
      & + xyz_dz_xyr( xyr_xyz( xyz_DensBZ * xyz_KhBl ) * xyr_dz_xyz( xyz_CDensBl ) ) / xyz_DensBZ

    xyz_DCDensDt = xyz_DCDensDt0 + xyz_Turb

    ! output
    !
    call HistoryAutoPut(TimeN, 'CDensTurb', xyz_Turb(1:nx,1:ny,1:nz))    

    !--------------------------------
    ! ̤ tendency
    !
    xyz_Turb =                                                                  &
      &   xyz_dx_pyz( pyz_xyz( xyz_KhBl ) * pyz_dx_xyz( xyz_PTempBlAll ) )  &
      & + xyz_dy_xqz( xqz_xyz( xyz_KhBl ) * xqz_dy_xyz( xyz_PTempBlAll ) )  &
      & + xyz_dz_xyr( xyr_xyz( xyz_DensBZ * xyz_KhBl ) * xyr_dz_xyz( xyz_PTempBlAll ) ) / xyz_DensBZ
    
    xyz_DispHeat = (xyz_KmBl ** 3.0d0) &
      & / (xyz_ExnerBZ * CpDry * (Cm ** 2.0d0) * (MixLen ** 4.0d0))

    xyz_DPTempDt = xyz_DPTempDt0 + xyz_Turb + xyz_DispHeat

    call HistoryAutoPut(TimeN, 'PTempDisp', xyz_DispHeat(1:nx, 1:ny, 1:nz))
    call HistoryAutoPut(TimeN, 'PTempTurb', xyz_Turb(1:nx, 1:ny, 1:nz))

    !--------------------------------
    !  tendency
    !
    do f = 1, ncmax    
      xyzf_Turb(:,:,:,f) =                                                     &
        &   xyz_dx_pyz( pyz_xyz( xyz_KhBl ) * pyz_dx_xyz( xyzf_QMixBlAll(:,:,:,f) ) )  &
        & + xyz_dy_xqz( xqz_xyz( xyz_KhBl ) * xqz_dy_xyz( xyzf_QMixBlAll(:,:,:,f) ) )  &
        & + xyz_dz_xyr( xyr_xyz( xyz_DensBZ * xyz_KhBl ) * xyr_dz_xyz( xyzf_QMixBlAll(:,:,:,f) ) ) / xyz_DensBZ
      
      call HistoryAutoPut(TimeN, trim(SpcWetSymbol(f))//'_Turb', xyzf_Turb(1:nx,1:ny,1:nz,f))
    end do

    xyzf_DQMixDt = xyzf_DQMixDt0 + xyzf_Turb
    
    !--------------------------------
    ! ®ʬ tendency
    !
    pyz_Turb = &
      &   2.0d0 * pyz_dx_xyz( xyz_KmBl * xyz_dx_pyz( pyz_VelXBl ) )&
      & + pyz_dy_pqz(                                              &
      &       pqz_xyz( xyz_KmBl ) * pqz_dx_xqz( xqz_VelYBl )   &
      &     + pqz_xyz( xyz_KmBl ) * pqz_dy_pyz( pyz_VelXBl )   &
      &   )                                                        &
      & + pyz_dz_pyr(                                              &
      &       pyr_xyz( xyz_DensBZ * xyz_KmBl ) * pyr_dx_xyr( xyr_VelZBl )   &
      &     + pyr_xyz( xyz_DensBZ * xyz_KmBl ) * pyr_dz_pyz( pyz_VelXBl )   &
      &   ) / pyz_DensBZ                                           &
      & - 2.0d0 * pyz_dx_xyz( ( xyz_KmBl ** 2.0d0 ) )              &
      &   / ( 3.0d0 * ( Cm ** 2.0d0 ) * ( MixLen ** 2.0d0 ) )

    pyz_DVelXDt = pyz_DVelXDt0 + pyz_Turb

    call HistoryAutoPut(TimeN, 'VelXTurb', pyz_Turb(1:nx, 1:ny, 1:nz))

    xqz_Turb = &
      &   2.0d0 * xqz_dy_xyz( xyz_KmBl * xyz_dy_xqz( xqz_VelYBl ) ) &
      & + xqz_dx_pqz(                                             &
      &       pqz_xyz( xyz_KmBl ) * pqz_dy_pyz( pyz_VelXBl )  &
      &     + pqz_xyz( xyz_KmBl ) * pqz_dx_xqz( xqz_VelYBl )  &
      &   )                                                       &
      & + xqz_dz_xqr(                                             &
      &       xqr_xyz( xyz_DensBZ * xyz_KmBl ) * xqr_dy_xyr( xyr_VelZBl )  &
      &     + xqr_xyz( xyz_DensBZ * xyz_KmBl ) * xqr_dz_xqz( xqz_VelYBl )  &
      &   ) / xqz_DensBZ                                          &
      & - 2.0d0 * xqz_dy_xyz( ( xyz_KmBl ** 2.0d0 ) )             &
      &   / ( 3.0d0 * ( Cm ** 2.0d0 ) * ( MixLen ** 2.0d0 ) )
    
    xqz_DVelYDt = xqz_DVelYDt0 + xqz_Turb

    call HistoryAutoPut(TimeN, 'VelYTurb', xqz_Turb(1:nx, 1:ny, 1:nz))

    xyr_Turb = &
      & + 2.0d0 * xyr_dz_xyz( xyz_DensBZ * xyz_KmBl * xyz_dz_xyr( xyr_VelZBl ) ) &
      &    / xyr_DensBZ                                            &
      & + xyr_dx_pyr(                                               &
      &      pyr_xyz( xyz_KmBl ) * pyr_dz_pyz( pyz_VelXBl )     &
      &    + pyr_xyz( xyz_KmBl ) * pyr_dx_xyr( xyr_VelZBl )     &
      &   )                                                         &
      & + xyr_dy_xqr(                                               &
      &      xqr_xyz( xyz_KmBl ) * xqr_dz_xqz( xqz_VelYBl )     &
      &    + xqr_xyz( xyz_KmBl ) * xqr_dy_xyr( xyr_VelZBl )     &
      &   )                                                         & 
      & - 2.0d0 * xyr_dz_xyz( xyz_DensBZ * ( xyz_KmBl ** 2.0d0 ) )  &
      &   / ( 3.0d0 * ( Cm ** 2.0d0 ) * ( MixLen ** 2.0d0 ) )       &
      &   / xyr_xyz( xyz_DensBZ ) 

    xyr_DVelZDt = xyr_DVelZDt0 + xyr_Turb

    call HistoryAutoPut(TimeN, 'VelZTurb', xyr_Turb(1:nx, 1:ny, 1:nz))

    !--------------------
    ! Exner function
    !
    if ( FlagDExnerDtTurb ) then
      xyz_DispPI = xyz_DExnerDt_xyz( xyz_DispHeat )
    else 
      xyz_DispPi = 0.0d0
    end if
    xyz_DExnerDt = xyz_DExnerDt0 + xyz_DispPI

    call HistoryAutoPut(TimeN, 'ExnerDisp', xyz_DispPI(1:nx, 1:ny, 1:nz))

    ! Set Margin
    !
    call SetMargin_xyz(xyz_KmAl)
    call SetMargin_xyz(xyz_KhAl)

  end subroutine Turbulence_KW1978_forcing


!!!------------------------------------------------------------------------!!!
  function xyz_BuoyMoistKm(xyz_PTemp, xyz_Exner, xyzf_QMix)
    !

    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in) :: xyz_PTemp(imin:imax,jmin:jmax,kmin:kmax)
                                               !
    real(DP), intent(in) :: xyz_Exner(imin:imax,jmin:jmax,kmin:kmax)
                                               !̵
    real(DP), intent(in) :: xyzf_QMix(imin:imax,jmin:jmax,kmin:kmax, ncmax)
                                               !Žʬκ
    real(DP) :: xyzf_QMixAll(imin:imax,jmin:jmax,kmin:kmax, ncmax)
                                               !Žʬκ
    real(DP) :: xyzf_QMixAll2(imin:imax,jmin:jmax,kmin:kmax, ncmax)
                                               !Žʬκ
    real(DP) :: xyz_BuoyMoistKm(imin:imax,jmin:jmax,kmin:kmax)
                                               !
    real(DP) :: xyzf_LatentHeat(imin:imax,jmin:jmax,kmin:kmax, GasNum)
                                               !Ǯ
    real(DP) :: xyz_TempAll(imin:imax,jmin:jmax,kmin:kmax)
                                               !
    real(DP) :: xyz_EffHeat(imin:imax,jmin:jmax,kmin:kmax)
                                               !
    real(DP) :: xyz_EffPTemp(imin:imax,jmin:jmax,kmin:kmax)    
                                               !ϤФ벹ٺδͿ
    real(DP) :: xyz_EffMolWt(imin:imax,jmin:jmax,kmin:kmax)    
                                               !ϤФʬ̺δͿ
    real(DP) :: xyzf_QMixPerMolWt(imin:imax,jmin:jmax,kmin:kmax, GasNum)
                                               !/ʬ
    integer              :: s
    
    
    !, , ̤
    !ʬʿʬ­
    xyz_TempAll = ( xyz_PTemp + xyz_PTempBZ ) * ( xyz_Exner + xyz_ExnerBZ )
    xyzf_QMixAll = xyzf_QMixBZ + xyzf_QMix
    xyzf_LatentHeat = 0.0d0
    
    !ν. ΤΤ
    !
    do s = 1, GasNum
      xyzf_QMixPerMolWt(:,:,:,s) = xyzf_QMix(:,:,:,IdxG(s)) / MolWtWet(IdxG(s))
    end do
    
    !٤θ
    !
    xyz_EffPTemp = xyz_PTemp / xyz_PTempBZ 
    
    !ʬ̸ + Ťθ
    !
    xyz_EffMolWt =                                      &
      & + sum(xyzf_QMixPerMolWt, 4)                     &
      &    / ( 1.0d0 / MolWtDry + xyz_QMixBZPerMolWt )  &
      & - sum(xyzf_QMix, 4) / ( 1.0d0 + xyz_QMixBZ )
    
    !ȯǮ׻
    !  ʬ̤ʬϤĤǤǮ˰¤ƤʤȸʤΤ, 
    !  κ椬λˤ, ǮδͿϥȤʤ褦ĴᤷƤ
    !
    xyzf_QMixAll2 = xyzf_QMixAll
!    xzya_QMixAll2(:,:,:,IdxNH3) = &
!      &  xyzf_QMixAll(:,:,:,IdxNH3) - xyzf_QMixAll(:,:,:,IdxH2S) 

    do s = 1, CondNum
      xyzf_LatentHeat(:,:,:,s) =                             &
        & xyz_LatentHeat( SpcWetID(IdxCC(s)), xyz_TempAll )  &
        &  * xyzf_QMixAll2(:,:,:,IdxCG(s))                    &
        &  * ( 5.0d-1 + sign( 5.0d-1, (xyzf_QMixAll2(:,:,:,IdxCC(s)) - 1.0d-4) ) )
    end do

    xyz_EffHeat = ( sum( xyzf_LatentHeat, 4 ) * xyz_EffMolWtBZ &
      &          ) / ( CpDry * xyz_ExnerBZ ) 

    
    !ήȻλȯŸϹ
    xyz_BuoyMoistKm = &
      &  - 3.0d0 * Grav * ( Cm * Cm ) * ( MixLen * MixLen )         &
      &    * xyz_xyr(                                               &
      &        xyr_dz_xyz(                                          &
      &           xyz_EffHeat                                       &
      &         + xyz_PTempBZ / xyz_EffMolWtBZ                      &
      &           * ( 1.0d0 + xyz_EffPTemp + xyz_EffMolWt )         &
      &         )                                                   &
      &      )                                                      &
      &    / ( 2.0d0 * xyz_PTempBZ / xyz_EffMolWtBZ)                   

  end function xyz_BuoyMoistKm

end module Turbulence_kw1978
