!= Module initialdata_baker1998
!
! Authors::   SUGIYAMA Koichiro, ODAKA Masatsugu
! Version::   $Id: initialdata_baker1998.f90,v 1.2 2014-03-04 05:55:04 sugiyama Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]


module initialdata_baker1998
  !
  ! Baker et al. (1998) Ϥ뤿Υ⥸塼

  !⥸塼ɤ߹
  use dc_types,   only: STRING, DP
  use dc_message, only: MessageNotify
  use mpi_wrapper,only: myrank
  use gridset,  only: kmin,          &! Z β
    &                 kmax,          &! Z ξ
    &                 nz,            &! Z ο
    &                 ncmax           !Žʬο
  use axesset, only:  z_Z, r_Z, dz    !
  use constants, only:GasRDry,       &!ʬ갵Ǯ
    &                 TempTop,       &!ɽ̲
    &                 PressTop,      &!ɽ̰
    &                 PressBasis,    &!ɽ̰
    &                 CpDry,         &!ǮΨ
    &                 Grav            !
  use composition

    
  !ۤηػ
  implicit none

  !ǥեȤ private
  private

  !
  public initialdata_baker1998_basic

contains

!!------------------------------------------------------------------------------!!!
  subroutine initialdata_baker1998_basic( z_Temp, z_Press )
    !
    !== 
    !  * Baker and Shubert (1989) ǻȤ줿ͤƸ.
    !    * 絤٤鲹١Ϥδܾ
    !      * ̤Υǡϰ٤ǼƤΤ, 򲹰̤ǾƤľ
    !      * ̤, ܾβ١Ϥ׻. 
    !

    implicit none
    
    real(DP), intent(out) :: z_Press(kmin:kmax)!
    real(DP), intent(out) :: z_Temp(kmin:kmax) !
    real(DP)              :: r_DPTempDz(kmin:kmax)
    real(DP)              :: z_PTemp(kmin:kmax)
    real(DP), parameter   :: r_dPTempDz_45km = 3.9d-3
    real(DP), parameter   :: r_dPTempDz_48km = 0.0d0
    real(DP), parameter   :: r_dPTempDz_55km = 0.0d0
    real(DP), parameter   :: r_dPTempDz_60km = 8.35d-3
    integer               :: k

    ! 
    !
    z_Press  = 0.0d0
    z_Temp   = 0.0d0

    ! 絤٤Ϳ.
    !   BS1998 ɽ 1 ܤɤ߼, ľƤ. 
    ! 
    do k = kmin, kmax
      if ( r_Z(k) < 45.0d3 ) then 
        r_DPTempDz(k) = r_DPTempDz_45km + 0.30d-6 * ( r_Z(k) - 45.0d3 )
      elseif ( 45.0d3 <= r_Z(k) .AND. r_Z(k) < 48.0d3 ) then 
        r_DPTempDz(k) = r_DPTempDz_45km - 1.30d-6 * ( r_Z(k) - 45.0d3 )
      elseif ( 48.0d3 <= r_Z(k) .AND. r_Z(k) < 55.0d3 ) then 
        r_DPTempDz(k) = r_DPTempDz_48km
      elseif ( 55.0d3 <= r_Z(k) .AND. r_Z(k) < 60.0d3 ) then 
        r_DPTempDz(k) = r_DPTempDz_55km + 1.67d-6 * ( r_Z(k) - 55.0d3 )
      elseif ( 60.0d3 <= r_Z(k) ) then 
        r_DPTempDz(k) = r_DPTempDz_60km - 1.20d-6 * ( r_Z(k) - 60.0d3 )
      end if
    end do

    ! ̸ DPTempDz ʬپ z_PTemp ׻
    ! ȾʻͤѤ. 
    !
    z_PTemp(nz) = TempTop - r_DPTempDz(1) * dz * 0.5d0
    do k = nz-1, 1, -1
      z_PTemp(k) = z_PTemp(k+1) - r_DPTempDz(k) * dz
    end do

    !----------------------------------------------
    ! ϤȲ٤η׻
    !    
    z_Press(nz) = 2.20d4
    z_Temp(nz)  = 268.0d0
!    z_Press(nz) = PressTop + (Grav * PressTop * dz * 5.0d-1) / (GasRDry * TempTop)
!    z_Temp(nz)  = z_PTemp(nz) * (z_Press(nz) / PressBasis) ** (GasRDry / CpDry)

    do k = nz-1, 1, -1
      z_Press(k) = z_Press(k+1) + (Grav * z_Press(k+1) * dz) / (GasRDry * z_Temp(k+1))
      z_Temp(k)  = z_PTemp(k) * ((z_Press(k) / PressBasis) ** (GasRDry / CpDry))
    end do
       
  end subroutine Initialdata_baker1998_basic
  
end module Initialdata_baker1998
