!= Module EnergyMonit
!
! Authors::   ODAKA Masatsugu 
! Version::   $Id: $
! Tag Name::  $Name: $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!¸̤η׻ȽϤԤΥ⥸塼
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!
!== Future Plans
!
module EnergyMonit
  ! ¸̤η׻ȽϤԤΥ⥸塼

  !⥸塼ɤ߹
  use dc_types,   only: DP, STRING
  use dc_iounit,  only: FileOpen
  use dc_message, only: MessageNotify
  use gtool_historyauto, &
    &             only: HistoryAutoAddVariable, HistoryAutoPut

  use mpi_wrapper,only: myrank
  use gridset,  only: imin,         & !x β
    &                 imax,         & !x ξ
    &                 jmin,         & !y β
    &                 jmax,         & !y ξ
    &                 kmin,         & !z β
    &                 kmax,         & !z ξ
    &                 nx, ny, nz
  use axesset,  only: xyz_dx, xyz_dy, xyz_dz, &           !ʻֳ
    &                 xyz_Z,                  &           !ɸ
    &                 xmin, xmax, ymin, ymax, zmin, zmax,&!׻ΰ
    &                 xyz_avr_pyz, xyz_avr_xqz, xyz_avr_xyr
  use constants,only: CpDry,        & !갵Ǯ
    &                 CvDry,        & !Ǯ
    &                 GasRDry,      & !
    &                 PressSfc,     & !ɽ
    &                 Grav            !ϲ®
  use basicset, only: xyz_ExnerBZ,  & !ܾΰϴؿ
    &                 xyz_PressBZ,  & !ܾε
    &                 xyz_PTempBZ,  & !ܾβ
    &                 xyz_TempBZ,   & !ܾβ
    &                 xyzf_QMixBZ,  & !ܾκ
    &                 xyz_DensBZ,   & !ܾ̩
    &                 xyz_VelSoundBZ  !®

  use timeset, only:  TimeN
  use namelist_util, only: namelist_filename

  ! ѿ
  character(*), parameter:: module_name = 'energymonit'
                              ! ⥸塼̾.

                              ! Module name
  

contains
!!!------------------------------------------------------------------------!!!
  subroutine EnergyMonit_init
    !
    !ѿԤ. 
    !

    !ۤηػ
    implicit none

    call HistoryAutoAddVariable(   &
      & varname='DensDev',         &
      & dims=(/'t'/),  &
      & longname='Total density deviation', &
      & units='kg',            &
      & xtype='float')

    call HistoryAutoAddVariable(   &
      & varname='KinEnrgy',        &
      & dims=(/'t'/),  &
      & longname='Total kinetic energy', &
      & units='J',             &
      & xtype='float')

    call HistoryAutoAddVariable(   &
      & varname='ElstEnrgy',       &
      & dims=(/'t'/),  &
      & longname='Total elastic energy', &
      & units='J',             &
      & xtype='float')

    call HistoryAutoAddVariable(   &
      & varname='PotEnrgy',        &
      & dims=(/'t'/),  &
      & longname='Total potential energy', &
      & units='J',             &
      & xtype='float')

  end subroutine EnergyMonit_init
!!!------------------------------------------------------------------------!!!
  subroutine EnergyMonit( &
    & pyz_VelX, xqz_VelY, xyr_VelZ, xyz_Exner, xyz_PTemp &
    )
    !
    !¸̤η׻ȽϤԤ. ׻̤
    !, ưͥ륮, ͥ륮, ݥƥ󥷥륨ͥ륮
    !

    !ۤηػ
    implicit none

    !ѿ
    real(DP),intent(in) :: pyz_VelX(imin:imax,jmin:jmax,kmin:kmax)   !®(xʬ)
    real(DP),intent(in) :: xqz_VelY(imin:imax,jmin:jmax,kmin:kmax)   !®(yʬ)
    real(DP),intent(in) :: xyr_VelZ(imin:imax,jmin:jmax,kmin:kmax)   !®(zʬ)
    real(DP),intent(in) :: xyz_Exner(imin:imax,jmin:jmax,kmin:kmax)  !ϴؿ
    real(DP),intent(in) :: xyz_PTemp(imin:imax,jmin:jmax,kmin:kmax)  !

    real(DP) :: xyz_DensDev(imin:imax,jmin:jmax,kmin:kmax) 
                                     !̩(к)
    real(DP) :: xyz_KinEnrgyDens(imin:imax,jmin:jmax,kmin:kmax) 
                                     !ưͥ륮̩
    real(DP) :: xyz_ElstEnrgyDens(imin:imax,jmin:jmax,kmin:kmax)
                                     !ͥ륮̩
    real(DP) :: xyz_PotEnrgyDens(imin:imax,jmin:jmax,kmin:kmax)
                                     !ݥƥ󥷥륨ͥ륮̩

    real(DP) :: MassTotalBZ          !(ܾ)
    real(DP) :: MassTotalDev         !(к)
    real(DP) :: KinEnrgyTotal        !ưͥ륮
    real(DP) :: ElstEnrgyTotal       !ͥ륮
    real(DP) :: PotEnrgyTotal        !ݥƥ󥷥륨ͥ륮

! ɲä٤(׸Ƥ)
! * ư
! * 󥿥ԡ
! * ȥ졼
! * Ǯ

    ! Ƴʻ絤̩к
    ! 
    xyz_DensDev = PressSfc * ( & 
      & (xyz_ExnerBZ + xyz_Exner)**( CvDry/GasRDry ) &
      &          - (xyz_ExnerBZ )**( CvDry/GasRDry ) &
      & )/xyz_PTempBZ 

    ! ΰΤ絤
    !
    MassTotalBZ  = (xyz_PressBz(1,1,1) - xyz_PressBz(1,1,nz))/Grav &
      &              *(xmax - xmin)*(ymax - ymin)
    MassTotalDev = sum(xyz_dx(1:nx,1:ny,1:nz)* &
      &                xyz_dy(1:nx,1:ny,1:nz)* &
      &                xyz_dz(1:nx,1:ny,1:nz)* &
      &                xyz_DensDev(1:nx,1:ny,1:nz))

   
    ! Ƴʻαưͥ륮̩
    ! * ̩٤ϴܾͤɾ
    ! 
    xyz_KinEnrgyDens = 0.5d0 * xyz_DensBZ * ( &
      &             xyz_avr_pyz(pyz_VelX)**2  &
      &           + xyz_avr_xqz(xqz_VelY)**2  &
      &           + xyz_avr_xyr(xyr_VelZ)**2  &
      & )

    !Ƴʻͥ륮̩
    ! * ̩٤ϴܾͤɾ
    !  
    xyz_ElstEnrgyDens = 0.5d0 * xyz_DensBZ     &
      &  * (CpDry * xyz_PTempBZ * xyz_Exner / xyz_VelSoundBZ)**2 
      
    ! ΰΤαư/ͥ륮
    !
    KinEnrgyTotal = sum(xyz_dx(1:nx,1:ny,1:nz)* &
      &                  xyz_dy(1:nx,1:ny,1:nz)* &
      &                  xyz_dz(1:nx,1:ny,1:nz)* &
      &                  xyz_KinEnrgyDens(1:nx,1:ny,1:nz))

    ElstEnrgyTotal = sum(xyz_dx(1:nx,1:ny,1:nz)* &
      &                   xyz_dy(1:nx,1:ny,1:nz)* &
      &                   xyz_dz(1:nx,1:ny,1:nz)* &
      &                   xyz_ElstEnrgyDens(1:nx,1:ny,1:nz))


    !ƳʻΥݥƥ󥷥륨ͥ륮̩
    ! 
    xyz_PotEnrgyDens = &
      &  - Grav * xyz_DensBZ * xyz_PTemp * xyz_Z / xyz_PTempBZ

    ! ΰΤΥݥƥ󥷥륨ͥ륮
    !
    PotEnrgyTotal = sum(xyz_dx(1:nx,1:ny,1:nz)* &
      &                  xyz_dy(1:nx,1:ny,1:nz)* &
      &                  xyz_dz(1:nx,1:ny,1:nz)* &
      &                  xyz_PotEnrgyDens(1:nx,1:ny,1:nz))


    !եؤν
    !
    call HistoryAutoPut(TimeN, 'DensDev',   MassTotalDev  )
    call HistoryAutoPut(TimeN, 'KinEnrgy',  KinEnrgyTotal )
    call HistoryAutoPut(TimeN, 'ElstEnrgy', ElstEnrgyTotal)
    call HistoryAutoPut(TimeN, 'PotEnrgy',  PotEnrgyTotal )

  end subroutine EnergyMonit

end module EnergyMonit
