!= Module MoistAdjust
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: moistadjust.f90,v 1.6 2012-01-12 11:53:09 sugiyama Exp $
! Tag Name::  $Name: arare5-20120511 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
!˰Ĵˡ
! 
!== Error Handling
!
!== Bugs
!
!== Note
!
!== Future Plans
!
!

Module MoistAdjust
  !
  !˰ĴˡԤΥѥå⥸塼
  !  * ˰¾Ȥؼ, 층Ū˼¹Ԥ
  !  * ȿˤĤƤ, 줾βȿ˼¹Ԥ. 

  !⥸塼ɤ߹
  use dc_types,   only : DP
  use dc_message, only : MessageNotify
  use gridset, only :    ncmax,                &!ؼο
    &                    imin, imax,        &!x ξ¤Ȳ
    &                    jmin, jmax,        &!y ξ
    &                    kmin, kmax          !z β
  use basicset,only :    xyz_ExnerBZ,       &!̵(ܾ)
    &                    xyz_PTempBZ,       &!(ܾ)
    &                    xyzf_QMixBZ         !Žʬ(ܾ)
    use constants, only: PressBasis,        &!̤δవ         [Pa]
    &                    CpDry,             &!ʬʿ갵Ǯ [J/K kg]
    &                    MolWtDry,          &!ʬʿʬ   [kg/mol]
    &                    GasRDry             !ʬε     [J/K kg]
  use composition, only :   MolWtWet,          &!ʬʬ  
    &                    SpcWetID,          &!ʬβؼID 
    &                    CondNum,           &!ŷο
    &                    IdxCG,             &!ŷ()ź
    &                    IdxCC,             &!ŷ()ź
    &                    IdxNH3,            &!NH3()ź
    &                    IdxH2S,            &!H2S()ź
    &                    IdxNH4SHc           !NH4SH()ź
  use ChemCalc, only : xyz_SvapPress, xyz_LatentHeat, ReactHeatNH4SH, xyz_DQMixSatDPTemp, xyz_DelQMixNH4SH

  !ۤηػ
  implicit none
  
  !°λ
  private

  !ؿ° public ѹ
  public MoistAdjustSvapPress    !˰¾Ѥ˰¼Ĵ(ʰ)
  public MoistAdjustNH4SH        !ȿΰʿѤ˰¼Ĵ

contains

!!!------------------------------------------------------------------!!!
  subroutine MoistAdjustSvapPress(xyz_PressDry, xyz_Exner, xyz_PTemp, xyzf_QMix)
    !
    ! ˰¾Ѥ˰Ĵˡμ¹
    ! ץǤ, ͽ᤿ȿɤԤ. 
    !

    !ۤηػ
    implicit none
    
    !ѿ
    real(8),intent(in)   :: xyz_PressDry(imin:imax,jmin:jmax,kmin:kmax) 
                                                          !ʬΰ
    real(8),intent(in)   :: xyz_Exner(imin:imax,jmin:jmax,kmin:kmax) 
                                                          !ʡؿ
    real(8),intent(inout):: xyz_PTemp(imin:imax,jmin:jmax,kmin:kmax) 
                                                          !
    real(8),intent(inout):: xyzf_QMix(imin:imax,jmin:jmax,kmin:kmax, ncmax)
                                                          !
    integer, parameter   :: ItrNum = 4                    !ȿɤβ

    real(DP):: xyz_QMixV_pre(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP):: xyz_QMixV_nxt(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP):: xyz_QMixC_pre(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP):: xyz_QMixC_nxt(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP):: xyz_PTemp_pre(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP):: xyz_PTemp_nxt(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP):: xyz_ExnerAll(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP):: xyz_TempAll(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP):: xyz_DelQMix(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP):: xyz_QMixSat(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP):: xyz_Cond(imin:imax,jmin:jmax,kmin:kmax)  
    real(DP):: xyz_Evap(imin:imax,jmin:jmax,kmin:kmax)  
    real(DP):: xyz_Gamma(imin:imax,jmin:jmax,kmin:kmax) 
    integer :: i, s                                       ! ź  
    integer :: IG, iC

    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
!    xyz_QMixV_pre  = 0.0d0
!    xyz_QMixV_nxt  = 0.0d0
!    xyz_QMixC_pre  = 0.0d0
!    xyz_QMixC_nxt  = 0.0d0
!    xyz_PTemp_pre = 0.0d0
!    xyz_PTemp_nxt = 0.0d0
    
!    xyz_ExnerAll    = 0.0d0
!    xyz_TempAll     = 0.0d0
!    xyz_DelQMix    = 0.0d0
!    xyz_QMixSat    = 0.0d0 
!    xyz_Gamma       = 0.0d0
    
    !---------------------------------------------------------------------
    ! ˰Ĵˡμ¹
    !   롼פ󤹤Τ, ˤĤƤ.  
    !---------------------------------------------------------------------
    LoopSvapPress: do s = 1, CondNum

       ! źݴ
       iG = IdxCG(s)
       iC = IdxCC(s)
      
      !˰ˡǤϰϤѲʤ. 
      xyz_ExnerAll = xyz_Exner + xyz_ExnerBZ
          
      !ޤǤ줿ʬ̤ͤȤߤʤ. źɲ
      xyz_QMixV_pre  = xyzf_QMix(:,:,:,iG) + xyzf_QMixBZ(:,:,:,iG)
      xyz_QMixC_pre  = xyzf_QMix(:,:,:,iC) + xyzf_QMixBZ(:,:,:,iC)
      xyz_PTemp_pre = xyz_PTemp

      Adjusting: do i = 1, ItrNum
        !---------------------------------------------------------------
        ! ˰¾˰º
        !---------------------------------------------------------------
        !
        xyz_TempAll = ( xyz_PTemp_pre + xyz_PTempBZ ) * xyz_ExnerAll

        !˰¾˰º׻(ܾ줫κ). 
        xyz_QMixSat =                                    &
          & xyz_SvapPress(SpcWetID(iC), xyz_TempAll)     &
          &  * MolWtWet(iC) / MolWtDry / xyz_PressDry

        !ʲ줿Ǯ
        xyz_Gamma = xyz_LatentHeat(SpcWetID(iC), xyz_TempAll) &
          &        / (xyz_ExnerAll * CpDry)

        !ŷ̤. 
        !  ŷ뤬ˤ, xz_QMixV_pre - xz_QMixSat ɬͤȤʤ.
        !  ȯˤ, ȯ̤ - QMixC Ķ뤳ȤϤʤ. 
        xyz_DelQMix =                                                    &
          & ( xyz_QMixV_pre - xyz_QMixSat )                              &
          &   / (1.0d0 + xyz_Gamma * xyz_DQMixSatDPTemp(                 &
          &        SpcWetID(iC), MolWtWet(iC), xyz_TempAll, xyz_ExnerAll & 
          &        ) )

        xyz_Cond = max( 0.0d0, min( xyz_QMixV_pre,   xyz_DelQMix ) )
        xyz_Evap = max( 0.0d0, min( xyz_QMixC_pre, - xyz_DelQMix ) )

        !꿿˶ᤤͤ׻
        xyz_PTemp_nxt = xyz_PTemp_pre + xyz_Gamma * ( xyz_Cond - xyz_Evap )
        xyz_QMixV_nxt  = xyz_QMixV_pre  - xyz_Cond + xyz_Evap
        xyz_QMixC_nxt  = xyz_QMixC_pre  + xyz_Cond - xyz_Evap

        !֤Τѿ
        xyz_PTemp_pre = xyz_PTemp_nxt
        xyz_QMixV_pre  = xyz_QMixV_nxt
        xyz_QMixC_pre  = xyz_QMixC_nxt

      end do Adjusting
      
      xyz_PTemp                 = xyz_PTemp_nxt                 
      xyzf_QMix(:,:,:,iG) = xyz_QMixV_nxt - xyzf_QMixBZ(:,:,:,iG)
      xyzf_QMix(:,:,:,iC) = xyz_QMixC_nxt - xyzf_QMixBZ(:,:,:,iC)
      
    end do LoopSvapPress
    
  end subroutine MoistAdjustSvapPress


!!!--------------------------------------------------------------------------!!!
  subroutine MoistAdjustNH4SH(xyz_PressDry, xyz_Exner, xyz_PTemp, xyzf_QMix ) 
    !
    ! NH3 + H2S --> NH4SH ȿΰʿ Kp Ѥ˰¼Ĵˡ
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(8),intent(in)   :: xyz_PressDry(imin:imax,jmin:jmax,kmin:kmax) 
                                                          !ʬΰ
    real(8),intent(in)   :: xyz_Exner(imin:imax,jmin:jmax,kmin:kmax) 
                                                          !ʡؿ
    real(8),intent(inout):: xyz_PTemp(imin:imax,jmin:jmax,kmin:kmax) 
                                                          !
    real(8),intent(inout):: xyzf_QMix(imin:imax,jmin:jmax,kmin:kmax, ncmax)
                                                          !Žʬκ
    real(DP):: xyz_PTemp_pre(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP):: xyz_PTemp_nxt(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP):: xyz_QMixNH3_pre(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP):: xyz_QMixNH3_nxt(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP):: xyz_QMixH2S_pre(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP):: xyz_QMixH2S_nxt(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP):: xyz_QMixNH4SH_pre(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP):: xyz_QMixNH4SH_nxt(imin:imax,jmin:jmax,kmin:kmax) 
    
    real(DP):: xyz_ExnerAll(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP):: xyz_PressAll(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP):: xyz_TempAll(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP):: xyz_Gamma(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP):: xyz_DelQMix(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP):: xyz_Cond(imin:imax,jmin:jmax,kmin:kmax)  
    real(DP)::xyz_Evap(imin:imax,jmin:jmax,kmin:kmax)  
    
    integer            :: i
    integer, parameter :: ItrNum = 2
            
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
!    xyz_PTemp_nxt = 0.0d0
!    xyz_QMixNH3_nxt   = 0.0d0
!    xyz_QMixH2S_nxt   = 0.0d0
!    xyz_QMixNH4SH_nxt = 0.0d0
!    
!    xyz_Gamma     = 0.0d0
!    xyz_DelQMix  = 0.0d0

    !˰ˡǤϰϤѲʤ. 
    xyz_ExnerAll = xyz_Exner + xyz_ExnerBZ
    xyz_PressAll = PressBasis * (xyz_ExnerAll ** (CpDry / GasRDry))
        
    !ޤǤ줿ʬ̤ͤȤߤʤ. źɲ
    xyz_QMixNH3_pre(:,:,:)   = xyzf_QMix(:,:,:,IdxNH3) &
      &                           + xyzf_QMixBZ(:,:,:,IdxNH3)
    xyz_QMixH2S_pre(:,:,:)   = xyzf_QMix(:,:,:,IdxH2S) &
      &                           + xyzf_QMixBZ(:,:,:,IdxH2S)
    xyz_QMixNH4SH_pre(:,:,:) = xyzf_QMix(:,:,:,IdxNH4SHc) &
      &                           + xyzf_QMixBZ(:,:,:,IdxNH4SHc)
    xyz_PTemp_pre            = xyz_PTemp

    !ʲ줿ȿǮ (NH4SH kg ФǮ)
    xyz_Gamma = ReactHeatNH4SH / ( xyz_ExnerAll * CpDry )

    AdjustNH4SH: do i = 1, ItrNum
      !---------------------------------------------------------------
      ! ѿν
      !---------------------------------------------------------------
      !
      xyz_TempAll = ( xyz_PTemp_pre + xyz_PTempBZ ) * xyz_ExnerAll
      
      !NH4SH 
      xyz_DelQMix =                                        &
        &    xyz_DelQMixNH4SH(                             &
        &        xyz_TempAll, xyz_PressAll, xyz_PressDry,  &
        &        xyz_QMixNH3_pre, xyz_QMixH2S_pre,         &
        &        MolWtWet(IdxNH3), MolWtWet(IdxH2S)        &
        &      )

      xyz_Cond = max( 0.0d0, xyz_DelQMix )
      xyz_Evap = max( 0.0d0, min( - xyz_DelQMix, xyz_QMixNH4SH_pre ) )

      !---------------------------------------------------------------
      ! 꿿˶ᤤͤ˰¾˰º
      !---------------------------------------------------------------
      ! NH4SH κ
      xyz_QMixNH4SH_nxt  = xyz_QMixNH4SH_pre + xyz_Cond - xyz_Evap
      
      ! DelPress 򸵤, NH3  H2S κ
      xyz_QMixNH3_nxt = xyz_QMixNH3_pre - ( xyz_Cond - xyz_Evap )      &
        &                 * MolWtWet(IdxNH3) / MolWtWet(IdxNH4SHc)
      xyz_QMixH2S_nxt = xyz_QMixH2S_pre - ( xyz_Cond - xyz_Evap )      &
        &                 * MolWtWet(IdxH2S) / MolWtWet(IdxNH4SHc)
          
      !̤
      xyz_PTemp_nxt = xyz_PTemp_pre + xyz_Gamma * ( xyz_Cond - xyz_Evap )
      
      !롼פ󤹤ѿѲ
      xyz_PTemp_pre    = xyz_PTemp_nxt
      xyz_QMixNH3_pre   = xyz_QMixNH3_nxt 
      xyz_QMixH2S_pre   = xyz_QMixH2S_nxt 
      xyz_QMixNH4SH_pre = xyz_QMixNH4SH_nxt 

    end do AdjustNH4SH

    xyz_PTemp                  = xyz_PTemp_nxt                 
    xyzf_QMix(:,:,:,IdxNH3)    = xyz_QMixNH3_nxt   - xyzf_QMixBZ(:,:,:,IdxNH3)
    xyzf_QMix(:,:,:,IdxH2S)    = xyz_QMixH2S_nxt   - xyzf_QMixBZ(:,:,:,IdxH2S)
    xyzf_QMix(:,:,:,IdxNH4SHc) = xyz_QMixNH4SH_nxt - xyzf_QMixBZ(:,:,:,IdxNH4SHc)
    
  end subroutine MoistAdjustNH4SH

end Module MoistAdjust
