!= 3  (xyz ) ֳָ߳ʻ ʬ黻⥸塼
!
!* 
!  * 2007/07/15 () : 3D deepconv ذܿ, dc_types  Use.
!  * 2007/06/27 () : 1 ʬ黻⥸塼˰¸ʤ褦
!  * 2006/06/07 () : 
!

module xyz_deriv_module
  != 3  (xyz ) ֳָ߳ʻ ʬ黻⥸塼
  !
  !== ǽ
  !
  ! xyz_deriv_module , 3  (xyz ) ֳָ߳ʻҤѤͭºʬ
  ! ˡ˴ŤͥǥΤ, ʬ黻Ԥ Fortran90 ؿ󶡤. 
  ! ʬ黻 2 濴ʬѤƹԤ.
  !
  ! Υ⥸塼ϲ⥸塼Ȥ xyz_base_module, data_type 
  ! ⥸塼ѤƤ. 
  !
  ! ⥸塼ѿȼ³̿̾ˡˤĤƤ xyz_module 򻲾ȤΤ.
  !
  !
  !== ѿ, ³
  !
  !=== 1 ʬ
  !
  ! xyz_dx_pyz, pyz_dx_xyz :: x  1 ʬ׻
  ! xyz_dy_xqz, xqz_dy_xyz :: y  1 ʬ׻
  ! xyz_dz_xyr, xyr_dz_xyz :: z  1 ʬ׻
  !

  use dc_types, only : DP
  use gridset,  only : imin, imax, jmin, jmax, kmin, kmax
  use axesset,  only : x_dx, p_dx, y_dy, q_dy, z_dz, r_dz

  implicit none
  private
  public :: xyz_dx_pyz, pyz_dx_xyz, &
    &       xyz_dy_xqz, xqz_dy_xyz, &
    &       xyz_dz_xyr, xyr_dz_xyz

  public :: pqz_dx_xqz, xqz_dx_pqz, &
    &       pyr_dx_xyr, xyr_dx_pyr, &
    &       pqz_dy_pyz, pyz_dy_pqz, &
    &       xqr_dy_xyr, xyr_dy_xqr, &
    &       xqr_dz_xqz, xqz_dz_xqr, &
    &       pyr_dz_pyz, pyz_dz_pyr

 
  contains
!--------------------------------------------------------------------
    function xyz_dx_pyz(pyz_Var)
      ! Ⱦʻ 1 ʬ׻
  
      real(DP),intent(in) :: pyz_Var(imin:imax,jmin:jmax,kmin:kmax) 
      real(DP)            :: xyz_dx_pyz(imin:imax,jmin:jmax,kmin:kmax)
      integer                 :: ix

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      xyz_dx_pyz = 0.0d0

      ! 1 ʬη׻
      !
      do ix = imin+1, imax
        xyz_dx_pyz(ix,:,:) = (pyz_Var(ix,:,:)-pyz_Var(ix-1,:,:))/x_dx(ix)
      end do

      xyz_dx_pyz(imin,:,:) = xyz_dx_pyz(imin+1,:,:)


    end function xyz_dx_pyz
!--------------------------------------------------------------------
    function pyz_dx_xyz(xyz_Var)
      ! Ⱦʻ 1 ʬ׻
  
      real(DP),intent(in) :: xyz_Var(imin:imax,jmin:jmax,kmin:kmax) 
      real(DP)            :: pyz_dx_xyz(imin:imax,jmin:jmax,kmin:kmax)
      integer                 :: ix 

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      pyz_dx_xyz = 0.0d0

      ! 1 ʬη׻
      !
      do ix = imin, imax-1
        pyz_dx_xyz(ix,:,:) = (xyz_Var(ix+1,:,:) - xyz_Var(ix,:,:))/p_dx(ix)
      end do

      pyz_dx_xyz(imax,:,:) = pyz_dx_xyz(imax-1,:,:)

    end function pyz_dx_xyz
!--------------------------------------------------------------------
    function pqz_dx_xqz(xqz_Var)
  
      real(DP),intent(in) :: xqz_Var(imin:imax,jmin:jmax,kmin:kmax) 
      real(DP)            :: pqz_dx_xqz(imin:imax,jmin:jmax,kmin:kmax)
      integer                 :: ix

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      pqz_dx_xqz = 0.0d0

      ! 1 ʬη׻
      !
      do ix = imin, imax-1
        pqz_dx_xqz(ix,:,:) = (xqz_Var(ix+1,:,:)-xqz_Var(ix,:,:))/p_dx(ix)
      end do

      pqz_dx_xqz(imax,:,:) = pqz_dx_xqz(imax-1,:,:)

    end function pqz_dx_xqz
!--------------------------------------------------------------------
    function xqz_dx_pqz(pqz_Var)
  
      real(DP),intent(in) :: pqz_Var(imin:imax,jmin:jmax,kmin:kmax) 
      real(DP)            :: xqz_dx_pqz(imin:imax,jmin:jmax,kmin:kmax)
      integer                 :: ix

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      xqz_dx_pqz = 0.0d0

      ! 1 ʬη׻
      !
      do ix = imin+1, imax
        xqz_dx_pqz(ix,:,:) = (pqz_Var(ix,:,:)-pqz_Var(ix-1,:,:))/x_dx(ix)
      end do

      xqz_dx_pqz(imin,:,:) = xqz_dx_pqz(imin+1,:,:)

    end function xqz_dx_pqz
!--------------------------------------------------------------------
    function pyr_dx_xyr(xyr_Var)
  
      real(DP),intent(in) :: xyr_Var(imin:imax,jmin:jmax,kmin:kmax) 
      real(DP)            :: pyr_dx_xyr(imin:imax,jmin:jmax,kmin:kmax)
      integer                 :: ix

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      pyr_dx_xyr = 0.0d0

      ! 1 ʬη׻
      !
      do ix = imin, imax-1
        pyr_dx_xyr(ix,:,:) = (xyr_Var(ix+1,:,:)-xyr_Var(ix,:,:))/p_dx(ix)
      end do

      pyr_dx_xyr(imax,:,:) = pyr_dx_xyr(imax-1,:,:)

    end function pyr_dx_xyr
!--------------------------------------------------------------------
    function xyr_dx_pyr(pyr_Var)
  
      real(DP),intent(in) :: pyr_Var(imin:imax,jmin:jmax,kmin:kmax) 
      real(DP)            :: xyr_dx_pyr(imin:imax,jmin:jmax,kmin:kmax)
      integer                 :: ix

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      xyr_dx_pyr = 0.0d0

      ! 1 ʬη׻
      !
      do ix = imin+1, imax
        xyr_dx_pyr(ix,:,:) = (pyr_Var(ix,:,:)-pyr_Var(ix-1,:,:))/x_dx(ix)
      end do

      xyr_dx_pyr(imin,:,:) = xyr_dx_pyr(imin+1,:,:)

    end function xyr_dx_pyr
!--------------------------------------------------------------------
    function xyz_dy_xqz(xqz_Var)
      ! Ⱦʻ 1 ʬ׻
  
      real(DP),intent(in) :: xqz_Var(imin:imax,jmin:jmax,kmin:kmax) 
      real(DP)            :: xyz_dy_xqz(imin:imax,jmin:jmax,kmin:kmax)
      integer                 :: jy 

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      xyz_dy_xqz = 0.0d0

      ! y ͤʾʬϥ.
      if (jmin == jmax) return

      ! 1 ʬη׻
      !
      do jy = jmin+1, jmax
        xyz_dy_xqz(:,jy,:) = (xqz_Var(:,jy,:) - xqz_Var(:,jy-1,:))/y_dy(jy)
      end do

      xyz_dy_xqz(:,jmin,:) = xyz_dy_xqz(:,jmin+1,:)

    end function xyz_dy_xqz
!--------------------------------------------------------------------
    function xqz_dy_xyz(xyz_Var)
      ! Ⱦʻ 1 ʬ׻
  
      real(DP),intent(in) :: xyz_Var(imin:imax,jmin:jmax,kmin:kmax) 
      real(DP)            :: xqz_dy_xyz(imin:imax,jmin:jmax,kmin:kmax)
      integer                 :: jy

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      xqz_dy_xyz = 0.0d0

      ! y ͤʾʬϥ.
      if (jmin == jmax) return

      ! 1 ʬη׻
      !
      do jy = jmin, jmax-1
        xqz_dy_xyz(:,jy,:) = (xyz_Var(:,jy+1,:) - xyz_Var(:,jy,:))/q_dy(jy)
      end do

      xqz_dy_xyz(:,jmax,:) = xqz_dy_xyz(:,jmax-1,:)

    end function xqz_dy_xyz
!--------------------------------------------------------------------
    function pqz_dy_pyz(pyz_Var)
      ! Ⱦʻ 1 ʬ׻
  
      real(DP),intent(in) :: pyz_Var(imin:imax,jmin:jmax,kmin:kmax) 
      real(DP)            :: pqz_dy_pyz(imin:imax,jmin:jmax,kmin:kmax)
      integer                 :: jy

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      pqz_dy_pyz = 0.0d0

      ! y ͤʾʬϥ.
      if (jmin == jmax) return

      ! 1 ʬη׻
      !
      do jy = jmin, jmax-1
          pqz_dy_pyz(:,jy,:) = (pyz_Var(:,jy+1,:) - pyz_Var(:,jy,:))/q_dy(jy)
      end do

      pqz_dy_pyz(:,jmax,:) = pqz_dy_pyz(:,jmax-1,:) 

    end function pqz_dy_pyz
!--------------------------------------------------------------------
    function pyz_dy_pqz(pqz_Var)
      ! Ⱦʻ 1 ʬ׻
  
      real(DP),intent(in) :: pqz_Var(imin:imax,jmin:jmax,kmin:kmax) 
      real(DP)            :: pyz_dy_pqz(imin:imax,jmin:jmax,kmin:kmax)
      integer                 :: jy 

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      pyz_dy_pqz = 0.0d0

      ! y ͤʾʬϥ.
      if (jmin == jmax) return

      ! 1 ʬη׻
      !
      do jy = jmin+1, jmax
        pyz_dy_pqz(:,jy,:) = (pqz_Var(:,jy,:) - pqz_Var(:,jy-1,:))/y_dy(jy)
      end do

      pyz_dy_pqz(:,jmin,:) = pyz_dy_pqz(:,jmin+1,:)

    end function pyz_dy_pqz
!--------------------------------------------------------------------
    function xqr_dy_xyr(xyr_Var)
      ! Ⱦʻ 1 ʬ׻
  
      real(DP),intent(in) :: xyr_Var(imin:imax,jmin:jmax,kmin:kmax) 
      real(DP)            :: xqr_dy_xyr(imin:imax,jmin:jmax,kmin:kmax)
      integer                 :: jy

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      xqr_dy_xyr = 0.0d0

      ! y ͤʾʬϥ.
      if (jmin == jmax) return

      ! 1 ʬη׻
      !
      do jy = jmin, jmax-1
        xqr_dy_xyr(:,jy,:) = (xyr_Var(:,jy+1,:) - xyr_Var(:,jy,:))/q_dy(jy)
      end do

      xqr_dy_xyr(:,jmax,:) = xqr_dy_xyr(:,jmax-1,:)

    end function xqr_dy_xyr
!--------------------------------------------------------------------
    function xyr_dy_xqr(xqr_Var)
      ! Ⱦʻ 1 ʬ׻
  
      real(DP),intent(in) :: xqr_Var(imin:imax,jmin:jmax,kmin:kmax) 
      real(DP)            :: xyr_dy_xqr(imin:imax,jmin:jmax,kmin:kmax)
      integer                 :: jy 

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      xyr_dy_xqr = 0.0d0

      ! y ͤʾʬϥ.
      if (jmin == jmax) return

      ! 1 ʬη׻
      !
      do jy = jmin+1, jmax
        xyr_dy_xqr(:,jy,:) = (xqr_Var(:,jy,:) - xqr_Var(:,jy-1,:))/y_dy(jy)
      end do

      xyr_dy_xqr(:,jmin,:) = xyr_dy_xqr(:,jmin+1,:)

    end function xyr_dy_xqr
!--------------------------------------------------------------------
    function xyz_dz_xyr(xyr_Var)
      ! Ⱦʻ 1 ʬ׻
  
      real(DP),intent(in) :: xyr_Var(imin:imax,jmin:jmax,kmin:kmax) 
      real(DP)            :: xyz_dz_xyr(imin:imax,jmin:jmax,kmin:kmax)
      integer                 :: kz

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      xyz_dz_xyr = 0.0d0

      ! 1 ʬη׻
      !
      do kz = kmin+1, kmax
        xyz_dz_xyr(:,:,kz) = (xyr_Var(:,:,kz) - xyr_Var(:,:,kz-1))/z_dz(kz)
      end do

      xyz_dz_xyr(:,:,kmin) = xyz_dz_xyr(:,:,kmin+1)

    end function xyz_dz_xyr
!--------------------------------------------------------------------
    function xyr_dz_xyz(xyz_Var)
      ! Ⱦʻ 1 ʬ׻
  
      real(DP),intent(in) :: xyz_Var(imin:imax,jmin:jmax,kmin:kmax) 
      real(DP)            :: xyr_dz_xyz(imin:imax,jmin:jmax,kmin:kmax)
      integer                 :: kz

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      xyr_dz_xyz = 0.0d0

      ! 1 ʬη׻
      !
      do kz = kmin, kmax-1
        xyr_dz_xyz(:,:,kz) = (xyz_Var(:,:,kz+1) - xyz_Var(:,:,kz))/r_dz(kz)
      end do

      xyr_dz_xyz(:,:,kmax) = xyr_dz_xyz(:,:,kmax-1)
      
    end function xyr_dz_xyz
!--------------------------------------------------------------------
    function pyr_dz_pyz(pyz_Var)
      ! Ⱦʻ 1 ʬ׻
  
      real(DP),intent(in) :: pyz_Var(imin:imax,jmin:jmax,kmin:kmax) 
      real(DP)            :: pyr_dz_pyz(imin:imax,jmin:jmax,kmin:kmax)
      integer                 :: kz

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      pyr_dz_pyz = 0.0d0

      ! 1 ʬη׻
      !
      do kz = kmin, kmax-1
        pyr_dz_pyz(:,:,kz) = (pyz_Var(:,:,kz+1) - pyz_Var(:,:,kz))/r_dz(kz)
      end do

      pyr_dz_pyz(:,:,kmax) = pyr_dz_pyz(:,:,kmax-1)

    end function pyr_dz_pyz
!--------------------------------------------------------------------
    function pyz_dz_pyr(pyr_Var)
      ! Ⱦʻ 1 ʬ׻
  
      real(DP),intent(in) :: pyr_Var(imin:imax,jmin:jmax,kmin:kmax) 
      real(DP)            :: pyz_dz_pyr(imin:imax,jmin:jmax,kmin:kmax)
      integer                 :: kz

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      pyz_dz_pyr = 0.0d0

      ! 1 ʬη׻
      !
      do kz = kmin+1, kmax
        pyz_dz_pyr(:,:,kz) = (pyr_Var(:,:,kz) - pyr_Var(:,:,kz-1))/z_dz(kz)
      end do

      pyz_dz_pyr(:,:,kmin) = pyz_dz_pyr(:,:,kmin+1)

    end function pyz_dz_pyr
!--------------------------------------------------------------------
    function xqr_dz_xqz(xqz_Var)
      ! Ⱦʻ 1 ʬ׻
  
      real(DP),intent(in) :: xqz_Var(imin:imax,jmin:jmax,kmin:kmax) 
      real(DP)            :: xqr_dz_xqz(imin:imax,jmin:jmax,kmin:kmax)
      integer                 :: kz

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      xqr_dz_xqz = 0.0d0

      ! 1 ʬη׻
      !
      do kz = kmin, kmax-1
        xqr_dz_xqz(:,:,kz) = (xqz_Var(:,:,kz+1) - xqz_Var(:,:,kz))/r_dz(kz)
      end do

      xqr_dz_xqz(:,:,kmax) = xqr_dz_xqz(:,:,kmax-1)

    end function xqr_dz_xqz
!--------------------------------------------------------------------
    function xqz_dz_xqr(xqr_Var)
      ! Ⱦʻ 1 ʬ׻
  
      real(DP),intent(in) :: xqr_Var(imin:imax,jmin:jmax,kmin:kmax) 
      real(DP)            :: xqz_dz_xqr(imin:imax,jmin:jmax,kmin:kmax)
      integer                 :: kz

      ! 
      ! * 0 ɤˤϥޥ󥤥ץͤѤ٤
      !
      xqz_dz_xqr = 0.0d0

      ! 1 ʬη׻
      !
      do kz = kmin+1, kmax
        xqz_dz_xqr(:,:,kz) = (xqr_Var(:,:,kz) - xqr_Var(:,:,kz-1))/z_dz(kz)
      end do

      xqz_dz_xqr(:,:,kmin) = xqz_dz_xqr(:,:,kmin+1)

    end function xqz_dz_xqr
!--------------------------------------------------------------------
end module xyz_deriv_module
