!= Module CFLCheck
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: cflcheck.f90,v 1.1 2011-04-26 04:08:11 sugiyama Exp $ 
! Tag Name::  $Name: arare5-20110623-2 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!CFL Υå򤹤뤿Υѥå⥸塼
!  * ȤФ CFL å
!  * Ϥ줿®٤Ф CFL å
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
!Error Handling  gtool5 Ѥ褦ѹ
!

module CFLCheck
  !
  !CFL Υå򤹤뤿Υѥå⥸塼
  !  * ȤФ CFL å
  !  * Ϥ줿®٤Ф CFL å
  !

  !⥸塼ɤ߹
  use dc_types,   only: DP
  use dc_message, only: MessageNotify

  use gridset, only: imin,    &! x β
    &                imax,    &! x ξ
    &                jmin,    &! z β
    &                jmax,    &! z ξ
    &                kmin,    &! z β
    &                kmax      ! z ξ
  use axesset, only: xyz_dX,  &! x γʻֳ
    &                xyz_dY,  &! y γʻֳ
    &                xyz_dZ    ! z γʻֳ
  use timeset, only: DelTimeShort,  &!û֥ƥå
    &                DelTimeLong     !Ĺ֥ƥå
  
  !ۤηػ
  implicit none

  !private °λ
  private

  !ؿ public °
  public CFLCheckTimeShort
  public CFLCheckTimeLongVelX
  public CFLCheckTimeLongVelY
  public CFLCheckTimeLongVelZ
  
contains  

!!!-----------------------------------------------------------------!!!
  subroutine CFLCheckTimeShort( xyz_VelSound )
    !
    !ȤФ CFL å
    ! 

    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in) :: xyz_VelSound &
      &                    (imin:imax,jmin:jmax, kmin:kmax)
                                        !®
    real(DP)             :: CFL          !
    real(DP)            :: DxyzMin      !ǾʻҴֳ
    
    !® CFL 
    DxyzMin = min(min(minval(xyz_dx), minval(xyz_dy)), minval(xyz_dz))
    CFL = DelTimeShort * maxval(xyz_VelSound) / DxyzMin

    !å
    call MessageNotify( "M", &
      & "CFLCheckTimeShort", &
      & "Sound Wave Velocity = %f", d=(/maxval(xyz_VelSound)/) )
    call MessageNotify( "M", &
      & "CFLCheckTimeShort", &
      & "min(DelX, DelY, DelZ) = %f", d=(/DxyzMin/) )
    call MessageNotify( "M", &
      & "CFLCheckTimeShort", &
      & "DelTimeShort = %f", d=(/DelTimeSHort/) )

    !ٹå
    if ( CFL >= 1.0) then 
      call MessageNotify( "E", &
        & "CFLCheckTimeShort", &
        & "CFL Condition is broken, DelTimeShort * VelSound > min(DelX, DelZ)")
    else
      call MessageNotify( "M", &
        & "CFLCheckTimeShort", &
        & "Courant number for DelTimeSort = %f", d=(/CFL/) )
    end if
  
  end subroutine CFLCheckTimeShort


!!!-----------------------------------------------------------------!!!
  subroutine CFLCheckTimeLongVelX( pyz_VelX )
    !
    !ʿ®٤Ф CFL å. 
    ! 

    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in) :: pyz_VelX &
      &                    (imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: CFL

    !CFL 
    CFL = DelTimeLong * maxval(abs(pyz_VelX/xyz_dx))
  
    !å
    call MessageNotify( "M", &
      & "CFLCheckTimeLongVelX", &
      & "Courant number of VelX for DelTimeLong = %f", d=(/CFL/) )

  end subroutine CFLCheckTimeLongVelX
    

!!!-----------------------------------------------------------------!!!
  subroutine CFLCheckTimeLongVelY( xqz_VelY )
    !
    !ʿ®٤Ф CFL å. 
    ! 

    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in) :: xqz_VelY &
      &                     (imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: CFL

    !CFL 
    CFL = DelTimeLong * maxval(abs(xqz_VelY/xyz_dy))
  
    !å
    call MessageNotify( "M", &
      & "CFLCheckTimeLongVelY", &
      & "Courant number of VelY for DelTimeLong = %f", d=(/CFL/) )

  end subroutine CFLCheckTimeLongVelY


!!!-----------------------------------------------------------------!!!
  subroutine CFLCheckTimeLongVelZ( xyr_VelZ )
    !
    !ʿ®٤Ф CFL å. 
    ! 

    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in) :: xyr_VelZ &
      &                    (imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: CFL
    
    !CFL 
    CFL = DelTimeLong * maxval(abs(xyr_VelZ/xyz_dz)) 
    
    !å
    call MessageNotify( "M", &
      & "CFLCheckTimeLongVelZ", &
      & "Courant number of VelZ for DelTimeLong = %f", d=(/CFL/) )
    
  end subroutine CFLCheckTimeLongVelZ
  
end module CFLCheck
