!= Module FileSet
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: fileset.f90,v 1.8 2011-06-21 06:14:52 sugiyama Exp $ 
! Tag Name::  $Name: arare5-20110623-2 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!Ϳ줿 NAMELIST ե뤫, ¸̾ξ
!ݴɤ뤿ѿȷ⥸塼
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!

module fileset
  !
  !Ϳ줿 NAMELIST ե뤫, I/O ե̾, 
  !ݴɤ뤿ѿȷ⥸塼
  !

  !⥸塼ɤ߹
  use dc_types,    only : STRING        
  use dc_iounit,   only : FileOpen      
  use dc_message,  only : MessageNotify 
  use mpi_wrapper, only: myrank         
  use namelist_util, only: namelist_filename

  !ۤηػ
  implicit none

  private

  !ѿ
  character(STRING), save, public :: FileTitle = 'cloud moist convection experiment'
                              ! ¸̾.
                              ! Title of experiment
!  character(STRING), save, public :: FileSource = 'deepconv/arare5 $Name: arare5-20110623-2 $ (http://www.gfd-dennou.org/library/deepconv)'
  character(STRING), save, public :: FileSource = 'deepconv/arare5 arare5-20110623-2 (http://www.gfd-dennou.org/library/deepconv)'
                              ! ǡեץ̾. 
                              ! Source of data file
  character(STRING), save, public :: FileInstitution = 'GFD Dennou Club (http://www.gfd-dennou.org)'
                              ! ǡե/롼.
                              ! Institution or person that changes data files for the last time

  public fileset_init

contains

  subroutine fileset_init
    !
    !ե뤫ϥե˵ܤɤ߹
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    integer                       :: unit     !եֹ
  
    
    !ե뤫ɤ߹ϥե
    NAMELIST /fileset_nml/ FileTitle, FileSource, FileInstitution
    
    !ե뤫ϥե˵ܤɤ߹
    call FileOpen(unit, file=namelist_filename, mode='r')
    read(unit, NML=fileset_nml)
    close(unit)
    
    !"myrank == 0" ˳׻Ρɤ, ɤ߹
    if (myrank == 0) then 
      call MessageNotify( "M", &
        & "fileset_init", "FileTitle = %c",    c1=trim(FileTitle) )
      call MessageNotify( "M", &
        & "fileset_init", "FileSource = %c",   c1=trim(FileSource) )
      call MessageNotify( "M", &
        & "fileset_init", "FileInstitution = %c", c1=trim(FileInstitution) )
    end if

  end subroutine fileset_init

end module fileset
