!= Module Clockset
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: clockset.f90,v 1.1 2011-06-17 19:05:23 sugiyama Exp $ 
! Tag Name::  $Name: arare5-20110623-2 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview 
!
!Ϳ줿 NAMELIST ե뤫, ˴ؤ, 
!ݴɤ뤿ѿ⥸塼
!
!== Error Handling
!
!== Known Bugs
!
!== Note
!
!== Future Plans
!
!

module clockset
  !
  !Ϳ줿 NAMELIST ե뤫, ˴ؤ, 
  !ݴɤ뤿ѿ⥸塼
  !
  
  !⥸塼ɤ߹
  use dc_types,   only: DP, STRING
  use dc_message, only: MessageNotify
  use dc_clock,   only : CLOCK, DCClockCreate, &
    & DCClockClose, DCClockStart, DCClockStop, &
    & DCClockResult, DCClockPredict, &
    & operator(+)                             ! Access module (⥸塼)
  use mpi_wrapper, only: myrank
  use timeset,     only: TimeA, RestartTime, IntegPeriod

  !ۤηػ
  implicit none

  !°λ
  private
  
  ! Public Interface
  type(CLOCK), save :: clock_init, clock_loop  ! Variables for CPU time counting 
                                               ! CPU ַ¬ѿ
  public ClocksetInit, ClocksetClose, ClocksetPredict
  public ClockSetPreStart, ClockSetPreStop, ClockSetLoopStart, ClocksetLoopStop

contains
   
  subroutine ClocksetInit
    ! ַ¬ 
    !
    implicit none
    
    ! 롼Ѥλ¬
    !
    call DCClockCreate( &           ! Initialize ()
      & clk = clock_init, &         ! (out)
      & name = 'initialization' )   ! (in)

    ! ȯŸ롼Ѥλ¬
    !
    call DCClockCreate( &           ! Initialize ()
      & clk = clock_loop, &         ! (out)
      & name = 'time-integration' ) ! (in)

  end subroutine ClocksetInit


  subroutine ClocksetPreStart
    ! ¬
    !
    implicit none
    
    call DCClockStart(clk = clock_init) ! (inout)   ! Start CPU time counting 
    
  end subroutine ClocksetPreStart
  

  subroutine ClocksetLoopStart
    ! ¬
    !
    implicit none
    
    call DCClockStart(clk = clock_loop) ! (inout)   ! Start CPU time counting 
    
  end subroutine ClocksetLoopStart


  subroutine ClocksetPreStop
    ! ¬
    !
    implicit none
    
    call DCClockStop(clk = clock_init) ! (inout)    ! Stop CPU time counting 
                                                    ! (CPU ַ¬λ)    
  end subroutine ClocksetPreStop


  subroutine ClocksetLoopStop
    ! ¬
    !
    implicit none
    
    call DCClockStop(clk = clock_loop) ! (inout)    ! Stop CPU time counting 
                                                    ! (CPU ַ¬λ)    

  end subroutine ClocksetLoopStop


  subroutine ClocksetPredict
    ! ¬
    !
    implicit none
    real(4) :: progress 

    progress = real((TimeA - RestartTime) / IntegPeriod, 4)
    
    if (myrank == 0) then 
      write(*,*) ""
      call MessageNotify( "M", "main", "Time = %f", d=(/TimeA/) )
      call DCClockPredict( &                       ! Estimate remaining time (Ĥ֤ͽ¬)
        &   clk = clock_init + clock_loop,       & ! (in)
        &   progress = progress                  & ! (in) 
        &  )   
    end if
    
  end subroutine ClocksetPredict


  subroutine ClocksetClose
    ! ¬λ
    !
    implicit none

    if (myrank == 0) then     
      call DCClockResult( &                    ! Display total CPU time ( CPU ֤ɽ)
        & clks = (/clock_init, clock_loop/), & ! (in)
        & total_auto = .true. )                ! (in)
    end if
    call DCClockClose( clk = clock_init )    ! (inout)       ! Finalize ()
    call DCClockClose( clk = clock_loop )    ! (inout)       ! Finalize ()
    
  end subroutine ClocksetClose
  

end module clockset
