!= Module ChemCalc_3d
!
! Authors::   SUGIYAMA Ko-ichiro
! Version::   $Id: chemcalc.f90,v 1.3 2011-05-31 06:57:00 sugiyama Exp $
! Tag Name::  $Name: arare5-20110623-2 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
!شϢν̤׻뤿Υ⥸塼. 
!AMP  Antoine ˰¾Ѥưʲ. 
!ǥեȤǤ AMP Ȥ褦ˤƤ. 
!  * ˰¾
!  * ˰¾βʬ
!  * Ǯ
! 
!== Error Handling
!
!== Bugs
!
!== Note
!
!== Future Plans
!
!

module ChemCalc
  !
  !شϢν̤׻뤿Υ⥸塼. 
  !AMP  Antoine ˰¾Ѥưʲ. 
  !ǥեȤǤ AMP Ȥ褦ˤƤ. 
  !  * ˰¾
  !  * ˰¾βʬ
  !  * Ǯ
  !

  !⥸塼ƤӽФ
  use dc_types,       only : DP

  use dc_message, only: MessageNotify

  use ChemData, only: ChemData_init,                 & !
    &                 ChemData_SpcNum,               & !ǡ١βؼ
    &                 ChemData_SvapPress_AntoineA,   & !Antoine  A 
    &                 ChemData_SvapPress_AntoineB,   & !Antoine  B 
    &                 ChemData_SvapPress_AntoineC,   & !Antoine  C 
    &                 ChemData_SvapPress_AntoineUnit,& !ñѴѷ
    &                 ChemData_SvapPress_AMPA,       & !AMP  A 
    &                 ChemData_SvapPress_AMPB,       & !AMP  B 
    &                 ChemData_SvapPress_AMPC,       & !AMP  C 
    &                 ChemData_SvapPress_AMPD,       & !AMP  D 
    &                 ChemData_SvapPress_AMPE,       & !AMP  E 
    &                 GasRUniv,                      & !
    &                 ChemData_OneSpcID,             & !ؼ ID      
    &                 ChemData_CpRef,                & !ɸ֤Ǥñ̼Ǯ
    &                 ChemData_CpPerMolRef,          & !ɸ֤Ǥñ̥Ǯ
    &                 ChemData_CvRef,                & !ɸ֤Ǥñ̼Ǯ
    &                 ChemData_MolWt,                & !ʬ
    &                 ChemData_GasR                    ! [J/K kg]
  use gridset, only:  imin,                     &!  X β
    &                 imax,                        &!  X ξ
    &                 jmin,                        &!  Y β
    &                 jmax,                        &!  Y ξ
    &                 kmin,                        &!  Z β
    &                 kmax                          !  Z ξ
  use constants,only: PressBasis,         & !̤ɸవ         [Pa]
    &                 CpDry,              & !ʬʿ갵Ǯ [J/K kg]
    &                 MolWtDry,           & !ʬʿʬ   [kg/mol]
    &                 GasRDry               !ʬε     [J/K kg]

  !ۤηػ
  implicit none

  !ΤФ private °դ. 
  private
  
  !Τˤ public °դ
  public ChemCalc_Init                            !롼
  public MolWt                                    !ʬ
  public GasR                                     !
  public CpRef, CpPerMolRef, CvRef                !갵Ǯ, Ǯ
  public SvapPress, xyz_SvapPress                 !˰¾ [Pa]
  public xyz_DSvapPressDTemp                      !˰¾βʬ [Pa/K]
  public xyz_LatentHeat                           !Ǯ [J/K kg]
  public LatentHeatPerMol                         !Ǯ [J/K mol]
  public ReactHeatNH4SH, ReactHeatNH4SHPerMol     !NH4SH ȿǮ
  public xyz_DQMixSatDPTemp
  public xyz_DelQMixNH4SH
  public DelMolFrNH4SH

  real(DP)            :: ReactHeatNH4SH           !NH4SH ȿǮ [J/K kg]
  real(DP)            :: ReactHeatNH4SHPerMol     !NH4SH ȿǮ [J/K mol]
  real(DP)            :: a_antA(ChemData_SpcNum)   !Antoine ξ A 
  real(DP)            :: a_antB(ChemData_SpcNum)   !Antoine ξ B 
  real(DP)            :: a_antC(ChemData_SpcNum)   !Antoine ξ C 
  real(DP)            :: a_antU(ChemData_SpcNum)   !Antoine ξñ̴Τη
  real(DP)            :: a_ampA(ChemData_SpcNum)   !AMP ξ A 
  real(DP)            :: a_ampB(ChemData_SpcNum)   !AMP ξ B 
  real(DP)            :: a_ampC(ChemData_SpcNum)   !AMP ξ C 
  real(DP)            :: a_ampD(ChemData_SpcNum)   !AMP ξ D 
  real(DP)            :: a_ampE(ChemData_SpcNum)   !AMP ξ E 
  real(DP)            :: a_MolWt(ChemData_SpcNum)  !ʬ
 
  save ReactHeatNH4SH, ReactHeatNH4SHPerMol
  save a_antA, a_antB, a_antC, a_antU, a_MolWt
  save a_ampA, a_ampB, a_ampC, a_ampD, a_ampE

contains
  
!!!
!!! 롼
!!!
!!!==========================================================================
  subroutine ChemCalc_Init( )
    !
    !롼
    !

    !ۤηػ
    implicit none

    !ѿ
    character(20)      :: Name
    integer            :: id

    !-----------------------------------------------------------
    ! 
    !

    ! ǡ١ν
    call chemdata_init( )

    !Antoine ˰¾η
    a_antA = ChemData_SvapPress_AntoineA
    a_antB = ChemData_SvapPress_AntoineB
    a_antC = ChemData_SvapPress_AntoineC
    a_antU = ChemData_SvapPress_AntoineUnit

    !AMP ˰¾η
    a_ampA = ChemData_SvapPress_AMPA
    a_ampB = ChemData_SvapPress_AMPB
    a_ampC = ChemData_SvapPress_AMPC
    a_ampD = ChemData_SvapPress_AMPD
    a_ampE = ChemData_SvapPress_AMPE

    !ʬ
    a_MolWt = ChemData_MolWt
    
    !NH4SH ȿǮν
    !  NH4SH 1kg ФȿǮˤ.
    Name = 'NH4SH-s'
    id   = ChemData_OneSpcID( Name )  
    
    ReactHeatNH4SHPerMol  = GasRUniv * 10834.0d0
    ReactHeatNH4SH = GasRUniv * 10834.0d0 / MolWt( id )

    call MessageNotify( "M", &
      & "ChemCalc_Init", "ReactHeatNH4SH = %f", d=(/ReactHeatNH4SH/) )
    call MessageNotify( "M", &
      & "ChemCalc_Init", "NH4SH MolWt = %f", d=(/MolWt(id)/) )

  end subroutine ChemCalc_Init



!!!
!!! ˰¾, Ǯ, etc. δܴؿ. 
!!! ؼ ID Ȳ٤Ф֤ͤ
!!!  

!!!==========================================================================
  function CpRef(ID)
    !
    !Ϳ줿ؼФ, ɸ֤Ǥñ̼갵Ǯ׻
    !

    !ۤηػ
    implicit none
    
    !ѿ  
    real(DP)            :: CpRef        !ɸ֤Ǥñ̼Ǯ
    integer, intent(in) :: ID           !ؼ ID

    
    !ǡ١
    CpRef = ChemData_CpRef(ID)

  end function CpRef


!!!==========================================================================
  function CpPerMolRef(ID)
    !
    !Ϳ줿ؼФ, ɸ֤Ǥñ̥갵Ǯ׻
    !

    !ۤηػ
    implicit none
    
    !ѿ  
    real(DP)            :: CpPerMolRef  !ɸ֤Ǥñ̥Ǯ
    integer, intent(in) :: ID           !ؼ ID

    
    !ǡ١
    CpPerMolRef = ChemData_CpPerMolRef(ID)

  end function CpPerMolRef


!!!==========================================================================
  function CvRef(ID)
    !
    !Ϳ줿ؼФ, ɸ֤Ǥñ̼갵Ǯ׻
    !

    !ۤηػ
    implicit none
    
    !ѿ  
    real(DP)            :: CvRef       !ɸ֤Ǥñ̼Ǯ
    integer, intent(in) :: ID           !ؼ ID

    
    !ǡ١
    CvRef = ChemData_CvRef(ID)

  end function CvRef


!!!==========================================================================
  function MolWt(ID)
    !
    !Ϳ줿ؼФ, ʬ̤׻
    !

    !ۤηػ
    implicit none
    
    !ѿ  
    real(DP)            :: MolWt         !ʬ
    integer, intent(in) :: ID      !ؼ ID

    
    !ǡ١
    MolWt = ChemData_MolWt(ID)

  end function MolWt


!!!==========================================================================
  function GasR(ID)
    !
    !Ϳ줿ؼФ, ׻
    !

    !ۤηػ
    implicit none
    
    !ѿ  
    real(DP)            :: GasR          !ʬ
    integer, intent(in) :: ID      !ؼ ID
    
    
    !ǡ١
    GasR = ChemData_GasR(ID)

  end function GasR



!!!
!!!  3 δؿ
!!!

!!!==========================================================================
  function xyz_SvapPressAnt( ID, xyz_Temp )
    !
    !˰¾η׻. Antoine μ
    !

    !ۤηػ
    implicit none
    
    ! ѿ  
    real(DP)            :: xyz_SvapPressAnt(imin:imax,jmin:jmax,kmin:kmax) 
                                                          !˰¾
    real(DP),intent(in) :: xyz_Temp(imin:imax,jmin:jmax,kmin:kmax)  
                                                          !
    integer, intent(in) :: ID                             !ؼ ID
  
    !ѿ
    real(DP)            :: xyz_LogSvapPress(imin:imax,jmin:jmax,kmin:kmax) 
    real(DP),parameter  :: Temp0C = 273.15d0


    !˰¾ log ׻
    !п礭ʤꤹʤ褦ˤ. 
    ! Fujitsu Fortran Compiler Ǥ 700 礭 exp ȷٹ𤬽Ф.
    xyz_LogSvapPress =                                          &
      & min(                                                   & 
      &       (                                                &
      &         a_antA(ID)                                     &
      &         - a_antB(ID) / (a_antC(ID) + xyz_Temp - Temp0C) &
      &        ) * dlog(10.0d0)                                &
      &        + a_antU(ID),                                   &
      &      7.0d2                                             &
      &    )
    
    !˰¾׻
    xyz_SvapPressAnt =  dexp( xyz_LogSvapPress )

  end function xyz_SvapPressAnt


!!!==========================================================================
  function xyz_DSvapPressDTempAnt(ID, xyz_Temp)
    !
    !˰¾βʬη׻. Antoine μ
    !
    
    !ۤηػ
    implicit none
    
    !ѿ
    real(DP)            :: xyz_DSvapPressDTempAnt(imin:imax,jmin:jmax,kmin:kmax)
                                                  !˰¾βʬ [Pa/K]
    real(DP),intent(in) :: xyz_Temp(imin:imax,jmin:jmax,kmin:kmax)
                                                  ! [K]
    integer, intent(in) :: ID                     !ؼ ID
  
    !ѿ
    real(DP)            :: xyz_LogSvapPress(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)            :: xyz_DLogSvapPressDTemp(imin:imax,jmin:jmax,kmin:kmax)
    real(DP),parameter  :: Temp0C = 273.15d0


    !˰¾ log ׻
    !п礭ʤꤹʤ褦ˤ. 
    ! Fujitsu Fortran Compiler Ǥ 700 礭 exp ȷٹ𤬽Ф.
    xyz_LogSvapPress =                                          &
      & min(                                                   &
      &      (                                                 &
      &          a_antA(ID)                                    &
      &        - a_antB(ID) / (a_antC(ID) + xyz_Temp - Temp0C)  &
      &       ) * dlog(10.0d0)                                 &
      &       + a_antU(ID),                                    &
      &     7.0d2                                              &
      &    )
    
    xyz_DLogSvapPressDTemp =                                &
      & a_antB(ID) * dlog(10.0d0)                          &
      &  / ( (a_antC(ID) + xyz_Temp - Temp0C) ** 2.0d0 )
    
    !˰¾βʬ׻
    xyz_DSvapPressDTempAnt = xyz_DLogSvapPressDTemp * dexp( xyz_LogSvapPress ) 
    
  end function xyz_DSvapPressDTempAnt
  

!!!==========================================================================
  function xyz_LatentHeatAnt(ID, xyz_Temp)
    !
    !˰¾Ǯ׻. Antoine μ
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(DP)            :: xyz_LatentHeatAnt(imin:imax,jmin:jmax,kmin:kmax)
                                                            !Ǯ[J/K kg]
    real(DP),intent(in) :: xyz_Temp(imin:imax,jmin:jmax,kmin:kmax)
                                                    ![K]
    integer, intent(in) :: ID                       !ؼ ID

    !ؿ
    real(DP)            :: xyz_DLogSvapPressDTemp(imin:imax,jmin:jmax,kmin:kmax)
    real(DP),parameter  :: GasRUniv = 8.314d0
    real(DP),parameter  :: Temp0C = 273.15d0

    !˰¾ log ׻, Ǯ׻. 
    xyz_DLogSvapPressDTemp =                                   &
      & a_antB(ID) * dlog(10.0d0)                             &
      &  / ( (a_antC(ID) + xyz_Temp - Temp0C) ** 2.0d0 )
    
    xyz_LatentHeatAnt =                                        &
      & xyz_DLogSvapPressDTemp * GasRUniv * (xyz_Temp ** 2.0d0) &
      &  / a_MolWt(ID)

  end function xyz_LatentHeatAnt


!!!==========================================================================
  function xyz_SvapPress(ID, xyz_Temp)
    !
    !Ϳ줿ؼȲ٤Ф, ˰¾׻. AMP 
    !

    !ۤηػ
    implicit none
    
    !ѿ  
    real(DP)            :: xyz_SvapPress(imin:imax,jmin:jmax,kmin:kmax)
                                                         !˰¾
    real(DP),intent(in) :: xyz_Temp(imin:imax,jmin:jmax,kmin:kmax) 
                                                         ! [K]
    integer, intent(in) :: ID                            !ؼ ID

    !ѿ
    real(DP)            :: xyz_LogSvapPress(imin:imax,jmin:jmax,kmin:kmax)
    
    !˰¾п׻
    !п礭ʤꤹʤ褦ˤ. 
    ! Fujitsu Fortran Compiler Ǥ 700 礭 exp ȷٹ𤬽Ф.
    xyz_LogSvapPress =                            &
      & min(                                     &
      &      (                                   &
      &          a_ampA(ID) / xyz_Temp            &
      &        + a_ampB(ID)                      &
      &        + a_ampC(ID) * dlog( xyz_Temp )    &
      &        + a_ampD(ID) * xyz_Temp            &
      &        + a_ampE(ID) * ( xyz_temp ** 2 )   &
      &        + dlog(1.0d-1)                    &
      &      ),                                  &
      &    7.0d2                                 &
      &   )

    !˰¾׻
    xyz_SvapPress =  dexp( xyz_LogSvapPress )
    
  end function xyz_SvapPress


!!!==========================================================================
  function xyz_DSvapPressDTemp(ID, xyz_Temp)
    !
    !Ϳ줿ؼȲ٤Ф, ˰¾βʬ׻
    !
    
    !ۤηػ
    implicit none
  
    !ѿ    
    real(DP)            :: xyz_DSvapPressDTemp(imin:imax,jmin:jmax,kmin:kmax)
                                                         !˰¾βʬ [Pa/K]
    real(DP),intent(in) :: xyz_Temp(imin:imax,jmin:jmax,kmin:kmax) 
                                                         ! [K]
    integer, intent(in) :: ID                            !ؼ̾

    !ѿ
    real(DP)            :: xyz_LogSvapPress(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)            :: xyz_DLogSvapPressDTemp(imin:imax,jmin:jmax,kmin:kmax)
    

    !˰¾п׻
    !п礭ʤꤹʤ褦ˤ. 
    ! Fujitsu Fortran Compiler Ǥ 700 礭 exp ȷٹ𤬽Ф.
    xyz_LogSvapPress =                        &
      & min(                               &
      &      (                             &
      &          a_ampA(ID) / xyz_Temp            &
      &        + a_ampB(ID)                      &
      &        + a_ampC(ID) * dlog( xyz_Temp )    &
      &        + a_ampD(ID) * xyz_Temp            &
      &        + a_ampE(ID) * ( xyz_temp ** 2 )   &
      &        + dlog(1.0d-1)                    &
      &      ),                                  &
      &    7.0d2                                 &
      &   )

    !˰¾βʬ
    xyz_DLogSvapPressDTemp =                   &
      & - a_ampA(ID) / (xyz_Temp ** 2.0d0)        &
      & + a_ampC(ID) / xyz_Temp                   &
      & + a_ampD(ID)                             &
      & + a_ampE(ID) * 2.0d0 * xyz_Temp
    
    !˰¾βʬ
    xyz_DSvapPressDTemp =                          &
      & xyz_DLogSvapPressDTemp * dexp( xyz_LogSvapPress ) 
    
  end function xyz_DSvapPressDTemp
  

!!!==========================================================================
  function xyz_LatentHeat(ID, xyz_Temp)
    !
    !Ϳ줿ؼȲ٤Ф, Ǯ׻
    !

    !ۤηػ
    implicit none

    !ѿ
    real(DP)            :: xyz_LatentHeat(imin:imax,jmin:jmax,kmin:kmax)
                                                         !Ǯ
    real(DP),intent(in) :: xyz_Temp(imin:imax,jmin:jmax,kmin:kmax) 
                                                         !
    integer, intent(in) :: ID                            !ؼ̾
    
    !ѿ
    real(DP)            :: xyz_DLogSvapPressDTemp(imin:imax,jmin:jmax,kmin:kmax)
    real(DP),parameter  :: GasRUniv = 8.314d0  !׵
    

    !˰¾βʬ
    xyz_DLogSvapPressDTemp =                      &
      & - a_ampA(ID) / (xyz_Temp ** 2.0d0)        &
      & + a_ampC(ID) / xyz_Temp                   &
      & + a_ampD(ID)                             &
      & + a_ampE(ID) * 2.0d0 * xyz_Temp
        
    !Ǯη׻
    xyz_LatentHeat =                                           &
      & xyz_DLogSvapPressDTemp * GasRUniv * (xyz_Temp ** 2.0d0) &
      & / a_MolWt(ID)

  end function xyz_LatentHeat


!!!==========================================================================
  function SvapPress(ID, Temp)
    !
    !Ϳ줿ؼȲ٤Ф, ˰¾׻. AMP 
    !

    !ۤηػ
    implicit none
    
    !ѿ  
    real(DP)            :: SvapPress   !˰¾
    real(DP),intent(in) :: Temp        ! [K]
    integer, intent(in) :: ID          !ؼ ID

    !ѿ
    real(DP)            :: LogSvapPress
    
    !˰¾п׻
    !п礭ʤꤹʤ褦ˤ. 
    ! Fujitsu Fortran Compiler Ǥ 700 礭 exp ȷٹ𤬽Ф.
    LogSvapPress =                            &
      & min(                                     &
      &      (                                   &
      &          a_ampA(ID) / Temp            &
      &        + a_ampB(ID)                      &
      &        + a_ampC(ID) * dlog( Temp )    &
      &        + a_ampD(ID) * Temp            &
      &        + a_ampE(ID) * ( temp ** 2 )   &
      &        + dlog(1.0d-1)                    &
      &      ),                                  &
      &    7.0d2                                 &
      &   )

    !˰¾׻
    SvapPress =  dexp( LogSvapPress )
    
  end function SvapPress


!!!==========================================================================
  function LatentHeatPerMol(ID, Temp)
    !
    !Ϳ줿ؼȲ٤Ф, Ǯ׻
    !

    !ۤηػ
    implicit none

    !ѿ
    real(DP)            :: LatentHeatPerMol   !Ǯ
    real(DP),intent(in) :: Temp            !
    integer, intent(in) :: ID                 !ؼ̾
    
    !ѿ
    real(DP)            :: DLogSvapPressDTemp
    real(DP),parameter  :: GasRUniv = 8.314d0  !׵
    

    !˰¾βʬ
    DLogSvapPressDTemp =                      &
      & - a_ampA(ID) / (Temp ** 2.0d0)        &
      & + a_ampC(ID) / Temp                   &
      & + a_ampD(ID)                          &
      & + a_ampE(ID) * 2.0d0 * Temp
        
    !Ǯη׻
    LatentHeatPerMol =                                     &
      & DLogSvapPressDTemp * GasRUniv * (Temp ** 2.0d0) 

  end function LatentHeatPerMol

!!!-----------------------------------------------------------------------!!!
  function xyz_DQMixSatDPTemp(SpcID, MolWt, xyz_TempAll, xyz_ExnerAll)
    !
    !˰¾  ʬԤ
    !ºݤˤ, dq/dp * dp/dT * dT/d ¹. (â p ˰¾)
    !

    !ۤηػ
    implicit none 
    
    !ѿ
    integer, intent(in) :: SpcID
    real(DP),intent(in) :: MolWt
    real(DP),intent(in) :: xyz_TempAll(imin:imax,jmin:jmax,kmin:kmax)
                                            !( + ܾ)
    real(DP),intent(in) :: xyz_ExnerAll(imin:imax,jmin:jmax,kmin:kmax)
                                            !ʡؿ( + ܾ)
    real(DP)            :: xyz_PressAll(imin:imax,jmin:jmax,kmin:kmax)
                                            !( + ܾ)
    real(DP)            :: xyz_DQMixSatDPTemp(imin:imax,jmin:jmax,kmin:kmax)
                           
    xyz_DQMixSatDPTemp   = 0.0d0
    xyz_PressAll = PressBasis * (xyz_ExnerAll ** (CpDry / GasRDry))
    
    xyz_DQMixSatDPTemp =                            &
      &   MolWt / ( MolWtDry * xyz_PressAll )          &
      & * xyz_DSvapPressDTemp(SpcID, xyz_TempAll)       &
      & * xyz_ExnerAll
    
  end function xyz_DQMixSatDPTemp


!!!-----------------------------------------------------------------------!!!
  function xyz_DelQMixNH4SH(xyz_TempAll, xyz_PressAll, xyz_QMixNH3, xyz_QMixH2S, &
    &                    MolWtNH3, MolWtH2S)
    !
    ! NH4SH ȿȼ, NH4SH ()
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(DP),intent(in) :: xyz_TempAll(imin:imax,jmin:jmax,kmin:kmax)
                                         !
    real(DP),intent(in) :: xyz_PressAll(imin:imax,jmin:jmax,kmin:kmax)
                                         !
    real(DP),intent(in) :: xyz_QMixNH3(imin:imax,jmin:jmax,kmin:kmax)
                                         !NH3 κ
    real(DP),intent(in) :: xyz_QMixH2S(imin:imax,jmin:jmax,kmin:kmax)
                                         !H2S κ
    real(DP),intent(in) :: MolWtNH3      !NH3 ʬ
    real(DP),intent(in) :: MolWtH2S      !H2S ʬ

    real(DP) :: xyz_DelQMixNH4SH(imin:imax,jmin:jmax,kmin:kmax)
                                         !NH4SH κ
    real(DP) :: xyz_EquivConst(imin:imax,jmin:jmax,kmin:kmax)
                                         !ʿ
    real(DP) :: xyzf_PartialPress(imin:imax,jmin:jmax,kmin:kmax,2)
                                         !(ʬ)
    real(DP) :: xyz_Solution(imin:imax,jmin:jmax,kmin:kmax)
                                         !(β)

    !
    xyz_DelQMixNH4SH = 0.0d0
    
    !˥βǤʬ. 
    xyzf_PartialPress(:,:,:,1) = xyz_QMixNH3 * xyz_PressAll * MolWtDry / MolWtNH3 
    xyzf_PartialPress(:,:,:,2) = xyz_QMixH2S * xyz_PressAll * MolWtDry / MolWtH2S 

    !ʿ
    xyz_EquivConst = 61.781d0 - 10834.0d0 / xyz_TempAll - dlog(1.0d2)

    !Ѳ. 
    !  (P_NH3 - X) * (P_H2S - X) = exp(Kp)
    !  DelX^2 - (P_NH3 + P_H2S) * DelX + P_NH3 * P_H2S * exp( Kp ) = 0
    !  Ȥɬפ뤬, P_NH3 > P_H2S  X < P_H2S 
    !  θ, θΤ򤵤.
    xyz_Solution  =                                                   &
      & (                                                            &
      &     sum(xyzf_PartialPress, 4)                                        &
      &   - dsqrt( (xyzf_PartialPress(:,:,:,1) - xyzf_PartialPress(:,:,:,2)) ** 2.0d0 &
      &            + 4.0d0 * dexp( min( 700.0d0, xyz_EquivConst ) ) ) &
      &  ) * 5.0d-1

    !̤
    xyz_DelQMixNH4SH = xyz_Solution * ( MolWtNH3 + MolWtH2S ) &
      &                   / ( xyz_PressAll * MolWtDry )

  end function xyz_DelQMixNH4SH
  

!!!-----------------------------------------------------------------------!!!
  function DelMolFrNH4SH(TempAll, PressAll, MolFrNH3, MolFrH2S, Humidity)
    !
    ! NH4SH ȿȼ H2S  NH3 Υθʬ
    !
    
    !ۤηػ
    implicit none

    !ѿ
    real(DP),intent(in) :: TempAll       !
    real(DP),intent(in) :: PressAll      !
    real(DP),intent(in) :: MolFrNH3      !NH3 Υ
    real(DP),intent(in) :: MolFrH2S      !H2S Υ
    real(DP),intent(in) :: Humidity      !˰
    real(DP)            :: DelMolFrNH4SH !NH4SH ȼѲ
    real(DP)            :: EquivConst    !ʿ
    real(DP)            :: PPress(2)     !(ʬ)
    real(DP)            :: Solution      !(β)

    !------------------------------------------------------------
    !NH4SH ʿվ
    !------------------------------------------------------------
    !˥βǤʬ
    PPress(1) = MolFrNH3 * PressAll
    PPress(2) = MolFrH2S * PressAll

    !ʿ
    EquivConst = 61.781d0 - 10834.0d0 / TempAll - dlog(1.0d2) - 2.0d0 * dlog( Humidity )
    
    !ѲβȤƵ. 
    Solution = 5.0d-1 * (sum(PPress) &
      &        - dsqrt( (PPress(1) - PPress(2))**2.0d0 &
      &                    + 4.0d0 * dexp( min( 700.0d0, EquivConst ))) )
    
    !NH4SH . 
    DelMolFrNH4SH = Solution / PressAll

  end function DelMolFrNH4SH

end module ChemCalc

