!= Module Radiation
!
! Authors::   YAMASHITA Tatsuya, SUGIYAMA Ko-ichiro
! Version::   $Id: radiation_heatbalance.f90,v 1.4 2011-06-17 19:07:26 sugiyama Exp $
! Tag Name::  $Name: arare5-20110623-2 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
!ǥͲ׻뤿Υѥå⥸塼
!Ūˤϰʲι׻뤿δؿǼ.  
!  * 
!
!== Error Handling
!
!== Bugs
!
!== Note
!
!
!== Future Plans
!
!

module Radiation_HeatBalance
  !
  !ǥͲ׻뤿Υѥå⥸塼
  !Ūˤϰʲι׻뤿δؿǼ.  
  !  * 
  !

  !⥸塼ɤ߹
  use dc_types, only: DP, STRING
  use dc_iounit,  only: FileOpen
  use dc_message, only: MessageNotify
  use gtool_historyauto, only: HistoryAutoAddVariable, HistoryAutoPut

  use mpi_wrapper,only: myrank
  use namelist_util, only: namelist_filename
  use timeset, only:  TimeN
  use gridSet,  only: imin,     & !x β
    &                 imax,     & !x ξ
    &                 jmin,     & !y β
    &                 jmax,     & !y ξ
    &                 kmin,     & !z β
    &                 kmax,     & !z ξ
    &                 nx, ny, nz
  use axesset, only:  z_Z, z_dz   !Z ɸ(顼ʻ)
  use constants,only: DayTime,  & ! 1 Ĺ [s]
    &                 PressSfc, & !ɽ̰
    &                 CpDry,    & !갵Ǯ
    &                 CvDry,    & !Ǯ
    &                 GasRDry     !
  use basicset, only: xyz_ExnerBZ, & !ʡؿδܾ
    &                 xyz_VelSoundBZ,  &! ®
    &                 xyz_VPTempBZ,    &! 
    &                 xyz_PTempBZ    !̤δܾ
  
  !ۤηػ
  implicit none

  !private °
  private

  !ؿ public ˤ. 
  public Radiation_heatbalance_init
  public Radiation_heatbalance_forcing

  !ѿ
  real(DP),save   :: RadCoolRate = 0.0d0     !ͲǮΨ [K/day]
  integer, save   :: IdxHeatUp = 0.0d0    !Ǯ¤αľɸб
  integer, save   :: IdxHeatDown = 0.0d0  !Ѱ¤αľɸб
  integer, save   :: IdxCoolUp = 0.0d0    !Ǯ¤αľɸб
  integer, save   :: IdxCoolDown = 0.0d0  !Ѱ¤αľɸб
  real(DP),save, allocatable :: xyz_RadHeightHeat(:,:,:)  !ͲǮ¸ߤΰ
  real(DP),save, allocatable :: xyz_RadHeightCool(:,:,:)  !ͲǮ¸ߤΰ

contains

!!!------------------------------------------------------------------------!!!
  subroutine Radiation_heatbalance_init
    !
    !NAMELIST Ͷ
    !

    !ۤηػ
    implicit none

    !ѿ
    real(8)                  :: HeightHeatUp   = 0.0d0  !ͶͿľΰξ
    real(8)                  :: HeightHeatDown = 0.0d0  !ͶͿľΰξ
    real(8)                  :: HeightCoolUp   = 0.0d0  !ͶͿľΰξ
    real(8)                  :: HeightCoolDown = 0.0d0  !ͶͿľΰξ
    integer                  :: k                    !롼ѿ
    integer                  :: unit

    ! NAMELIST 
    NAMELIST /radiation_heatbalance_nml/ &
      & RadCoolRate, HeightHeatUp, HeightHeatDown, HeightCoolUp, HeightCoolDown

    call FileOpen(unit, file=namelist_filename, mode='r')
    read(unit, NML=radiation_heatbalance_nml)
    close(unit)

    do k = kmin, kmax-1
      if ( z_Z(k) <= HeightHeatUp .AND. HeightHeatUp < z_Z(k+1) ) then 
        IdxHeatUp = k
      elseif ( z_Z(k) <= HeightHeatDown .AND. HeightHeatDown < z_Z(k+1) ) then 
        IdxHeatDown = k
      elseif ( z_Z(k) <= HeightCoolUp .AND. HeightCoolUp < z_Z(k+1) ) then 
        IdxCoolUp = k
      elseif ( z_Z(k) <= HeightCoolDown .AND. HeightCoolDown < z_Z(k+1) ) then 
        IdxCoolDown = k
      end if
    end do

    allocate( xyz_RadHeightHeat(imin:imax, jmin:jmax, kmin:kmax) )
    allocate( xyz_RadHeightCool(imin:imax, jmin:jmax, kmin:kmax) )

    xyz_RadHeightHeat = 1.0d0
    xyz_RadHeightHeat(:,:,IdxHeatDown:IdxHeatUp) = 1.0d0
    xyz_RadHeightCool = 0.0d0
    xyz_RadHeightCool(:,:,IdxCoolDown:IdxCoolUp) = 1.0d0

    ! Output
    !
    if (myrank == 0) then 
      call MessageNotify( "M", &
        & "Radiation", "RadCoolRate = %f", d=(/RadCoolRate/))
      call MessageNotify( "M", &
        & "Radiation", "HeightHeatUp = %f", d=(/HeightHeatUp/))
      call MessageNotify( "M", &
        & "Radiation", "HeightHeatDown= %f", d=(/HeightHeatDown/))
      call MessageNotify( "M", &
        & "Radiation", "HeightCoolUp = %f", d=(/HeightCoolUp/))
      call MessageNotify( "M", &
        & "Radiation", "HeightCoolDown= %f", d=(/HeightCoolDown/))
    end if

    call HistoryAutoAddVariable(  &
      & varname='PTempRad', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Radiation term of potential temperature', &
      & units='K.s-1"',    &
      & xtype='double')

    call HistoryAutoAddVariable(  &
      & varname='ExnerRad', &
      & dims=(/'x','y','z','t'/),     &
      & longname='Radiation term of exner function', &
      & units='s-1"',    &
      & xtype='double')

  end subroutine Radiation_heatbalance_init

!!!------------------------------------------------------------------------!!!
  subroutine radiation_heatbalance_forcing(xyz_Exner, xyz_PTemp, xyz_DPTempDt, xyz_DExnerDt)
    !
    ! ̤Ͷ. 
    ! ɽ̤ RadHeight ǻꤵ줿٤ޤǤδ֤ǶŪ˰ͤʲǮ, 
    ! RadHeight  RadHeight2 ޤǤδ֤ǶŪʰͤѤͿ. 
    ! ͶΤȤƲǮѤХ󥹤褦˻ͲǮΨ
    ! ӰΨѲ. 
    ! ѤοͿ, ǮοĴ᤹. 

    !ۤηػ
    implicit none

    !ѿ
    real(DP), intent(in)  :: xyz_Exner(imin:imax, jmin:jmax, kmin:kmax)
    real(DP), intent(in)  :: xyz_PTemp(imin:imax, jmin:jmax, kmin:kmax)
    real(DP), intent(inout) :: xyz_DPTempDt(imin:imax, jmin:jmax, kmin:kmax)
    real(DP), intent(inout) :: xyz_DExnerDt(imin:imax, jmin:jmax, kmin:kmax)
    real(DP)              :: xyz_DPTempDt0(imin:imax, jmin:jmax, kmin:kmax)
    real(DP)              :: xyz_DExnerDt0(imin:imax, jmin:jmax, kmin:kmax)
    real(DP)              :: xyz_Rad(imin:imax, jmin:jmax, kmin:kmax)
    real(DP)              :: xyz_RadPI(imin:imax, jmin:jmax, kmin:kmax)
    real(DP)              :: xyz_DensSum(imin:imax, jmin:jmax, kmin:kmax) 
                                        !̩(ܾʬȾʬ)
    real(DP)              :: HeatSum    !Ǥñ̻βǮ
    real(DP)              :: CoolSum    !Ǥñ̻
    real(DP)              :: RadHeatRate
    integer               :: i, j, k

    ! 
    !
    HeatSum = 0.0d0
    CoolSum = 0.0d0
    xyz_DPTempDt0 = xyz_DPTempDt
    xyz_DExnerDt0 = xyz_DExnerDt

    ! ̩٤λ
    xyz_DensSum = PressSfc &
      & * (xyz_ExnerBZ + xyz_Exner)**( CvDry /GasRDry ) &
      & / (GasRDry * (xyz_PTempBZ + xyz_PTemp ) )   

    ! Ǥ (Ǯ/ǮΨ) ׻
    do k = IdxHeatDown, IdxHeatUp
      do j = 1, ny
        do i = 1, nx
          HeatSum = HeatSum + z_dz(k) * CpDry * xyz_DensSum(i,j,k)
        end do
      end do
    end do
    
    ! Ǥ (/Ψ) ׻
    do k = IdxCoolDown, IdxCoolUp
      do j = 1, ny
        do i = 1, nx
          CoolSum = CoolSum + z_dz(k) * CpDry * xyz_DensSum(i,j,k)
        end do
      end do
    end do

    ! ǮΨλ
    ! RadCoolRate ͤǤ뤳Ȥ. 
    RadHeatRate = - RadCoolRate * CoolSum / HeatSum
    
    xyz_Rad = &
      &   xyz_RadHeightHeat * RadHeatRate / ( xyz_ExnerBZ  * DayTime ) &
      & + xyz_RadHeightCool * RadCoolRate / ( xyz_ExnerBZ  * DayTime )

    xyz_DPTempDt = xyz_DPTempDt0 + xyz_Rad

    ! Ѳ
    !
    xyz_RadPI = (xyz_VelSoundBZ ** 2.0d0) * xyz_Rad &
      &          / (CpDry * xyz_VPTempBZ ** 2.0d0)
    
    xyz_DExnerDt = xyz_DExnerDt0 + xyz_RadPI

    ! output
    !
    call HistoryAutoPut(TimeN, 'PTempRad', xyz_Rad(1:nx,1:ny,1:nz))
    call HistoryAutoPut(TimeN, 'ExnerRad', xyz_RadPI(1:nx,1:ny,1:nz))
    
  end subroutine radiation_heatbalance_forcing
  
end module Radiation_HeatBalance
