!= Module WarmRainPrm
!
! Authors::   SUGIYAMA Ko-ichiro, ODAKA Masatsugu
! Version::   $Id: cloudphys_k1969.f90,v 1.10 2011-06-17 19:07:26 sugiyama Exp $
! Tag Name::  $Name: arare5-20110623-2 $
! Copyright:: Copyright (C) GFD Dennou Club, 2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
!== Overview
!
!ȤΥХ륯ˡѤ, ȱ, ȱκѴ.
!   *  (1994) Ѥ꼰򤽤Τޤ. 
! 
!== Error Handling
!
!== Bugs
!
!== Note
!
!== Future Plans
!
!

module cloudphys_k1969
  !
  !ȤΥХ륯ˡѤ, ȱ, ȱκѴ.
  !   *  (1994) Ѥ꼰򤽤Τޤ. 
  ! 
  
  !⥸塼ɤ߹
  use dc_types,   only : DP, STRING
  use dc_iounit,  only : FileOpen
  use dc_message, only : MessageNotify
  use gtool_historyauto, only: HistoryAutoAddVariable, HistoryAutoPut

  use mpi_wrapper,only: myrank
  use timeset, only:  DelTimeLong, TimeN
  use gridset, only : imin,              &!x β
    &                 imax,              &!x ξ
    &                 jmin,              &!y ξ
    &                 jmax,              &!y ξ
    &                 kmin,              &!z β
    &                 kmax,              &!z ξ
    &                 nx, ny, nz, ncmax      !ʪΰ礭
  use constants,only: PressBasis,        &!̤δవ 
    &                 CpDry,             &!ʬǮ
    &                 MolWtDry,          &!
    &                 GasRDry             !ʬε 
  use basicset, only: xyz_DensBZ,        &!ܾ̩
    &                 xyz_PTempBZ,       &!ܾβ
    &                 xyz_ExnerBZ,       &!̵ܾ
    &                 xyzf_QMixBZ         !ܾκ
  use composition, only:                    &
    &                 MolWtWet,          &!
    &                 SpcWetID,          &!
    &                 SpcWetSymbol,      &!
    &                 CondNum,           &!ŷο
    &                 IdxCG,             &!ŷ()ź
    &                 IdxCC,             &!ŷ()ź
    &                 IdxCR,             &!ŷ()ź
    &                 CloudNum,          &!ο
    &                 RainNum,           &!ο
    &                 IdxC,              &!ź
    &                 IdxR,              &!ź
    &                 IdxNH3,            &!NH3()ź
    &                 IdxH2S,            &!H2S()ź
    &                 IdxNH4SHr           !NH4SH()ź
  use axesset, only : xyz_avr_xyr
  use xyz_deriv_module,only : xyr_dz_xyz
  use ChemCalc,  only : xyz_SvapPress, xyz_LatentHeat, ReactHeatNH4SH, xyz_DelQMixNH4SH
  use MoistAdjust, only: MoistAdjustSvapPress, MoistAdjustNH4SH
  use setmargin, only: SetMargin_xyzf, SetMargin_xyz
  use namelist_util, only: namelist_filename

  !ۤηػ
  implicit none

  !°λ
  private

  !ؿ public ˤ
  public Cloudphys_K1969_Init
  public Cloudphys_K1969_forcing
  public Cloudphys_K1969_FallRain

  real(DP), save :: FactorJ      = 1.0d0 !ʪΥѥ᡼
                                         !Ǥ 3.0d0
                                         !ϵǤ 1.0d0 Ȥ
  real(DP), save :: AutoConvTime = 1.0d3 !ʻĹλ [sec]
  real(DP), save :: QMixCr       = 1.0d-3 
                                         !ʻĹ׳ [kg/kg]

contains  

!!!=================================================================================!!!
  subroutine Cloudphys_K1969_Init

    !ۤηػ
    implicit none

    !ѿ
    integer  :: unit    !ֹ
    integer  :: l
    character(STRING) :: Planet = ""

    !-----------------------------------------------------------
    ! NAMELIST 
    !-----------------------------------------------------------
    ! NAMELIST 
    NAMELIST /cloudphys_k1969_nml/ Planet, FactorJ, AutoConvTime, QMixCr

    call FileOpen(unit, file=namelist_filename, mode='r')
    read(unit, NML=cloudphys_k1969_nml)
    close(unit)

    if (trim(Planet) == "Earth") then 
      FactorJ = 1.0d0
    elseif (trim(Planet) == "Jupiter") then 
      FactorJ = 3.0d0
    end if

    if (myrank == 0) then 
      call MessageNotify( "M", &
        &  "WarmRainPrm_Init", "Planet = %c",  c1=trim(Planet))
      call MessageNotify( "M", &
        &  "WarmRainPrm_Init", "FactorJ = %f",  d=(/FactorJ/) )
      call MessageNotify( "M", &
        &  "WarmRainPrm_Init", "AutoConvTime = %f",  d=(/AutoConvTime/) )
      call MessageNotify( "M", &
        &  "WarmRainPrm_Init", "QMixCr = %f",  d=(/QMixCr/) )
    end if

    call HistoryAutoAddVariable(  &
      & varname='PTempCond',&
      & dims=(/'x','y','z','t'/),     &
      & longname='Latent heat term of potential temperature', &
      & units='K.s-1',    &
      & xtype='double')

    do l = 1, ncmax
      call HistoryAutoAddVariable(  &
        & varname=trim(SpcWetSymbol(l))//'_Cond', & 
        & dims=(/'x','y','z','t'/),     &
        & longname='Condensation term of '          &
        &           //trim(SpcWetSymbol(l))//' mixing ratio',  &
        & units='kg.kg-1.s-1',    &
        & xtype='double')
      
      call HistoryAutoAddVariable(  &
        & varname=trim(SpcWetSymbol(l))//'_Fall', & 
        & dims=(/'x','y','z','t'/),     &
        & longname='Fall Rain term of '          &
        &           //trim(SpcWetSymbol(l))//' mixing ratio',  &
        & units='kg.kg-1.s-1',    &
        & xtype='double')
    end do
    
  end subroutine Cloudphys_K1969_Init
!!!=================================================================================!!!  

  subroutine Cloudphys_K1969_forcing(xyz_ExnerNl, xyz_PTempAl, xyzf_QMixAl)

    implicit none

    real(DP), intent(in)           :: xyz_ExnerNl(imin:imax, jmin:jmax, kmin:kmax)
    real(DP), intent(inout)        :: xyz_PTempAl(imin:imax, jmin:jmax, kmin:kmax)
    real(DP), intent(inout)        :: xyzf_QMixAl(imin:imax, jmin:jmax, kmin:kmax, ncmax)
    real(DP)                       :: xyz_PTempOrig(imin:imax, jmin:jmax, kmin:kmax)
    real(DP)                       :: xyz_PTempWork(imin:imax, jmin:jmax, kmin:kmax)
    real(DP)                       :: xyz_DelPTemp(imin:imax, jmin:jmax, kmin:kmax)
    real(DP)                       :: xyz_Del(imin:imax, jmin:jmax, kmin:kmax)
    real(DP)                       :: xyzf_QMixOrig(imin:imax, jmin:jmax, kmin:kmax, ncmax)
    real(DP)                       :: xyzf_QMixWork(imin:imax, jmin:jmax, kmin:kmax, ncmax)
    real(DP)                       :: xyzf_DelQMix(imin:imax, jmin:jmax, kmin:kmax, ncmax)
    real(DP)                       :: xyzf_Del(imin:imax, jmin:jmax, kmin:kmax, ncmax)
    real(DP)                       :: DelTime
    integer                        :: l, s

    real(DP)             :: xyzf_Cloud2Rain(imin:imax,jmin:jmax,kmin:kmax, ncmax)
                                          !鱫ؤѴ
    real(DP)             :: xyz_AutoConv(imin:imax,jmin:jmax,kmin:kmax)
                                          !˰º
    real(DP)             :: xyz_Collect(imin:imax,jmin:jmax,kmin:kmax)
                                          !ʲ줿Ǯ

    real(DP)             :: xyzf_QMixAll(imin:imax,jmin:jmax,kmin:kmax, ncmax)
                                          !ξʬ + ʿʬ
    real(DP)             :: xyz_TempAll(imin:imax,jmin:jmax,kmin:kmax)
                                          !٤ξʬ + ʿʬ
    real(DP)             :: xyz_PressAll(imin:imax,jmin:jmax,kmin:kmax)
                                          !
    real(DP)             :: xyz_ExnerAll(imin:imax,jmin:jmax,kmin:kmax)
    real(DP)             :: xyz_NonSaturate(imin:imax,jmin:jmax,kmin:kmax)
                                          !̤˰(˰ºȾκκ)
    real(DP)             :: xyzf_Rain2Gas(imin:imax,jmin:jmax,kmin:kmax, ncmax)
    real(DP)             :: xyzf_Rain2GasNH4SH(imin:imax,jmin:jmax,kmin:kmax, ncmax)
    real(DP)             :: xyzf_DelPTemp(imin:imax,jmin:jmax,kmin:kmax, ncmax)
    real(DP)             :: xyz_DelPTempNH4SH(imin:imax,jmin:jmax,kmin:kmax)

    !-----------------------------------------
    ! ֹ. Leap-frog ʤΤ, 2 \del t
    !
    DelTime = 2.0d0 * DelTimeLong

    !------------------------------------------
    ! ͤݴ Store Initial Value
    !
    xyz_PTempOrig = xyz_PTempAl
    xyzf_QMixOrig  = xyzf_QMixAl    

    !------------------------------------------    
    ! ȤΥѥ᥿ꥼ.
    ! * <--> ѴԤ.
    !
    ! Warm rain parameterization.
    ! * Conversion from cloud to rain.
    
    !ޤǤͤݴ
    ! Previous values are stored to work area.
    !
    xyzf_QMixWork = xyzf_QMixAl
    
    !ؤѲ̤׻
    ! Conversion values are calculated.
    !    
    xyzf_QMixAll = max( 1.0d-60, xyzf_QMixAl + xyzf_QMixBZ )

    xyzf_Cloud2Rain = 0.0d0

    do s = 1, CloudNum
      xyz_AutoConv = 0.0d0
      xyz_Collect  = 0.0d0
      
      !ʻĹ
      !
      xyz_AutoConv =                                             &
        & DelTime / AutoConvTime                                 &
        & * max( 1.0d-60, ( xyzf_QMixAll(:,:,:,IdxC(s)) - QMixCr) )

      !͹Ĺ
      !
      xyz_Collect =                                                 &
        &  DelTime                                                  &
        &  * 2.2d0 * FactorJ * xyzf_QMixAll(:,:,:,IdxC(s))          &
        &  * (xyzf_QMixAll(:,:,:,IdxR(s)) * xyz_DensBZ) ** 0.875d0  

      !Ѵ: ʻĹȹξͤ
      !  Ѳ̤ͤȤꤹ. ͤȤʤ.
      !
      xyzf_Cloud2Rain(:,:,:,IdxC(s)) =                       &
        & - min( xyzf_QMixAll(:,:,:,IdxC(s)), ( xyz_AutoConv + xyz_Collect ) )
      
      !Ѵ. ϱѴ̤Ȥȿ. 
      xyzf_Cloud2Rain(:,:,:,IdxR(s)) = - xyzf_Cloud2Rain(:,:,:,IdxC(s)) 
    end do

    ! Ѳ̤­
    !
    xyzf_QMixAl = xyzf_QMixWork + xyzf_Cloud2Rain

    ! Set Margin
    !
    call SetMargin_xyzf(xyzf_QMixAl)

    !-------------------------------------------
    ! ˰Ĵ
    ! * <-->ѴԤ.
    !
    ! Moist adjustment.
    ! * Conversion from vapor to cloud.
    !
    call MoistAdjustSvapPress(   &
      & xyz_ExnerNl,             & ! (in)
      & xyz_PTempAl,             & ! (inout)
      & xyzf_QMixAl              & ! (inout)
      & )
    if (IdxNH4SHr /= 0) then 
      call MoistAdjustNH4SH(     &
        & xyz_ExnerNl,           & !(in)
        & xyz_PTempAl,           & !(inout)
        & xyzf_QMixAl            & !(inout)
        & )
    end if

    ! Set Margin
    !
    call SetMargin_xyz(xyz_PTempAl)
    call SetMargin_xyzf(xyzf_QMixAl)

    !-------------------------------------------    
    ! ȤΥѥ᥿ꥼ.
    ! * <--> ѴԤ
    !
    ! Warm rain parameterization.
    ! * Conversion from rain to vapor.
    
    !ޤǤͤݴ
    ! Previous values are stored to work area.
    !
    xyz_PTempWork = xyz_PTempAl
    xyzf_QMixWork  = xyzf_QMixAl
    
    ! ؤκѲ
    ! * ̤η׻ˤ, ѲɬפȤʤ뤿, 
    !   Ѳ 1 ĤȤѰդ.
    !
    ! Conversion values are calculated.
    !

    !, , ̤
    !ʬʿʬ­
    !
    xyz_ExnerAll  = xyz_ExnerNl + xyz_ExnerBZ
    xyz_TempAll   = ( xyz_PTempAl + xyz_PTempBZ ) * ( xyz_ExnerNl + xyz_ExnerBZ )
    xyz_PressAll  = PressBasis * ((xyz_ExnerNl + xyz_ExnerBZ) ** (CpDry / GasRDry))
    xyzf_QMixAll = max( 1.0d-60, xyzf_QMixAl + xyzf_QMixBZ )
    xyzf_Rain2Gas = 0.0d0
    xyzf_Rain2GasNH4SH = 0.0d0
    xyz_NonSaturate = 0.0d0
    xyzf_DelPTemp = 0.0d0

    do s = 1, CondNum
      !˰¾Ⱥκ(˰)׻. 
      !  ؤѴ̤˰٤㤹.
      !
      xyz_NonSaturate =                                         &
        & max(                                                  &
        &   1.0d-60,                                              &
        &   xyz_SvapPress(SpcWetID(IdxCC(s)), xyz_TempAll)      &
        &     * MolWtWet(IdxCG(s)) / ( MolWtDry * xyz_PressAll) &
        &     - xyzf_QMixAll(:,:,:,IdxCG(s))                    &
        &    )

      !Ѵ
      !  αγκʾ˾ȯʤ褦˾ͤ
      !
      xyzf_Rain2Gas(:,:,:,IdxCR(s)) =                                    &
        & - min(                                                         &
        &    DelTime * 4.85d-2 * FactorJ * xyz_NonSaturate               &
        &     * ( xyzf_QMixAll(:,:,:,IdxCR(s)) * xyz_DensBZ )** 0.65d0,  &
        &    xyzf_QMixAll(:,:,:,IdxCR(s))                                &
        &   ) 

      !Ѵ
      !  γѴ̤Ȥ椬դȤʤ
      !
      xyzf_Rain2Gas(:,:,:,IdxCG(s)) = - xyzf_Rain2Gas(:,:,:,IdxCR(s)) 
    
      ! xyzf_DelQMix 򸵤Ǯ׻
      !
      xyzf_DelPTemp(:,:,:,s) =                               &
        & xyz_LatentHeat( SpcWetID(IdxCR(s)), xyz_TempAll )   &
        &  * xyzf_Rain2Gas(:,:,:,IdxCR(s))                    &
        &  / (xyz_ExnerAll * CpDry) 

    end do

    !˰¾Ⱥκ(˰)׻. 
    !  ؤѴ̤˰٤㤹.
    !  ̤˰٤᤿Τ, ޥʥ򤫤Ƥ
    !  (DelQMixNH4SH , NH4SH ä, ʤ˰٤ȤƤ)
    !
    xyz_NonSaturate    = 0.0d0
    xyzf_Rain2GasNH4SH = 0.0d0
    xyz_DelPTempNH4SH  = 0.0d0

    if (IdxNH4SHr /= 0) then 
      xyz_NonSaturate =                                                 &
        & max(                                                          &
        &  1.0d-60,                                                       &
        &   - xyz_DelQMixNH4SH(                                         &  
        &       xyz_TempAll, xyz_PressAll,                              &
        &       xyzf_QMixAll(:,:,:,IdxNH3), xyzf_QMixAll(:,:,:,IdxH2S), &
        &       MolWtWet(IdxNH3), MolWtWet(IdxH2S)                      &
        &     )                                                         &
        &  )

      !Ѵ
      !  αγκʾ˾ȯʤ褦˾ͤ
      !
      xyzf_Rain2GasNH4SH(:,:,:,IdxNH4SHr) =                              &
        & - min(                                                         &
        &     DelTime * 4.85d-2 * FactorJ * xyz_NonSaturate              &
        &      * (xyzf_QMixAll(:,:,:,IdxNH4SHr) * xyz_DensBZ) ** 0.65d0, &
        &     xyzf_QMixAll(:,:,:,IdxNH4SHr)                              &
        &    ) 
     
      !Ѵ
      !  γѴ̤Ȥ椬դȤʤ
      !
      xyzf_Rain2GasNH4SH(:,:,:,IdxNH3) =                           &
        & - xyzf_Rain2GasNH4SH(:,:,:,IdxNH4SHr) * MolWtWet(IdxNH3) &
        &   / MolWtWet(IdxNH4SHr)
      xyzf_Rain2GasNH4SH(:,:,:,IdxH2S) =                           &
        & - xyzf_Rain2GasNH4SH(:,:,:,IdxNH4SHr) * MolWtWet(IdxH2S) &
        &   / MolWtWet(IdxNH4SHr)

      xyz_DelPTempNH4SH                                          &
        & = ReactHeatNH4SH * xyzf_Rain2GasNH4SH(:,:,:,IdxNH4SHr) &
        &    / (xyz_ExnerAll * CpDry)

    end if

    !Ѳ̤­
    !
    xyzf_DelQMix = xyzf_Rain2Gas + xyzf_Rain2GasNH4SH
    xyz_DelPTemp = sum(xyzf_DelPTemp, 4) + xyz_DelPTempNH4SH

    ! ̤Ⱥη׻. ؤѴʬɲ
    !
    xyz_PTempAl = xyz_PTempWork + xyz_DelPTemp
    xyzf_QMixAl = xyzf_QMixWork + xyzf_DelQMix

    ! Set Margin
    !
    call SetMargin_xyz(xyz_PTempAl)
    call SetMargin_xyzf(xyzf_QMixAl)

    !------------------------------------------
    ! Output
    !
    xyz_Del  = (xyz_PTempAl - xyz_PTempOrig) / DelTime
    xyzf_Del = (xyzf_QMixAl - xyzf_QMixOrig) / DelTime

    call HistoryAutoPut(TimeN, 'PTempCond', xyz_Del(1:nx, 1:ny, 1:nz) / DelTime)
    do l = 1, ncmax
      call HistoryAutoPut(TimeN, trim(SpcWetSymbol(l))//'_Cond', xyzf_Del(1:nx, 1:ny, 1:nz, l) / DelTime)
    end do

  end subroutine Cloudphys_K1969_forcing

!!!=================================================================================!!!
  subroutine CloudPhys_K1969_FallRain(xyzf_QMix, xyzf_DQMixDt )
    !
    ! γˤή. 
    ! 

    !ۤηػ
    implicit none
    
    !ѿ
    real(DP), intent(in) :: xyzf_QMix(imin:imax,jmin:jmax,kmin:kmax, ncmax) 
                                                 !()
    real(DP), intent(inout) :: xyzf_DQMixDt(imin:imax,jmin:jmax,kmin:kmax, ncmax) 
                                                 !Ѳ
    real(DP)  :: xyzf_QMixAll(imin:imax,jmin:jmax,kmin:kmax, ncmax)
                                                 !( + ʿѾ)
    real(DP)  :: xyzf_FallRain(imin:imax,jmin:jmax,kmin:kmax, ncmax)
                                                 !γ
    real(DP)  :: xyz_VelZRain(imin:imax,jmin:jmax,kmin:kmax)
                                                 !γ®
    real(DP)  :: xyzf_DQMixDtOrig(imin:imax,jmin:jmax,kmin:kmax, ncmax) 
                                                 !Ѳ
    integer  :: s, l

    xyzf_QMixAll = max( 0.0d0, xyzf_QMix + xyzf_QMixBZ )
    xyzf_DQMixDtOrig = xyzf_DQMixDt
    xyzf_FallRain = 0.0d0
    xyz_VelZRain = 0.0d0
    
    !ˤή
    !  Dens  avr äƤ, 䤬Τ
    do s = 1, RainNum
      !γü®
      xyz_VelZRain = 12.2d0 * FactorJ * ( xyzf_QMixAll(:,:,:,IdxR(s)) ** 0.125d0 )
      
      xyzf_FallRain(:,:,:,IdxR(s)) =                   &
        &  xyz_avr_xyr(                                &
        &     xyr_dz_xyz(xyz_DensBZ                &
        &               * xyz_VelZRain                 &
        &               * xyzf_QMixAll(:,:,:,IdxR(s)) &
        &              )                               &
        &      ) / xyz_DensBZ                      
    end do

    xyzf_DQMixDt = xyzf_DQMixDtOrig + xyzf_FallRain
    
    do l = 1, ncmax
      call HistoryAutoPut(TimeN, trim(SpcWetSymbol(l))//'_Fall', xyzf_FallRain(1:nx, 1:ny, 1:nz, l))
    end do
    
  end subroutine CloudPhys_K1969_FallRain
  
end module Cloudphys_k1969
